/*
 * RT-Linux v1 compatibility
 *
 *  Copyright (C) 1999 FSM Labs (http://www.fsmlabs.com/)
 *  Written by Michael Barabanov <baraban@fsmlabs.com>
 */

#ifndef __RTL_COMPATIBILITY__
#define __RTL_COMPATIBILITY__

/* compatibility */

#include <rtl_conf.h>
#include <asm/rt_time.h>

#ifdef CONFIG_RTL_USE_V1_API

#define RT_TICKS_PER_SEC ((long long) HRTICKS_PER_SEC)
#define RT_TIME_END HRTIME_INFINITY

#ifdef __KERNEL__
#include <linux/malloc.h>

#define rt_get_time gethrtime

#define rt_delay(x) rtl_delay((x) * 838)


extern inline hrtime_t rtl_set_periodic_mode (hrtime_t period)
{
	int mode_success;
	schedule_t *s = LOCAL_SCHED;
	mode_success = rtl_setclockmode (s->clock, RTL_CLOCK_MODE_PERIODIC, period);
	if (mode_success == 0) {
		return clock_gethrtime(s->clock);
	} else {
		return HRTIME_INFINITY;
	}
}

extern inline int rtl_set_oneshot_mode (void)
{
	schedule_t *s = LOCAL_SCHED;
	return rtl_setclockmode(s->clock, RTL_CLOCK_MODE_ONESHOT, 0);
}

#ifdef CONFIG_RTL_FP_SUPPORT
extern inline int rt_task_use_fp (pthread_t *task, int flag) {
	return -pthread_setfp_np (*task, flag);
}
#endif

/* cross-CPU-allowed functions */
extern int rt_task_suspend(pthread_t *task);
extern int rt_task_wakeup(pthread_t *thread);


extern inline int rt_task_delete(pthread_t *thread)
{
	int ret;
	ret = pthread_delete_np(*thread);
	return 0;
}

extern int rt_task_make_periodic (pthread_t *threadptr, RTIME start_time, RTIME period);

/* end of cross-CPU-allowed functions */


/* for periodic tasks -- wait until the next period */
extern inline int rt_task_wait (void)
{
	pthread_wait_np();
	return 0;
}


#define RT_TASK pthread_t


extern int rt_task_init (RT_TASK *t, void (*fn)(int data), int data, int stack_size, int priority);

#define rtl_init (a,b,c,d,e) { rt_task_init(a,b,c,d,e); }
#define rtl_fpinit (a,b,c,d,e) { rt_task_init(a,b,c,d,e); rtl_task_use_fp (a, 1); }

#endif
#endif

#endif
