/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A 1  T148  R CALL_PREFIX_NOT 148
D 2  T157  R ABSTRACT_RESULT 158,159
A 1  T159  R ORDINARY_RESULT 159
D 4  T186  R LOCAL_ARGUMENT 192,194,184,187
A 1  T182  R LOCAL_VAR_LIST 182
A 1  T207  E NATIVE_ARRAY[INTEGER_CONSTANT] 207
D 8  T218  R ROUTINE 311,310,308,307,296,295,292,290
A 1  T332  E NATIVE_ARRAY[EFFECTIVE_ARG_LIST] 332
A 1  T286  E NATIVE_ARRAY[FORMAL_GENERIC_ARG] 286
A*1  T263  R ARRAY[TYPE] 263
A*1  T39   R SMALL_EIFFEL 39
A*1  T376  R DICTIONARY[TYPE_REF_TO_EXP,STRING] 376
A*1  T347  R DICTIONARY[MANIFEST_STRING,STRING] 347
A*1  T284  R ARRAY[FORMAL_GENERIC_ARG] 284
A 1  T273  R TYPE_NONE 273
A 1  T222  R E_CHECK 222
A 2  T360  R ARRAY[RUN_FEATURE] 360,60
A*1  T322  R ARRAY[EXPORT_ITEM] 322
A*1  T313  R ARRAY[DECLARATION] 313
A 1  T189  R ARRAY[LOCAL_NAME1] 189
A*1  T92   R ARRAY[RENAME_PAIR] 92
A 1  T249  R LOOP_VARIANT_2 249
A*1  T21   R STRING_ALIASER 21
A 1  T145  R PREFIX_NAME 145
A 1  T277  R TYPE_CLASS 277
A 1  T133  R CALL_INFIX_EQ 133
A*1  T342  R DICTIONARY[RUN_CLASS,STRING] 342
A*1  T95   R DICTIONARY[E_FEATURE,STRING] 95
A 1  T324  E NATIVE_ARRAY[EXPORT_ITEM] 324
A 1  T314  E NATIVE_ARRAY[DECLARATION] 314
A 1  T228  E NATIVE_ARRAY[INSTRUCTION] 228
A 1  T190  E NATIVE_ARRAY[LOCAL_NAME1] 190
A 1  T93   E NATIVE_ARRAY[RENAME_PAIR] 93
A 1  T62   E NATIVE_ARRAY[RUN_FEATURE] 62
A 1  T125  R CALL_INFIX_AND 125
A*1  T36   R STD_OUTPUT 36
A*1  T383  R MEMO[E_OLD] 383
A 1  T266  E NATIVE_ARRAY[TYPE] 266
A 1  T6    E BOOLEAN 6
A 1  T377  R FIXED_ARRAY[TYPE_REF_TO_EXP] 377
A 1  T212  R FIXED_ARRAY[MANIFEST_STRING] 212
A*1  T19   R INTEGER_REF 19
A 1  T215  R CST_ATT_REAL 215
A*1  T100  R FEATURE_CLAUSE 100
A 1  T378  E NATIVE_ARRAY[TYPE_REF_TO_EXP] 378
A 1  T317  E NATIVE_ARRAY[LOCAL_ARGUMENT1] 317
A 1  T213  E NATIVE_ARRAY[MANIFEST_STRING] 213
A 1  T81   E NATIVE_ARRAY[CREATION_CLAUSE] 81
A 1  T123  R CALL_INFIX_OR 123
A*1  T76   R PARSER_BUFFER 76
A*1  T46   R CODE_ATTRIBUTE 46
A*1  T338  R FIXED_ARRAY[DICTIONARY[RUN_FEATURE,STRING]] 338
A 1  T270  R TYPE_CHARACTER 270
A 1  T288  R REVERSE_ASSIGNMENT 288
A 1  T339  E NATIVE_ARRAY[DICTIONARY[RUN_FEATURE,STRING]] 339
A 1  T379  R PRECURSOR_NAME 379
A 1  T161  R WRITTEN_CURRENT 161
A 1  T318  R DECLARATION_1 318
A*1  T53   R CP_INFO 53
A 1  T2    E INTEGER 2
A 1  T310  R ONCE_PROCEDURE 310
A*1  T202  R TMP_FEATURE 202
A*1  T105  R ASSERTION 105
A*1  T384  R MANIFEST_ARRAY_POOL 384
A*1  T98   R FORMAL_GENERIC_LIST 98
A*1  T99   R FEATURE_CLAUSE_LIST 99
A*1  T41   R ERROR_HANDLER 41
A*1  T86   R COMMENT 86
D 3  T165  R PROC_CALL 168,167,166
D 11 T45   R RUN_FEATURE 59,348,349,391,371,389,357,372,381,380,44
A 1  T3    E CHARACTER 3
A 1  T216  R CST_ATT_DOUBLE 216
A 1  T203  R CST_ATT_UNIQUE 203
A*1  T208  R COUNTER 208
A*1  T344  R FIXED_ARRAY[PARENT] 344
A*1  T31   R FIXED_ARRAY[STRING] 31
D 2  T241  R WHEN_ITEM 245,244
A 1  T8    E POINTER 8
A 1  T261  R TYPE_LIKE_CURRENT 261
A 1  T271  R TYPE_DOUBLE 271
A 1  T136  R CALL_INFIX_DIV 136
A 1  T150  R E_STRIP 150
A*1  T247  R LOOP_INVARIANT 247
A 1  T388  R IMPLICIT_CAST 388
A 1  T129  R CALL_INFIX_LT 129
A 1  T127  R CALL_INFIX_GT 127
A 1  T275  R TYPE_REAL 275
A*1  T368  R RUN_REQUIRE 368
A 1  T187  R LOCAL_NAME1 187
A 1  T42   R JVM 42
D 8  T204  R CST_ATT 217,210,214,209,211,203,216,215
A 1  T330  E NATIVE_ARRAY[CALL_PROC_CALL] 330
A 1  T196  E NATIVE_ARRAY[ARGUMENT_NAME1] 196
A 1  T102  E NATIVE_ARRAY[FEATURE_CLAUSE] 102
A 1  T265  R TYPE_ARRAY 265
A 1  T298  R NATIVE_WITH_CURRENT 298
A 1  T177  R REAL_CONSTANT 177
A*1  T346  R MANIFEST_STRING_POOL 346
A 1  T305  R NATIVE_JVM_INVOKEVIRTUAL 305
A 1  T184  R LOCAL_NAME2 184
A*1  T364  R ADDRESS_OF_POOL 364
A 1  T268  R TYPE_BOOLEAN 268
A*1  T343  R FIXED_ARRAY[RUN_CLASS] 343
A*1  T96   R FIXED_ARRAY[E_FEATURE] 96
A*1  T385  R DICTIONARY[TYPE,INTEGER] 385
A 1  T276  R TYPE_STRING 276
A 1  T138  R CALL_INFIX_INT_DIV 138
A*1  T345  R ONCE_ROUTINE_POOL 345
A*1  T327  R ARRAY[INDEX_CLAUSE] 327
D 5  T144  R CALL_0 146,147,142,153,148
A 1  T262  R TYPE_LIKE_ARGUMENT 262
A*1  T329  R FIXED_ARRAY[CALL_PROC_CALL] 329
D 2  T312  R DECLARATION 318,315
A*1  T221  R FIXED_ARRAY[INSTRUCTION] 221
A 4  T61   R FIXED_ARRAY[RUN_FEATURE] 356,352,350,61
A 1  T297  R NATIVE_SMALL_EIFFEL 297
A 1  T292  R DEFERRED_FUNCTION 292
D 2  T43   R CODE_PRINTER 390,42
A 1  T211  R CST_ATT_STRING 211
A*1  T78   R CREATION_CLAUSE_LIST 78
A 1  T235  R E_RETRY 235
A*1  T63   R STD_ERROR 63
A 1  T114  R MANIFEST_ARRAY 114
A 1  T166  R PROC_CALL_0 166
A 1  T137  R CALL_INFIX_INT_REM 137
D 2  T188  R LOCAL_ARGUMENT1 194,187
A 1  T244  R WHEN_ITEM_1 244
D 27 T120  R CALL 116,122,135,146,131,134,139,147,198,142,156,140,126,124,128,130,153,155,137,138,127,129,136,123,125,133,148
A 1  T234  R EXPRESSION_WITH_COMMENT 234
A 1  T167  R PROC_CALL_1 167
A*1  T35   R ECHO 35
A 1  T290  R DEFERRED_PROCEDURE 290
A 1  T251  R CREATION_CALL_1 251
A 1  T236  R E_INSPECT 236
A*1  T40   R RUN_CLASS 40
A 1  T155  R CALL_1_C 155
A 1  T153  R CALL_0_C 153
A*1  T238  R WHEN_LIST 238
D 2  T316  R ARRAY[LOCAL_ARGUMENT1] 195,189
A 1  T225  R ARRAY[MANIFEST_STRING] 225
A*1  T80   R ARRAY[CREATION_CLAUSE] 80
A 1  T130  R CALL_INFIX_LE 130
A 1  T128  R CALL_INFIX_GE 128
D 4  T306  R EFFECTIVE_ROUTINE 311,307,308,310
A 1  T245  R WHEN_ITEM_2 245
A*1  T220  R COMPOUND 220
A 1  T66   E NATIVE_ARRAY[POSITION] 66
D 22 T58   R TYPE 354,373,285,282,280,279,278,277,276,275,274,273,272,271,270,268,267,265,264,262,261,259
A 1  T163  R ADDRESS_OF 163
A 1  T303  R NATIVE_JVM_INVOKESTATIC 303
A 1  T372  R RUN_FEATURE_1 372
A*1  T67   R STD_FILE_READ 67
A 1  T315  R DECLARATION_GROUP 315
A 1  T176  R BIT_CONSTANT 176
A 1  T226  R IFTHENELSE 226
A*1  T77   R RUN_CONTROL 77
A 1  T285  R TYPE_FORMAL_GENERIC 285
A 1  T387  E NATIVE_ARRAY[ADDRESS_OF] 387
A 1  T201  E NATIVE_ARRAY[CLASS_NAME] 201
A 1  T115  E NATIVE_ARRAY[EXPRESSION] 115
A 1  T72   E NATIVE_ARRAY[BASE_CLASS] 72
A 1  T254  R CREATION_CALL_2 254
A*1  T321  R EXPORT_ITEM 321
A*1  T110  R TAG_NAME 110
A 1  T358  E NATIVE_ARRAY[RUN_FEATURE_9] 358
A 1  T353  E NATIVE_ARRAY[RUN_FEATURE_6] 353
A 1  T351  E NATIVE_ARRAY[RUN_FEATURE_5] 351
A 1  T334  E NATIVE_ARRAY[RUN_FEATURE_2] 334
A*1  T219  R E_ENSURE 219
A*1  T73   R CLASS_NAME 73
A 1  T274  R TYPE_POINTER 274
A 1  T272  R TYPE_INTEGER 272
A*1  T50   R METHOD_INFO 50
A*1  T74   R SYSTEM_TOOLS 74
A 1  T59   R RUN_FEATURE_2 59
A 1  T141  R INFIX_NAME 141
D 6  T269  R TYPE_BASIC_EIFFEL_EXPANDED 272,274,268,275,271,270
A 1  T124  R CALL_INFIX_OR_ELSE 124
D 17 T164  R INSTRUCTION 288,287,258,256,254,251,248,236,235,226,229,224,222,181,168,167,166
A*1  T52   R FIXED_ARRAY[CP_INFO] 52
A*1  T27   R FIXED_ARRAY[INTEGER] 27
A 1  T279  R TYPE_EXPANDED 279
A*1  T49   R BINARY_FILE_WRITE 49
A 1  T296  R EXTERNAL_FUNCTION 296
A*1  T337  R DICTIONARY[DICTIONARY[RUN_FEATURE,STRING],STRING] 337
A 1  T126  R CALL_INFIX_AND_THEN 126
A 1  T151  R SIMPLE_FEATURE_NAME 151
A 1  T168  R PROC_CALL_N 168
A*1  T112  R TMP_NAME 112
A 1  T335  E SWITCH_COLLECTION 335
A 1  T320  R FROZEN_FEATURE_NAME 320
A 1  T256  R CREATION_CALL_3 256
D 2  T246  R LOOP_VARIANT 250,249
A 1  T44   R RUN_FEATURE_3 44
A*1  T91   R RENAME_PAIR 91
D 7  T293  R NATIVE 305,303,302,301,300,298,297
A 1  T319  R WRITABLE_ATTRIBUTE 319
A 1  T295  R EXTERNAL_PROCEDURE 295
D 30 T121  R CALL_PROC_CALL 116,122,135,146,131,134,139,147,198,142,156,140,168,126,124,128,130,153,155,167,137,166,138,127,129,136,123,125,133,148
A 1  T356  R FIXED_ARRAY[RUN_FEATURE_9] 356
A 1  T352  R FIXED_ARRAY[RUN_FEATURE_6] 352
A 1  T350  R FIXED_ARRAY[RUN_FEATURE_5] 350
A 1  T160  R E_VOID 160
A 1  T391  R RUN_FEATURE_4 391
A 1  T258  R CREATION_CALL_4 258
A 1  T60   R ARRAY[RUN_FEATURE_2] 60
A 1  T181  R E_PRECURSOR_PROCEDURE 181
A*1  T103  R CLIENT_LIST 103
A 1  T336  E SWITCH 336
A*1  T7    R STRING 7
D 2  T289  R DEFERRED_ROUTINE 290,292
A 1  T171  R E_TRUE 171
A*1  T365  R CECIL_POOL 365
A 1  T240  E NATIVE_ARRAY[E_WHEN] 240
A 1  T233  E NATIVE_ARRAY[IFTHEN] 233
A 1  T85   E NATIVE_ARRAY[PARENT] 85
A 1  T32   E NATIVE_ARRAY[STRING] 32
A 1  T140  R CALL_INFIX_FREEOP 140
A 1  T308  R FUNCTION 308
A*1  T10   R COMPILE_TO_JVM 10
A 1  T149  R E_OLD 149
A*1  T230  R IFTHEN 230
A 1  T209  R CST_ATT_BOOLEAN 209
A*1  T89   R RENAME_LIST 89
A 1  T302  R NATIVE_INLINE_WITHOUT_CURRENT 302
D 2  T180  R E_PRECURSOR 179,181
A*1  T82   R PARENT_LIST 82
A 1  T349  R RUN_FEATURE_5 349
A 1  T156  R CALL_N 156
A*1  T104  R ID_PROVIDER 104
A 1  T142  R CALL_PREFIX_FREEOP 142
A*1  T65   R POSITION 65
A*1  T283  R FORMAL_GENERIC_ARG 283
A*1  T362  R ARRAY[BOOLEAN] 362
A*1  T175  R ARRAY[INTEGER] 175
A*1  T237  R E_WHEN 237
A 1  T267  R TYPE_NATIVE_ARRAY 267
D 5  T56   R FEATURE_NAME 379,320,151,141,145
A 1  T158  R ONCE_RESULT 158
A*1  T325  R INDEX_CLAUSE 325
A 1  T348  R RUN_FEATURE_6 348
A 1  T248  R E_LOOP 248
A*1  T83   R PARENT 83
A 1  T214  R CST_ATT_BIT 214
A 1  T179  R E_PRECURSOR_FUNCTION 179
A*1  T51   R FIELD_INFO 51
A 1  T375  E NATIVE_ARRAY[TYPE_BIT_REF] 375
A 1  T328  E NATIVE_ARRAY[INDEX_CLAUSE] 328
A 1  T90   E NATIVE_ARRAY[FEATURE_NAME] 90
A*1  T323  R EXPORT_LIST 323
A*1  T239  R ARRAY[E_WHEN] 239
A*1  T232  R ARRAY[IFTHEN] 232
A*1  T84   R ARRAY[PARENT] 84
A*1  T75   R ARRAY[STRING] 75
A*1  T369  R ARRAY[E_REQUIRE] 369
A*1  T340  R ARRAY[RUN_CLASS] 340
A*1  T242  R ARRAY[WHEN_ITEM] 242
A*1  T106  R ARRAY[ASSERTION] 106
D 2  T309  R ONCE_ROUTINE 311,310
A 1  T300  R NATIVE_INLINE_WITH_CURRENT 300
A 1  T389  R RUN_FEATURE_7 389
A 1  T278  R TYPE_GENERIC 278
A 1  T386  R FIXED_ARRAY[ADDRESS_OF] 386
A*1  T200  R FIXED_ARRAY[CLASS_NAME] 200
A 4  T154  R FIXED_ARRAY[EXPRESSION] 386,212,206,154
A*1  T71   R FIXED_ARRAY[BASE_CLASS] 71
A 3  T366  R FIXED_ARRAY[TYPE] 377,374,366
D 2  T294  R EXTERNAL_ROUTINE 295,296
D 2  T183  R DECLARATION_LIST 191,182
A 1  T259  R TYPE_LIKE_FEATURE 259
D 51 T109  R EXPRESSION 388,194,187,234,116,122,123,124,125,126,127,129,128,130,131,133,134,135,136,137,138,139,198,140,149,197,192,184,179,178,177,176,174,173,172,171,163,161,160,159,158,156,155,153,151,150,142,146,147,148,114
A*1  T331  R FIXED_ARRAY[EFFECTIVE_ARG_LIST] 331
A 1  T198  R CALL_INFIX_POWER 198
A*1  T333  R DICTIONARY[RUN_FEATURE,STRING] 333
A 1  T371  R RUN_FEATURE_8 371
A*1  T367  R EXCEPTIONS_HANDLER 367
A*1  T47   R CONSTANT_POOL 47
D 2  T281  R TYPE_BIT 282,280
A*1  T79   R CREATION_CLAUSE 79
A 1  T194  R ARGUMENT_NAME1 194
A*1  T223  R CHECK_INVARIANT 223
A*1  T64   R FIXED_ARRAY[POSITION] 64
A 4  T113  R ARRAY[EXPRESSION] 195,189,225,113
A 1  T357  R RUN_FEATURE_9 357
A*1  T361  R GC_HANDLER 361
A 1  T229  R INSTRUCTION_WITH_COMMENT 229
A*1  T55   R EXCEPTION_TABLE 55
A 1  T390  R C_PRETTY_PRINTER 390
A*1  T152  R EFFECTIVE_ARG_LIST 152
A 1  T147  R CALL_PREFIX_PLUS 147
A 1  T139  R CALL_INFIX_TIMES 139
A 1  T134  R CALL_INFIX_MINUS 134
A*1  T23   R DICTIONARY[STRING,STRING] 23
A 1  T210  R CST_ATT_CHARACTER 210
A 1  T131  R CALL_INFIX_NEQ 131
A 1  T354  R TYPE_REF_TO_EXP 354
D 17 T94   R E_FEATURE 319,311,310,308,307,296,295,292,290,217,216,215,214,211,210,209,203
A 1  T370  E NATIVE_ARRAY[E_REQUIRE] 370
A 1  T341  E NATIVE_ARRAY[RUN_CLASS] 341
A 1  T243  E NATIVE_ARRAY[WHEN_ITEM] 243
A 1  T111  E NATIVE_ARRAY[ASSERTION] 111
A 1  T97   E NATIVE_ARRAY[E_FEATURE] 97
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T146  R CALL_PREFIX_MINUS 146
A*1  T70   R DICTIONARY[BASE_CLASS,STRING] 70
A 1  T373  R TYPE_BIT_REF 373
A 1  T374  R FIXED_ARRAY[TYPE_BIT_REF] 374
A*1  T88   R FIXED_ARRAY[FEATURE_NAME] 88
A 1  T173  R CHARACTER_CONSTANT 173
D 2  T169  R BOOLEAN_CONSTANT 172,171
A 1  T192  R ARGUMENT_NAME2 192
A 1  T307  R PROCEDURE 307
A 1  T217  R CST_ATT_INTEGER 217
A 1  T135  R CALL_INFIX_PLUS 135
A 1  T380  R RUN_FEATURE_10 380
A*1  T231  R IFTHENLIST 231
A*1  T69   R BASE_CLASS 69
A 1  T311  R ONCE_FUNCTION 311
A 1  T206  R FIXED_ARRAY[INTEGER_CONSTANT] 206
A 1  T264  R TYPE_ANY 264
A 1  T355  E FILE_TOOLS 355
A 1  T280  R TYPE_BIT_1 280
A 1  T178  R INTEGER_CONSTANT 178
A 1  T287  R ASSIGNMENT 287
A 1  T172  R E_FALSE 172
A*1  T326  R INDEX_LIST 326
A 1  T122  R CALL_INFIX_XOR 122
A*1  T87   R FEATURE_NAME_LIST 87
A 1  T224  R E_DEBUG 224
A 1  T195  R ARRAY[ARGUMENT_NAME1] 195
A*1  T101  R ARRAY[FEATURE_CLAUSE] 101
A 1  T174  R MANIFEST_STRING 174
A 1  T191  R FORMAL_ARG_LIST 191
A 1  T197  R IMPLICIT_CURRENT 197
A 1  T116  R CALL_INFIX_IMPLIES 116
A*1  T199  R CLASS_NAME_LIST 199
A*1  T107  R CLASS_INVARIANT 107
A*1  T291  R E_REQUIRE 291
A 1  T282  R TYPE_BIT_2 282
A 1  T363  E NATIVE_ARRAY[BOOLEAN] 363
A 1  T54   E NATIVE_ARRAY[CP_INFO] 54
A 1  T28   E NATIVE_ARRAY[INTEGER] 28
A 1  T250  R LOOP_VARIANT_1 250
A 1  T381  R RUN_FEATURE_11 381
A*1  T34   R EIFFEL_PARSER 34
A*1  T359  R ASSERTION_COLLECTOR 359
A 1  T301  R NATIVE_WITHOUT_CURRENT 301
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S148 T148;
typedef struct S159 T159;
typedef struct S182 T182;
typedef struct S178 T178;
typedef struct S152 T152;
typedef struct S283 T283;
typedef struct S263 T263;
typedef struct S39 T39;
typedef struct S376 T376;
typedef struct S347 T347;
typedef struct S284 T284;
typedef struct S273 T273;
typedef struct S222 T222;
typedef struct S360 T360;
typedef struct S322 T322;
typedef struct S313 T313;
typedef struct S189 T189;
typedef struct S92 T92;
typedef struct S249 T249;
typedef void*T21;
typedef struct S145 T145;
typedef struct S277 T277;
typedef struct S133 T133;
typedef struct S342 T342;
typedef struct S95 T95;
typedef struct S321 T321;
typedef struct S187 T187;
typedef struct S91 T91;
typedef struct S125 T125;
typedef void*T36;
typedef struct S383 T383;
typedef struct S377 T377;
typedef struct S212 T212;
typedef struct S19 T19;
typedef struct S215 T215;
typedef struct S100 T100;
typedef struct S354 T354;
typedef struct S174 T174;
typedef struct S79 T79;
typedef struct S123 T123;
typedef struct S76 T76;
typedef struct S46 T46;
typedef struct S338 T338;
typedef struct S270 T270;
typedef struct S288 T288;
typedef struct S333 T333;
typedef struct S379 T379;
typedef struct S161 T161;
typedef struct S318 T318;
typedef struct S53 T53;
typedef struct S310 T310;
typedef struct S202 T202;
typedef struct S105 T105;
typedef void*T384;
typedef struct S98 T98;
typedef struct S99 T99;
typedef struct S41 T41;
typedef struct S86 T86;
typedef struct S216 T216;
typedef struct S203 T203;
typedef struct S208 T208;
typedef struct S344 T344;
typedef struct S31 T31;
typedef struct S261 T261;
typedef struct S271 T271;
typedef struct S136 T136;
typedef struct S150 T150;
typedef struct S247 T247;
typedef struct S388 T388;
typedef struct S129 T129;
typedef struct S127 T127;
typedef struct S275 T275;
typedef struct S368 T368;
typedef struct S42 T42;
typedef struct S194 T194;
typedef struct S265 T265;
typedef struct S298 T298;
typedef struct S177 T177;
typedef void*T346;
typedef struct S305 T305;
typedef struct S184 T184;
typedef void*T364;
typedef struct S268 T268;
typedef struct S343 T343;
typedef struct S96 T96;
typedef struct S385 T385;
typedef struct S276 T276;
typedef struct S138 T138;
typedef struct S345 T345;
typedef struct S327 T327;
typedef struct S262 T262;
typedef struct S329 T329;
typedef struct S221 T221;
typedef struct S61 T61;
typedef struct S297 T297;
typedef struct S292 T292;
typedef struct S211 T211;
typedef struct S78 T78;
typedef struct S235 T235;
typedef void*T63;
typedef struct S114 T114;
typedef struct S166 T166;
typedef struct S137 T137;
typedef struct S244 T244;
typedef struct S234 T234;
typedef struct S167 T167;
typedef struct S35 T35;
typedef struct S290 T290;
typedef struct S251 T251;
typedef struct S236 T236;
typedef struct S40 T40;
typedef struct S155 T155;
typedef struct S153 T153;
typedef struct S238 T238;
typedef struct S225 T225;
typedef struct S80 T80;
typedef struct S130 T130;
typedef struct S128 T128;
typedef struct S245 T245;
typedef struct S220 T220;
typedef struct S65 T65;
typedef struct S163 T163;
typedef struct S303 T303;
typedef struct S372 T372;
typedef struct S67 T67;
typedef struct S315 T315;
typedef struct S176 T176;
typedef struct S226 T226;
typedef struct S77 T77;
typedef struct S285 T285;
typedef struct S73 T73;
typedef struct S69 T69;
typedef struct S254 T254;
typedef struct S110 T110;
typedef struct S357 T357;
typedef struct S348 T348;
typedef struct S349 T349;
typedef struct S59 T59;
typedef struct S219 T219;
typedef struct S274 T274;
typedef struct S272 T272;
typedef struct S50 T50;
typedef struct S74 T74;
typedef struct S141 T141;
typedef struct S124 T124;
typedef struct S52 T52;
typedef struct S27 T27;
typedef struct S279 T279;
typedef struct S49 T49;
typedef struct S296 T296;
typedef struct S337 T337;
typedef struct S126 T126;
typedef struct S151 T151;
typedef struct S168 T168;
typedef struct S112 T112;
typedef int T335;
typedef struct S320 T320;
typedef struct S256 T256;
typedef struct S44 T44;
typedef struct S319 T319;
typedef struct S295 T295;
typedef struct S356 T356;
typedef struct S352 T352;
typedef struct S350 T350;
typedef struct S160 T160;
typedef struct S391 T391;
typedef struct S258 T258;
typedef struct S60 T60;
typedef struct S181 T181;
typedef struct S103 T103;
typedef int T336;
typedef struct S7 T7;
typedef struct S171 T171;
typedef struct S365 T365;
typedef struct S237 T237;
typedef struct S230 T230;
typedef struct S83 T83;
typedef struct S140 T140;
typedef struct S308 T308;
typedef struct S10 T10;
typedef struct S149 T149;
typedef struct S209 T209;
typedef struct S89 T89;
typedef struct S302 T302;
typedef struct S82 T82;
typedef struct S156 T156;
typedef struct S104 T104;
typedef struct S142 T142;
typedef struct S362 T362;
typedef struct S175 T175;
typedef struct S267 T267;
typedef struct S158 T158;
typedef struct S325 T325;
typedef struct S248 T248;
typedef struct S214 T214;
typedef struct S179 T179;
typedef struct S51 T51;
typedef struct S373 T373;
typedef struct S323 T323;
typedef struct S239 T239;
typedef struct S232 T232;
typedef struct S84 T84;
typedef struct S75 T75;
typedef struct S369 T369;
typedef struct S340 T340;
typedef struct S242 T242;
typedef struct S106 T106;
typedef struct S300 T300;
typedef struct S389 T389;
typedef struct S278 T278;
typedef struct S386 T386;
typedef struct S200 T200;
typedef struct S154 T154;
typedef struct S71 T71;
typedef struct S366 T366;
typedef struct S259 T259;
typedef struct S331 T331;
typedef struct S198 T198;
typedef struct S371 T371;
typedef struct S367 T367;
typedef struct S47 T47;
typedef struct S223 T223;
typedef struct S64 T64;
typedef struct S113 T113;
typedef struct S361 T361;
typedef struct S229 T229;
typedef void*T55;
typedef struct S390 T390;
typedef struct S147 T147;
typedef struct S139 T139;
typedef struct S134 T134;
typedef struct S23 T23;
typedef struct S210 T210;
typedef struct S131 T131;
typedef struct S291 T291;
typedef struct S146 T146;
typedef struct S70 T70;
typedef struct S374 T374;
typedef struct S88 T88;
typedef struct S173 T173;
typedef struct S192 T192;
typedef struct S307 T307;
typedef struct S217 T217;
typedef struct S135 T135;
typedef struct S380 T380;
typedef struct S231 T231;
typedef struct S311 T311;
typedef struct S206 T206;
typedef struct S264 T264;
typedef int T355;
typedef struct S280 T280;
typedef struct S287 T287;
typedef struct S172 T172;
typedef struct S326 T326;
typedef struct S122 T122;
typedef struct S87 T87;
typedef struct S224 T224;
typedef struct S195 T195;
typedef struct S101 T101;
typedef struct S191 T191;
typedef struct S197 T197;
typedef struct S116 T116;
typedef struct S199 T199;
typedef struct S107 T107;
typedef struct S282 T282;
typedef struct S250 T250;
typedef struct S381 T381;
typedef struct S34 T34;
typedef struct S359 T359;
typedef struct S301 T301;

/*C Header Pass 2 :*/
typedef T0**T207;
typedef T0**T332;
typedef T0**T286;
typedef T0**T324;
typedef T0**T314;
typedef T0**T228;
typedef T0**T190;
typedef T0**T93;
typedef T0**T62;
typedef T0**T266;
typedef T0**T378;
typedef T0**T317;
typedef T0**T213;
typedef T0**T81;
typedef T0**T339;
typedef T0**T330;
typedef T0**T196;
typedef T0**T102;
typedef T0**T66;
typedef T0**T387;
typedef T0**T201;
typedef T0**T115;
typedef T0**T72;
typedef T0**T358;
typedef T0**T353;
typedef T0**T351;
typedef T0**T334;
typedef T0**T240;
typedef T0**T233;
typedef T0**T85;
typedef T0**T32;
typedef T0**T375;
typedef T0**T328;
typedef T0**T90;
typedef T0**T370;
typedef T0**T341;
typedef T0**T243;
typedef T0**T111;
typedef T0**T97;
typedef T3*T9;
typedef T6*T363;
typedef T0**T54;
typedef T2*T28;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S148{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T148 M148;
struct S159{int id;T0* _start_position;T0* _run_feature;};
extern T159 M159;
struct S182{int id;T0* _list;T0* _flat_list;};
extern T182 M182;
struct S263{T266 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T263 M263;
struct S39{T0* _root_procedure;T6 _is_ready;T6 _short_flag;T6 _pretty_flag;T2 _magic_count;T2 _top;};
extern T39 M39;
struct S376{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T376 M376;
struct S347{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T347 M347;
struct S284{T286 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T284 M284;
struct S273{int id;T0* _base_class_name;};
extern T273 M273;
struct S222{int id;T0* _check_invariant;T0* _current_type;};
extern T222 M222;
struct S360{int id;T62 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T360 M360;
struct S322{T324 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T322 M322;
struct S313{T314 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T313 M313;
struct S189{int id;T190 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T189 M189;
struct S92{T93 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T92 M92;
struct S249{int id;T0* _comment;T0* _expression;T0* _current_type;T0* _tag;};
extern T249 M249;
extern T21 M21;
struct S145{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T145 M145;
struct S277{int id;T0* _base_class_name;};
extern T277 M277;
struct S133{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T133 M133;
struct S342{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T342 M342;
struct S95{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T95 M95;
struct S125{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T125 M125;
extern T36 M36;
struct S383{T0* _item;};
extern T383 M383;
struct S377{int id;T378 _storage;T2 _capacity;T2 _upper;};
extern T377 M377;
struct S212{int id;T213 _storage;T2 _capacity;T2 _upper;};
extern T212 M212;
struct S19{T2 _item;};
extern T19 M19;
struct S215{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T215 M215;
struct S100{T0* _clients;T0* _comment;T0* _list;};
extern T100 M100;
struct S123{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T123 M123;
struct S76{T0* _path;T2 _count;};
extern T76 M76;
struct S46{T2 _max_stack;T2 _max_locals;T2 _stack_level;T2 _check_flag_idx;T2 _skip_check;};
extern T46 M46;
struct S338{T339 _storage;T2 _capacity;T2 _upper;};
extern T338 M338;
struct S270{int id;T0* _base_class_name;};
extern T270 M270;
struct S288{int id;T0* _left_side;T0* _right_side;T0* _current_type;};
extern T288 M288;
struct S379{int id;T0* _enclosing;T0* _to_key;};
extern T379 M379;
struct S161{int id;T0* _start_position;T0* _result_type;};
extern T161 M161;
struct S318{int id;T0* _name;};
extern T318 M318;
struct S53{T3 _tag;T0* _info;};
extern T53 M53;
struct S310{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T310 M310;
struct S202{T0* _arguments;T0* _type;T0* _header_comment;T0* _obsolete_mark;T0* _require_assertion;T0* _local_vars;T0* _routine_body;};
extern T202 M202;
struct S105{T0* _tag;T0* _expression;T0* _comment;T0* _current_type;};
extern T105 M105;
extern T384 M384;
struct S98{T0* _start_position;T0* _list;};
extern T98 M98;
struct S99{T0* _list;};
extern T99 M99;
struct S41{T2 _error_counter;T2 _warning_counter;T6 _no_warning;};
extern T41 M41;
struct S86{T0* _start_position;T0* _list;};
extern T86 M86;
struct S216{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T216 M216;
struct S203{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _values;};
extern T203 M203;
struct S208{T2 _value;};
extern T208 M208;
struct S344{T85 _storage;T2 _capacity;T2 _upper;};
extern T344 M344;
struct S31{T32 _storage;T2 _capacity;T2 _upper;};
extern T31 M31;
struct S261{int id;T0* _start_position;T0* _run_type;};
extern T261 M261;
struct S271{int id;T0* _base_class_name;};
extern T271 M271;
struct S136{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T136 M136;
struct S150{int id;T0* _start_position;T0* _current_type;T0* _list;T0* _result_type_memory;};
extern T150 M150;
struct S247{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T247 M247;
struct S388{int id;T0* _expression;T0* _result_type;};
extern T388 M388;
struct S129{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T129 M129;
struct S127{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T127 M127;
struct S275{int id;T0* _base_class_name;};
extern T275 M275;
struct S368{T0* _list;};
extern T368 M368;
struct S187{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;T6 _is_used;};
extern T187 M187;
struct S42{int id;T0* _output_name;T2 _static_expression_count;T2 _top;T2 _direct_call_count;T2 _switch_count;T0* _current_frame;T2 _this_class_idx;T2 _super_class_idx;};
extern T42 M42;
struct S265{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T265 M265;
struct S298{int id;};
extern T298 M298;
struct S177{int id;T0* _start_position;T0* _to_string;};
extern T177 M177;
extern T346 M346;
struct S305{int id;};
extern T305 M305;
struct S184{int id;T0* _start_position;T2 _rank;T0* _local_var_list;};
extern T184 M184;
extern T364 M364;
struct S268{int id;T0* _base_class_name;};
extern T268 M268;
struct S343{T341 _storage;T2 _capacity;T2 _upper;};
extern T343 M343;
struct S96{T97 _storage;T2 _capacity;T2 _upper;};
extern T96 M96;
struct S385{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T385 M385;
struct S276{int id;T0* _base_class_name;};
extern T276 M276;
struct S138{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T138 M138;
struct S345{T2 _fields_count;};
extern T345 M345;
struct S327{T328 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T327 M327;
struct S262{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_feature;};
extern T262 M262;
struct S329{T330 _storage;T2 _capacity;T2 _upper;};
extern T329 M329;
struct S221{T228 _storage;T2 _capacity;T2 _upper;};
extern T221 M221;
struct S61{int id;T62 _storage;T2 _capacity;T2 _upper;};
extern T61 M61;
struct S297{int id;};
extern T297 M297;
struct S292{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _result_type;};
extern T292 M292;
struct S211{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _first_value;T0* _remainder;};
extern T211 M211;
struct S78{T0* _list;};
extern T78 M78;
struct S235{int id;T0* _start_position;T0* _run_feature;};
extern T235 M235;
extern T63 M63;
struct S114{int id;T0* _start_position;T0* _list;T0* _result_type;T0* _current_type;};
extern T114 M114;
struct S166{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T166 M166;
struct S137{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T137 M137;
struct S244{int id;T0* _e_when;T0* _expression;T2 _expression_value;};
extern T244 M244;
struct S234{int id;T0* _expression;T0* _comment;};
extern T234 M234;
struct S167{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T167 M167;
struct S35{T6 _verbose;};
extern T35 M35;
struct S290{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;};
extern T290 M290;
struct S251{int id;T0* _start_position;T0* _writable;T0* _current_type;};
extern T251 M251;
struct S236{int id;T0* _start_position;T0* _expression;T0* _when_list;T0* _else_position;T0* _else_compound;T0* _current_type;};
extern T236 M236;
struct S40{T0* _current_type;T2 _id;T6 _at_run_time;T0* _running;T0* _class_invariant;T6 _compile_to_c_done;T0* _feature_dictionary;T0* _actuals_clients;T0* _writable_attributes_mem;T0* _fully_qualified_name_memory;T6 _strip_used;T6 _runnable_class_invariant_done;};
extern T40 M40;
struct S155{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T155 M155;
struct S153{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T153 M153;
struct S238{T0* _e_inspect;T0* _list;};
extern T238 M238;
struct S225{int id;T213 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T225 M225;
struct S80{T81 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T80 M80;
struct S130{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T130 M130;
struct S128{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T128 M128;
struct S245{int id;T0* _e_when;T0* _upper;T0* _lower;T2 _lower_value;T2 _upper_value;};
extern T245 M245;
struct S220{T0* _header_comment;T0* _current_type;T0* _first_one;T0* _remainder;};
extern T220 M220;
struct S163{int id;T0* _feature_name;T0* _current_type;T0* _run_feature;};
extern T163 M163;
struct S303{int id;};
extern T303 M303;
struct S372{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _value;T0* _result_type;};
extern T372 M372;
struct S67{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T67 M67;
struct S315{int id;T0* _name_list;};
extern T315 M315;
struct S176{int id;T0* _start_position;T0* _value;T0* _result_type;T0* _hexa;};
extern T176 M176;
struct S226{int id;T0* _start_position;T0* _ifthenlist;T0* _else_compound;T0* _current_type;};
extern T226 M226;
struct S77{T2 _level;T6 _trace;T0* _root_class;T6 _generating_type_used;T6 _generator_used;T0* _cecil_path;T0* _root_procedure_memory;};
extern T77 M77;
struct S285{int id;T0* _formal_name;T2 _rank;T0* _run_type;};
extern T285 M285;
struct S254{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _type;};
extern T254 M254;
struct S321{T0* _clients;T0* _list;};
extern T321 M321;
struct S110{T0* _to_string;T0* _start_position;};
extern T110 M110;
struct S219{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_ensure_then;};
extern T219 M219;
struct S73{T0* _to_string;T0* _start_position;};
extern T73 M73;
struct S274{int id;T0* _base_class_name;};
extern T274 M274;
struct S272{int id;T0* _base_class_name;};
extern T272 M272;
struct S50{T2 _count;T2 _access_flags;T2 _name_index;T2 _descriptor_index;};
extern T50 M50;
struct S74{T0* _system_name;T0* _sys_directory;T0* _bin_directory;};
extern T74 M74;
struct S59{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _result_type;};
extern T59 M59;
struct S141{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T141 M141;
struct S124{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T124 M124;
struct S52{T54 _storage;T2 _capacity;T2 _upper;};
extern T52 M52;
struct S27{T28 _storage;T2 _capacity;T2 _upper;};
extern T27 M27;
struct S279{int id;T0* _start_position;T0* _written_mark;T0* _mapped;T0* _run_time_mark;T0* _run_type;};
extern T279 M279;
struct S49{T0* _path;T8 _output_stream;};
extern T49 M49;
struct S296{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;T0* _result_type;};
extern T296 M296;
struct S337{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T337 M337;
struct S126{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T126 M126;
struct S151{int id;T0* _to_string;T0* _start_position;T0* _run_feature_2;};
extern T151 M151;
struct S168{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T168 M168;
struct S112{T2 _column;T2 _line;T0* _aliased_string_memory;};
extern T112 M112;
extern T335 M335;
struct S320{int id;T0* _feature_name;};
extern T320 M320;
struct S256{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _call;};
extern T256 M256;
struct S44{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;T2 _in_line_status;};
extern T44 M44;
struct S91{T0* _new_name;T0* _old_name;};
extern T91 M91;
struct S319{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;};
extern T319 M319;
struct S295{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;};
extern T295 M295;
struct S356{int id;T358 _storage;T2 _capacity;T2 _upper;};
extern T356 M356;
struct S352{int id;T353 _storage;T2 _capacity;T2 _upper;};
extern T352 M352;
struct S350{int id;T351 _storage;T2 _capacity;T2 _upper;};
extern T350 M350;
struct S160{int id;T0* _start_position;};
extern T160 M160;
struct S391{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;T2 _static_value_mem;T2 _in_line_status;T6 _is_static_flag;};
extern T391 M391;
struct S258{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _call;T0* _type;};
extern T258 M258;
struct S60{int id;T334 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T60 M60;
struct S181{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T181 M181;
struct S103{T0* _start_position;T0* _list;};
extern T103 M103;
extern T336 M336;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S171{int id;T0* _start_position;};
extern T171 M171;
struct S365{T0* _user_cecil_list;T0* _user_cecil_name;T0* _user_path_h;};
extern T365 M365;
struct S140{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T140 M140;
struct S308{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T308 M308;
struct S10{T0* _level_flag;};
extern T10 M10;
struct S149{int id;T0* _expression;T0* _current_type;T2 _id;};
extern T149 M149;
struct S230{T0* _expression;T0* _then_compound;T0* _current_type;T2 _point2;};
extern T230 M230;
struct S209{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T209 M209;
struct S89{T0* _list;};
extern T89 M89;
struct S302{int id;};
extern T302 M302;
struct S82{T0* _base_class;T0* _start_position;T0* _heading_comment;T0* _list;};
extern T82 M82;
struct S349{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T349 M349;
struct S156{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T156 M156;
struct S104{T0* _mem_id;T0* _mem_str;};
extern T104 M104;
struct S142{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T142 M142;
struct S65{T0* _base_class_name;T2 _mem_line_column;};
extern T65 M65;
struct S283{T0* _name;T0* _constraint;};
extern T283 M283;
struct S362{T363 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T362 M362;
struct S175{T28 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T175 M175;
struct S237{T0* _start_position;T0* _list;T0* _header_comment;T0* _compound;T0* _when_list;T0* _values;T2 _point2;};
extern T237 M237;
struct S267{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type;};
extern T267 M267;
struct S158{int id;T0* _start_position;T0* _run_feature_6;};
extern T158 M158;
struct S325{T0* _tag;T0* _list;};
extern T325 M325;
struct S348{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T348 M348;
struct S248{int id;T0* _start_position;T0* _initialize;T0* _invariant_clause;T0* _variant_clause;T0* _until_expression;T0* _loop_body;T0* _current_type;};
extern T248 M248;
struct S83{T0* _parent_list;T0* _type;T0* _comment;T0* _rename_list;T0* _export_list;T0* _undefine_list;T0* _redefine_list;T0* _select_list;T0* _undefine_memory1;T0* _undefine_memory2;};
extern T83 M83;
struct S214{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T214 M214;
struct S179{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T179 M179;
struct S51{T2 _count;};
extern T51 M51;
struct S323{T0* _start_position;T0* _items;};
extern T323 M323;
struct S239{T240 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T239 M239;
struct S232{T233 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T232 M232;
struct S84{T85 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T84 M84;
struct S75{T32 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T75 M75;
struct S369{T370 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T369 M369;
struct S340{T341 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T340 M340;
struct S242{T243 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T242 M242;
struct S106{T111 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T106 M106;
struct S300{int id;};
extern T300 M300;
struct S389{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _ensure_assertion;};
extern T389 M389;
struct S278{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T278 M278;
struct S386{int id;T387 _storage;T2 _capacity;T2 _upper;};
extern T386 M386;
struct S200{T201 _storage;T2 _capacity;T2 _upper;};
extern T200 M200;
struct S154{int id;T115 _storage;T2 _capacity;T2 _upper;};
extern T154 M154;
struct S71{T72 _storage;T2 _capacity;T2 _upper;};
extern T71 M71;
struct S366{int id;T266 _storage;T2 _capacity;T2 _upper;};
extern T366 M366;
struct S259{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_type;};
extern T259 M259;
struct S331{T332 _storage;T2 _capacity;T2 _upper;};
extern T331 M331;
struct S198{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T198 M198;
struct S333{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T333 M333;
struct S371{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T2 _static_value_mem;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T371 M371;
struct S367{T6 _used;};
extern T367 M367;
struct S47{T2 _cp_up;T2 _idx_constant_utf8;T2 _idx_java_lang_object;T2 _idx_jvm_root_class;};
extern T47 M47;
struct S79{T0* _start_position;T0* _clients;T0* _comment;T0* _procedure_list;};
extern T79 M79;
struct S194{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;};
extern T194 M194;
struct S223{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T223 M223;
struct S64{T66 _storage;T2 _capacity;T2 _upper;};
extern T64 M64;
struct S113{int id;T115 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T113 M113;
struct S357{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T357 M357;
struct S361{T6 _is_off;T6 _dispose_flag;};
extern T361 M361;
struct S229{int id;T0* _instruction;T0* _comment;};
extern T229 M229;
extern T55 M55;
struct S390{int id;T0* _output_name;T6 _basic_directory_used;};
extern T390 M390;
struct S152{T0* _first_one;T0* _remainder;T0* _current_type;};
extern T152 M152;
struct S147{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T147 M147;
struct S139{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T139 M139;
struct S134{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T134 M134;
struct S23{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T23 M23;
struct S210{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T210 M210;
struct S131{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T131 M131;
struct S354{int id;T0* _run_class;T0* _written_mark;T0* _expanded_type;};
extern T354 M354;
struct S146{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T146 M146;
struct S70{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T70 M70;
struct S373{int id;T0* _type_bit;T0* _written_mark;T0* _run_time_mark;};
extern T373 M373;
struct S374{int id;T375 _storage;T2 _capacity;T2 _upper;};
extern T374 M374;
struct S88{T90 _storage;T2 _capacity;T2 _upper;};
extern T88 M88;
struct S173{int id;T0* _start_position;T3 _value;T2 _pretty_print_mode;};
extern T173 M173;
struct S192{int id;T0* _start_position;T2 _rank;T0* _formal_arg_list;};
extern T192 M192;
struct S307{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T307 M307;
struct S217{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T217 M217;
struct S135{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T135 M135;
struct S380{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T380 M380;
struct S231{T0* _list;T0* _current_type;};
extern T231 M231;
struct S69{T2 _id;T0* _path;T0* _index_list;T0* _heading_comment1;T6 _is_deferred;T6 _is_expanded;T0* _name;T0* _formal_generic_list;T0* _heading_comment2;T0* _obsolete_type_string;T0* _parent_list;T0* _creation_clause_list;T0* _feature_clause_list;T0* _class_invariant;T0* _end_comment;T0* _feature_dictionary;T0* _isom;};
extern T69 M69;
struct S311{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T311 M311;
struct S206{int id;T207 _storage;T2 _capacity;T2 _upper;};
extern T206 M206;
struct S264{int id;T0* _base_class_name;};
extern T264 M264;
extern T355 M355;
struct S280{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;};
extern T280 M280;
struct S178{int id;T0* _start_position;T2 _value;};
extern T178 M178;
struct S287{int id;T0* _left_side;T0* _right_side;};
extern T287 M287;
struct S172{int id;T0* _start_position;};
extern T172 M172;
struct S326{T0* _list;};
extern T326 M326;
struct S122{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T122 M122;
struct S87{T0* _first;T0* _remainder;};
extern T87 M87;
struct S224{int id;T0* _start_position;T0* _list;T0* _compound;T0* _current_type;};
extern T224 M224;
struct S195{int id;T196 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T195 M195;
struct S101{T102 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T101 M101;
struct S174{int id;T0* _start_position;T0* _to_string;T0* _break;T0* _ascii;T0* _percent;T0* _mangling;};
extern T174 M174;
struct S191{int id;T0* _list;T0* _flat_list;};
extern T191 M191;
struct S197{int id;T0* _start_position;T0* _result_type;};
extern T197 M197;
struct S116{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T116 M116;
struct S199{T0* _first;T0* _remainder;};
extern T199 M199;
struct S107{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T107 M107;
struct S291{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_require_else;};
extern T291 M291;
struct S282{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;T2 _nb;};
extern T282 M282;
struct S250{int id;T0* _comment;T0* _expression;T0* _current_type;};
extern T250 M250;
struct S381{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T381 M381;
struct S34{T6 _case_insensitive;T6 _no_style_warning;T6 _drop_comments;T6 _is_running;T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_comments;T6 _inside_function;T6 _inside_once_function;T0* _formal_generic_list;T6 _in_ensure;T6 _in_rescue;T0* _arguments;T0* _local_vars;T6 _ok;T2 _last_ascii_code;T0* _last_base_class;T0* _last_base_type;T0* _last_binary;T0* _last_bit_constant;T0* _last_boolean_constant;T0* _last_character_constant;T0* _last_class_name;T0* _last_class_type;T0* _last_expression;T0* _last_feature_declaration;T0* _last_feature_name;T0* _last_feature_name_list;T0* _last_keyword;T0* _last_type_formal_generic;T0* _last_infix;T0* _last_prefix;T0* _last_integer_constant;T0* _last_instruction;T0* _last_index_value;T0* _last_manifest_constant;T0* _last_manifest_string;T0* _last_parent;T0* _last_real_constant;T0* _last_type;T0* _last_tag_mark;T2 _start_column;T2 _start_line;};
extern T34 M34;
struct S359{T6 _processing_require;T0* _header_comment;};
extern T359 M359;
struct S301{int id;};
extern T301 M301;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T2 r2min(T2 C,T2 a1);
T2 r2max(T2 C,T2 a1);
T2 r2_px_94(T2 C,T2 a1);
T2 r2hash_code(T2 C);
T3 r2digit(T2 C);
T3 r2hexadecimal_digit(T2 C);
void r2append_in(T2 C,T0* a1);
T0* r2to_string(T2 C);
T3 r3to_lower(T3 C);
T2 r3value(T3 C);
T6 r3is_letter(T3 C);
T6 r3_px_6061(T3 C,T3 a1);
T6 r3_px_6261(T3 C,T3 a1);
T6 r3is_separator(T3 C);
T6 r3same_as(T3 C,T3 a1);
T6 r3is_digit(T3 C);
T6 r3_px_60(T3 C,T3 a1);
T3 r3to_upper(T3 C);
T207 r207realloc(T207 C,T2 a1,T2 a2);
void r207copy_from(T207 C,T207 a1,T2 a2);
void r207set_all_with(T207 C,T0* a1,T2 a2);
void r207clear_all(T207 C,T2 a1);
T332 r332realloc(T332 C,T2 a1,T2 a2);
void r332copy_from(T332 C,T332 a1,T2 a2);
void r332set_all_with(T332 C,T0* a1,T2 a2);
T286 r286realloc(T286 C,T2 a1,T2 a2);
void r286copy_from(T286 C,T286 a1,T2 a2);
T324 r324realloc(T324 C,T2 a1,T2 a2);
void r324copy_from(T324 C,T324 a1,T2 a2);
T314 r314realloc(T314 C,T2 a1,T2 a2);
void r314copy_from(T314 C,T314 a1,T2 a2);
T228 r228realloc(T228 C,T2 a1,T2 a2);
void r228copy_from(T228 C,T228 a1,T2 a2);
void r228clear_all(T228 C,T2 a1);
T190 r190realloc(T190 C,T2 a1,T2 a2);
void r190copy_from(T190 C,T190 a1,T2 a2);
void r190set_all_with(T190 C,T0* a1,T2 a2);
T93 r93realloc(T93 C,T2 a1,T2 a2);
void r93copy_from(T93 C,T93 a1,T2 a2);
void r62clear(T62 C,T2 a1,T2 a2);
T62 r62realloc(T62 C,T2 a1,T2 a2);
void r62move(T62 C,T2 a1,T2 a2,T2 a3);
void r62copy_from(T62 C,T62 a1,T2 a2);
void r62set_all_with(T62 C,T0* a1,T2 a2);
T2 r62fast_index_of(T62 C,T0* a1,T2 a2);
T266 r266realloc(T266 C,T2 a1,T2 a2);
void r266copy_from(T266 C,T266 a1,T2 a2);
void r266set_all_with(T266 C,T0* a1,T2 a2);
T378 r378realloc(T378 C,T2 a1,T2 a2);
void r378copy_from(T378 C,T378 a1,T2 a2);
void r378set_all_with(T378 C,T0* a1,T2 a2);
T213 r213realloc(T213 C,T2 a1,T2 a2);
void r213copy_from(T213 C,T213 a1,T2 a2);
void r213set_all_with(T213 C,T0* a1,T2 a2);
void r213clear_all(T213 C,T2 a1);
T81 r81realloc(T81 C,T2 a1,T2 a2);
void r81copy_from(T81 C,T81 a1,T2 a2);
T339 r339realloc(T339 C,T2 a1,T2 a2);
void r339copy_from(T339 C,T339 a1,T2 a2);
void r339set_all_with(T339 C,T0* a1,T2 a2);
T330 r330realloc(T330 C,T2 a1,T2 a2);
void r330copy_from(T330 C,T330 a1,T2 a2);
void r330set_all_with(T330 C,T0* a1,T2 a2);
T196 r196realloc(T196 C,T2 a1,T2 a2);
void r196copy_from(T196 C,T196 a1,T2 a2);
void r196set_all_with(T196 C,T0* a1,T2 a2);
T102 r102realloc(T102 C,T2 a1,T2 a2);
void r102copy_from(T102 C,T102 a1,T2 a2);
T66 r66realloc(T66 C,T2 a1,T2 a2);
T6 r66equal_like(T0* a1,T0* a2);
void r66copy_from(T66 C,T66 a1,T2 a2);
T2 r66fast_index_of(T66 C,T0* a1,T2 a2);
T2 r66index_of(T66 C,T0* a1,T2 a2);
T387 r387realloc(T387 C,T2 a1,T2 a2);
void r387copy_from(T387 C,T387 a1,T2 a2);
void r387set_all_with(T387 C,T0* a1,T2 a2);
void r387clear_all(T387 C,T2 a1);
T201 r201realloc(T201 C,T2 a1,T2 a2);
void r201copy_from(T201 C,T201 a1,T2 a2);
T115 r115realloc(T115 C,T2 a1,T2 a2);
void r115copy_from(T115 C,T115 a1,T2 a2);
void r115set_all_with(T115 C,T0* a1,T2 a2);
void r115clear_all(T115 C,T2 a1);
T72 r72realloc(T72 C,T2 a1,T2 a2);
void r72copy_from(T72 C,T72 a1,T2 a2);
void r72set_all_with(T72 C,T0* a1,T2 a2);
T2 r72fast_index_of(T72 C,T0* a1,T2 a2);
T358 r358realloc(T358 C,T2 a1,T2 a2);
void r358copy_from(T358 C,T358 a1,T2 a2);
void r358set_all_with(T358 C,T0* a1,T2 a2);
T2 r358fast_index_of(T358 C,T0* a1,T2 a2);
T353 r353realloc(T353 C,T2 a1,T2 a2);
void r353copy_from(T353 C,T353 a1,T2 a2);
void r353set_all_with(T353 C,T0* a1,T2 a2);
T2 r353fast_index_of(T353 C,T0* a1,T2 a2);
T351 r351realloc(T351 C,T2 a1,T2 a2);
void r351copy_from(T351 C,T351 a1,T2 a2);
void r351set_all_with(T351 C,T0* a1,T2 a2);
T2 r351fast_index_of(T351 C,T0* a1,T2 a2);
void r334clear(T334 C,T2 a1,T2 a2);
T334 r334realloc(T334 C,T2 a1,T2 a2);
void r334move(T334 C,T2 a1,T2 a2,T2 a3);
void r334copy_from(T334 C,T334 a1,T2 a2);
void r334set_all_with(T334 C,T0* a1,T2 a2);
T240 r240realloc(T240 C,T2 a1,T2 a2);
void r240copy_from(T240 C,T240 a1,T2 a2);
T233 r233realloc(T233 C,T2 a1,T2 a2);
void r233copy_from(T233 C,T233 a1,T2 a2);
T85 r85realloc(T85 C,T2 a1,T2 a2);
void r85copy_from(T85 C,T85 a1,T2 a2);
T32 r32realloc(T32 C,T2 a1,T2 a2);
T6 r32equal_like(T0* a1,T0* a2);
void r32copy_from(T32 C,T32 a1,T2 a2);
void r32set_all_with(T32 C,T0* a1,T2 a2);
T2 r32fast_index_of(T32 C,T0* a1,T2 a2);
T2 r32index_of(T32 C,T0* a1,T2 a2);
T375 r375realloc(T375 C,T2 a1,T2 a2);
void r375copy_from(T375 C,T375 a1,T2 a2);
void r375set_all_with(T375 C,T0* a1,T2 a2);
T328 r328realloc(T328 C,T2 a1,T2 a2);
void r328copy_from(T328 C,T328 a1,T2 a2);
T90 r90realloc(T90 C,T2 a1,T2 a2);
void r90copy_from(T90 C,T90 a1,T2 a2);
void r90set_all_with(T90 C,T0* a1,T2 a2);
T370 r370realloc(T370 C,T2 a1,T2 a2);
void r370copy_from(T370 C,T370 a1,T2 a2);
T341 r341realloc(T341 C,T2 a1,T2 a2);
void r341copy_from(T341 C,T341 a1,T2 a2);
void r341set_all_with(T341 C,T0* a1,T2 a2);
T2 r341fast_index_of(T341 C,T0* a1,T2 a2);
T243 r243realloc(T243 C,T2 a1,T2 a2);
void r243copy_from(T243 C,T243 a1,T2 a2);
T111 r111realloc(T111 C,T2 a1,T2 a2);
void r111copy_from(T111 C,T111 a1,T2 a2);
void r111set_all_with(T111 C,T0* a1,T2 a2);
T2 r111fast_index_of(T111 C,T0* a1,T2 a2);
T97 r97realloc(T97 C,T2 a1,T2 a2);
void r97copy_from(T97 C,T97 a1,T2 a2);
void r97set_all_with(T97 C,T0* a1,T2 a2);
void r97clear_all(T97 C,T2 a1);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
void r9fast_replace_all(T9 C,T3 a1,T3 a2,T2 a3);
T363 r363realloc(T363 C,T2 a1,T2 a2);
void r363clear(T363 C,T2 a1,T2 a2);
void r363move(T363 C,T2 a1,T2 a2,T2 a3);
void r363copy_from(T363 C,T363 a1,T2 a2);
void r363set_all_with(T363 C,T6 a1,T2 a2);
T54 r54realloc(T54 C,T2 a1,T2 a2);
void r54copy_from(T54 C,T54 a1,T2 a2);
void r54set_all_with(T54 C,T0* a1,T2 a2);
T28 r28realloc(T28 C,T2 a1,T2 a2);
void r28copy_from(T28 C,T28 a1,T2 a2);
void r28set_all_with(T28 C,T2 a1,T2 a2);
T2 r28fast_index_of(T28 C,T2 a1,T2 a2);
T6 r7has_string(T7* C,T0* a1);
T6 r7is_equal(T7* C,T0* a1);
T3 r7last(T7* C);
void r7add_first(T7* C,T3 a1);
T8 r7to_external(T7* C);
T6 r7same_as(T7* C,T0* a1);
void r7prepend(T7* C,T0* a1);
void r7copy(T7* C,T0* a1);
void r7swap(T7* C,T2 a1,T2 a2);
void r7head(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7to_lower(T7* C);
void r7remove_first(T7* C,T2 a1);
T2 r7index_of_string(T7* C,T0* a1);
void r7remove_between(T7* C,T2 a1,T2 a2);
void r7make(T7* C,T2 a1);
void r7to_hexadecimal(T7* C);
T6 r7has_prefix(T7* C,T0* a1);
T2 r7hash_code(T7* C);
void r7remove_last(T7* C,T2 a1);
T6 r7_px_60(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r263add_last(T263* C,T0* a1);
void r263copy(T263* C,T0* a1);
T0* r263twin(T263* C);
T2 r263count(T263* C);
T0* r263item(T263* C,T2 a1);
void r284add_last(T284* C,T0* a1);
T2 r284count(T284* C);
T0* r284item(T284* C,T2 a1);
void r360make(T360* C,T2 a1,T2 a2);
void r360force(T360* C,T0* a1,T2 a2);
void r360resize(T360* C,T2 a1,T2 a2);
void r360clear_all(T360* C);
T0* r360item(T360* C,T2 a1);
void r322add_last(T322* C,T0* a1);
T2 r322count(T322* C);
T0* r322item(T322* C,T2 a1);
void r313add_last(T313* C,T0* a1);
T2 r313count(T313* C);
T0* r313item(T313* C,T2 a1);
void r189add_last(T189* C,T0* a1);
void r189make(T189* C,T2 a1,T2 a2);
void r189copy(T189* C,T0* a1);
T0* r189twin(T189* C);
T2 r189count(T189* C);
T0* r189item(T189* C,T2 a1);
void r92add_last(T92* C,T0* a1);
T2 r92count(T92* C);
T0* r92item(T92* C,T2 a1);
void r377with_capacity(T377* C,T2 a1);
void r377add_last(T377* C,T0* a1);
void r377make(T377* C,T2 a1);
void r377resize(T377* C,T2 a1);
void r212add_last(T212* C,T0* a1);
void r212with_capacity(T212* C,T2 a1);
void r212make(T212* C,T2 a1);
void r212copy(T212* C,T0* a1);
void r212resize(T212* C,T2 a1);
T0* r212twin(T212* C);
void r338make(T338* C,T2 a1);
void r338resize(T338* C,T2 a1);
void r344add_last(T344* C,T0* a1);
void r344with_capacity(T344* C,T2 a1);
T6 r344empty(T344* C);
T0* r344last(T344* C);
void r344remove_last(T344* C);
void r31add_last(T31* C,T0* a1);
void r31with_capacity(T31* C,T2 a1);
void r31make(T31* C,T2 a1);
T6 r31fast_has(T31* C,T0* a1);
T2 r31fast_index_of(T31* C,T0* a1);
void r31resize(T31* C,T2 a1);
T6 r31valid_index(T31* C,T2 a1);
void r343add_last(T343* C,T0* a1);
void r343with_capacity(T343* C,T2 a1);
void r343make(T343* C,T2 a1);
T2 r343fast_index_of(T343* C,T0* a1);
void r343resize(T343* C,T2 a1);
void r96add_last(T96* C,T0* a1);
void r96with_capacity(T96* C,T2 a1);
T6 r96empty(T96* C);
void r96make(T96* C,T2 a1);
void r96copy(T96* C,T0* a1);
void r96resize(T96* C,T2 a1);
T0* r96twin(T96* C);
void r327add_last(T327* C,T0* a1);
T2 r327count(T327* C);
void r329make(T329* C,T2 a1);
void r329resize(T329* C,T2 a1);
void r221with_capacity(T221* C,T2 a1);
void r221add_last(T221* C,T0* a1);
void r221copy(T221* C,T0* a1);
T0* r221twin(T221* C);
void r61add_last(T61* C,T0* a1);
void r61with_capacity(T61* C,T2 a1);
void r61make(T61* C,T2 a1);
T6 r61fast_has(T61* C,T0* a1);
T2 r61fast_index_of(T61* C,T0* a1);
void r61resize(T61* C,T2 a1);
T6 r61valid_index(T61* C,T2 a1);
void r61clear_all(T61* C);
T2 r61count(T61* C);
T0* r61item(T61* C,T2 a1);
void r225add_last(T225* C,T0* a1);
void r225copy(T225* C,T0* a1);
T0* r225twin(T225* C);
T2 r225count(T225* C);
T0* r225item(T225* C,T2 a1);
void r80add_last(T80* C,T0* a1);
T2 r80count(T80* C);
T0* r80item(T80* C,T2 a1);
void r52add_last(T52* C,T0* a1);
void r52make(T52* C,T2 a1);
void r27with_capacity(T27* C,T2 a1);
void r27add_last(T27* C,T2 a1);
void r27make(T27* C,T2 a1);
T6 r27fast_has(T27* C,T2 a1);
T2 r27fast_index_of(T27* C,T2 a1);
void r27resize(T27* C,T2 a1);
T6 r27valid_index(T27* C,T2 a1);
void r356add_last(T356* C,T0* a1);
void r356with_capacity(T356* C,T2 a1);
void r356make(T356* C,T2 a1);
T6 r356fast_has(T356* C,T0* a1);
T2 r356fast_index_of(T356* C,T0* a1);
void r356resize(T356* C,T2 a1);
T6 r356valid_index(T356* C,T2 a1);
void r352add_last(T352* C,T0* a1);
void r352with_capacity(T352* C,T2 a1);
void r352make(T352* C,T2 a1);
T6 r352fast_has(T352* C,T0* a1);
T2 r352fast_index_of(T352* C,T0* a1);
void r352resize(T352* C,T2 a1);
T6 r352valid_index(T352* C,T2 a1);
void r350add_last(T350* C,T0* a1);
void r350with_capacity(T350* C,T2 a1);
void r350make(T350* C,T2 a1);
T6 r350fast_has(T350* C,T0* a1);
T2 r350fast_index_of(T350* C,T0* a1);
void r350resize(T350* C,T2 a1);
T6 r350valid_index(T350* C,T2 a1);
void r60add_last(T60* C,T0* a1);
void r60make(T60* C,T2 a1,T2 a2);
void r60force(T60* C,T0* a1,T2 a2);
void r60swap(T60* C,T2 a1,T2 a2);
void r60resize(T60* C,T2 a1,T2 a2);
T2 r60count(T60* C);
T0* r60item(T60* C,T2 a1);
void r362make(T362* C,T2 a1,T2 a2);
void r362set_slice_with(T362* C,T6 a1,T2 a2,T2 a3);
void r362force(T362* C,T6 a1,T2 a2);
void r362resize(T362* C,T2 a1,T2 a2);
T6 r362valid_index(T362* C,T2 a1);
T6 r362item(T362* C,T2 a1);
void r175add_last(T175* C,T2 a1);
T2 r175count(T175* C);
void r239add_last(T239* C,T0* a1);
void r239copy(T239* C,T0* a1);
T0* r239twin(T239* C);
T2 r239count(T239* C);
T0* r239item(T239* C,T2 a1);
void r232add_last(T232* C,T0* a1);
void r232copy(T232* C,T0* a1);
T0* r232twin(T232* C);
T2 r232count(T232* C);
T0* r232item(T232* C,T2 a1);
void r84add_last(T84* C,T0* a1);
T2 r84count(T84* C);
T0* r84item(T84* C,T2 a1);
void r75with_capacity(T75* C,T2 a1,T2 a2);
void r75add_last(T75* C,T0* a1);
T6 r75fast_has(T75* C,T0* a1);
T2 r75fast_index_of(T75* C,T0* a1);
T2 r75index_of(T75* C,T0* a1);
T6 r75valid_index(T75* C,T2 a1);
T2 r75count(T75* C);
T0* r75item(T75* C,T2 a1);
void r369with_capacity(T369* C,T2 a1,T2 a2);
void r369add_last(T369* C,T0* a1);
void r369swap(T369* C,T2 a1,T2 a2);
T2 r369count(T369* C);
T0* r369item(T369* C,T2 a1);
void r340add_last(T340* C,T0* a1);
void r340with_capacity(T340* C,T2 a1,T2 a2);
T6 r340empty(T340* C);
T6 r340fast_has(T340* C,T0* a1);
void r340copy(T340* C,T0* a1);
T2 r340fast_index_of(T340* C,T0* a1);
T6 r340valid_index(T340* C,T2 a1);
T2 r340count(T340* C);
T0* r340item(T340* C,T2 a1);
void r242add_last(T242* C,T0* a1);
void r242copy(T242* C,T0* a1);
T0* r242twin(T242* C);
T2 r242count(T242* C);
T0* r242item(T242* C,T2 a1);
void r106with_capacity(T106* C,T2 a1,T2 a2);
void r106add_last(T106* C,T0* a1);
void r106clear(T106* C);
T6 r106empty(T106* C);
void r106make(T106* C,T2 a1,T2 a2);
T6 r106fast_has(T106* C,T0* a1);
void r106copy(T106* C,T0* a1);
T2 r106fast_index_of(T106* C,T0* a1);
T6 r106valid_index(T106* C,T2 a1);
T0* r106twin(T106* C);
T2 r106count(T106* C);
T0* r106item(T106* C,T2 a1);
void r386add_last(T386* C,T0* a1);
void r386with_capacity(T386* C,T2 a1);
void r386make(T386* C,T2 a1);
void r386copy(T386* C,T0* a1);
void r386resize(T386* C,T2 a1);
T0* r386twin(T386* C);
void r200with_capacity(T200* C,T2 a1);
void r200add_last(T200* C,T0* a1);
void r154with_capacity(T154* C,T2 a1);
void r154add_last(T154* C,T0* a1);
void r154make(T154* C,T2 a1);
void r154copy(T154* C,T0* a1);
void r154resize(T154* C,T2 a1);
T0* r154twin(T154* C);
void r154clear_all(T154* C);
T2 r154count(T154* C);
T0* r154item(T154* C,T2 a1);
void r71add_last(T71* C,T0* a1);
void r71with_capacity(T71* C,T2 a1);
void r71make(T71* C,T2 a1);
T6 r71fast_has(T71* C,T0* a1);
T2 r71fast_index_of(T71* C,T0* a1);
void r71resize(T71* C,T2 a1);
T6 r71valid_index(T71* C,T2 a1);
void r366add_last(T366* C,T0* a1);
void r366with_capacity(T366* C,T2 a1);
void r366make(T366* C,T2 a1);
void r366resize(T366* C,T2 a1);
void r366clear_all(T366* C);
T2 r366count(T366* C);
T0* r366item(T366* C,T2 a1);
void r331make(T331* C,T2 a1);
void r331resize(T331* C,T2 a1);
void r64add_last(T64* C,T0* a1);
void r64with_capacity(T64* C,T2 a1);
T6 r64empty(T64* C);
T6 r64fast_has(T64* C,T0* a1);
T2 r64fast_index_of(T64* C,T0* a1);
T2 r64index_of(T64* C,T0* a1);
T6 r64valid_index(T64* C,T2 a1);
T6 r64has(T64* C,T0* a1);
void r113add_last(T113* C,T0* a1);
void r113copy(T113* C,T0* a1);
T0* r113twin(T113* C);
T2 r113count(T113* C);
T0* r113item(T113* C,T2 a1);
void r374add_last(T374* C,T0* a1);
void r374with_capacity(T374* C,T2 a1);
void r374make(T374* C,T2 a1);
void r374resize(T374* C,T2 a1);
void r88with_capacity(T88* C,T2 a1);
void r88add_last(T88* C,T0* a1);
void r88make(T88* C,T2 a1);
void r206add_last(T206* C,T0* a1);
void r206with_capacity(T206* C,T2 a1);
void r206make(T206* C,T2 a1);
void r206copy(T206* C,T0* a1);
void r206resize(T206* C,T2 a1);
T0* r206twin(T206* C);
void r195add_last(T195* C,T0* a1);
void r195make(T195* C,T2 a1,T2 a2);
void r195copy(T195* C,T0* a1);
T0* r195twin(T195* C);
T2 r195count(T195* C);
T0* r195item(T195* C,T2 a1);
void r101add_last(T101* C,T0* a1);
T2 r101count(T101* C);
T0* r101item(T101* C,T2 a1);
void r376with_capacity(T376* C,T2 a1);
void r376resize_buckets(T376* C,T2 a1);
void r376expand(T376* C);
T0* r376at(T376* C,T0* a1);
void r376put(T376* C,T0* a1,T0* a2);
T6 r376has(T376* C,T0* a1);
void r347with_capacity(T347* C,T2 a1);
void r347resize_buckets(T347* C,T2 a1);
void r347expand(T347* C);
void r347remove(T347* C,T0* a1);
void r347set_cache_user_idx(T347* C,T2 a1);
void r347put(T347* C,T0* a1,T0* a2);
T6 r347has(T347* C,T0* a1);
T0* r347item(T347* C,T2 a1);
void r342with_capacity(T342* C,T2 a1);
void r342resize_buckets(T342* C,T2 a1);
void r342expand(T342* C);
T0* r342at(T342* C,T0* a1);
void r342set_cache_user_idx(T342* C,T2 a1);
void r342put(T342* C,T0* a1,T0* a2);
T6 r342has(T342* C,T0* a1);
T0* r342item(T342* C,T2 a1);
void r95with_capacity(T95* C,T2 a1);
void r95resize_buckets(T95* C,T2 a1);
void r95expand(T95* C);
T0* r95at(T95* C,T0* a1);
void r95put(T95* C,T0* a1,T0* a2);
T6 r95has(T95* C,T0* a1);
void r385with_capacity(T385* C,T2 a1);
void r385resize_buckets(T385* C,T2 a1);
void r385expand(T385* C);
void r385put(T385* C,T0* a1,T2 a2);
T6 r385has(T385* C,T2 a1);
void r337with_capacity(T337* C,T2 a1);
void r337resize_buckets(T337* C,T2 a1);
void r337expand(T337* C);
T0* r337at(T337* C,T0* a1);
void r337set_cache_user_idx(T337* C,T2 a1);
void r337put(T337* C,T0* a1,T0* a2);
T6 r337has(T337* C,T0* a1);
T0* r337item(T337* C,T2 a1);
void r333with_capacity(T333* C,T2 a1);
void r333resize_buckets(T333* C,T2 a1);
void r333expand(T333* C);
T0* r333at(T333* C,T0* a1);
void r333set_cache_user_idx(T333* C,T2 a1);
void r333put(T333* C,T0* a1,T0* a2);
T6 r333has(T333* C,T0* a1);
T0* r333item(T333* C,T2 a1);
void r23with_capacity(T23* C,T2 a1);
void r23resize_buckets(T23* C,T2 a1);
void r23expand(T23* C);
T0* r23at(T23* C,T0* a1);
void r23put(T23* C,T0* a1,T0* a2);
T6 r23has(T23* C,T0* a1);
void r70with_capacity(T70* C,T2 a1);
void r70resize_buckets(T70* C,T2 a1);
void r70expand(T70* C);
T0* r70at(T70* C,T0* a1);
void r70set_cache_user_idx(T70* C,T2 a1);
void r70put(T70* C,T0* a1,T0* a2);
T6 r70has(T70* C,T0* a1);
T0* r70item(T70* C,T2 a1);
void r148standard_compile_target_to_jvm(T148* C);
extern T0*oBC12code_attribute;
void r148compile_to_jvm_old(T148* C);
T0* r148runnable_expression(T0* a1,T0* a2);
void r148run_feature_has_result(T148* C);
T2 r148static_value(T148* C);
extern T0*oBC12eh;
void r148run_feature_match(T148* C);
extern T0*oBC12jvm;
T0* r148add_comment(T148* C,T0* a1);
void r148with(T148* C,T0* a1,T0* a2,T0* a3);
void r148afd_check(T148* C);
T0* r148operator(void);
T6 r148use_current(T148* C);
T0* r148to_runnable(T148* C,T0* a1);
T2 r148to_integer(T148* C);
T6 r148is_static(T148* C);
void r148error(T0* a1,T0* a2);
T0* r148result_type(T148* C);
T6 r148can_be_dropped(T148* C);
T2 r148jvm_standard_branch_if_false(T148* C);
T0* r148run_feature_for(T148* C,T0* a1,T0* a2);
extern T335 oBC12switch_collection;
T0* r148static_result_base_class(T148* C);
void r148make(T148* C,T0* a1,T0* a2);
void r148fatal_error(T0* a1);
T2 r148standard_compile_to_jvm_into(T148* C,T0* a1);
void r148assertion_check(T148* C,T3 a1);
T2 r148compile_to_jvm_into(T148* C,T0* a1);
T2 r148jvm_branch_if_true(T148* C);
T2 r148jvm_standard_branch_if_true(T148* C);
T2 r148jvm_branch_if_false(T148* C);
void r159standard_compile_target_to_jvm(T159* C);
T0* r159add_comment(T159* C,T0* a1);
T0* r159to_runnable(T159* C,T0* a1);
T2 r159to_integer(T159* C);
void r159compile_to_jvm(T159* C);
void r159error(T0* a1,T0* a2);
T0* r159result_type(T159* C);
extern T0*oBC12small_eiffel;
T0* r159static_result_base_class(void);
void r159jvm_assign(T159* C);
T2 r159standard_compile_to_jvm_into(T159* C,T0* a1);
T2 r159compile_to_jvm_into(T159* C,T0* a1);
T2 r159jvm_branch_if_true(T159* C);
T2 r159jvm_branch_if_false(T159* C);
void r182add_last(T182* C,T0* a1);
T2 r182rank_of(T182* C,T0* a1);
void r182fatal_error(T0* a1);
void r182check_name_clash(T182* C,T0* a1);
void r182declaration_list_make(T182* C,T0* a1);
T2 r182jvm_offset_of(T182* C,T0* a1);
T2 r182jvm_stack_space(T182* C);
T0* r182to_runnable(T182* C,T0* a1);
T0* r182twin(T182* C);
T0* r182type(T182* C,T2 a1);
void r182dynamic_runnable(T182* C,T0* a1);
void r182error(T0* a1,T0* a2);
T6 r182is_runnable(T182* C,T0* a1);
void r182jvm_initialize(T182* C);
extern T0*oBC39parser_buffer_path;
extern int fBC12type_string;
extern T0*oBC12type_string;
T0* r39type_string(void);
extern int fBC39rename_dictionary;
extern T0*oBC39rename_dictionary;
T0* r39rename_dictionary(T39* C);
void r39warning(T0* a1,T0* a2);
extern T0*oBC12tmp_file_read;
void r39pop(T39* C);
T0* r39top_rf(T39* C);
extern T0*oBC39stack_rf;
void r39incr_magic_count(T39* C);
T0* r39base_class(T39* C,T0* a1);
extern T0*oBC39base_class_dictionary;
T6 r39parser_buffer_for(T39* C,T0* a1);
void r39push(T39* C,T0* a1);
void r39compile_to_jvm(T39* C);
void r39get_started(T39* C,T0* a1,T0* a2);
T6 r39is_used(T0* a1);
extern T0*oBC12manifest_string_pool;
T0* r39load_class(T39* C,T0* a1);
void r39add_class(T39* C,T0* a1);
extern T0*oBC12address_of_pool;
extern int fBC39loading_path;
extern T0*oBC39loading_path;
T0* r39loading_path(void);
T0* r39run_class(T0* a1);
T0* r39get_class(T0* a1);
void r39fatal_error(T0* a1);
extern T0*oBC12echo;
T0* r39memory_class_used(void);
extern T0*oBC12run_control;
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r39system_tools(void);
extern T0*oBC39run_class_dictionary;
extern int fBC39tmp_class_name;
extern T0*oBC39tmp_class_name;
T0* r39tmp_class_name(void);
extern T0*oBC39tmp_tail;
extern T0*oBC12parser_buffer;
extern T0*oBC39rf9_memory;
extern T0*oBC12cecil_pool;
extern T0*oBC12eiffel_parser;
void r39afd_check_deferred(T0* a1);
T0* r273generic_list(T273* C);
T0* r273base_class(T273* C);
T0* r273look_up_for(T273* C,T0* a1,T0* a2);
extern T0*oBC12constant_pool;
T6 r273has_creation(T273* C,T0* a1);
void r273error(T0* a1,T0* a2);
T6 r273is_a_in(T273* C,T0* a1,T0* a2);
T6 r273is_native_array(T273* C);
void r273make(T273* C,T0* a1);
T2 r273jvm_stack_space(void);
extern int fBC12jvm_root_class;
extern T0*oBC12jvm_root_class;
T0* r273jvm_root_class(void);
void r273fatal_error_generic_list(T273* C);
T0* r273smallest_ancestor(T0* a1);
T0* r273run_time_mark(void);
T2 r273jvm_push_default(void);
T0* r273written_mark(void);
T2 r273jvm_expanded_from_reference(T0* a1);
extern int fBC12jvm_root_descriptor;
extern T0*oBC12jvm_root_descriptor;
T0* r273jvm_root_descriptor(void);
void r222make(T222* C,T0* a1,T0* a2,T0* a3);
T0* r222add_comment(T222* C,T0* a1);
void r222afd_check(T222* C);
T6 r222use_current(T222* C);
T0* r222to_runnable(T222* C,T0* a1);
void r222compile_to_jvm(T222* C);
T6 r222is_pre_computable(T222* C);
T0* r222start_position(T222* C);
void r249make(T249* C,T0* a1,T0* a2,T0* a3);
void r249afd_check(T249* C);
T6 r249use_current(T249* C);
T0* r249to_runnable(T249* C,T0* a1);
T0* r249twin(T249* C);
void r249error(T0* a1,T0* a2);
T0* r249start_position(T249* C);
void r141declaration_in(T141* C,T0* a1);
void r141make(T141* C,T0* a1,T0* a2);
void r141undefine_in(T141* C,T0* a1);
extern int fBC12string_aliaser;
extern T0*oBC12string_aliaser;
T0* r141string_aliaser(void);
T0* r141origin_base_class(T141* C);
void r141error(T0* a1,T0* a2);
T6 r34a_manifest_string(T34* C);
void r34disconnect(T34* C);
void r34a_indexing(T34* C);
T0* r34current_position(T34* C);
T0* r34a_actuals(T34* C);
T0* r34a_clients(T34* C);
T6 r34a_strip(T34* C);
extern T0*oBC34forbidden_class;
extern T0*oBC34tmp_name;
void r34a_after_a_dot(T34* C,T6 a1,T0* a2);
extern T0*oBC34faof;
T6 r34a_integer(T34* C);
void r34a_parent_list(T34* C,T0* a1,T0* a2);
T6 r34a_actual(T34* C);
void r34a_rename_list(T34* C);
T6 r34a_local_variable(T34* C);
T6 r34a_infix(T34* C);
T0* r34analyse_class(T34* C,T0* a1);
void r34skip_comments(T34* C);
T6 r34a_inspect(T34* C);
T6 r34a_current(T34* C);
void r34next_char(T34* C);
T6 r34a_unary(T34* C);
T6 r34a_conditional(T34* C);
void r34a_base_class_name1(T34* C);
T6 r34a_retry(T34* C);
extern T0*oBC34tmp_string;
T6 r34a_e10(T34* C);
T6 r34a_tag_mark(T34* C);
T0* r34a_routine_body(T34* C);
T6 r34a_feature_declaration(T34* C);
void r34a_r10(T34* C,T6 a1,T0* a2,T0* a3,T0* a4);
T6 r34a_keyword(T34* C,T0* a1);
T6 r34a_class_type(T34* C);
T6 r34a_feature_name_list(T34* C);
T6 r34a_feature_name(T34* C);
T0* r34a_assertion(T34* C);
void r34a_ascii_code(T34* C);
T6 r34a_void(T34* C);
void r34a_formal_generic_list(T34* C);
T6 r34a_index_value(T34* C);
void r34a_assignment_aux(T34* C,T6 a1);
T0* r34to_proc_call(T34* C,T0* a1,T0* a2,T0* a3);
T6 r34a_expression(T34* C);
T0* r34a_routine(T34* C);
T6 r34a_creation(T34* C);
T6 r34a_bit_constant(T34* C);
T6 r34a_boolean_constant(T34* C);
T0* r34a_external(T34* C);
T6 r34a_type(T34* C);
T6 r34skip1unless2(T34* C,T3 a1,T3 a2);
T6 r34a_real(T34* C);
T6 r34a_index_clause(T34* C);
void r34a_procedure_call(T34* C);
T6 r34a_parent(T34* C);
T0* r34a_compound1(T34* C);
T6 r34a_instruction(T34* C);
T6 r34a_debug(T34* C);
T0* r34connect_to_cecil(T34* C);
void r34to_frozen_feature_name(T34* C);
T6 r34a_manifest_constant(T34* C);
T6 r34a_base_type(T34* C);
T6 r34a_result(T34* C);
T6 r34a_base_class_name(T34* C);
void r34a_formal_arg_list(T34* C);
T6 r34a_identifier(T34* C);
void r34wcpefnc(T34* C,T0* a1,T0* a2);
T6 r34skip1(T34* C,T3 a1);
T6 r34skip2(T34* C,T3 a1,T3 a2);
T6 r34a_integer_constant(T34* C);
T0* r34a_compound2(T34* C,T0* a1,T0* a2);
void r34a_new_export_list(T34* C);
void r34a_creation_clause(T34* C,T0* a1);
void r34show_nb(T2 a1,T0* a2);
T6 r34a_identifier1(T34* C);
void r34fcp(T34* C,T0* a1);
T6 r34a_character_constant(T34* C);
T0* r34parse_feature_name(T34* C);
extern T0*oBC34lcs;
void r34a_local_var_list(T34* C);
T0* r34pos(T2 a1,T2 a2);
T6 r34a_loop(T34* C);
T6 r34a_free_operator(T34* C);
T6 r34a_binary(T34* C,T0* a1);
T6 r34a_check(T34* C);
void r34a_then_part_list(T34* C,T0* a1);
T0* r34parse_c_name(T34* C);
T6 r34a_precursor(T34* C,T6 a1);
T6 r34a_prefix(T34* C);
void r34fatal_error(T0* a1);
T6 r34a_identifier2(T34* C);
void r34warning(T0* a1,T0* a2);
extern T0*oBC34tmp_feature;
T0* r34get_comments(T34* C);
T0* r34parse_run_type(T34* C);
void r34error(T0* a1,T0* a2);
T0* r34to_call(T0* a1,T0* a2,T0* a3);
T6 r34a_then_part(T34* C,T0* a1);
T6 r34a_type_formal_generic(T34* C);
void r34go_back_at(T34* C,T2 a1,T2 a2);
T6 r34a_when_part(T34* C,T0* a1);
T6 r34a_argument(T34* C);
T6 r34a_assignment_or_call(T34* C);
T6 r34a_constant(T34* C);
T6 r34a_e0(T34* C);
T6 r34a_e1(T34* C);
T6 r34a_e2(T34* C);
T6 r34a_e3(T34* C);
T6 r34a_e4(T34* C);
T6 r34a_e5(T34* C);
T6 r34a_e6(T34* C);
T6 r34a_e7(T34* C);
void r34a_function_call(T34* C);
T6 r34a_e8(T34* C);
T6 r34a_e9(T34* C);
T6 r34end_of_input(T34* C);
T6 r34a_real_constant(T34* C);
T6 r34a_rename_pair(T34* C);
void r34a_r1(T34* C,T0* a1);
void r34a_r2(T34* C,T0* a1);
void r34a_r3(T34* C,T0* a1);
void r34a_r4(T34* C,T0* a1);
void r34a_r5(T34* C,T0* a1);
void r34a_r6(T34* C,T0* a1);
void r34a_r7(T34* C,T0* a1);
T0* r34last_result(T34* C);
void r34a_r8(T34* C,T0* a1);
T0* r34a_alias(T34* C);
void r34a_feature_clause(T34* C);
void r34err_exp(T0* a1,T0* a2);
void r34a_class_declaration(T34* C);
void r277jvm_to_reference(T277* C);
T0* r277generic_list(T277* C);
T2 r277id(T277* C);
T0* r277base_class(T277* C);
T0* r277look_up_for(T277* C,T0* a1,T0* a2);
void r277jvm_descriptor_in(T277* C,T0* a1);
T6 r277has_creation(T277* C,T0* a1);
T6 r277is_a_in(T277* C,T0* a1,T0* a2);
T6 r277is_native_array(T277* C);
T6 r277is_a(T277* C,T0* a1);
extern T0*oBC277check_memory;
void r277used_as_reference(T277* C);
T2 r277jvm_stack_space(void);
T6 r277is_reference(T277* C);
T0* r277jvm_root_class(void);
void r277fatal_error_generic_list(T277* C);
T0* r277smallest_ancestor(T277* C,T0* a1);
T0* r277to_runnable(T277* C,T0* a1);
void r277jvm_standard_is_equal(T277* C);
T0* r277run_class(T277* C);
void r277jvm_xnewarray(T277* C);
T6 r277is_dummy_expanded(T277* C);
T2 r277jvm_push_default(T277* C);
void r277standard_jvm_check_class_invariant(T277* C);
T6 r277is_expanded(T277* C);
T2 r277jvm_convert_to(T277* C,T0* a1);
T0* r277expanded_initializer(T277* C);
T2 r277jvm_expanded_from_reference(T0* a1);
T0* r277jvm_root_descriptor(void);
void r133standard_compile_target_to_jvm(T133* C);
void r133compile_to_jvm_old(T133* C);
T0* r133runnable_expression(T0* a1,T0* a2);
T2 r133static_value(T133* C);
T2 r133static_eq_void(T0* a1);
void r133jvm_void_cmp(T0* a1);
void r133check_comparison(T133* C,T0* a1);
T0* r133add_comment(T133* C,T0* a1);
void r133with(T133* C,T0* a1,T0* a2,T0* a3);
void r133afd_check(T133* C);
T6 r133is_manifest_array(T0* a1);
T0* r133operator(void);
T6 r133use_current(T133* C);
T0* r133runnable_args(T0* a1,T0* a2);
T0* r133to_runnable(T133* C,T0* a1);
T2 r133to_integer(T133* C);
void r133bit_limitation(T133* C,T0* a1,T0* a2);
void r133compile_to_jvm(T133* C);
T6 r133is_static(T133* C);
void r133error(T0* a1,T0* a2);
extern int fBC12type_boolean;
extern T0*oBC12type_boolean;
T0* r133type_boolean(void);
T2 r133jvm_standard_branch_if_false(T133* C);
T0* r133static_result_base_class(void);
void r133make(T133* C,T0* a1,T0* a2,T0* a3);
void r133fatal_error(T0* a1);
T2 r133standard_compile_to_jvm_into(T133* C,T0* a1);
void r133assertion_check(T133* C,T3 a1);
T2 r133compile_to_jvm_into(T133* C,T0* a1);
void r133error_comparison(T133* C,T0* a1,T0* a2);
T2 r133jvm_standard_branch_if_true(T133* C);
T6 r133is_static_eq_void(T0* a1);
void r125standard_compile_target_to_jvm(T125* C);
void r125compile_to_jvm_old(T125* C);
T0* r125runnable_expression(T0* a1,T0* a2);
void r125run_feature_has_result(T125* C);
void r125run_feature_match(T125* C,T0* a1);
T0* r125add_comment(T125* C,T0* a1);
void r125with(T125* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r125afd_check(T125* C);
T0* r125operator(void);
T6 r125use_current(T125* C);
T0* r125runnable_args(T0* a1,T0* a2);
T0* r125to_runnable(T125* C,T0* a1);
T2 r125to_integer(T125* C);
T6 r125is_static(T125* C);
void r125error(T0* a1,T0* a2);
T0* r125result_type(T125* C);
T2 r125jvm_standard_branch_if_false(T125* C);
T0* r125run_feature_for(T125* C,T0* a1,T0* a2);
T0* r125static_result_base_class(T125* C);
void r125make(T125* C,T0* a1,T0* a2,T0* a3);
void r125fatal_error(T0* a1);
T2 r125standard_compile_to_jvm_into(T125* C,T0* a1);
void r125assertion_check(T125* C,T3 a1);
T2 r125compile_to_jvm_into(T125* C,T0* a1);
T2 r125jvm_standard_branch_if_true(T125* C);
void r36put_string(T36* C,T0* a1);
void r36put_integer(T36* C,T2 a1);
extern T0*oBC37tmp_string;
T6 r215is_merge_with(T215* C,T0* a1,T0* a2);
T6 r215is_merge_with2aux(T215* C,T0* a1,T0* a2);
T0* r215try_to_undefine_aux(T215* C,T0* a1,T0* a2);
T0* r215try_to_undefine(T215* C,T0* a1,T0* a2);
void r215check_obsolete(T215* C,T0* a1);
T6 r215is_merge_with1(T215* C,T0* a1);
T6 r215is_merge_with2(T215* C,T0* a1,T0* a2);
T0* r215to_run_feature(T215* C,T0* a1,T0* a2);
void r215error(T0* a1,T0* a2);
void r215make(T215* C,T0* a1,T0* a2,T0* a3);
void r215add_into(T215* C,T0* a1);
T6 r215can_hide(T215* C,T0* a1,T0* a2);
void r215merge_header_comments(T215* C,T0* a1);
T0* r215start_position(T215* C);
void r100make(T100* C,T0* a1,T0* a2,T0* a3);
void r100add_into(T100* C,T0* a1);
void r123standard_compile_target_to_jvm(T123* C);
void r123compile_to_jvm_old(T123* C);
T0* r123runnable_expression(T0* a1,T0* a2);
void r123run_feature_has_result(T123* C);
void r123run_feature_match(T123* C,T0* a1);
T0* r123add_comment(T123* C,T0* a1);
void r123with(T123* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r123afd_check(T123* C);
T0* r123operator(void);
T6 r123use_current(T123* C);
T0* r123runnable_args(T0* a1,T0* a2);
T0* r123to_runnable(T123* C,T0* a1);
T2 r123to_integer(T123* C);
T6 r123is_static(T123* C);
void r123error(T0* a1,T0* a2);
T0* r123result_type(T123* C);
T2 r123jvm_standard_branch_if_false(T123* C);
T0* r123run_feature_for(T123* C,T0* a1,T0* a2);
T0* r123static_result_base_class(T123* C);
void r123make(T123* C,T0* a1,T0* a2,T0* a3);
void r123fatal_error(T0* a1);
T2 r123standard_compile_to_jvm_into(T123* C,T0* a1);
void r123assertion_check(T123* C,T3 a1);
T2 r123compile_to_jvm_into(T123* C,T0* a1);
T2 r123jvm_standard_branch_if_true(T123* C);
void r76load_file(T76* C,T0* a1);
extern T0*oBC76text;
T0* r76get_line(T2 a1);
T0* r76item(T2 a1);
T0* r270generic_list(T270* C);
T0* r270base_class(T270* C);
T0* r270look_up_for(T270* C,T0* a1,T0* a2);
T6 r270has_creation(T270* C,T0* a1);
void r270error(T0* a1,T0* a2);
T6 r270is_a_in(T270* C,T0* a1,T0* a2);
T6 r270is_native_array(T270* C);
T6 r270is_a(T270* C,T0* a1);
void r270make(T270* C,T0* a1);
extern int fBC270used_as_reference;
void r270used_as_reference(void);
T2 r270jvm_stack_space(void);
void r270fatal_error_generic_list(T270* C);
T0* r270smallest_ancestor(T270* C,T0* a1);
extern int fBC270check_type;
void r270check_type(T270* C);
extern int fBC12type_character_ref;
extern T0*oBC12type_character_ref;
T0* r270type_character_ref(void);
void r270load_ref(T0* a1);
T0* r270to_runnable(T270* C,T0* a1);
T0* r270run_time_mark(void);
T0* r270run_class(T270* C);
T2 r270jvm_push_default(void);
T2 r270jvm_convert_to(T0* a1);
T0* r270written_mark(void);
T2 r270jvm_expanded_from_reference(T0* a1);
T0* r288left_type(T288* C);
void r288make(T288* C,T0* a1,T0* a2);
void r288fatal_error(T0* a1);
void r288warning(T0* a1,T0* a2);
T0* r288add_comment(T288* C,T0* a1);
void r288afd_check(T288* C);
T6 r288use_current(T288* C);
T0* r288right_type(T288* C);
T0* r288to_runnable(T288* C,T0* a1);
void r288compile_to_jvm(T288* C);
void r288error(T0* a1,T0* a2);
T0* r288start_position(T288* C);
void r379refer_to(T379* C,T2 a1,T0* a2);
void r379undefine_in(T379* C,T0* a1);
T0* r379string_aliaser(void);
T0* r379origin_base_class(T379* C);
T6 r379is_frozen(T379* C);
T0* r379to_string(T379* C);
void r379error(T0* a1,T0* a2);
T0* r379start_position(T379* C);
void r161standard_compile_target_to_jvm(T161* C);
T0* r161add_comment(T161* C,T0* a1);
T0* r161to_runnable(T161* C,T0* a1);
T2 r161to_integer(T161* C);
void r161compile_to_jvm(T161* C);
void r161error(T0* a1,T0* a2);
T2 r161standard_compile_to_jvm_into(T161* C,T0* a1);
T2 r161compile_to_jvm_into(T161* C,T0* a1);
T2 r161jvm_branch_if_true(T161* C);
T2 r161jvm_branch_if_false(T161* C);
void r161compile_target_to_jvm(T161* C);
void r318make(T318* C,T0* a1,T0* a2);
void r318append_in(T318* C,T0* a1);
void r53b_put(T53* C);
void r53clear(T53* C);
T6 r53is_utf8_idx(T53* C,T0* a1);
void r53set_fieldref(T53* C,T0* a1);
void r53set_name_and_type(T53* C,T0* a1);
void r53set_methodref(T53* C,T0* a1);
T6 r53is_string_idx(T53* C,T2 a1);
T6 r53is_class_idx(T53* C,T2 a1);
void r53set_class(T53* C,T0* a1);
T6 r53is_methodref_idx(T53* C,T2 a1,T2 a2);
void r53set_utf8(T53* C,T0* a1);
void r53set_string(T53* C,T0* a1);
T6 r53is_name_and_type_idx(T53* C,T2 a1,T2 a2);
T6 r53is_fieldref_idx(T53* C,T2 a1,T2 a2);
T2 r53u2_to_integer(T53* C,T2 a1);
T6 r310is_merge_with(T310* C,T0* a1,T0* a2);
T6 r310is_merge_with2aux(T310* C,T0* a1,T0* a2);
T0* r310try_to_undefine_aux(T310* C,T0* a1,T0* a2);
T0* r310try_to_undefine(T310* C,T0* a1,T0* a2);
void r310check_obsolete(T310* C,T0* a1);
T6 r310is_merge_with1(T310* C,T0* a1);
T6 r310is_merge_with2(T310* C,T0* a1,T0* a2);
T0* r310to_run_feature(T310* C,T0* a1,T0* a2);
void r310error(T0* a1,T0* a2);
void r310set_header_comment(T310* C,T0* a1);
void r310make_routine(T310* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r310make(T310* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r310add_into(T310* C,T0* a1);
T6 r310can_hide(T310* C,T0* a1,T0* a2);
void r310merge_header_comments(T310* C,T0* a1);
T0* r310start_position(T310* C);
void r105compile_to_jvm_old(T105* C);
void r105make(T105* C,T0* a1,T0* a2,T0* a3);
void r105afd_check(T105* C);
T6 r105use_current(T105* C);
T0* r105to_runnable(T105* C,T0* a1,T3 a2);
void r105compile_to_jvm(T105* C,T6 a1);
T6 r105is_pre_computable(T105* C);
void r105error(T0* a1,T0* a2);
T0* r105start_position(T105* C);
void r98make(T98* C,T0* a1,T0* a2);
void r98fatal_error(T0* a1);
void r98check_generic_formal_arguments(T98* C);
T2 r98index_of(T98* C,T0* a1);
void r99get_started(T99* C,T0* a1);
void r41add_position(T0* a1);
void r41print_as_fatal_error(T41* C);
T6 r41empty(void);
void r41fatal_error(T0* a1);
extern T0*oBC41explanation;
void r41feature_not_found(T0* a1);
extern T0*oBC41positions;
void r41print_as_warning(T41* C);
void r41add_feature_name(T0* a1);
void r41add_type(T0* a1,T0* a2);
void r41do_print(T0* a1);
void r41print_as_error(T41* C);
void r86good_end(T86* C,T0* a1);
void r86make(T86* C,T0* a1,T0* a2);
void r86warning(T0* a1,T0* a2);
void r86append(T86* C,T0* a1);
T6 r216is_merge_with(T216* C,T0* a1,T0* a2);
T6 r216is_merge_with2aux(T216* C,T0* a1,T0* a2);
T0* r216try_to_undefine_aux(T216* C,T0* a1,T0* a2);
T0* r216try_to_undefine(T216* C,T0* a1,T0* a2);
void r216check_obsolete(T216* C,T0* a1);
T6 r216is_merge_with1(T216* C,T0* a1);
T6 r216is_merge_with2(T216* C,T0* a1,T0* a2);
T0* r216to_run_feature(T216* C,T0* a1,T0* a2);
void r216error(T0* a1,T0* a2);
void r216make(T216* C,T0* a1,T0* a2,T0* a3);
void r216add_into(T216* C,T0* a1);
T6 r216can_hide(T216* C,T0* a1,T0* a2);
void r216merge_header_comments(T216* C,T0* a1);
T0* r216start_position(T216* C);
T6 r203is_merge_with(T203* C,T0* a1,T0* a2);
T6 r203is_merge_with2aux(T203* C,T0* a1,T0* a2);
T0* r203try_to_undefine_aux(T203* C,T0* a1,T0* a2);
extern T0*oBC203counter;
T0* r203try_to_undefine(T203* C,T0* a1,T0* a2);
void r203check_obsolete(T203* C,T0* a1);
T6 r203is_merge_with1(T203* C,T0* a1);
T6 r203is_merge_with2(T203* C,T0* a1,T0* a2);
T0* r203to_run_feature(T203* C,T0* a1,T0* a2);
void r203error(T0* a1,T0* a2);
void r203make(T203* C,T0* a1,T0* a2);
void r203add_into(T203* C,T0* a1);
T6 r203can_hide(T203* C,T0* a1,T0* a2);
void r203merge_header_comments(T203* C,T0* a1);
T0* r203start_position(T203* C);
void r261jvm_target_descriptor_in(T261* C,T0* a1);
T0* r261generic_list(T261* C);
T2 r261jvm_method_flags(T261* C);
T2 r261id(T261* C);
T2 r261jvm_if_x_ne(T261* C);
void r261jvm_check_class_invariant(T261* C);
T0* r261base_class(T261* C);
T6 r261is_array(T261* C);
T0* r261look_up_for(T261* C,T0* a1,T0* a2);
void r261jvm_descriptor_in(T261* C,T0* a1);
T6 r261has_creation(T261* C,T0* a1);
T6 r261is_a_in(T261* C,T0* a1,T0* a2);
T6 r261is_native_array(T261* C);
T6 r261is_boolean(T261* C);
T6 r261is_a(T261* C,T0* a1);
T6 r261is_generic(T261* C);
void r261jvm_xaload(T261* C);
void r261jvm_return_code(T261* C);
void r261used_as_reference(T261* C);
T2 r261jvm_stack_space(T261* C);
T6 r261is_reference(T261* C);
T6 r261is_real(T261* C);
T6 r261is_user_expanded(T261* C);
T6 r261is_integer(T261* C);
void r261fatal_error_generic_list(T261* C);
T6 r261is_any(T261* C);
T6 r261is_string(T261* C);
void r261jvm_xastore(T261* C);
T0* r261smallest_ancestor(T261* C,T0* a1);
void r261with(T261* C,T0* a1,T0* a2);
T6 r261is_double(T261* C);
void r261jvm_write_local(T261* C,T2 a1);
T6 r261is_none(T261* C);
T0* r261to_runnable(T261* C,T0* a1);
T6 r261is_pointer(T261* C);
void r261jvm_standard_is_equal(T261* C);
T0* r261run_time_mark(T261* C);
T0* r261run_class(T261* C);
void r261jvm_xnewarray(T261* C);
T6 r261is_dummy_expanded(T261* C);
void r261jvm_push_local(T261* C,T2 a1);
T2 r261jvm_push_default(T261* C);
T6 r261is_expanded(T261* C);
T2 r261jvm_convert_to(T261* C,T0* a1);
T2 r261jvm_if_x_eq(T261* C);
T0* r261expanded_initializer(T261* C);
T6 r261is_basic_eiffel_expanded(T261* C);
T0* r261written_mark(void);
T6 r261is_character(T261* C);
T2 r261jvm_expanded_from_reference(T0* a1);
T0* r261base_class_name(T261* C);
T6 r261is_bit(T261* C);
T0* r271generic_list(T271* C);
extern int fBC12type_double_ref;
extern T0*oBC12type_double_ref;
T0* r271type_double_ref(void);
T2 r271jvm_if_x_ne(void);
T0* r271base_class(T271* C);
T0* r271look_up_for(T271* C,T0* a1,T0* a2);
T6 r271has_creation(T271* C,T0* a1);
void r271error(T0* a1,T0* a2);
T6 r271is_a_in(T271* C,T0* a1,T0* a2);
T6 r271is_native_array(T271* C);
T6 r271is_a(T271* C,T0* a1);
void r271make(T271* C,T0* a1);
extern int fBC271used_as_reference;
void r271used_as_reference(void);
T2 r271jvm_stack_space(void);
void r271fatal_error_generic_list(T271* C);
T0* r271smallest_ancestor(T271* C,T0* a1);
extern int fBC271check_type;
void r271check_type(T271* C);
void r271load_ref(T0* a1);
T0* r271to_runnable(T271* C,T0* a1);
T0* r271run_time_mark(void);
T0* r271run_class(T271* C);
T2 r271jvm_push_default(void);
T2 r271jvm_convert_to(T0* a1);
T2 r271jvm_if_x_eq(void);
T0* r271written_mark(void);
T2 r271jvm_expanded_from_reference(T0* a1);
void r136standard_compile_target_to_jvm(T136* C);
void r136compile_to_jvm_old(T136* C);
T0* r136runnable_expression(T0* a1,T0* a2);
void r136run_feature_has_result(T136* C);
void r136run_feature_match(T136* C,T0* a1);
T0* r136add_comment(T136* C,T0* a1);
void r136with(T136* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r136afd_check(T136* C);
T0* r136operator(void);
T6 r136use_current(T136* C);
T0* r136runnable_args(T0* a1,T0* a2);
T0* r136to_runnable(T136* C,T0* a1);
T2 r136to_integer(T136* C);
void r136error(T0* a1,T0* a2);
T0* r136result_type(T136* C);
T2 r136jvm_standard_branch_if_false(T136* C);
T0* r136run_feature_for(T136* C,T0* a1,T0* a2);
T0* r136static_result_base_class(T136* C);
void r136make(T136* C,T0* a1,T0* a2,T0* a3);
void r136fatal_error(T0* a1);
T2 r136standard_compile_to_jvm_into(T136* C,T0* a1);
void r136assertion_check(T136* C,T3 a1);
T2 r136compile_to_jvm_into(T136* C,T0* a1);
T2 r136jvm_standard_branch_if_true(T136* C);
extern int fBC12type_any;
extern T0*oBC12type_any;
T0* r150type_any(void);
extern T0*oBC150tmp_string;
T2 r150array_count(T150* C,T0* a1);
T0* r150add_comment(T150* C,T0* a1);
T0* r150to_runnable(T150* C,T0* a1);
T2 r150to_integer(T150* C);
void r150compile_to_jvm(T150* C);
void r150error(T0* a1,T0* a2);
T0* r150result_type(T150* C);
T0* r150static_result_base_class(void);
void r150make(T150* C,T0* a1,T0* a2);
T2 r150compile_to_jvm_into(T150* C,T0* a1);
extern T0*oBC12manifest_array_pool;
T0* r150jvm_root_class(void);
T0* r150jvm_root_descriptor(void);
extern T0*oBC108failure;
void r247make(T247* C,T0* a1,T0* a2,T0* a3);
void r247afd_check(T247* C);
T6 r247use_current(T247* C);
T0* r247to_runnable(T247* C,T0* a1);
void r247compile_to_jvm(T247* C,T6 a1);
T0* r247twin(T247* C);
extern T0*oBC12assertion_collector;
void r388compile_to_jvm_old(T388* C);
T2 r388static_value(T388* C);
T6 r388is_current(T388* C);
T0* r388static_result_base_class(T388* C);
void r388make(T388* C,T0* a1,T0* a2);
void r388jvm_assign(T388* C);
T0* r388add_comment(T388* C,T0* a1);
void r388assertion_check(T388* C,T3 a1);
T2 r388compile_to_jvm_into(T388* C,T0* a1);
void r388afd_check(T388* C);
T2 r388jvm_branch_if_true(T388* C);
T6 r388is_result(T388* C);
T6 r388use_current(T388* C);
T0* r388to_runnable(T388* C,T0* a1);
T2 r388to_integer(T388* C);
void r388compile_to_jvm(T388* C);
T6 r388is_static(T388* C);
T6 r388is_pre_computable(T388* C);
void r388error(T0* a1,T0* a2);
T2 r388isa_dca_inline_argument(T388* C);
T2 r388jvm_branch_if_false(T388* C);
T6 r388can_be_dropped(T388* C);
T0* r388start_position(T388* C);
void r388compile_target_to_jvm(T388* C);
void r129standard_compile_target_to_jvm(T129* C);
void r129compile_to_jvm_old(T129* C);
T0* r129runnable_expression(T0* a1,T0* a2);
void r129run_feature_has_result(T129* C);
void r129run_feature_match(T129* C,T0* a1);
T0* r129add_comment(T129* C,T0* a1);
void r129with(T129* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r129afd_check(T129* C);
T0* r129operator(void);
T6 r129use_current(T129* C);
T0* r129runnable_args(T0* a1,T0* a2);
T0* r129to_runnable(T129* C,T0* a1);
T2 r129to_integer(T129* C);
T6 r129is_static(T129* C);
void r129error(T0* a1,T0* a2);
T0* r129result_type(T129* C);
T2 r129jvm_standard_branch_if_false(T129* C);
T0* r129run_feature_for(T129* C,T0* a1,T0* a2);
T0* r129static_result_base_class(T129* C);
void r129make(T129* C,T0* a1,T0* a2,T0* a3);
void r129fatal_error(T0* a1);
T2 r129standard_compile_to_jvm_into(T129* C,T0* a1);
void r129assertion_check(T129* C,T3 a1);
T2 r129compile_to_jvm_into(T129* C,T0* a1);
T2 r129jvm_branch_if_true(T129* C);
T2 r129jvm_standard_branch_if_true(T129* C);
T2 r129jvm_branch_if_false(T129* C);
void r127standard_compile_target_to_jvm(T127* C);
void r127compile_to_jvm_old(T127* C);
T0* r127runnable_expression(T0* a1,T0* a2);
void r127run_feature_has_result(T127* C);
void r127run_feature_match(T127* C,T0* a1);
T0* r127add_comment(T127* C,T0* a1);
void r127with(T127* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r127afd_check(T127* C);
T0* r127operator(void);
T6 r127use_current(T127* C);
T0* r127runnable_args(T0* a1,T0* a2);
T0* r127to_runnable(T127* C,T0* a1);
T2 r127to_integer(T127* C);
T6 r127is_static(T127* C);
void r127error(T0* a1,T0* a2);
T0* r127result_type(T127* C);
T2 r127jvm_standard_branch_if_false(T127* C);
T0* r127run_feature_for(T127* C,T0* a1,T0* a2);
T0* r127static_result_base_class(T127* C);
void r127make(T127* C,T0* a1,T0* a2,T0* a3);
void r127fatal_error(T0* a1);
T2 r127standard_compile_to_jvm_into(T127* C,T0* a1);
void r127assertion_check(T127* C,T3 a1);
T2 r127compile_to_jvm_into(T127* C,T0* a1);
T2 r127jvm_branch_if_true(T127* C);
T2 r127jvm_standard_branch_if_true(T127* C);
T2 r127jvm_branch_if_false(T127* C);
T0* r275generic_list(T275* C);
T2 r275jvm_if_x_ne(void);
T0* r275base_class(T275* C);
T0* r275look_up_for(T275* C,T0* a1,T0* a2);
T6 r275has_creation(T275* C,T0* a1);
void r275error(T0* a1,T0* a2);
T6 r275is_a_in(T275* C,T0* a1,T0* a2);
T6 r275is_native_array(T275* C);
T6 r275is_a(T275* C,T0* a1);
void r275make(T275* C,T0* a1);
extern int fBC12type_real_ref;
extern T0*oBC12type_real_ref;
T0* r275type_real_ref(void);
extern int fBC275used_as_reference;
void r275used_as_reference(void);
T2 r275jvm_stack_space(void);
extern int fBC12type_double;
extern T0*oBC12type_double;
T0* r275type_double(void);
void r275fatal_error_generic_list(T275* C);
T0* r275smallest_ancestor(T275* C,T0* a1);
extern int fBC275check_type;
void r275check_type(T275* C);
void r275load_ref(T0* a1);
T0* r275to_runnable(T275* C,T0* a1);
T0* r275run_time_mark(void);
T0* r275run_class(T275* C);
T2 r275jvm_push_default(void);
T2 r275jvm_convert_to(T0* a1);
T2 r275jvm_if_x_eq(void);
T0* r275written_mark(void);
T2 r275jvm_expanded_from_reference(T0* a1);
void r368make(T368* C,T0* a1);
void r368add(T368* C,T0* a1);
extern T0*oBC368sucess;
void r368afd_check(T368* C);
T6 r368use_current(T368* C);
void r368compile_to_jvm(T368* C);
void r368clear_run_feature(T368* C);
void r187standard_compile_target_to_jvm(T187* C);
T0* r187base_class_written(T187* C);
T0* r187add_comment(T187* C,T0* a1);
T0* r187to_runnable(T187* C,T0* a1);
T2 r187to_integer(T187* C);
void r187compile_to_jvm(T187* C);
T0* r187twin(T187* C);
void r187error(T0* a1,T0* a2);
T0* r187static_result_base_class(T187* C);
void r187make(T187* C,T0* a1,T0* a2);
void r187jvm_assign(T187* C);
T2 r187standard_compile_to_jvm_into(T187* C,T0* a1);
void r187name_clash_for(T187* C,T0* a1,T0* a2);
T2 r187compile_to_jvm_into(T187* C,T0* a1);
T2 r187jvm_branch_if_true(T187* C);
T2 r187jvm_branch_if_false(T187* C);
T0* r187written_in(T187* C);
void r42push_check(T42* C,T0* a1);
extern T0*oBC42tmp_string;
extern T0*oBC42out_file_path;
void r42add_method(T0* a1);
void r42std_is_equal(T0* a1,T0* a2);
extern T0*oBC42out_file;
void r42push_target(T42* C);
void r42push_direct(T42* C,T0* a1);
extern T0*oBC43stack_rf;
extern T0*oBC12once_routine_pool;
void r42define_class_invariant_method(T42* C,T0* a1);
void r42fields_by_fields_copy(T0* a1);
void r42start_new_class(T42* C,T0* a1);
extern T0*oBC43stack_target;
T0* r42target_position(T42* C);
void r42set_output_name(T42* C,T0* a1);
T2 r42local_offset_of(T42* C,T0* a1);
void r42stack_overflow(T42* C);
extern T0*oBC43stack_code;
void r42push_se_argv(T42* C);
void r42bfw_connect(T42* C,T0* a1,T0* a2);
extern T355 oBC1file_tools;
void r42prepare_methods(T42* C);
void r42push_switch(T42* C,T0* a1,T0* a2);
void r42b_put_byte_string(T0* a1);
T2 r42push_ith_argument(T42* C,T2 a1);
extern T0*oBC12field_info;
T2 r42args_field_idx(void);
T2 r42argument_offset_of(T42* C,T0* a1);
extern T0*oBC43stack_cpc;
void r42push_expanded_initialize(T42* C,T0* a1);
T0* r42jvm_root_class(void);
extern T0*oBC12method_info;
T2 r42push_arguments(T42* C);
extern T0*oBC42methods;
void r42b_put_u2(T2 a1);
void r42opcode_check_id_for(T0* a1);
void r42pop(T42* C);
extern T0*oBC43stack_static_rf;
void r42add_field(T0* a1);
void r42write_jvm_root_class(T42* C);
T2 r42max_locals(T42* C);
void r42drop_target(T42* C);
void r42write_main_class(T42* C,T0* a1);
void r42fatal_error(T0* a1);
T2 r42result_offset(T42* C);
extern T0*oBC42fields;
void r42drop_ith_argument(T42* C,T2 a1);
extern T0*oBC43stack_args;
void r42call_proc_call_mapping(T42* C,T0* a1);
T0* r42system_tools(void);
void r42finish_class(T42* C);
void r42push_target_as_target(T42* C);
void r42inside_new(T42* C,T0* a1,T0* a2);
void r42mkdir(T42* C);
void r42incr_static_expression_count(T42* C);
void r42push_precursor(T42* C,T0* a1,T0* a2);
void r42inside_twin(T42* C,T0* a1);
void r42stack_push(T42* C,T2 a1);
T2 r265id(T265* C);
T0* r265base_class(T265* C);
T0* r265look_up_for(T265* C,T0* a1,T0* a2);
T6 r265has_creation(T265* C,T0* a1);
T6 r265is_a_in(T265* C,T0* a1,T0* a2);
T6 r265is_native_array(T265* C);
extern T0*oBC265tmp_written_mark;
T6 r265is_a(T265* C,T0* a1);
void r265make(T265* C,T0* a1,T0* a2);
T0* r265run_type(T265* C);
T2 r265jvm_stack_space(void);
void r265load_basic_features(T265* C);
T0* r265jvm_root_class(void);
T6 r265is_run_type(T265* C);
T0* r265smallest_ancestor(T265* C,T0* a1);
T0* r265string_aliaser(void);
void r265with(T265* C,T0* a1,T0* a2,T0* a3);
T0* r265to_runnable(T265* C,T0* a1);
void r265jvm_standard_is_equal(T265* C);
T0* r265run_time_mark(T265* C);
void r265final(T265* C,T0* a1,T0* a2);
T0* r265run_class(T265* C);
void r265fatal_error(T0* a1);
T2 r265jvm_push_default(void);
void r265standard_jvm_check_class_invariant(T265* C);
T2 r265jvm_expanded_from_reference(T0* a1);
T0* r265jvm_root_descriptor(void);
T0* r178add_comment(T178* C,T0* a1);
T0* r178to_real_constant(T178* C);
void r178error(T0* a1,T0* a2);
extern int fBC178result_type;
extern T0*oBC178result_type;
T0* r178result_type(void);
void r178unary_minus(T178* C);
T0* r178static_result_base_class(void);
void r178make(T178* C,T2 a1,T0* a2);
T2 r178standard_compile_to_jvm_into(T178* C,T0* a1);
T2 r178compile_to_jvm_into(T178* C,T0* a1);
T2 r178isa_dca_inline_argument(void);
void r184standard_compile_target_to_jvm(T184* C);
void r184refer_to(T184* C,T0* a1,T0* a2,T2 a3);
T0* r184add_comment(T184* C,T0* a1);
T0* r184to_runnable(T184* C,T0* a1);
T2 r184to_integer(T184* C);
void r184compile_to_jvm(T184* C);
void r184error(T0* a1,T0* a2);
T0* r184result_type(T184* C);
T0* r184static_result_base_class(T184* C);
void r184fatal_error(T0* a1);
void r184jvm_assign(T184* C);
T2 r184standard_compile_to_jvm_into(T184* C,T0* a1);
void r184assertion_check(T184* C,T3 a1);
T2 r184compile_to_jvm_into(T184* C,T0* a1);
T2 r184jvm_branch_if_true(T184* C);
T2 r184jvm_branch_if_false(T184* C);
T0* r268generic_list(T268* C);
T0* r268base_class(T268* C);
T0* r268look_up_for(T268* C,T0* a1,T0* a2);
T6 r268has_creation(T268* C,T0* a1);
void r268error(T0* a1,T0* a2);
T6 r268is_a_in(T268* C,T0* a1,T0* a2);
T6 r268is_native_array(T268* C);
T6 r268is_a(T268* C,T0* a1);
void r268make(T268* C,T0* a1);
extern int fBC268used_as_reference;
void r268used_as_reference(void);
T2 r268jvm_stack_space(void);
void r268fatal_error_generic_list(T268* C);
T0* r268smallest_ancestor(T268* C,T0* a1);
extern int fBC268check_type;
void r268check_type(T268* C);
void r268load_ref(T0* a1);
T0* r268to_runnable(T268* C,T0* a1);
extern int fBC12type_boolean_ref;
extern T0*oBC12type_boolean_ref;
T0* r268type_boolean_ref(void);
T0* r268run_time_mark(void);
T0* r268run_class(T268* C);
T2 r268jvm_push_default(void);
T2 r268jvm_convert_to(T0* a1);
T0* r268written_mark(void);
T2 r268jvm_expanded_from_reference(T0* a1);
T0* r276generic_list(T276* C);
T0* r276type_string(void);
T0* r276base_class(T276* C);
T0* r276look_up_for(T276* C,T0* a1,T0* a2);
T6 r276has_creation(T276* C,T0* a1);
T6 r276is_a_in(T276* C,T0* a1,T0* a2);
T6 r276is_native_array(T276* C);
T6 r276is_a(T276* C,T0* a1);
void r276make(T276* C,T0* a1);
T2 r276jvm_stack_space(void);
T0* r276jvm_root_class(void);
void r276fatal_error_generic_list(T276* C);
T0* r276smallest_ancestor(T276* C,T0* a1);
extern int fBC276set_at_run_time;
void r276set_at_run_time(void);
void r276jvm_standard_is_equal(T276* C);
T0* r276run_time_mark(void);
T0* r276run_class(T276* C);
T2 r276jvm_push_default(void);
void r276standard_jvm_check_class_invariant(T276* C);
T0* r276written_mark(void);
T2 r276jvm_expanded_from_reference(T0* a1);
T0* r276jvm_root_descriptor(void);
void r138standard_compile_target_to_jvm(T138* C);
void r138compile_to_jvm_old(T138* C);
T0* r138runnable_expression(T0* a1,T0* a2);
void r138run_feature_has_result(T138* C);
void r138run_feature_match(T138* C,T0* a1);
T0* r138add_comment(T138* C,T0* a1);
void r138with(T138* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r138afd_check(T138* C);
T0* r138operator(void);
T6 r138use_current(T138* C);
T0* r138runnable_args(T0* a1,T0* a2);
T0* r138to_runnable(T138* C,T0* a1);
T2 r138to_integer(T138* C);
T6 r138is_static(T138* C);
void r138error(T0* a1,T0* a2);
T0* r138result_type(T138* C);
T2 r138jvm_standard_branch_if_false(T138* C);
T0* r138run_feature_for(T138* C,T0* a1,T0* a2);
T0* r138static_result_base_class(T138* C);
void r138make(T138* C,T0* a1,T0* a2,T0* a3);
void r138fatal_error(T0* a1);
T2 r138standard_compile_to_jvm_into(T138* C,T0* a1);
void r138assertion_check(T138* C,T3 a1);
T2 r138compile_to_jvm_into(T138* C,T0* a1);
T2 r138jvm_standard_branch_if_true(T138* C);
T2 r191rank_of(T191* C,T0* a1);
void r191check_name_clash(T191* C,T0* a1);
void r191declaration_list_make(T191* C,T0* a1);
void r191with(T191* C,T0* a1,T0* a2);
T2 r191jvm_offset_of(T191* C,T0* a1);
T2 r191jvm_switch_push_ith(T191* C,T0* a1,T2 a2);
T2 r191jvm_switch_push(T191* C,T0* a1);
void r191jvm_descriptor_in(T191* C,T0* a1);
T0* r191type(T191* C,T2 a1);
void r191dynamic_runnable(T191* C,T0* a1);
void r191error(T0* a1,T0* a2);
void r191add_last(T191* C,T0* a1);
T6 r191is_a_in(T191* C,T0* a1,T0* a2);
void r191make(T191* C,T0* a1);
void r191fatal_error(T0* a1);
T2 r191jvm_stack_space(T191* C);
T0* r191jvm_root_class(void);
T6 r191is_runnable(T191* C,T0* a1);
T0* r191jvm_root_descriptor(void);
T0* r191start_position(T191* C);
T6 r292is_merge_with(T292* C,T0* a1,T0* a2);
T6 r292is_merge_with2aux(T292* C,T0* a1,T0* a2);
T0* r292try_to_undefine(T292* C,T0* a1,T0* a2);
void r292check_obsolete(T292* C,T0* a1);
T6 r292is_merge_with1(T292* C,T0* a1);
T6 r292is_merge_with2(T292* C,T0* a1,T0* a2);
T0* r292to_run_feature(T292* C,T0* a1,T0* a2);
void r292error(T0* a1,T0* a2);
void r292set_header_comment(T292* C,T0* a1);
void r292set_rescue_compound(T292* C,T0* a1);
void r292make_routine(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r292make(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r292add_into(T292* C,T0* a1);
T6 r292can_hide(T292* C,T0* a1,T0* a2);
void r292from_effective(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r292merge_header_comments(T292* C,T0* a1);
T0* r292start_position(T292* C);
T0* r211value(T211* C,T2 a1);
T6 r211is_merge_with(T211* C,T0* a1,T0* a2);
T6 r211is_merge_with2aux(T211* C,T0* a1,T0* a2);
T0* r211try_to_undefine_aux(T211* C,T0* a1,T0* a2);
T0* r211try_to_undefine(T211* C,T0* a1,T0* a2);
void r211check_obsolete(T211* C,T0* a1);
T6 r211is_merge_with1(T211* C,T0* a1);
T6 r211is_merge_with2(T211* C,T0* a1,T0* a2);
T0* r211to_run_feature(T211* C,T0* a1,T0* a2);
void r211error(T0* a1,T0* a2);
void r211make(T211* C,T0* a1,T0* a2,T0* a3);
void r211add_into(T211* C,T0* a1);
T6 r211can_hide(T211* C,T0* a1,T0* a2);
void r211merge_header_comments(T211* C,T0* a1);
T0* r211start_position(T211* C);
void r78check_expanded_with(T78* C,T0* a1);
T0* r78root_procedure_name(T78* C,T0* a1);
void r78fatal_error(T0* a1);
T0* r78expanded_initializer(T78* C,T0* a1);
T0* r78get_clause(T78* C,T0* a1);
T0* r78start_position(T78* C);
void r235fatal_error(T0* a1);
T0* r235add_comment(T235* C,T0* a1);
T0* r235to_runnable(T235* C,T0* a1);
void r235compile_to_jvm(T235* C);
void r63put_string(T63* C,T0* a1);
void r63put_integer(T63* C,T2 a1);
void r114compile_to_jvm_old(T114* C);
T0* r114type_any(void);
extern T0*oBC114tmp_string;
T0* r114add_comment(T114* C,T0* a1);
T0* r114sd(T0* a1);
void r114afd_check(T114* C);
T6 r114use_current(T114* C);
T0* r114to_runnable(T114* C,T0* a1);
T2 r114to_integer(T114* C);
void r114compile_to_jvm(T114* C);
void r114error(T0* a1,T0* a2);
T0* r114static_result_base_class(void);
void r114make(T114* C,T0* a1,T0* a2);
void r114assertion_check(T114* C,T3 a1);
T2 r114compile_to_jvm_into(T114* C,T0* a1);
T6 r114is_pre_computable(T114* C);
void r114compile_target_to_jvm(T114* C);
T0* r166runnable_expression(T0* a1,T0* a2);
T0* r166run_feature_for(T166* C,T0* a1,T0* a2);
void r166make(T166* C,T0* a1,T0* a2);
void r166fatal_error(T0* a1);
void r166run_feature_has_no_result(T166* C);
void r166run_feature_match(T166* C);
T0* r166add_comment(T166* C,T0* a1);
void r166afd_check(T166* C);
T6 r166use_current(T166* C);
T0* r166to_runnable(T166* C,T0* a1);
T0* r166make_runnable(T166* C,T0* a1,T0* a2,T0* a3);
T0* r166start_position(T166* C);
void r137standard_compile_target_to_jvm(T137* C);
void r137compile_to_jvm_old(T137* C);
T0* r137runnable_expression(T0* a1,T0* a2);
void r137run_feature_has_result(T137* C);
void r137run_feature_match(T137* C,T0* a1);
T0* r137add_comment(T137* C,T0* a1);
void r137with(T137* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r137afd_check(T137* C);
T0* r137operator(void);
T6 r137use_current(T137* C);
T0* r137runnable_args(T0* a1,T0* a2);
T0* r137to_runnable(T137* C,T0* a1);
T2 r137to_integer(T137* C);
T6 r137is_static(T137* C);
void r137error(T0* a1,T0* a2);
T0* r137result_type(T137* C);
T2 r137jvm_standard_branch_if_false(T137* C);
T0* r137run_feature_for(T137* C,T0* a1,T0* a2);
T0* r137static_result_base_class(T137* C);
void r137make(T137* C,T0* a1,T0* a2,T0* a3);
void r137fatal_error(T0* a1);
T2 r137standard_compile_to_jvm_into(T137* C,T0* a1);
void r137assertion_check(T137* C,T3 a1);
T2 r137compile_to_jvm_into(T137* C,T0* a1);
T2 r137jvm_standard_branch_if_true(T137* C);
T0* r244to_runnable_integer(T244* C,T0* a1);
T0* r244to_runnable_character(T244* C,T0* a1);
T0* r244twin(T244* C);
void r244error(T0* a1,T0* a2);
T0* r244start_position(T244* C);
void r234compile_to_jvm_old(T234* C);
T2 r234static_value(T234* C);
T6 r234is_current(T234* C);
T0* r234static_result_base_class(T234* C);
void r234make(T234* C,T0* a1,T0* a2);
void r234jvm_assign(T234* C);
T6 r234is_manifest_string(T234* C);
T0* r234add_comment(T234* C,T0* a1);
void r234assertion_check(T234* C,T3 a1);
T2 r234compile_to_jvm_into(T234* C,T0* a1);
void r234afd_check(T234* C);
T2 r234jvm_branch_if_true(T234* C);
T6 r234is_result(T234* C);
T6 r234use_current(T234* C);
T0* r234to_runnable(T234* C,T0* a1);
T2 r234to_integer(T234* C);
T6 r234is_void(T234* C);
void r234compile_to_jvm(T234* C);
T6 r234is_static(T234* C);
T6 r234is_pre_computable(T234* C);
void r234error(T0* a1,T0* a2);
T2 r234isa_dca_inline_argument(T234* C);
T0* r234result_type(T234* C);
T2 r234jvm_branch_if_false(T234* C);
T6 r234can_be_dropped(T234* C);
T0* r234start_position(T234* C);
void r234compile_target_to_jvm(T234* C);
T0* r167runnable_expression(T0* a1,T0* a2);
void r167run_feature_match(T167* C,T0* a1);
T0* r167add_comment(T167* C,T0* a1);
void r167with(T167* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r167afd_check(T167* C);
T6 r167use_current(T167* C);
T0* r167runnable_args(T0* a1,T0* a2);
T0* r167to_runnable(T167* C,T0* a1);
void r167compile_to_jvm(T167* C);
T0* r167make_runnable(T167* C,T0* a1,T0* a2,T0* a3);
T0* r167run_feature_for(T167* C,T0* a1,T0* a2);
void r167make(T167* C,T0* a1,T0* a2,T0* a3);
void r167fatal_error(T0* a1);
void r167run_feature_has_no_result(T167* C);
T6 r167standard_use_current(T167* C);
T0* r167start_position(T167* C);
void r35print_count(T35* C,T0* a1,T2 a2);
void r35put_string(T35* C,T0* a1);
void r35put_integer(T35* C,T2 a1);
void r35put_new_line(T35* C);
void r35sfr_connect(T35* C,T0* a1,T0* a2);
void r35w_put_string(T0* a1);
void r35w_put_integer(T2 a1);
void r35w_put_character(T3 a1);
extern T0*oBC1std_error;
void r35put_character(T35* C,T3 a1);
extern T0*oBC1std_output;
T6 r290is_merge_with(T290* C,T0* a1,T0* a2);
T6 r290is_merge_with2aux(T290* C,T0* a1,T0* a2);
T0* r290try_to_undefine(T290* C,T0* a1,T0* a2);
void r290check_obsolete(T290* C,T0* a1);
T6 r290is_merge_with1(T290* C,T0* a1);
T6 r290is_merge_with2(T290* C,T0* a1,T0* a2);
T0* r290to_run_feature(T290* C,T0* a1,T0* a2);
void r290error(T0* a1,T0* a2);
void r290set_header_comment(T290* C,T0* a1);
void r290set_rescue_compound(T290* C,T0* a1);
void r290make_routine(T290* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r290add_into(T290* C,T0* a1);
T6 r290can_hide(T290* C,T0* a1,T0* a2);
void r290from_effective(T290* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r290merge_header_comments(T290* C,T0* a1);
T0* r290start_position(T290* C);
void r251compile_to_jvm0(T0* a1);
void r251make(T251* C,T0* a1,T0* a2);
void r251fatal_error(T0* a1);
void r251warning(T0* a1,T0* a2);
T0* r251add_comment(T251* C,T0* a1);
void r251check_created_type(T251* C,T0* a1);
void r251check_creation_clause(T251* C,T0* a1);
void r251check_writable(T251* C,T0* a1);
T6 r251use_current(T251* C);
T0* r251to_runnable(T251* C,T0* a1);
void r251compile_to_jvm(T251* C);
T6 r251is_pre_computable(T251* C);
void r251error(T0* a1,T0* a2);
void r236make(T236* C,T0* a1,T0* a2);
T0* r236add_comment(T236* C,T0* a1);
void r236afd_check(T236* C);
void r236set_else_compound(T236* C,T0* a1,T0* a2);
T6 r236use_current(T236* C);
T0* r236to_runnable(T236* C,T0* a1);
void r236compile_to_jvm(T236* C);
T0* r236twin(T236* C);
void r236error(T0* a1,T0* a2);
void r236add_when(T236* C,T0* a1);
void r40jvm_to_reference(T40* C);
extern T0*oBC40tmp_string;
T0* r40at(T40* C,T0* a1);
void r40jvm_check_class_invariant(T40* C);
T0* r40base_class(T40* C);
void r40afd_check(T40* C);
T6 r40gt(T0* a1,T0* a2);
T0* r40fully_qualified_name(T40* C);
void r40compile_to_jvm(T40* C);
void r40jvm_basic_new(T40* C);
void r40jvm_invoke(T40* C,T2 a1,T2 a2);
void r40error(T0* a1,T0* a2);
void r40jvm_expanded_push_default(T40* C);
void r40runnable_class_invariant(T40* C);
void r40store_feature(T40* C,T0* a1);
void r40make(T40* C,T0* a1);
extern T0*oBC40to_reference_memory;
void r40efnf(T40* C,T0* a1,T0* a2);
void r40opcode_instanceof(T40* C);
void r40jvm_reference_from(T40* C,T0* a1);
T6 r40is_running_of(T40* C,T0* a1);
T0* r40writable_attributes(T40* C);
void r40used_as_reference(T40* C);
T2 r40opcode_getfield(T40* C,T0* a1);
T0* r40unqualified_name(T40* C);
T0* r40dynamic(T40* C,T0* a1);
void r40prepare_strip(T40* C);
void r40add_rf(T40* C,T0* a1,T0* a2);
void r40falling_down(T40* C);
void r40opcode_checkcast(T40* C);
extern int fBC12class_general;
extern T0*oBC12class_general;
T0* r40class_general(void);
extern T0*oBC40fully_qualified_name_memory2;
T0* r40get_feature(T40* C,T0* a1);
void r40sort_wam(T0* a1);
void r40set_at_run_time(T40* C);
T0* r40to_reference(T40* C);
extern T0*oBC12gc_handler;
T0* r40get_memory_dispose(T40* C);
void r40jvm_type_descriptor_in(T40* C,T0* a1);
void r40fatal_error(T0* a1);
T0* r40get_result_type(T40* C,T0* a1);
T0* r40get_or_fatal_error(T40* C,T0* a1);
extern T0*oBC40unqualified_name_memory;
T0* r40get_copy(T40* C);
T0* r40get_feature_with(T40* C,T0* a1);
T2 r40jvm_constant_pool_index(T40* C);
T0* r40get_rf_with(T40* C,T0* a1);
void r40add_running(T40* C,T0* a1);
void r40jvm_define_class_invariant(T40* C);
T0* r40class_with(T0* a1);
extern int fBC12id_provider;
extern T0*oBC12id_provider;
T0* r40id_provider(void);
void r40add_client(T40* C,T0* a1);
void r155standard_compile_target_to_jvm(T155* C);
void r155compile_to_jvm_old(T155* C);
T0* r155runnable_expression(T0* a1,T0* a2);
void r155run_feature_has_result(T155* C);
T2 r155static_value(T155* C);
void r155run_feature_match(T155* C,T0* a1);
T0* r155add_comment(T155* C,T0* a1);
void r155with(T155* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r155afd_check(T155* C);
T6 r155use_current(T155* C);
T0* r155runnable_args(T0* a1,T0* a2);
T0* r155to_runnable(T155* C,T0* a1);
T2 r155to_integer(T155* C);
T6 r155is_static(T155* C);
void r155error(T0* a1,T0* a2);
T0* r155result_type(T155* C);
T2 r155jvm_standard_branch_if_false(T155* C);
T0* r155run_feature_for(T155* C,T0* a1,T0* a2);
T0* r155static_result_base_class(T155* C);
void r155make(T155* C,T0* a1,T0* a2,T0* a3);
void r155fatal_error(T0* a1);
T2 r155standard_compile_to_jvm_into(T155* C,T0* a1);
void r155assertion_check(T155* C,T3 a1);
T2 r155compile_to_jvm_into(T155* C,T0* a1);
T2 r155jvm_standard_branch_if_true(T155* C);
T0* r155start_position(T155* C);
void r153standard_compile_target_to_jvm(T153* C);
void r153compile_to_jvm_old(T153* C);
T0* r153runnable_expression(T0* a1,T0* a2);
void r153run_feature_has_result(T153* C);
T2 r153static_value(T153* C);
void r153run_feature_match(T153* C);
T0* r153add_comment(T153* C,T0* a1);
void r153with(T153* C,T0* a1,T0* a2,T0* a3);
void r153afd_check(T153* C);
T6 r153use_current(T153* C);
T0* r153to_runnable(T153* C,T0* a1);
T2 r153to_integer(T153* C);
void r153compile_to_jvm(T153* C);
T6 r153is_static(T153* C);
void r153error(T0* a1,T0* a2);
T0* r153result_type(T153* C);
T6 r153can_be_dropped(T153* C);
T2 r153jvm_standard_branch_if_false(T153* C);
T0* r153run_feature_for(T153* C,T0* a1,T0* a2);
T0* r153static_result_base_class(T153* C);
void r153make(T153* C,T0* a1,T0* a2);
void r153fatal_error(T0* a1);
T2 r153standard_compile_to_jvm_into(T153* C,T0* a1);
void r153assertion_check(T153* C,T3 a1);
T2 r153compile_to_jvm_into(T153* C,T0* a1);
T2 r153jvm_standard_branch_if_true(T153* C);
T6 r153is_pre_computable(T153* C);
T0* r153start_position(T153* C);
void r238compile_to_jvm_resolve_branch(T238* C);
T0* r238to_runnable_integer(T238* C,T0* a1);
void r238from_when_list(T238* C,T0* a1);
void r238afd_check(T238* C);
T6 r238use_current(T238* C);
T0* r238to_runnable_character(T238* C,T0* a1);
void r238compile_to_jvm(T238* C,T0* a1);
T6 r238includes_integer(T238* C,T2 a1);
void r238error(T0* a1,T0* a2);
T0* r238start_position(T238* C);
void r130standard_compile_target_to_jvm(T130* C);
void r130compile_to_jvm_old(T130* C);
T0* r130runnable_expression(T0* a1,T0* a2);
void r130run_feature_has_result(T130* C);
void r130run_feature_match(T130* C,T0* a1);
T0* r130add_comment(T130* C,T0* a1);
void r130with(T130* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r130afd_check(T130* C);
T0* r130operator(void);
T6 r130use_current(T130* C);
T0* r130runnable_args(T0* a1,T0* a2);
T0* r130to_runnable(T130* C,T0* a1);
T2 r130to_integer(T130* C);
T6 r130is_static(T130* C);
void r130error(T0* a1,T0* a2);
T0* r130result_type(T130* C);
T2 r130jvm_standard_branch_if_false(T130* C);
T0* r130run_feature_for(T130* C,T0* a1,T0* a2);
T0* r130static_result_base_class(T130* C);
void r130make(T130* C,T0* a1,T0* a2,T0* a3);
void r130fatal_error(T0* a1);
T2 r130standard_compile_to_jvm_into(T130* C,T0* a1);
void r130assertion_check(T130* C,T3 a1);
T2 r130compile_to_jvm_into(T130* C,T0* a1);
T2 r130jvm_branch_if_true(T130* C);
T2 r130jvm_standard_branch_if_true(T130* C);
T2 r130jvm_branch_if_false(T130* C);
void r128standard_compile_target_to_jvm(T128* C);
void r128compile_to_jvm_old(T128* C);
T0* r128runnable_expression(T0* a1,T0* a2);
void r128run_feature_has_result(T128* C);
void r128run_feature_match(T128* C,T0* a1);
T0* r128add_comment(T128* C,T0* a1);
void r128with(T128* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r128afd_check(T128* C);
T0* r128operator(void);
T6 r128use_current(T128* C);
T0* r128runnable_args(T0* a1,T0* a2);
T0* r128to_runnable(T128* C,T0* a1);
T2 r128to_integer(T128* C);
T6 r128is_static(T128* C);
void r128error(T0* a1,T0* a2);
T0* r128result_type(T128* C);
T2 r128jvm_standard_branch_if_false(T128* C);
T0* r128run_feature_for(T128* C,T0* a1,T0* a2);
T0* r128static_result_base_class(T128* C);
void r128make(T128* C,T0* a1,T0* a2,T0* a3);
void r128fatal_error(T0* a1);
T2 r128standard_compile_to_jvm_into(T128* C,T0* a1);
void r128assertion_check(T128* C,T3 a1);
T2 r128compile_to_jvm_into(T128* C,T0* a1);
T2 r128jvm_branch_if_true(T128* C);
T2 r128jvm_standard_branch_if_true(T128* C);
T2 r128jvm_branch_if_false(T128* C);
T0* r245to_runnable_integer(T245* C,T0* a1);
void r245make(T245* C,T0* a1,T0* a2);
T0* r245to_runnable_character(T245* C,T0* a1);
T0* r245twin(T245* C);
void r245error(T0* a1,T0* a2);
T0* r245start_position(T245* C);
void r220make(T220* C,T0* a1,T0* a2,T0* a3);
void r220fatal_error(T0* a1);
void r220afd_check(T220* C);
T6 r220use_current(T220* C);
T0* r220to_runnable(T220* C,T0* a1);
void r220compile_to_jvm(T220* C);
void r220put(T220* C,T0* a1,T2 a2);
T2 r220count(T220* C);
T6 r220is_pre_computable(T220* C);
void r220from_compound(T220* C,T0* a1);
T0* r220start_position(T220* C);
T0* r220item(T220* C,T2 a1);
T0* r163add_comment(T163* C,T0* a1);
T0* r163to_runnable(T163* C,T0* a1);
T2 r163to_integer(T163* C);
void r163compile_to_jvm(T163* C);
void r163error(T0* a1,T0* a2);
extern int fBC12type_pointer;
extern T0*oBC12type_pointer;
T0* r163type_pointer(void);
T0* r163static_result_base_class(void);
void r163fatal_error(T0* a1);
T0* r163start_position(T163* C);
void r163compile_target_to_jvm(T163* C);
T2 r372jvm_argument_offset(T372* C,T0* a1);
T2 r372static_value_mem(T372* C);
T6 r372use_current(T372* C);
void r372fall_down(T372* C);
void r372mapping_jvm(T372* C);
T6 r372is_static(T372* C);
T6 r372is_exported_in(T372* C,T0* a1);
T2 r372jvm_local_variable_offset(T372* C,T0* a1);
T0* r372clients(T372* C);
void r372std_compute_use_current(T372* C);
T2 r372jvm_max_locals(T372* C);
T6 r372is_deferred(T372* C);
T2 r372jvm_result_offset(T372* C);
T0* r372run_class(T372* C);
void r372make(T372* C,T0* a1,T0* a2,T0* a3);
void r372initialize(T372* C);
extern T0*oBC45tmp_jvm_descriptor;
T0* r372jvm_descriptor(void);
T0* r372start_position(T372* C);
void r67disconnect(T67* C);
void r67read_line_in(T67* C,T0* a1);
T6 r67end_of_input(T67* C);
extern T0*oBC68last_string;
void r67read_character(T67* C);
void r67read_line(T67* C);
void r67read_word(T67* C);
void r67connect_to(T67* C,T0* a1);
void r67skip_separators(T67* C);
void r315make(T315* C,T0* a1,T0* a2);
void r315append_in(T315* C,T0* a1);
T2 r315count(T315* C);
T0* r176add_comment(T176* C,T0* a1);
T0* r176to_runnable(T176* C,T0* a1);
T2 r176to_integer(T176* C);
void r176compile_to_jvm(T176* C);
void r176error(T0* a1,T0* a2);
T0* r176static_result_base_class(void);
void r176make(T176* C,T0* a1,T0* a2);
T2 r176standard_compile_to_jvm_into(T176* C,T0* a1);
T2 r176compile_to_jvm_into(T176* C,T0* a1);
void r176compile_target_to_jvm(T176* C);
T0* r226add_comment(T226* C,T0* a1);
void r226afd_check(T226* C);
T6 r226use_current(T226* C);
void r226add_if_then(T226* C,T0* a1,T0* a2);
T0* r226to_runnable(T226* C,T0* a1);
void r226compile_to_jvm(T226* C);
T0* r226twin(T226* C);
T6 r77ensure_check(T77* C);
T6 r77debug_check(T77* C);
T6 r77no_check(T77* C);
T6 r77boost(T77* C);
T6 r77require_check(T77* C);
void r77compute_root_class(T77* C,T0* a1);
T6 r77loop_check(T77* C);
T6 r77invariant_check(T77* C);
T6 r77all_check(T77* C);
T0* r77root_procedure(T77* C);
void r285jvm_target_descriptor_in(T285* C,T0* a1);
T0* r285generic_list(T285* C);
T2 r285jvm_method_flags(T285* C);
T2 r285id(T285* C);
void r285warning(T0* a1,T0* a2);
T2 r285jvm_if_x_ne(T285* C);
void r285jvm_check_class_invariant(T285* C);
T0* r285base_class(T285* C);
T6 r285is_array(T285* C);
T0* r285look_up_for(T285* C,T0* a1,T0* a2);
void r285jvm_descriptor_in(T285* C,T0* a1);
T6 r285has_creation(T285* C,T0* a1);
void r285error(T0* a1,T0* a2);
T6 r285is_a_in(T285* C,T0* a1,T0* a2);
T6 r285is_native_array(T285* C);
T6 r285is_boolean(T285* C);
T6 r285is_a(T285* C,T0* a1);
T6 r285is_generic(T285* C);
void r285jvm_xaload(T285* C);
void r285make(T285* C,T0* a1,T2 a2);
void r285jvm_return_code(T285* C);
void r285used_as_reference(T285* C);
T2 r285jvm_stack_space(T285* C);
T0* r285formal_generic_list(T285* C);
T6 r285is_reference(T285* C);
T6 r285is_real(T285* C);
T6 r285is_user_expanded(T285* C);
T6 r285is_integer(T285* C);
void r285fatal_error_generic_list(T285* C);
T6 r285is_any(T285* C);
void r285jvm_xastore(T285* C);
T6 r285is_string(T285* C);
T0* r285constraint(T285* C);
T0* r285smallest_ancestor(T285* C,T0* a1);
T6 r285is_double(T285* C);
void r285jvm_write_local(T285* C,T2 a1);
T6 r285is_none(T285* C);
T0* r285to_runnable(T285* C,T0* a1);
T0* r285make_runnable(T285* C,T0* a1);
T0* r285twin(T285* C);
T6 r285is_pointer(T285* C);
T0* r285formal_arg(T285* C);
void r285jvm_standard_is_equal(T285* C);
T0* r285static_base_class_name(T285* C);
T0* r285run_time_mark(T285* C);
T0* r285run_class(T285* C);
void r285jvm_xnewarray(T285* C);
T6 r285is_dummy_expanded(T285* C);
void r285jvm_push_local(T285* C,T2 a1);
void r285fatal_error(T0* a1);
T2 r285jvm_push_default(T285* C);
T6 r285is_expanded(T285* C);
T2 r285jvm_convert_to(T285* C,T0* a1);
T2 r285jvm_if_x_eq(T285* C);
T0* r285expanded_initializer(T285* C);
T6 r285is_basic_eiffel_expanded(T285* C);
T6 r285is_character(T285* C);
T2 r285jvm_expanded_from_reference(T285* C,T0* a1);
T0* r285base_class_name(T285* C);
T6 r285is_bit(T285* C);
void r254compile_to_jvm0(T0* a1);
void r254make(T254* C,T0* a1,T0* a2,T0* a3);
void r254fatal_error(T0* a1);
void r254warning(T0* a1,T0* a2);
T0* r254add_comment(T254* C,T0* a1);
void r254check_created_type(T254* C,T0* a1);
void r254check_creation_clause(T254* C,T0* a1);
void r254check_writable(T254* C,T0* a1);
T6 r254use_current(T254* C);
T0* r254to_runnable(T254* C,T0* a1);
void r254compile_to_jvm(T254* C);
void r254check_explicit_type(T254* C);
T6 r254is_pre_computable(T254* C);
void r254error(T0* a1,T0* a2);
void r321make(T321* C,T0* a1,T0* a2);
void r321make_all(T321* C,T0* a1);
T6 r321affect(T321* C,T0* a1);
void r110make(T110* C,T0* a1,T0* a2);
T0* r359runnable(T0* a1,T0* a2,T0* a3,T3 a4);
T0* r359require_end(T359* C,T0* a1,T0* a2);
void r359assertion_add_last(T359* C,T0* a1);
T0* r359ensure_end(T359* C,T0* a1,T0* a2);
void r359invariant_add_last(T359* C,T0* a1);
extern T0*oBC359collector;
void r359ensure_start(T359* C);
void r359require_start(T359* C);
T0* r359invariant_end(T359* C,T0* a1);
void r359error(T0* a1,T0* a2);
void r359invariant_start(T359* C);
T6 r73is_subclass_of(T73* C,T0* a1);
void r73make(T73* C,T0* a1,T0* a2);
T0* r73base_class(T73* C);
void r73make_unknown(T73* C);
T0* r274generic_list(T274* C);
T0* r274base_class(T274* C);
T0* r274look_up_for(T274* C,T0* a1,T0* a2);
T6 r274has_creation(T274* C,T0* a1);
void r274error(T0* a1,T0* a2);
T6 r274is_a_in(T274* C,T0* a1,T0* a2);
T6 r274is_native_array(T274* C);
T6 r274is_a(T274* C,T0* a1);
void r274make(T274* C,T0* a1);
extern int fBC274used_as_reference;
void r274used_as_reference(void);
T2 r274jvm_stack_space(void);
void r274fatal_error_generic_list(T274* C);
T0* r274smallest_ancestor(T274* C,T0* a1);
extern int fBC274check_type;
void r274check_type(T274* C);
void r274load_ref(T0* a1);
T0* r274to_runnable(T274* C,T0* a1);
extern int fBC12type_pointer_ref;
extern T0*oBC12type_pointer_ref;
T0* r274type_pointer_ref(void);
T0* r274run_time_mark(void);
T0* r274run_class(T274* C);
T2 r274jvm_push_default(void);
T2 r274jvm_convert_to(T0* a1);
T0* r274written_mark(void);
T2 r274jvm_expanded_from_reference(T0* a1);
T0* r272generic_list(T272* C);
T0* r272base_class(T272* C);
T0* r272look_up_for(T272* C,T0* a1,T0* a2);
T6 r272has_creation(T272* C,T0* a1);
void r272error(T0* a1,T0* a2);
T6 r272is_a_in(T272* C,T0* a1,T0* a2);
T6 r272is_native_array(T272* C);
T6 r272is_a(T272* C,T0* a1);
void r272make(T272* C,T0* a1);
extern int fBC272used_as_reference;
void r272used_as_reference(void);
T2 r272jvm_stack_space(void);
void r272fatal_error_generic_list(T272* C);
T0* r272smallest_ancestor(T272* C,T0* a1);
extern int fBC272check_type;
void r272check_type(T272* C);
void r272load_ref(T0* a1);
T0* r272to_runnable(T272* C,T0* a1);
extern int fBC12type_integer_ref;
extern T0*oBC12type_integer_ref;
T0* r272type_integer_ref(void);
T0* r272run_time_mark(void);
T0* r272run_class(T272* C);
T2 r272jvm_push_default(void);
T2 r272jvm_convert_to(T0* a1);
T0* r272written_mark(void);
T2 r272jvm_expanded_from_reference(T0* a1);
void r74environment_variable_substitution(T74* C,T0* a1,T0* a2);
T6 r74backslash_separator(T74* C);
T0* r74get_environment_variable(T74* C,T0* a1);
void r74class_file_path(T74* C,T0* a1,T0* a2,T0* a3);
void r74make(T74* C);
extern T0*oBC74system_list;
void r74bad_use_exit(T74* C,T0* a1);
T6 r74slash_separator(T74* C);
void r74append_lp_in(T74* C,T0* a1,T0* a2);
void r74loading_path_add(T74* C,T0* a1,T0* a2,T2 a3);
void r74add_directory(T74* C,T0* a1,T0* a2);
void r74parent_directory(T74* C,T0* a1);
void r74read_loading_path_in(T74* C,T0* a1);
T2 r59jvm_argument_offset(T59* C,T0* a1);
void r59jvm_define(T59* C);
void r59afd_check(T59* C);
T6 r59use_current(T59* C);
void r59fall_down(T59* C);
void r59mapping_jvm(T59* C);
T6 r59is_exported_in(T59* C,T0* a1);
T2 r59jvm_local_variable_offset(T59* C,T0* a1);
T0* r59clients(T59* C);
T2 r59jvm_max_locals(T59* C);
T2 r59jvm_result_offset(T59* C);
T0* r59run_class(T59* C);
void r59make(T59* C,T0* a1,T0* a2,T0* a3);
void r59update_tmp_jvm_descriptor(T59* C);
void r59initialize(T59* C);
T0* r59jvm_descriptor(T59* C);
T0* r59jvm_root_class(void);
T0* r59jvm_root_descriptor(void);
void r124standard_compile_target_to_jvm(T124* C);
void r124compile_to_jvm_old(T124* C);
T0* r124runnable_expression(T0* a1,T0* a2);
void r124run_feature_has_result(T124* C);
void r124run_feature_match(T124* C,T0* a1);
T0* r124add_comment(T124* C,T0* a1);
void r124with(T124* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r124afd_check(T124* C);
T0* r124operator(void);
T6 r124use_current(T124* C);
T0* r124runnable_args(T0* a1,T0* a2);
T0* r124to_runnable(T124* C,T0* a1);
T2 r124to_integer(T124* C);
void r124compile_to_jvm(T124* C);
T6 r124is_static(T124* C);
void r124error(T0* a1,T0* a2);
T0* r124result_type(T124* C);
T2 r124jvm_standard_branch_if_false(T124* C);
T0* r124run_feature_for(T124* C,T0* a1,T0* a2);
T0* r124static_result_base_class(T124* C);
void r124make(T124* C,T0* a1,T0* a2,T0* a3);
void r124fatal_error(T0* a1);
T2 r124standard_compile_to_jvm_into(T124* C,T0* a1);
void r124assertion_check(T124* C,T3 a1);
T2 r124compile_to_jvm_into(T124* C,T0* a1);
T2 r124jvm_standard_branch_if_true(T124* C);
void r279jvm_to_reference(T279* C);
T0* r279generic_list(T279* C);
T2 r279id(T279* C);
T0* r279base_class(T279* C);
T0* r279look_up_for(T279* C,T0* a1,T0* a2);
T6 r279has_creation(T279* C,T0* a1);
T0* r279compute_mark(T0* a1);
T6 r279is_a_in(T279* C,T0* a1,T0* a2);
T6 r279is_native_array(T279* C);
extern T0*oBC279tmp_written_mark;
T6 r279is_boolean(T279* C);
T6 r279is_a(T279* C,T0* a1);
T6 r279is_generic(T279* C);
void r279make(T279* C,T0* a1,T0* a2);
void r279used_as_reference(T279* C);
T2 r279jvm_stack_space(T279* C);
T6 r279is_real(T279* C);
T6 r279is_user_expanded(T279* C);
T6 r279is_integer(T279* C);
void r279from_other(T279* C,T0* a1,T0* a2);
T0* r279smallest_ancestor(T279* C,T0* a1);
T0* r279string_aliaser(void);
T6 r279is_double(T279* C);
void r279jvm_write_local(T279* C,T2 a1);
T0* r279to_runnable(T279* C,T0* a1);
T6 r279is_pointer(T279* C);
void r279jvm_standard_is_equal(T279* C);
T0* r279run_class(T279* C);
void r279jvm_xnewarray(T279* C);
T6 r279is_dummy_expanded(T279* C);
void r279fatal_error(T0* a1);
T2 r279jvm_push_default(T279* C);
void r279standard_jvm_check_class_invariant(T279* C);
T2 r279jvm_convert_to(T279* C,T0* a1);
T0* r279expanded_initializer(T279* C);
T6 r279is_basic_eiffel_expanded(T279* C);
T6 r279is_character(T279* C);
T2 r279jvm_expanded_from_reference(T0* a1);
T0* r279base_class_name(T279* C);
T6 r279is_bit(T279* C);
void r49disconnect(T49* C);
T8 r49bfw_open(T2 a1,T8 a2);
void r49put_byte(T49* C,T3 a1);
void r49connect_to(T49* C,T0* a1);
T6 r296is_merge_with(T296* C,T0* a1,T0* a2);
T6 r296is_merge_with2aux(T296* C,T0* a1,T0* a2);
T0* r296try_to_undefine_aux(T296* C,T0* a1,T0* a2);
T0* r296try_to_undefine(T296* C,T0* a1,T0* a2);
void r296check_obsolete(T296* C,T0* a1);
T6 r296use_current(T296* C);
T6 r296is_merge_with1(T296* C,T0* a1);
T6 r296is_merge_with2(T296* C,T0* a1,T0* a2);
T0* r296to_run_feature(T296* C,T0* a1,T0* a2);
void r296error(T0* a1,T0* a2);
void r296set_header_comment(T296* C,T0* a1);
void r296set_rescue_compound(T296* C,T0* a1);
void r296make_routine(T296* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r296make(T296* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r296make_external_routine(T296* C,T0* a1,T0* a2);
void r296add_into(T296* C,T0* a1);
T6 r296can_hide(T296* C,T0* a1,T0* a2);
void r296merge_header_comments(T296* C,T0* a1);
T0* r296start_position(T296* C);
void r126standard_compile_target_to_jvm(T126* C);
void r126compile_to_jvm_old(T126* C);
T0* r126runnable_expression(T0* a1,T0* a2);
void r126run_feature_has_result(T126* C);
void r126run_feature_match(T126* C,T0* a1);
T0* r126add_comment(T126* C,T0* a1);
void r126with(T126* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r126afd_check(T126* C);
T0* r126operator(void);
T6 r126use_current(T126* C);
T0* r126runnable_args(T0* a1,T0* a2);
T0* r126to_runnable(T126* C,T0* a1);
T2 r126to_integer(T126* C);
void r126compile_to_jvm(T126* C);
T6 r126is_static(T126* C);
void r126error(T0* a1,T0* a2);
T0* r126result_type(T126* C);
T2 r126jvm_standard_branch_if_false(T126* C);
T0* r126run_feature_for(T126* C,T0* a1,T0* a2);
T0* r126static_result_base_class(T126* C);
void r126make(T126* C,T0* a1,T0* a2,T0* a3);
void r126fatal_error(T0* a1);
T2 r126standard_compile_to_jvm_into(T126* C,T0* a1);
void r126assertion_check(T126* C,T3 a1);
T2 r126compile_to_jvm_into(T126* C,T0* a1);
T2 r126jvm_standard_branch_if_true(T126* C);
T0* r151add_comment(T151* C,T0* a1);
void r151with(T151* C,T0* a1,T0* a2);
T0* r151to_runnable(T151* C,T0* a1);
T2 r151to_integer(T151* C);
void r151compile_to_jvm(T151* C);
void r151error(T0* a1,T0* a2);
T6 r151can_be_dropped(T151* C);
T0* r151run_feature(T151* C,T0* a1);
T0* r151static_result_base_class(T151* C);
void r151make(T151* C,T0* a1,T0* a2);
void r151fatal_error(T0* a1);
void r151jvm_assign(T151* C);
void r151undefine_in(T151* C,T0* a1);
T2 r151standard_compile_to_jvm_into(T151* C,T0* a1);
T0* r151origin_base_class(T151* C);
T2 r151compile_to_jvm_into(T151* C,T0* a1);
T2 r151jvm_branch_if_true(T151* C);
T2 r151jvm_branch_if_false(T151* C);
void r151compile_target_to_jvm(T151* C);
T0* r168runnable_expression(T0* a1,T0* a2);
T0* r168run_feature_for(T168* C,T0* a1,T0* a2);
void r168make(T168* C,T0* a1,T0* a2,T0* a3);
void r168fatal_error(T0* a1);
void r168run_feature_has_no_result(T168* C);
void r168run_feature_match(T168* C,T0* a1);
T0* r168add_comment(T168* C,T0* a1);
void r168with(T168* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r168afd_check(T168* C);
T6 r168use_current(T168* C);
T0* r168runnable_args(T0* a1,T0* a2);
T0* r168to_runnable(T168* C,T0* a1);
T0* r168make_runnable(T168* C,T0* a1,T0* a2,T0* a3);
T0* r168start_position(T168* C);
void r320declaration_in(T320* C,T0* a1);
void r320undefine_in(T320* C,T0* a1);
T0* r320origin_base_class(T320* C);
T0* r320to_key(T320* C);
T0* r320to_string(T320* C);
void r320error(T0* a1,T0* a2);
T0* r320start_position(T320* C);
void r256compile_to_jvm0(T0* a1);
void r256warning(T0* a1,T0* a2);
T0* r256add_comment(T256* C,T0* a1);
void r256check_created_type(T256* C,T0* a1);
void r256afd_check(T256* C);
void r256check_writable(T256* C,T0* a1);
T6 r256use_current(T256* C);
T0* r256to_runnable(T256* C,T0* a1);
void r256compile_to_jvm(T256* C);
void r256error(T0* a1,T0* a2);
T0* r256run_args(T256* C);
void r256make(T256* C,T0* a1,T0* a2,T0* a3);
void r256fatal_error(T0* a1);
T2 r256arg_count(T256* C);
void r256check_creation_clause(T256* C,T0* a1);
T6 r256is_pre_computable(T256* C);
void r256cp_not_found(T256* C,T0* a1);
T2 r44jvm_argument_offset(T44* C,T0* a1);
void r44jvm_define(T44* C);
void r44fall_down(T44* C);
void r44compute_use_current(T44* C);
extern T0*oBC12exceptions_handler;
T0* r44clients(T44* C);
void r44std_compute_use_current(T44* C);
void r44method_info_start(T44* C);
T2 r44jvm_max_locals(T44* C);
T0* r44run_ensure(T44* C);
T2 r44jvm_result_offset(T44* C);
T6 r44empty_or_null_body(T44* C);
void r44make(T44* C,T0* a1,T0* a2,T0* a3);
T6 r44dca(T44* C);
void r44routine_mapping_jvm(T44* C);
T0* r44memory_dispose(T44* C);
void r44initialize(T44* C);
T0* r44jvm_descriptor(T44* C);
void r44routine_afd_check(T44* C);
T0* r44body_one_dpca(T44* C);
T6 r44one_pc(T44* C);
T6 r44do_not_use_current(T44* C);
T0* r44run_require(T44* C);
T6 r44isa_in_line(T44* C);
T6 r44use_current(T44* C);
void r44jvm_define_opening(T44* C);
void r44jvm_define_closing(T44* C);
T6 r44is_empty_or_null_body(T44* C);
void r44routine_update_tmp_jvm_descriptor(T44* C);
T6 r44is_exported_in(T44* C,T0* a1);
T2 r44jvm_local_variable_offset(T44* C,T0* a1);
T0* r44run_class(T44* C);
T6 r44attribute_writer(T44* C);
T6 r44direct_call(T44* C);
T6 r44is_pre_computable(T44* C);
void r91make(T91* C,T0* a1,T0* a2);
void r91fatal_error(T0* a1);
T6 r319is_merge_with(T319* C,T0* a1,T0* a2);
T6 r319is_merge_with2aux(T319* C,T0* a1,T0* a2);
T0* r319try_to_undefine_aux(T319* C,T0* a1,T0* a2);
T0* r319try_to_undefine(T319* C,T0* a1,T0* a2);
void r319check_obsolete(T319* C,T0* a1);
T6 r319is_merge_with1(T319* C,T0* a1);
T6 r319is_merge_with2(T319* C,T0* a1,T0* a2);
T0* r319to_run_feature(T319* C,T0* a1,T0* a2);
void r319error(T0* a1,T0* a2);
void r319make(T319* C,T0* a1,T0* a2);
void r319add_into(T319* C,T0* a1);
T6 r319can_hide(T319* C,T0* a1,T0* a2);
void r319merge_header_comments(T319* C,T0* a1);
T0* r319start_position(T319* C);
T6 r295is_merge_with(T295* C,T0* a1,T0* a2);
T6 r295is_merge_with2aux(T295* C,T0* a1,T0* a2);
T0* r295try_to_undefine_aux(T295* C,T0* a1,T0* a2);
T0* r295try_to_undefine(T295* C,T0* a1,T0* a2);
void r295check_obsolete(T295* C,T0* a1);
T6 r295use_current(T295* C);
T6 r295is_merge_with1(T295* C,T0* a1);
T6 r295is_merge_with2(T295* C,T0* a1,T0* a2);
T0* r295to_run_feature(T295* C,T0* a1,T0* a2);
void r295error(T0* a1,T0* a2);
void r295set_header_comment(T295* C,T0* a1);
void r295set_rescue_compound(T295* C,T0* a1);
void r295make_routine(T295* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r295make(T295* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r295make_external_routine(T295* C,T0* a1,T0* a2);
void r295add_into(T295* C,T0* a1);
T6 r295can_hide(T295* C,T0* a1,T0* a2);
void r295merge_header_comments(T295* C,T0* a1);
T0* r295start_position(T295* C);
T0* r160add_comment(T160* C,T0* a1);
T2 r160compile_to_jvm_into(T0* a1);
T2 r160to_integer(T160* C);
void r160error(T0* a1,T0* a2);
extern int fBC160result_type;
extern T0*oBC160result_type;
T0* r160result_type(void);
T2 r391jvm_argument_offset(T391* C,T0* a1);
void r391jvm_define(T391* C);
void r391fall_down(T391* C);
T0* r391body_one_result_dca(T391* C);
void r391compute_use_current(T391* C);
T0* r391clients(T391* C);
T6 r391can_be_dropped(T391* C);
void r391std_compute_use_current(T391* C);
void r391method_info_start(T391* C);
T6 r391a_eq_neq(T391* C);
T2 r391jvm_max_locals(T391* C);
T0* r391run_ensure(T391* C);
T2 r391jvm_result_offset(T391* C);
T6 r391empty_or_null_body(T391* C);
T6 r391dca(T391* C);
void r391make(T391* C,T0* a1,T0* a2,T0* a3);
void r391routine_mapping_jvm(T391* C);
void r391initialize(T391* C);
T0* r391jvm_descriptor(T391* C);
void r391routine_afd_check(T391* C);
T6 r391dc_pco1(T391* C);
T0* r391body_one_result(T391* C);
T0* r391body_one_dc_pco(T391* C);
T6 r391direct_cse_call(T391* C);
T0* r391run_require(T391* C);
T6 r391dc_pco2(T391* C);
T6 r391isa_in_line(T391* C);
T6 r391use_current(T391* C);
void r391jvm_define_opening(T391* C);
void r391jvm_define_closing(T391* C);
T6 r391value_reader(T391* C);
T6 r391is_static(T391* C);
void r391routine_update_tmp_jvm_descriptor(T391* C);
T6 r391is_exported_in(T391* C,T0* a1);
T2 r391jvm_local_variable_offset(T391* C,T0* a1);
T0* r391run_class(T391* C);
void r391fatal_error(T0* a1);
T6 r391attribute_reader(T391* C);
T6 r391result_is_current(T391* C);
T6 r391direct_call(T391* C);
void r391jvm_result_store(T391* C);
void r258compile_to_jvm0(T0* a1);
void r258warning(T0* a1,T0* a2);
T0* r258add_comment(T258* C,T0* a1);
void r258check_created_type(T258* C,T0* a1);
void r258afd_check(T258* C);
void r258check_writable(T258* C,T0* a1);
T6 r258use_current(T258* C);
T0* r258to_runnable(T258* C,T0* a1);
void r258compile_to_jvm(T258* C);
void r258check_explicit_type(T258* C);
void r258error(T0* a1,T0* a2);
T0* r258run_args(T258* C);
void r258make(T258* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r258fatal_error(T0* a1);
T2 r258arg_count(T258* C);
void r258check_creation_clause(T258* C,T0* a1);
T6 r258is_pre_computable(T258* C);
void r258cp_not_found(T258* C,T0* a1);
void r181prepare_arguments(T181* C,T0* a1);
void r181make(T181* C,T0* a1,T0* a2,T0* a3);
void r181fatal_error(T0* a1);
T0* r181precursor_name(T0* a1,T0* a2);
T0* r181add_comment(T181* C,T0* a1);
T0* r181super_feature(T181* C,T0* a1);
void r181afd_check(T181* C);
T0* r181to_runnable(T181* C,T0* a1);
void r181compile_to_jvm(T181* C);
void r181error(T0* a1,T0* a2);
void r103make(T103* C,T0* a1,T0* a2);
T0* r103merge_with(T103* C,T0* a1);
void r103merge(T103* C,T0* a1,T0* a2,T0* a3);
T6 r103gives_permission_to_any(T103* C);
T6 r103gives_permission_to(T103* C,T0* a1);
T0* r103append(T103* C,T0* a1);
void r103vape_check(T103* C,T0* a1,T0* a2);
void r103gives_permission_error(T103* C,T6 a1,T0* a2);
T0* r171add_comment(T171* C,T0* a1);
void r171error(T0* a1,T0* a2);
T0* r171type_boolean(void);
T0* r171static_result_base_class(void);
T2 r171standard_compile_to_jvm_into(T0* a1);
T2 r171compile_to_jvm_into(T0* a1);
T2 r171isa_dca_inline_argument(void);
T2 r171jvm_branch_if_false(void);
void r140standard_compile_target_to_jvm(T140* C);
void r140compile_to_jvm_old(T140* C);
T6 r140call_is_static(T140* C);
T0* r140runnable_expression(T0* a1,T0* a2);
void r140run_feature_has_result(T140* C);
void r140run_feature_match(T140* C,T0* a1);
T0* r140add_comment(T140* C,T0* a1);
void r140with(T140* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r140afd_check(T140* C);
T6 r140use_current(T140* C);
T0* r140runnable_args(T0* a1,T0* a2);
T0* r140to_runnable(T140* C,T0* a1);
T2 r140to_integer(T140* C);
void r140error(T0* a1,T0* a2);
T0* r140result_type(T140* C);
T2 r140jvm_standard_branch_if_false(T140* C);
T0* r140run_feature_for(T140* C,T0* a1,T0* a2);
T0* r140static_result_base_class(T140* C);
void r140make(T140* C,T0* a1,T0* a2,T0* a3);
void r140fatal_error(T0* a1);
T2 r140standard_compile_to_jvm_into(T140* C,T0* a1);
void r140assertion_check(T140* C,T3 a1);
T2 r140compile_to_jvm_into(T140* C,T0* a1);
T2 r140jvm_standard_branch_if_true(T140* C);
T6 r308is_merge_with(T308* C,T0* a1,T0* a2);
T6 r308is_merge_with2aux(T308* C,T0* a1,T0* a2);
T0* r308try_to_undefine_aux(T308* C,T0* a1,T0* a2);
T0* r308try_to_undefine(T308* C,T0* a1,T0* a2);
void r308check_obsolete(T308* C,T0* a1);
T6 r308is_merge_with1(T308* C,T0* a1);
T6 r308is_merge_with2(T308* C,T0* a1,T0* a2);
T0* r308to_run_feature(T308* C,T0* a1,T0* a2);
void r308error(T0* a1,T0* a2);
void r308set_header_comment(T308* C,T0* a1);
void r308make_routine(T308* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r308make(T308* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r308add_into(T308* C,T0* a1);
T6 r308can_hide(T308* C,T0* a1,T0* a2);
void r308merge_header_comments(T308* C,T0* a1);
void r308make_effective_routine(T308* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
T0* r308start_position(T308* C);
void r149standard_compile_target_to_jvm(T149* C);
void r149compile_to_jvm_old(T149* C);
T0* r149add_comment(T149* C,T0* a1);
void r149afd_check(T149* C);
T6 r149use_current(T149* C);
T0* r149to_runnable(T149* C,T0* a1);
T2 r149to_integer(T149* C);
void r149compile_to_jvm(T149* C);
void r149error(T0* a1,T0* a2);
T0* r149result_type(T149* C);
T2 r149jvm_standard_branch_if_false(T149* C);
T0* r149static_result_base_class(T149* C);
T2 r149standard_compile_to_jvm_into(T149* C,T0* a1);
void r149assertion_check(T149* C,T3 a1);
T2 r149compile_to_jvm_into(T149* C,T0* a1);
T2 r149jvm_standard_branch_if_true(T149* C);
extern T0*oBC149vaol_check_memory;
T0* r149start_position(T149* C);
T2 r230compile_to_jvm_resolve_branch(T230* C);
void r230make(T230* C,T0* a1,T0* a2);
void r230afd_check(T230* C);
T6 r230use_current(T230* C);
T0* r230to_runnable(T230* C,T0* a1);
T2 r230compile_to_jvm(T230* C);
void r230error(T0* a1,T0* a2);
T6 r209is_merge_with(T209* C,T0* a1,T0* a2);
T6 r209is_merge_with2aux(T209* C,T0* a1,T0* a2);
T0* r209try_to_undefine_aux(T209* C,T0* a1,T0* a2);
T0* r209try_to_undefine(T209* C,T0* a1,T0* a2);
void r209check_obsolete(T209* C,T0* a1);
T6 r209is_merge_with1(T209* C,T0* a1);
T6 r209is_merge_with2(T209* C,T0* a1,T0* a2);
T0* r209to_run_feature(T209* C,T0* a1,T0* a2);
void r209error(T0* a1,T0* a2);
void r209make(T209* C,T0* a1,T0* a2,T0* a3);
void r209add_into(T209* C,T0* a1);
T6 r209can_hide(T209* C,T0* a1,T0* a2);
void r209merge_header_comments(T209* C,T0* a1);
T0* r209start_position(T209* C);
void r89fatal_error(T0* a1);
T0* r89name_in_child(T89* C,T0* a1);
T0* r89name_in_parent(T89* C,T0* a1);
void r89get_started(T89* C,T0* a1);
T0* r82first_parent_for(T82* C,T0* a1);
T0* r82going_up(T82* C,T0* a1,T0* a2,T0* a3);
void r82inherit_cycle_check(T82* C);
T6 r82has_redefine(T82* C,T0* a1);
T0* r82repeated_inheritance(T82* C,T0* a1,T0* a2,T0* a3);
T0* r82precursor_for(T82* C,T0* a1,T0* a2);
void r82make(T82* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r82fatal_error(T0* a1);
T0* r82smallest_ancestor(T82* C,T0* a1,T0* a2);
T6 r82has_parent(T82* C,T0* a1);
T6 r82is_a_vncg(T82* C,T0* a1,T0* a2);
void r82collect_assertion(T82* C,T0* a1);
void r82collect_invariant(T82* C,T0* a1);
T0* r82clients_for(T82* C,T0* a1);
T0* r82look_up_for(T82* C,T0* a1,T0* a2);
T0* r82e_feature(T82* C,T0* a1);
void r82get_started(T82* C);
T0* r82up_to_original(T82* C,T0* a1,T0* a2);
T0* r82next_parent_for(T82* C,T0* a1,T0* a2);
T2 r349jvm_argument_offset(T349* C,T0* a1);
void r349jvm_define(T349* C);
T0* r349run_require(T349* C);
T6 r349use_current(T349* C);
void r349fall_down(T349* C);
void r349jvm_define_opening(T349* C);
void r349jvm_define_closing(T349* C);
void r349routine_update_tmp_jvm_descriptor(T349* C);
T6 r349is_exported_in(T349* C,T0* a1);
T2 r349jvm_local_variable_offset(T349* C,T0* a1);
T0* r349clients(T349* C);
void r349std_compute_use_current(T349* C);
void r349method_info_start(T349* C);
T2 r349jvm_max_locals(T349* C);
T0* r349run_ensure(T349* C);
T2 r349jvm_result_offset(T349* C);
T0* r349run_class(T349* C);
void r349make(T349* C,T0* a1,T0* a2,T0* a3);
void r349routine_mapping_jvm(T349* C);
void r349initialize(T349* C);
T0* r349jvm_descriptor(T349* C);
void r349routine_afd_check(T349* C);
void r156standard_compile_target_to_jvm(T156* C);
void r156compile_to_jvm_old(T156* C);
T0* r156runnable_expression(T0* a1,T0* a2);
void r156run_feature_has_result(T156* C);
T2 r156static_value(T156* C);
void r156run_feature_match(T156* C,T0* a1);
T0* r156add_comment(T156* C,T0* a1);
void r156with(T156* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r156afd_check(T156* C);
T6 r156use_current(T156* C);
T0* r156runnable_args(T0* a1,T0* a2);
T0* r156to_runnable(T156* C,T0* a1);
T2 r156to_integer(T156* C);
T6 r156is_static(T156* C);
void r156error(T0* a1,T0* a2);
T0* r156result_type(T156* C);
T2 r156jvm_standard_branch_if_false(T156* C);
T0* r156run_feature_for(T156* C,T0* a1,T0* a2);
T0* r156static_result_base_class(T156* C);
void r156make(T156* C,T0* a1,T0* a2,T0* a3);
void r156fatal_error(T0* a1);
T2 r156standard_compile_to_jvm_into(T156* C,T0* a1);
void r156assertion_check(T156* C,T3 a1);
T2 r156compile_to_jvm_into(T156* C,T0* a1);
T2 r156jvm_standard_branch_if_true(T156* C);
T0* r156start_position(T156* C);
void r104make(T104* C);
T2 r104max_id(T104* C);
void r104add2(T104* C,T0* a1,T2 a2);
T2 r104hash_code(T0* a1);
T2 r104item(T104* C,T0* a1);
void r142standard_compile_target_to_jvm(T142* C);
void r142compile_to_jvm_old(T142* C);
T0* r142runnable_expression(T0* a1,T0* a2);
void r142run_feature_has_result(T142* C);
T2 r142static_value(T142* C);
void r142run_feature_match(T142* C);
T0* r142add_comment(T142* C,T0* a1);
void r142with(T142* C,T0* a1,T0* a2,T0* a3);
void r142afd_check(T142* C);
T6 r142use_current(T142* C);
T0* r142to_runnable(T142* C,T0* a1);
T2 r142to_integer(T142* C);
T6 r142is_static(T142* C);
void r142error(T0* a1,T0* a2);
T0* r142result_type(T142* C);
T6 r142can_be_dropped(T142* C);
T2 r142jvm_standard_branch_if_false(T142* C);
T0* r142run_feature_for(T142* C,T0* a1,T0* a2);
T0* r142static_result_base_class(T142* C);
void r142make(T142* C,T0* a1,T0* a2);
void r142fatal_error(T0* a1);
T2 r142standard_compile_to_jvm_into(T142* C,T0* a1);
void r142assertion_check(T142* C,T3 a1);
T2 r142compile_to_jvm_into(T142* C,T0* a1);
T2 r142jvm_standard_branch_if_true(T142* C);
T6 r65is_equal(T65* C,T0* a1);
void r65make(T65* C,T2 a1,T2 a2);
void r65fatal_error(T0* a1);
void r65set_line_column(T65* C,T2 a1,T2 a2);
void r65with(T65* C,T2 a1,T2 a2,T0* a3);
T0* r65base_class(T65* C);
void r65show(T65* C);
T6 r65before(T65* C,T0* a1);
T0* r65path(T65* C);
T0* r65get_line(T65* C);
void r283make(T283* C,T0* a1,T0* a2);
void r283fatal_error(T0* a1);
void r283check_generic_formal_arguments(T283* C);
void r237add_when_item_2(T237* C,T0* a1);
void r237add_value(T237* C,T0* a1);
T0* r237to_runnable_integer(T237* C,T0* a1);
void r237make(T237* C,T0* a1,T0* a2);
extern T0*oBC237points1;
void r237from_e_when(T237* C,T0* a1);
void r237afd_check(T237* C);
void r237err_occ(T237* C,T2 a1,T0* a2);
T6 r237use_current(T237* C);
T0* r237to_runnable_character(T237* C,T0* a1);
void r237add_when_item_1(T237* C,T0* a1);
void r237compile_to_jvm(T237* C,T0* a1,T2 a2);
void r237add_slice(T237* C,T0* a1,T0* a2);
T6 r237includes_integer(T237* C,T2 a1);
void r237error(T0* a1,T0* a2);
void r267jvm_target_descriptor_in(T267* C,T0* a1);
T2 r267id(T267* C);
T0* r267base_class(T267* C);
T0* r267look_up_for(T267* C,T0* a1,T0* a2);
void r267jvm_descriptor_in(T267* C,T0* a1);
T6 r267is_a_in(T267* C,T0* a1,T0* a2);
T6 r267is_native_array(T267* C);
T6 r267is_a(T267* C,T0* a1);
void r267make(T267* C,T0* a1,T0* a2);
T6 r267of_references(T267* C);
T2 r267jvm_stack_space(void);
void r267load_basic_features(T267* C);
T6 r267is_run_type(T267* C);
T0* r267type_any(void);
T0* r267smallest_ancestor(T267* C,T0* a1);
T0* r267string_aliaser(void);
T0* r267to_runnable(T267* C,T0* a1);
void r267make_runnable(T267* C,T0* a1,T0* a2);
T0* r267twin(T267* C);
T0* r267run_time_mark(T267* C);
T0* r267run_class(T267* C);
void r267jvm_xnewarray(T267* C);
void r267fatal_error(T0* a1);
T2 r267jvm_push_default(void);
T2 r267jvm_convert_to(T0* a1);
T2 r267jvm_expanded_from_reference(T0* a1);
void r158standard_compile_target_to_jvm(T158* C);
T0* r158add_comment(T158* C,T0* a1);
T0* r158to_runnable(T158* C,T0* a1);
T2 r158to_integer(T158* C);
void r158error(T0* a1,T0* a2);
T0* r158static_result_base_class(void);
T2 r158standard_compile_to_jvm_into(T158* C,T0* a1);
T2 r158compile_to_jvm_into(T158* C,T0* a1);
T2 r158jvm_branch_if_true(T158* C);
T2 r158jvm_branch_if_false(T158* C);
void r325add_last(T325* C,T0* a1);
T2 r348jvm_argument_offset(T348* C,T0* a1);
void r348jvm_define(T348* C);
void r348fall_down(T348* C);
extern T0*oBC348frozen_general;
T0* r348clients(T348* C);
void r348std_compute_use_current(T348* C);
void r348method_info_start(T348* C);
T2 r348jvm_max_locals(T348* C);
T0* r348run_ensure(T348* C);
T2 r348jvm_result_offset(T348* C);
void r348make(T348* C,T0* a1,T0* a2,T0* a3);
void r348routine_mapping_jvm(T348* C);
void r348initialize(T348* C);
T0* r348jvm_descriptor(T348* C);
void r348routine_afd_check(T348* C);
T0* r348run_require(T348* C);
T6 r348use_current(T348* C);
void r348jvm_define_closing(T348* C);
void r348jvm_define_opening(T348* C);
void r348routine_update_tmp_jvm_descriptor(T348* C);
T6 r348is_exported_in(T348* C,T0* a1);
T2 r348jvm_local_variable_offset(T348* C,T0* a1);
void r348jvm_result_load(T348* C);
T0* r348run_class(T348* C);
void r348fatal_error(T0* a1);
void r348jvm_result_store(T348* C);
void r348fe_vffd7(T348* C);
T6 r348is_pre_computable(T348* C);
void r248make(T248* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T0* r248add_comment(T248* C,T0* a1);
void r248afd_check(T248* C);
T6 r248use_current(T248* C);
T0* r248to_runnable(T248* C,T0* a1);
void r248compile_to_jvm(T248* C);
void r248error(T0* a1,T0* a2);
T0* r83going_down(T83* C,T0* a1,T0* a2);
T0* r83runnable_type(T83* C,T0* a1);
T0* r83do_rename(T83* C,T0* a1);
T0* r83precursor_for(T83* C,T0* a1,T0* a2);
T0* r83consider_export(T83* C,T0* a1);
T0* r83apply_undefine(T83* C,T0* a1,T0* a2);
T6 r83is_a_vncg(T83* C,T0* a1,T0* a2);
T0* r83base_class(T83* C);
T0* r83look_up_for(T83* C,T0* a1,T0* a2);
void r83get_started(T83* C,T0* a1);
extern T0*oBC83forbidden_parent_list;
T0* r83up_to_original(T83* C,T0* a1,T0* a2);
void r83missing_select(T0* a1,T0* a2);
T0* r83going_up(T83* C,T0* a1,T0* a2,T0* a3);
T6 r83has_redefine(T83* C,T0* a1);
T0* r83get_new_name(T83* C,T0* a1);
void r83make(T83* C,T0* a1);
T0* r83get_old_name(T83* C,T0* a1);
void r83fatal_error(T0* a1);
void r83multiple_check(T83* C,T0* a1);
T6 r83has_select_for(T83* C,T0* a1);
T0* r83name_in_parent(T83* C,T0* a1);
T0* r83has_undefine(T83* C,T0* a1);
T0* r83clients_for(T83* C,T0* a1);
T0* r83e_feature(T83* C,T0* a1);
void r83select_conflict(T0* a1,T0* a2);
void r83add_rename(T83* C,T0* a1);
T0* r83start_position(T83* C);
T6 r214is_merge_with(T214* C,T0* a1,T0* a2);
T6 r214is_merge_with2aux(T214* C,T0* a1,T0* a2);
T0* r214try_to_undefine_aux(T214* C,T0* a1,T0* a2);
T0* r214try_to_undefine(T214* C,T0* a1,T0* a2);
void r214check_obsolete(T214* C,T0* a1);
T6 r214is_merge_with1(T214* C,T0* a1);
T6 r214is_merge_with2(T214* C,T0* a1,T0* a2);
T0* r214to_run_feature(T214* C,T0* a1,T0* a2);
void r214error(T0* a1,T0* a2);
void r214make(T214* C,T0* a1,T0* a2,T0* a3);
void r214add_into(T214* C,T0* a1);
T6 r214can_hide(T214* C,T0* a1,T0* a2);
void r214merge_header_comments(T214* C,T0* a1);
T0* r214start_position(T214* C);
void r179standard_compile_target_to_jvm(T179* C);
void r179compile_to_jvm_old(T179* C);
T0* r179add_comment(T179* C,T0* a1);
void r179afd_check(T179* C);
T0* r179to_runnable(T179* C,T0* a1);
T2 r179to_integer(T179* C);
void r179compile_to_jvm(T179* C);
void r179error(T0* a1,T0* a2);
void r179prepare_arguments(T179* C,T0* a1);
T0* r179static_result_base_class(T179* C);
void r179make(T179* C,T0* a1,T0* a2,T0* a3);
void r179fatal_error(T0* a1);
T0* r179precursor_name(T0* a1,T0* a2);
T2 r179standard_compile_to_jvm_into(T179* C,T0* a1);
T2 r179compile_to_jvm_into(T179* C,T0* a1);
T0* r179super_feature(T179* C,T0* a1);
T2 r179jvm_branch_if_true(T179* C);
T2 r179jvm_branch_if_false(T179* C);
void r323make(T323* C,T0* a1,T0* a2);
T0* r323clients_for(T323* C,T0* a1);
T2 r389jvm_argument_offset(T389* C,T0* a1);
void r389jvm_closing(T389* C);
void r389jvm_define(T389* C);
T0* r389run_require(T389* C);
T6 r389use_current(T389* C);
void r389jvm_define_opening(T389* C);
void r389jvm_define_closing(T389* C);
void r389fall_down(T389* C);
void r389compute_use_current(T389* C);
void r389mapping_jvm(T389* C);
void r389routine_update_tmp_jvm_descriptor(T389* C);
T6 r389is_exported_in(T389* C,T0* a1);
T2 r389jvm_local_variable_offset(T389* C,T0* a1);
T0* r389clients(T389* C);
void r389jvm_field_or_method(T389* C);
void r389std_compute_use_current(T389* C);
void r389method_info_start(T389* C);
T2 r389jvm_max_locals(T389* C);
T0* r389run_ensure(T389* C);
T2 r389jvm_result_offset(T389* C);
T0* r389run_class(T389* C);
void r389make(T389* C,T0* a1,T0* a2,T0* a3);
void r389routine_mapping_jvm(T389* C);
void r389initialize(T389* C);
void r389jvm_opening(T389* C);
T0* r389jvm_descriptor(T389* C);
void r389routine_afd_check(T389* C);
T6 r278is_written_runnable(T278* C);
T2 r278id(T278* C);
extern T0*oBC278tmp_mark;
T0* r278base_class(T278* C);
void r278jvm_descriptor_in(T278* C,T0* a1);
T0* r278look_up_for(T278* C,T0* a1,T0* a2);
T6 r278has_creation(T278* C,T0* a1);
void r278basic_checks(T278* C);
T6 r278is_a_in(T278* C,T0* a1,T0* a2);
T6 r278is_native_array(T278* C);
T6 r278is_a(T278* C,T0* a1);
void r278make(T278* C,T0* a1,T0* a2);
T0* r278run_type(T278* C);
void r278used_as_reference(T278* C);
T2 r278jvm_stack_space(void);
T6 r278is_reference(T278* C);
T0* r278jvm_root_class(void);
T6 r278is_user_expanded(T278* C);
T6 r278is_run_type(T278* C);
T0* r278type_any(void);
T0* r278smallest_ancestor(T278* C,T0* a1);
T0* r278string_aliaser(void);
T0* r278to_runnable(T278* C,T0* a1);
void r278make_runnable(T278* C,T0* a1,T0* a2);
T0* r278twin(T278* C);
void r278jvm_standard_is_equal(T278* C);
T0* r278run_time_mark(T278* C);
T0* r278run_class(T278* C);
void r278jvm_xnewarray(T278* C);
T6 r278is_dummy_expanded(T278* C);
void r278fatal_error(T0* a1);
T2 r278jvm_push_default(T278* C);
void r278standard_jvm_check_class_invariant(T278* C);
T6 r278is_expanded(T278* C);
T2 r278jvm_convert_to(T278* C,T0* a1);
T0* r278expanded_initializer(T278* C);
T2 r278jvm_expanded_from_reference(T0* a1);
T0* r278jvm_root_descriptor(void);
void r259jvm_target_descriptor_in(T259* C,T0* a1);
T0* r259generic_list(T259* C);
T2 r259jvm_method_flags(T259* C);
T2 r259id(T259* C);
T2 r259jvm_if_x_ne(T259* C);
void r259jvm_check_class_invariant(T259* C);
T0* r259base_class(T259* C);
T6 r259is_array(T259* C);
T0* r259look_up_for(T259* C,T0* a1,T0* a2);
void r259jvm_descriptor_in(T259* C,T0* a1);
T6 r259has_creation(T259* C,T0* a1);
T6 r259is_a_in(T259* C,T0* a1,T0* a2);
T6 r259is_native_array(T259* C);
T6 r259is_boolean(T259* C);
T6 r259is_a(T259* C,T0* a1);
void r259anchor_cycle_start(T259* C);
T6 r259is_generic(T259* C);
void r259jvm_xaload(T259* C);
void r259make(T259* C,T0* a1,T0* a2);
void r259jvm_return_code(T259* C);
void r259anchor_cycle_end(T259* C);
void r259used_as_reference(T259* C);
T2 r259jvm_stack_space(T259* C);
T6 r259is_reference(T259* C);
T6 r259is_real(T259* C);
T6 r259is_user_expanded(T259* C);
T6 r259is_integer(T259* C);
void r259fatal_error_generic_list(T259* C);
T6 r259is_any(T259* C);
T6 r259is_string(T259* C);
void r259jvm_xastore(T259* C);
T0* r259smallest_ancestor(T259* C,T0* a1);
T0* r259string_aliaser(void);
void r259with(T259* C,T0* a1,T0* a2);
T6 r259is_double(T259* C);
void r259jvm_write_local(T259* C,T2 a1);
T6 r259is_none(T259* C);
T0* r259to_runnable(T259* C,T0* a1);
T6 r259is_pointer(T259* C);
void r259jvm_standard_is_equal(T259* C);
T0* r259static_base_class_name(T259* C);
T0* r259run_time_mark(T259* C);
T0* r259run_class(T259* C);
void r259jvm_xnewarray(T259* C);
T6 r259is_dummy_expanded(T259* C);
void r259jvm_push_local(T259* C,T2 a1);
void r259fatal_error(T0* a1);
T2 r259jvm_push_default(T259* C);
T6 r259is_expanded(T259* C);
T2 r259jvm_convert_to(T259* C,T0* a1);
T2 r259jvm_if_x_eq(T259* C);
T0* r259expanded_initializer(T259* C);
T6 r259is_basic_eiffel_expanded(T259* C);
T6 r259is_character(T259* C);
T2 r259jvm_expanded_from_reference(T0* a1);
T0* r259base_class_name(T259* C);
extern T0*oBC260visited;
T6 r259is_bit(T259* C);
void r198standard_compile_target_to_jvm(T198* C);
void r198compile_to_jvm_old(T198* C);
T0* r198runnable_expression(T0* a1,T0* a2);
void r198run_feature_has_result(T198* C);
void r198run_feature_match(T198* C,T0* a1);
T0* r198add_comment(T198* C,T0* a1);
void r198with(T198* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r198afd_check(T198* C);
T0* r198operator(void);
T6 r198use_current(T198* C);
T0* r198runnable_args(T0* a1,T0* a2);
T0* r198to_runnable(T198* C,T0* a1);
T2 r198to_integer(T198* C);
T6 r198is_static(T198* C);
void r198error(T0* a1,T0* a2);
T0* r198result_type(T198* C);
T2 r198jvm_standard_branch_if_false(T198* C);
T0* r198run_feature_for(T198* C,T0* a1,T0* a2);
T0* r198static_result_base_class(T198* C);
void r198make(T198* C,T0* a1,T0* a2,T0* a3);
void r198fatal_error(T0* a1);
T2 r198standard_compile_to_jvm_into(T198* C,T0* a1);
void r198assertion_check(T198* C,T3 a1);
T2 r198compile_to_jvm_into(T198* C,T0* a1);
T2 r198jvm_standard_branch_if_true(T198* C);
T2 r371jvm_argument_offset(T371* C,T0* a1);
void r371jvm_define(T371* C);
T0* r371type_string(void);
void r371fall_down(T371* C);
void r371compute_use_current(T371* C);
T0* r371clients(T371* C);
void r371jvm_field_or_method(T371* C);
void r371std_compute_use_current(T371* C);
void r371method_info_start(T371* C);
T2 r371jvm_max_locals(T371* C);
T0* r371run_ensure(T371* C);
void r371jvm_closing_fast(T371* C);
T2 r371jvm_result_offset(T371* C);
void r371make(T371* C,T0* a1,T0* a2,T0* a3);
void r371routine_mapping_jvm(T371* C);
T2 r371arg_count(T371* C);
void r371initialize(T371* C);
T0* r371jvm_descriptor(T371* C);
void r371routine_afd_check(T371* C);
extern T0*oBC12cpp;
void r371jvm_closing(T371* C);
T2 r371integer_value(T371* C,T0* a1);
T0* r371run_require(T371* C);
T6 r371use_current(T371* C);
void r371jvm_define_opening(T371* C);
void r371jvm_define_closing(T371* C);
void r371mapping_jvm(T371* C);
void r371routine_update_tmp_jvm_descriptor(T371* C);
T6 r371is_static(T371* C);
T6 r371is_exported_in(T371* C,T0* a1);
T2 r371jvm_local_variable_offset(T371* C,T0* a1);
T0* r371run_class(T371* C);
void r371fatal_error(T0* a1);
void r371jvm_opening(T371* C);
void r371jvm_result_store(T371* C);
void r79check_expanded_with(T79* C,T0* a1);
T0* r79root_procedure_name(T79* C,T0* a1);
void r79make(T79* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r79fatal_error(T0* a1);
T0* r79expanded_initializer(T79* C,T0* a1);
T6 r79has(T79* C,T0* a1);
void r194standard_compile_target_to_jvm(T194* C);
T0* r194base_class_written(T194* C);
T0* r194add_comment(T194* C,T0* a1);
T0* r194to_runnable(T194* C,T0* a1);
T2 r194to_integer(T194* C);
void r194compile_to_jvm(T194* C);
T0* r194twin(T194* C);
void r194error(T0* a1,T0* a2);
T0* r194static_result_base_class(T194* C);
void r194make(T194* C,T0* a1,T0* a2);
T2 r194standard_compile_to_jvm_into(T194* C,T0* a1);
void r194name_clash_for(T194* C,T0* a1,T0* a2);
T2 r194compile_to_jvm_into(T194* C,T0* a1);
T2 r194jvm_branch_if_true(T194* C);
T2 r194jvm_branch_if_false(T194* C);
T0* r194written_in(T194* C);
void r223make(T223* C,T0* a1,T0* a2,T0* a3);
void r223afd_check(T223* C);
T6 r223use_current(T223* C);
T0* r223to_runnable(T223* C,T0* a1);
void r223compile_to_jvm(T223* C,T6 a1);
T0* r223twin(T223* C);
T6 r223is_pre_computable(T223* C);
T2 r357jvm_argument_offset(T357* C,T0* a1);
T0* r357run_require(T357* C);
void r357afd_check(T357* C);
T6 r357use_current(T357* C);
void r357fall_down(T357* C);
void r357routine_update_tmp_jvm_descriptor(T357* C);
T6 r357is_exported_in(T357* C,T0* a1);
T2 r357jvm_local_variable_offset(T357* C,T0* a1);
T0* r357clients(T357* C);
T2 r357jvm_max_locals(T357* C);
T0* r357run_ensure(T357* C);
T6 r357is_deferred(T357* C);
T2 r357jvm_result_offset(T357* C);
T0* r357run_class(T357* C);
void r357make(T357* C,T0* a1,T0* a2,T0* a3);
void r357initialize(T357* C);
T0* r357jvm_descriptor(T357* C);
void r357routine_afd_check(T357* C);
T0* r357start_position(T357* C);
void r361falling_down(T361* C,T0* a1);
void r229make(T229* C,T0* a1,T0* a2);
T0* r229add_comment(T229* C,T0* a1);
void r229afd_check(T229* C);
T6 r229use_current(T229* C);
T0* r229to_runnable(T229* C,T0* a1);
void r229compile_to_jvm(T229* C);
T6 r229is_pre_computable(T229* C);
void r229error(T0* a1,T0* a2);
T0* r229start_position(T229* C);
void r55append_u2(T0* a1,T2 a2);
extern T0*oBC55handler_pc;
extern T0*oBC55from_pc;
extern T0*oBC55type_idx;
void r55store_in(T0* a1);
extern T0*oBC55to_pc;
void r390fatal_error(T0* a1);
void r390set_output_name(T390* C,T0* a1);
void r152compile_to_jvm_old(T152* C);
void r152match_with(T152* C,T0* a1,T0* a2);
void r152make_n(T152* C,T0* a1,T0* a2);
T0* r152run_class(T152* C);
T6 r152is_like_argument(T152* C,T0* a1,T0* a2,T0* a3);
void r152assertion_check(T152* C,T3 a1);
void r152afd_check(T152* C);
T2 r152compile_to_jvm_ith(T152* C,T0* a1,T2 a2);
T6 r152use_current(T152* C);
T0* r152to_runnable(T152* C,T0* a1);
T0* r152expression(T152* C,T2 a1);
T2 r152compile_to_jvm(T152* C,T0* a1);
T6 r152is_static(T152* C);
void r152put(T152* C,T0* a1,T2 a2);
T2 r152count(T152* C);
void r152from_model(T152* C,T0* a1);
extern T0*oBC152isa_dca_inline_memory;
T6 r152is_pre_computable(T152* C);
void r152error(T0* a1,T0* a2);
T6 r152isa_dca_inline(T152* C,T0* a1,T0* a2);
T0* r152start_position(T152* C);
void r147standard_compile_target_to_jvm(T147* C);
void r147compile_to_jvm_old(T147* C);
T0* r147runnable_expression(T0* a1,T0* a2);
void r147run_feature_has_result(T147* C);
T2 r147static_value(T147* C);
void r147run_feature_match(T147* C);
T0* r147add_comment(T147* C,T0* a1);
void r147with(T147* C,T0* a1,T0* a2,T0* a3);
void r147afd_check(T147* C);
T0* r147operator(void);
T6 r147use_current(T147* C);
T0* r147to_runnable(T147* C,T0* a1);
T2 r147to_integer(T147* C);
T6 r147is_static(T147* C);
void r147error(T0* a1,T0* a2);
T0* r147result_type(T147* C);
T6 r147can_be_dropped(T147* C);
T2 r147jvm_standard_branch_if_false(T147* C);
T0* r147run_feature_for(T147* C,T0* a1,T0* a2);
T0* r147static_result_base_class(T147* C);
void r147make(T147* C,T0* a1,T0* a2);
void r147fatal_error(T0* a1);
T2 r147standard_compile_to_jvm_into(T147* C,T0* a1);
void r147assertion_check(T147* C,T3 a1);
T2 r147compile_to_jvm_into(T147* C,T0* a1);
T2 r147jvm_standard_branch_if_true(T147* C);
T2 r147isa_dca_inline_argument(T147* C);
void r139standard_compile_target_to_jvm(T139* C);
void r139compile_to_jvm_old(T139* C);
T0* r139runnable_expression(T0* a1,T0* a2);
void r139run_feature_has_result(T139* C);
void r139run_feature_match(T139* C,T0* a1);
T0* r139add_comment(T139* C,T0* a1);
void r139with(T139* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r139afd_check(T139* C);
T0* r139operator(void);
T6 r139use_current(T139* C);
T0* r139runnable_args(T0* a1,T0* a2);
T0* r139to_runnable(T139* C,T0* a1);
T2 r139to_integer(T139* C);
T6 r139is_static(T139* C);
void r139error(T0* a1,T0* a2);
T0* r139result_type(T139* C);
T2 r139jvm_standard_branch_if_false(T139* C);
T0* r139run_feature_for(T139* C,T0* a1,T0* a2);
T0* r139static_result_base_class(T139* C);
void r139make(T139* C,T0* a1,T0* a2,T0* a3);
void r139fatal_error(T0* a1);
T2 r139standard_compile_to_jvm_into(T139* C,T0* a1);
void r139assertion_check(T139* C,T3 a1);
T2 r139compile_to_jvm_into(T139* C,T0* a1);
T2 r139jvm_standard_branch_if_true(T139* C);
void r134standard_compile_target_to_jvm(T134* C);
void r134compile_to_jvm_old(T134* C);
T0* r134runnable_expression(T0* a1,T0* a2);
void r134run_feature_has_result(T134* C);
void r134run_feature_match(T134* C,T0* a1);
T0* r134add_comment(T134* C,T0* a1);
void r134with(T134* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r134afd_check(T134* C);
T0* r134operator(void);
T6 r134use_current(T134* C);
T0* r134runnable_args(T0* a1,T0* a2);
T0* r134to_runnable(T134* C,T0* a1);
T2 r134to_integer(T134* C);
T6 r134is_static(T134* C);
void r134error(T0* a1,T0* a2);
T0* r134result_type(T134* C);
T2 r134jvm_standard_branch_if_false(T134* C);
T0* r134run_feature_for(T134* C,T0* a1,T0* a2);
T0* r134static_result_base_class(T134* C);
void r134make(T134* C,T0* a1,T0* a2,T0* a3);
void r134fatal_error(T0* a1);
T2 r134standard_compile_to_jvm_into(T134* C,T0* a1);
void r134assertion_check(T134* C,T3 a1);
T2 r134compile_to_jvm_into(T134* C,T0* a1);
T2 r134jvm_standard_branch_if_true(T134* C);
T2 r134isa_dca_inline_argument(T134* C);
T6 r210is_merge_with(T210* C,T0* a1,T0* a2);
T6 r210is_merge_with2aux(T210* C,T0* a1,T0* a2);
T0* r210try_to_undefine_aux(T210* C,T0* a1,T0* a2);
T0* r210try_to_undefine(T210* C,T0* a1,T0* a2);
void r210check_obsolete(T210* C,T0* a1);
T6 r210is_merge_with1(T210* C,T0* a1);
T6 r210is_merge_with2(T210* C,T0* a1,T0* a2);
T0* r210to_run_feature(T210* C,T0* a1,T0* a2);
void r210error(T0* a1,T0* a2);
void r210make(T210* C,T0* a1,T0* a2,T0* a3);
void r210add_into(T210* C,T0* a1);
T6 r210can_hide(T210* C,T0* a1,T0* a2);
void r210merge_header_comments(T210* C,T0* a1);
T0* r210start_position(T210* C);
void r131standard_compile_target_to_jvm(T131* C);
void r131compile_to_jvm_old(T131* C);
T0* r131runnable_expression(T0* a1,T0* a2);
T2 r131static_value(T131* C);
T2 r131static_neq_void(T0* a1);
void r131jvm_void_cmp(T0* a1);
void r131check_comparison(T131* C,T0* a1);
T0* r131add_comment(T131* C,T0* a1);
void r131with(T131* C,T0* a1,T0* a2,T0* a3);
void r131afd_check(T131* C);
T6 r131is_manifest_array(T0* a1);
T0* r131operator(void);
T6 r131use_current(T131* C);
T0* r131runnable_args(T0* a1,T0* a2);
T0* r131to_runnable(T131* C,T0* a1);
T2 r131to_integer(T131* C);
void r131bit_limitation(T131* C,T0* a1,T0* a2);
void r131compile_to_jvm(T131* C);
T6 r131is_static(T131* C);
void r131error(T0* a1,T0* a2);
T0* r131type_boolean(void);
T2 r131jvm_standard_branch_if_false(T131* C);
T0* r131static_result_base_class(void);
void r131make(T131* C,T0* a1,T0* a2,T0* a3);
void r131fatal_error(T0* a1);
void r131jvm_standard_is_neq_aux(T0* a1,T0* a2);
T2 r131standard_compile_to_jvm_into(T131* C,T0* a1);
void r131assertion_check(T131* C,T3 a1);
T2 r131compile_to_jvm_into(T131* C,T0* a1);
void r131error_comparison(T131* C,T0* a1,T0* a2);
T2 r131jvm_standard_branch_if_true(T131* C);
T6 r131is_static_neq_void(T0* a1);
T0* r354generic_list(T354* C);
T0* r354base_class(T354* C);
T0* r354look_up_for(T354* C,T0* a1,T0* a2);
T2 r354jvm_item_field_idx(T354* C);
T6 r354is_a_in(T354* C,T0* a1,T0* a2);
T6 r354is_native_array(T354* C);
T6 r354is_a(T354* C,T0* a1);
T6 r354is_generic(T354* C);
void r354make(T354* C,T0* a1);
T2 r354jvm_stack_space(void);
T0* r354jvm_root_class(void);
T0* r354smallest_ancestor(T0* a1);
T0* r354string_aliaser(void);
void r354jvm_standard_is_equal(T354* C);
T0* r354static_base_class_name(T354* C);
void r354fatal_error(T0* a1);
T2 r354jvm_push_default(void);
void r354standard_jvm_check_class_invariant(T354* C);
T2 r354jvm_convert_to(T0* a1);
T2 r354jvm_expanded_from_reference(T0* a1);
T0* r354base_class_name(T354* C);
void r354jvm_prepare_item_field(T354* C);
T0* r354jvm_root_descriptor(void);
void r146standard_compile_target_to_jvm(T146* C);
void r146compile_to_jvm_old(T146* C);
T0* r146runnable_expression(T0* a1,T0* a2);
void r146run_feature_has_result(T146* C);
T2 r146static_value(T146* C);
void r146run_feature_match(T146* C);
T0* r146add_comment(T146* C,T0* a1);
void r146with(T146* C,T0* a1,T0* a2,T0* a3);
void r146afd_check(T146* C);
T0* r146operator(void);
T6 r146use_current(T146* C);
T0* r146to_runnable(T146* C,T0* a1);
T2 r146to_integer(T146* C);
T6 r146is_static(T146* C);
void r146error(T0* a1,T0* a2);
T0* r146result_type(T146* C);
T6 r146can_be_dropped(T146* C);
T2 r146jvm_standard_branch_if_false(T146* C);
T0* r146run_feature_for(T146* C,T0* a1,T0* a2);
T0* r146static_result_base_class(T146* C);
void r146make(T146* C,T0* a1,T0* a2);
void r146fatal_error(T0* a1);
T2 r146standard_compile_to_jvm_into(T146* C,T0* a1);
void r146assertion_check(T146* C,T3 a1);
T2 r146compile_to_jvm_into(T146* C,T0* a1);
T2 r146jvm_standard_branch_if_true(T146* C);
T2 r146isa_dca_inline_argument(T146* C);
T0* r373generic_list(T373* C);
T2 r373id(T373* C);
T0* r373base_class(T373* C);
T0* r373look_up_for(T373* C,T0* a1,T0* a2);
T6 r373is_a_in(T373* C,T0* a1,T0* a2);
T6 r373is_native_array(T373* C);
T6 r373is_a(T373* C,T0* a1);
void r373make(T373* C,T0* a1);
T2 r373jvm_stack_space(void);
T0* r373jvm_root_class(void);
void r373fatal_error_generic_list(T373* C);
T0* r373type_any(void);
T0* r373smallest_ancestor(T373* C,T0* a1);
T0* r373string_aliaser(void);
void r373jvm_standard_is_equal(T373* C);
T0* r373run_class(T373* C);
T2 r373jvm_push_default(void);
T2 r373jvm_convert_to(T373* C,T0* a1);
T2 r373jvm_expanded_from_reference(T0* a1);
extern int fBC373base_class_name;
extern T0*oBC373base_class_name;
T0* r373base_class_name(void);
T0* r373jvm_root_descriptor(void);
T0* r173add_comment(T173* C,T0* a1);
void r173error(T0* a1,T0* a2);
extern int fBC173result_type;
extern T0*oBC173result_type;
T0* r173result_type(void);
T0* r173static_result_base_class(void);
void r173make(T173* C,T0* a1,T3 a2,T2 a3);
T2 r173standard_compile_to_jvm_into(T173* C,T0* a1);
T2 r173compile_to_jvm_into(T173* C,T0* a1);
T2 r173isa_dca_inline_argument(void);
void r192standard_compile_target_to_jvm(T192* C);
void r192refer_to(T192* C,T0* a1,T0* a2,T2 a3);
T0* r192add_comment(T192* C,T0* a1);
void r192with(T192* C,T0* a1,T0* a2);
T0* r192to_runnable(T192* C,T0* a1);
T2 r192to_integer(T192* C);
void r192compile_to_jvm(T192* C);
T0* r192to_string(T192* C);
void r192error(T0* a1,T0* a2);
T0* r192result_type(T192* C);
T0* r192static_result_base_class(T192* C);
T2 r192standard_compile_to_jvm_into(T192* C,T0* a1);
T2 r192compile_to_jvm_into(T192* C,T0* a1);
T2 r192jvm_branch_if_true(T192* C);
T2 r192jvm_branch_if_false(T192* C);
T6 r307is_merge_with(T307* C,T0* a1,T0* a2);
T6 r307is_merge_with2aux(T307* C,T0* a1,T0* a2);
T0* r307try_to_undefine_aux(T307* C,T0* a1,T0* a2);
T0* r307try_to_undefine(T307* C,T0* a1,T0* a2);
void r307check_obsolete(T307* C,T0* a1);
T6 r307is_merge_with1(T307* C,T0* a1);
T6 r307is_merge_with2(T307* C,T0* a1,T0* a2);
void r307error(T0* a1,T0* a2);
T0* r307to_run_feature(T307* C,T0* a1,T0* a2);
void r307set_header_comment(T307* C,T0* a1);
void r307make_routine(T307* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r307make(T307* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r307add_into(T307* C,T0* a1);
T6 r307can_hide(T307* C,T0* a1,T0* a2);
void r307merge_header_comments(T307* C,T0* a1);
T0* r307start_position(T307* C);
T6 r217is_merge_with(T217* C,T0* a1,T0* a2);
T6 r217is_merge_with2aux(T217* C,T0* a1,T0* a2);
T0* r217try_to_undefine_aux(T217* C,T0* a1,T0* a2);
T0* r217try_to_undefine(T217* C,T0* a1,T0* a2);
void r217check_obsolete(T217* C,T0* a1);
T6 r217is_merge_with1(T217* C,T0* a1);
T6 r217is_merge_with2(T217* C,T0* a1,T0* a2);
T0* r217to_run_feature(T217* C,T0* a1,T0* a2);
void r217error(T0* a1,T0* a2);
void r217make(T217* C,T0* a1,T0* a2,T0* a3);
void r217add_into(T217* C,T0* a1);
T6 r217can_hide(T217* C,T0* a1,T0* a2);
void r217merge_header_comments(T217* C,T0* a1);
T0* r217start_position(T217* C);
void r135standard_compile_target_to_jvm(T135* C);
void r135compile_to_jvm_old(T135* C);
T0* r135runnable_expression(T0* a1,T0* a2);
void r135run_feature_has_result(T135* C);
void r135run_feature_match(T135* C,T0* a1);
T0* r135add_comment(T135* C,T0* a1);
void r135with(T135* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r135afd_check(T135* C);
T0* r135operator(void);
T6 r135use_current(T135* C);
T0* r135runnable_args(T0* a1,T0* a2);
T0* r135to_runnable(T135* C,T0* a1);
T2 r135to_integer(T135* C);
T6 r135is_static(T135* C);
void r135error(T0* a1,T0* a2);
T0* r135result_type(T135* C);
T2 r135jvm_standard_branch_if_false(T135* C);
T0* r135run_feature_for(T135* C,T0* a1,T0* a2);
T0* r135static_result_base_class(T135* C);
void r135make(T135* C,T0* a1,T0* a2,T0* a3);
void r135fatal_error(T0* a1);
T2 r135standard_compile_to_jvm_into(T135* C,T0* a1);
void r135assertion_check(T135* C,T3 a1);
T2 r135compile_to_jvm_into(T135* C,T0* a1);
T2 r135jvm_standard_branch_if_true(T135* C);
T2 r135isa_dca_inline_argument(T135* C);
T2 r380jvm_argument_offset(T380* C,T0* a1);
void r380jvm_define(T380* C);
T0* r380run_require(T380* C);
T6 r380use_current(T380* C);
void r380jvm_define_opening(T380* C);
void r380jvm_define_closing(T380* C);
void r380routine_update_tmp_jvm_descriptor(T380* C);
T6 r380is_exported_in(T380* C,T0* a1);
T2 r380jvm_local_variable_offset(T380* C,T0* a1);
T0* r380clients(T380* C);
void r380std_compute_use_current(T380* C);
void r380method_info_start(T380* C);
T2 r380jvm_max_locals(T380* C);
T0* r380run_ensure(T380* C);
T6 r380is_deferred(T380* C);
T2 r380jvm_result_offset(T380* C);
T0* r380run_class(T380* C);
void r380make(T380* C,T0* a1,T0* a2,T0* a3);
void r380routine_mapping_jvm(T380* C);
void r380initialize(T380* C);
T0* r380jvm_descriptor(T380* C);
void r380routine_afd_check(T380* C);
T0* r380start_position(T380* C);
void r231compile_to_jvm_resolve_branch(T231* C);
void r231afd_check(T231* C);
T6 r231use_current(T231* C);
T0* r231to_runnable(T231* C,T0* a1);
T2 r231compile_to_jvm(T231* C);
T6 r69is_subclass_of(T69* C,T0* a1);
void r69check_expanded_with(T69* C,T0* a1);
void r69inherit_cycle_check(T69* C);
T0* r69root_procedure_name(T69* C,T0* a1);
T0* r69super_e_feature(T69* C,T0* a1);
void r69set_parent_list(T69* C,T0* a1,T0* a2,T0* a3);
extern int fBC12class_any;
extern T0*oBC12class_any;
T0* r69class_any(void);
void r69add_index_clause(T69* C,T0* a1);
void r69set_invariant(T69* C,T0* a1,T0* a2,T0* a3);
void r69warning(T0* a1,T0* a2);
void r69collect_assertion(T69* C,T0* a1);
void r69set_obsolete_type_string(T69* C,T0* a1);
T0* r69look_up_for(T69* C,T0* a1,T0* a2);
T6 r69has_creation(T69* C,T0* a1);
T0* r69up_to_original(T69* C,T0* a1,T0* a2);
void r69error(T0* a1,T0* a2);
void r69add_creation_clause(T69* C,T0* a1);
T6 r69proper_has(T69* C,T0* a1);
T6 r69has_redefine(T69* C,T0* a1);
T0* r69run_ensure(T69* C,T0* a1);
void r69make(T69* C);
void r69vdrd6(T0* a1,T0* a2,T0* a3);
T0* r69new_name_of_original(T69* C,T0* a1,T0* a2);
extern int fBC69mem_fn;
extern T0*oBC69mem_fn;
T0* r69mem_fn(void);
void r69check_generic_formal_arguments(T69* C);
void r69set_is_expanded(T69* C);
void r69set_is_deferred(T69* C);
void r69add_feature_clause(T69* C,T0* a1);
T0* r69new_name_of(T69* C,T0* a1,T0* a2);
T6 r69has(T69* C,T0* a1);
T0* r69root_procedure(T69* C,T0* a1);
T6 r69is_any(T69* C);
void r69fatal_undefine(T69* C,T0* a1);
T0* r69type_any(void);
T0* r69super_look_up_for(T69* C,T0* a1,T0* a2);
T0* r69smallest_ancestor(T69* C,T0* a1,T0* a2);
T0* r69run_require(T69* C,T0* a1);
T0* r69string_aliaser(void);
T6 r69is_a_vncg(T69* C,T0* a1,T0* a2);
void r69collect_invariant(T69* C,T0* a1);
T6 r69is_general(T69* C);
T6 r69has_simple_feature_name(T69* C,T0* a1);
void r69fatal_error_vdrd6(T0* a1,T0* a2,T0* a3);
void r69get_started(T69* C);
T0* r69going_up(T69* C,T0* a1,T0* a2,T0* a3);
T0* r69run_class(T69* C);
T0* r69run_feature_for(T69* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r69fatal_error(T0* a1);
T0* r69get_copy(T69* C);
T0* r69expanded_initializer(T69* C,T0* a1);
T6 r69is_subclass_of_aux(T69* C,T0* a1);
T0* r69clients_for(T69* C,T0* a1);
T0* r69e_feature(T69* C,T0* a1);
extern T0*oBC69going_up_trace;
extern T0*oBC69visited;
T0* r69id_provider(void);
T0* r69class_with(T0* a1);
T6 r311is_merge_with(T311* C,T0* a1,T0* a2);
T6 r311is_merge_with2aux(T311* C,T0* a1,T0* a2);
T0* r311try_to_undefine_aux(T311* C,T0* a1,T0* a2);
T0* r311try_to_undefine(T311* C,T0* a1,T0* a2);
void r311check_obsolete(T311* C,T0* a1);
T6 r311is_merge_with1(T311* C,T0* a1);
T6 r311is_merge_with2(T311* C,T0* a1,T0* a2);
T0* r311to_run_feature(T311* C,T0* a1,T0* a2);
void r311error(T0* a1,T0* a2);
void r311set_header_comment(T311* C,T0* a1);
void r311make_routine(T311* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r311make(T311* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r311add_into(T311* C,T0* a1);
T6 r311can_hide(T311* C,T0* a1,T0* a2);
void r311merge_header_comments(T311* C,T0* a1);
void r311make_effective_routine(T311* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
T0* r311start_position(T311* C);
T0* r264generic_list(T264* C);
T2 r264id(T264* C);
T0* r264base_class(T264* C);
T0* r264look_up_for(T264* C,T0* a1,T0* a2);
T6 r264has_creation(T264* C,T0* a1);
void r264error(T0* a1,T0* a2);
T6 r264is_a_in(T264* C,T0* a1,T0* a2);
T6 r264is_native_array(T264* C);
T6 r264is_a(T264* C,T0* a1);
void r264make(T264* C,T0* a1);
T2 r264jvm_stack_space(void);
T0* r264jvm_root_class(void);
void r264fatal_error_generic_list(T264* C);
extern int fBC264check_type;
void r264check_type(T264* C);
T0* r264to_runnable(T264* C,T0* a1);
void r264jvm_standard_is_equal(T264* C);
T0* r264run_time_mark(void);
T0* r264run_class(T264* C);
T2 r264jvm_push_default(void);
T2 r264jvm_convert_to(T264* C,T0* a1);
T0* r264written_mark(void);
T2 r264jvm_expanded_from_reference(T0* a1);
T0* r264jvm_root_descriptor(void);
void r280jvm_to_reference(T280* C);
T0* r280generic_list(T280* C);
T2 r280id(T280* C);
extern T0*oBC281mem_type_bit_ref;
T2 r280jvm_if_x_ne(void);
T0* r280base_class(T280* C);
T0* r280look_up_for(T280* C,T0* a1,T0* a2);
extern T0*oBC281mem_ref_nb;
T6 r280is_a_in(T280* C,T0* a1,T0* a2);
T6 r280is_native_array(T280* C);
T6 r280is_a(T280* C,T0* a1);
void r280make(T280* C,T0* a1,T0* a2);
void r280used_as_reference(T280* C);
T2 r280jvm_stack_space(void);
void r280set_run_time_mark(T280* C);
void r280fatal_error_generic_list(T280* C);
T0* r280type_any(void);
T0* r280smallest_ancestor(T280* C,T0* a1);
T0* r280string_aliaser(void);
void r280jvm_write_local(T2 a1);
T0* r280to_runnable(T280* C,T0* a1);
void r280jvm_standard_is_equal(T280* C);
T0* r280run_class(T280* C);
T2 r280jvm_push_default(T280* C);
T2 r280jvm_convert_to(T280* C,T0* a1);
T2 r280jvm_if_x_eq(void);
void r280to_runnable_1_2(T280* C);
T2 r280jvm_expanded_from_reference(T0* a1);
extern int fBC281base_class_name;
extern T0*oBC281base_class_name;
T0* r280base_class_name(void);
T0* r287left_type(T287* C);
void r287make(T287* C,T0* a1,T0* a2);
void r287fatal_error(T0* a1);
void r287warning(T0* a1,T0* a2);
void r287implicit_conversion(T287* C);
T0* r287add_comment(T287* C,T0* a1);
void r287afd_check(T287* C);
T6 r287use_current(T287* C);
T0* r287right_type(T287* C);
T0* r287to_runnable(T287* C,T0* a1);
void r287compile_to_jvm(T287* C);
T6 r287is_pre_computable(T287* C);
T0* r287start_position(T287* C);
T0* r172add_comment(T172* C,T0* a1);
void r172error(T0* a1,T0* a2);
T0* r172type_boolean(void);
T0* r172static_result_base_class(void);
T2 r172standard_compile_to_jvm_into(T0* a1);
T2 r172compile_to_jvm_into(T0* a1);
T2 r172jvm_branch_if_true(void);
T2 r172isa_dca_inline_argument(void);
void r122standard_compile_target_to_jvm(T122* C);
void r122compile_to_jvm_old(T122* C);
T0* r122runnable_expression(T0* a1,T0* a2);
void r122run_feature_has_result(T122* C);
void r122run_feature_match(T122* C,T0* a1);
T0* r122add_comment(T122* C,T0* a1);
void r122with(T122* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r122afd_check(T122* C);
T0* r122operator(void);
T6 r122use_current(T122* C);
T0* r122runnable_args(T0* a1,T0* a2);
T0* r122to_runnable(T122* C,T0* a1);
T2 r122to_integer(T122* C);
T6 r122is_static(T122* C);
void r122error(T0* a1,T0* a2);
T0* r122result_type(T122* C);
T2 r122jvm_standard_branch_if_false(T122* C);
T0* r122run_feature_for(T122* C,T0* a1,T0* a2);
T0* r122static_result_base_class(T122* C);
void r122make(T122* C,T0* a1,T0* a2,T0* a3);
void r122fatal_error(T0* a1);
T2 r122standard_compile_to_jvm_into(T122* C,T0* a1);
void r122assertion_check(T122* C,T3 a1);
T2 r122compile_to_jvm_into(T122* C,T0* a1);
T2 r122jvm_standard_branch_if_true(T122* C);
void r87add_last(T87* C,T0* a1);
T0* r87root_procedure_name(T87* C,T0* a1);
void r87make_n(T87* C,T0* a1);
T0* r87feature_name(T87* C,T0* a1);
void r87fatal_error(T0* a1);
void r87fe_multiple(T0* a1,T0* a2);
T2 r87index_of(T87* C,T0* a1);
T2 r87count(T87* C);
T6 r87has(T87* C,T0* a1);
T0* r87item(T87* C,T2 a1);
void r224make(T224* C,T0* a1,T0* a2,T0* a3);
T0* r224add_comment(T224* C,T0* a1);
void r224afd_check(T224* C);
T6 r224use_current(T224* C);
T0* r224to_runnable(T224* C,T0* a1);
void r224compile_to_jvm(T224* C);
T0* r174type_string(void);
void r174add_ascii(T174* C,T3 a1);
T0* r174add_comment(T174* C,T0* a1);
T2 r174fieldref_idx(T174* C);
T0* r174to_runnable(T174* C,T0* a1);
T2 r174to_integer(T174* C);
void r174compile_to_jvm(T174* C);
T0* r174twin(T174* C);
void r174error(T0* a1,T0* a2);
void r174break_line(T174* C);
T0* r174static_result_base_class(void);
void r174make(T174* C,T0* a1);
T2 r174compile_to_jvm_into(T174* C,T0* a1);
void r174add_percent(T174* C,T3 a1);
void r174compile_target_to_jvm(T174* C);
void r197standard_compile_target_to_jvm(T197* C);
T0* r197add_comment(T197* C,T0* a1);
T0* r197to_runnable(T197* C,T0* a1);
T2 r197to_integer(T197* C);
void r197compile_to_jvm(T197* C);
void r197error(T0* a1,T0* a2);
T2 r197standard_compile_to_jvm_into(T197* C,T0* a1);
T2 r197compile_to_jvm_into(T197* C,T0* a1);
T2 r197jvm_branch_if_true(T197* C);
T2 r197jvm_branch_if_false(T197* C);
void r197compile_target_to_jvm(T197* C);
void r116standard_compile_target_to_jvm(T116* C);
void r116compile_to_jvm_old(T116* C);
T0* r116runnable_expression(T0* a1,T0* a2);
void r116run_feature_has_result(T116* C);
void r116run_feature_match(T116* C,T0* a1);
T0* r116add_comment(T116* C,T0* a1);
void r116with(T116* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r116afd_check(T116* C);
T0* r116operator(void);
T6 r116use_current(T116* C);
T0* r116runnable_args(T0* a1,T0* a2);
T0* r116to_runnable(T116* C,T0* a1);
T2 r116to_integer(T116* C);
T6 r116is_static(T116* C);
void r116error(T0* a1,T0* a2);
T0* r116result_type(T116* C);
T2 r116jvm_standard_branch_if_false(T116* C);
T0* r116run_feature_for(T116* C,T0* a1,T0* a2);
T0* r116static_result_base_class(T116* C);
void r116make(T116* C,T0* a1,T0* a2,T0* a3);
void r116fatal_error(T0* a1);
T2 r116standard_compile_to_jvm_into(T116* C,T0* a1);
void r116assertion_check(T116* C,T3 a1);
T2 r116compile_to_jvm_into(T116* C,T0* a1);
T2 r116jvm_standard_branch_if_true(T116* C);
void r199add_last(T199* C,T0* a1);
void r199warning(T0* a1,T0* a2);
void r199merge(T199* C,T0* a1,T0* a2);
T6 r199gives_permission_to_any(T199* C);
T2 r199index_of(T199* C,T0* a1);
T6 r199gives_permission_to(T199* C,T0* a1);
T2 r199count(T199* C);
T0* r199item(T199* C,T2 a1);
void r107make(T107* C,T0* a1,T0* a2,T0* a3);
void r107add_into(T107* C,T0* a1);
void r107afd_check(T107* C);
void r107compile_to_jvm(T107* C,T6 a1);
void r107make_runnable(T107* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r291make(T291* C,T0* a1,T0* a2,T0* a3);
void r291add_into(T291* C,T0* a1);
void r291afd_check(T291* C);
T6 r291use_current(T291* C);
void r291compile_to_jvm(T291* C,T6 a1);
void r291make_runnable(T291* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r282jvm_to_reference(T282* C);
T0* r282generic_list(T282* C);
T2 r282id(T282* C);
T2 r282jvm_if_x_ne(void);
T0* r282base_class(T282* C);
T0* r282look_up_for(T282* C,T0* a1,T0* a2);
T6 r282is_a_in(T282* C,T0* a1,T0* a2);
T6 r282is_native_array(T282* C);
T6 r282is_a(T282* C,T0* a1);
void r282make(T282* C,T0* a1,T0* a2);
void r282used_as_reference(T282* C);
T2 r282jvm_stack_space(void);
void r282set_run_time_mark(T282* C);
void r282fatal_error_generic_list(T282* C);
T0* r282type_any(void);
T0* r282smallest_ancestor(T282* C,T0* a1);
T0* r282string_aliaser(void);
void r282jvm_write_local(T2 a1);
T0* r282to_runnable(T282* C,T0* a1);
void r282jvm_standard_is_equal(T282* C);
T0* r282run_class(T282* C);
void r282fatal_error(T0* a1);
T2 r282jvm_push_default(T282* C);
T2 r282jvm_convert_to(T282* C,T0* a1);
T2 r282jvm_if_x_eq(void);
void r282to_runnable_1_2(T282* C);
T2 r282jvm_expanded_from_reference(T0* a1);
T0* r282base_class_name(void);
void r250make(T250* C,T0* a1,T0* a2);
void r250afd_check(T250* C);
T6 r250use_current(T250* C);
T0* r250to_runnable(T250* C,T0* a1);
T0* r250twin(T250* C);
void r250error(T0* a1,T0* a2);
T0* r250start_position(T250* C);
T2 r381jvm_argument_offset(T381* C,T0* a1);
void r381jvm_define(T381* C);
T0* r381run_require(T381* C);
T6 r381use_current(T381* C);
void r381jvm_define_opening(T381* C);
void r381jvm_define_closing(T381* C);
void r381routine_update_tmp_jvm_descriptor(T381* C);
T6 r381is_exported_in(T381* C,T0* a1);
T2 r381jvm_local_variable_offset(T381* C,T0* a1);
T0* r381clients(T381* C);
void r381std_compute_use_current(T381* C);
void r381method_info_start(T381* C);
T2 r381jvm_max_locals(T381* C);
T0* r381run_ensure(T381* C);
T6 r381is_deferred(T381* C);
T2 r381jvm_result_offset(T381* C);
T0* r381run_class(T381* C);
void r381make(T381* C,T0* a1,T0* a2,T0* a3);
void r381routine_mapping_jvm(T381* C);
void r381initialize(T381* C);
void r381jvm_result_store(T381* C);
T0* r381jvm_descriptor(T381* C);
void r381routine_afd_check(T381* C);
T0* r381start_position(T381* C);
T0* r21key_for_prefix_infix(T0* a1,T0* a2);
T0* r21item(T0* a1);
T0* r21for_prefix(T0* a1);
void r21add2(T0* a1);
T0* r21for_infix(T0* a1);
extern T0*oBC21memory;
void r145declaration_in(T145* C,T0* a1);
void r145make(T145* C,T0* a1,T0* a2);
void r145undefine_in(T145* C,T0* a1);
T0* r145string_aliaser(void);
T0* r145origin_base_class(T145* C);
void r145error(T0* a1,T0* a2);
T0* r177add_comment(T177* C,T0* a1);
T2 r177to_integer(T177* C);
void r177error(T0* a1,T0* a2);
extern int fBC177result_type;
extern T0*oBC177result_type;
T0* r177result_type(void);
T0* r177static_result_base_class(void);
void r177make(T177* C,T0* a1,T0* a2);
T2 r177standard_compile_to_jvm_into(T177* C,T0* a1);
T2 r177compile_to_jvm_into(T177* C,T0* a1);
T2 r177isa_dca_inline_argument(void);
void r262jvm_target_descriptor_in(T262* C,T0* a1);
T0* r262generic_list(T262* C);
T2 r262jvm_method_flags(T262* C);
T2 r262id(T262* C);
T2 r262jvm_if_x_ne(T262* C);
void r262jvm_check_class_invariant(T262* C);
T0* r262base_class(T262* C);
T6 r262is_array(T262* C);
T0* r262look_up_for(T262* C,T0* a1,T0* a2);
void r262jvm_descriptor_in(T262* C,T0* a1);
T6 r262has_creation(T262* C,T0* a1);
T6 r262is_a_in(T262* C,T0* a1,T0* a2);
T6 r262is_native_array(T262* C);
T6 r262is_boolean(T262* C);
T6 r262is_a(T262* C,T0* a1);
T6 r262is_generic(T262* C);
void r262anchor_cycle_start(T262* C);
void r262jvm_xaload(T262* C);
void r262make(T262* C,T0* a1,T0* a2);
T0* r262run_type(T262* C);
void r262jvm_return_code(T262* C);
void r262anchor_cycle_end(T262* C);
void r262used_as_reference(T262* C);
T2 r262jvm_stack_space(T262* C);
T6 r262is_reference(T262* C);
T6 r262is_real(T262* C);
T6 r262is_user_expanded(T262* C);
T6 r262is_run_type(T262* C);
T6 r262is_integer(T262* C);
void r262fatal_error_generic_list(T262* C);
T6 r262is_any(T262* C);
void r262jvm_xastore(T262* C);
T6 r262is_string(T262* C);
T0* r262smallest_ancestor(T262* C,T0* a1);
T0* r262string_aliaser(void);
void r262with(T262* C,T0* a1,T0* a2);
T6 r262is_double(T262* C);
void r262jvm_write_local(T262* C,T2 a1);
T6 r262is_none(T262* C);
T0* r262to_runnable(T262* C,T0* a1);
T6 r262is_pointer(T262* C);
void r262jvm_standard_is_equal(T262* C);
T0* r262static_base_class_name(T262* C);
T0* r262run_time_mark(T262* C);
T0* r262run_class(T262* C);
void r262jvm_xnewarray(T262* C);
T6 r262is_dummy_expanded(T262* C);
void r262jvm_push_local(T262* C,T2 a1);
void r262fatal_error(T0* a1);
T2 r262jvm_push_default(T262* C);
T6 r262is_expanded(T262* C);
T2 r262jvm_convert_to(T262* C,T0* a1);
T2 r262jvm_if_x_eq(T262* C);
T0* r262expanded_initializer(T262* C);
T6 r262is_basic_eiffel_expanded(T262* C);
T6 r262is_character(T262* C);
T2 r262jvm_expanded_from_reference(T0* a1);
T0* r262base_class_name(T262* C);
T6 r262is_bit(T262* C);
void r219compile_to_jvm_old(T219* C);
void r219make(T219* C,T0* a1,T0* a2,T0* a3);
void r219add_into(T219* C,T0* a1);
void r219afd_check(T219* C);
T6 r219use_current(T219* C);
void r219compile_to_jvm(T219* C,T6 a1);
void r219make_runnable(T219* C,T0* a1,T0* a2,T0* a3,T0* a4);
extern T0*oBC46exception_table;
T0* r46type_string(void);
void r46se_trace(T46* C,T0* a1,T0* a2);
void r46resolve_with(T0* a1);
void r46opcode_aload(T46* C,T2 a1);
void r46opcode_fload(T46* C,T2 a1);
void r46opcode_dload(T46* C,T2 a1);
void r46opcode_iload(T46* C,T2 a1);
void r46opcode_putstatic(T46* C,T2 a1,T2 a2);
T2 r46opcode_ifnonnull(T46* C);
void r46opcode_getstatic(T46* C,T2 a1,T2 a2);
T2 r46opcode_goto(T46* C);
void r46opcode_invokespecial(T46* C,T2 a1,T2 a2);
void r46opcode_invokevirtual(T46* C,T2 a1,T2 a2);
void r46runtime_check_loop_variant(T46* C,T0* a1);
extern T0*oBC46code;
void r46opcode_instanceof(T46* C,T2 a1);
T0* r46jvm_root_class(void);
void r46opcode_iinc(T46* C,T2 a1,T2 a2);
void r46opcode_astore(T46* C,T2 a1);
void r46opcode_fstore(T46* C,T2 a1);
void r46opcode_dstore(T46* C,T2 a1);
void r46opcode_istore(T46* C,T2 a1);
void r46resolve_u2_branch(T2 a1);
void r46opcode_push_as_float(T46* C,T0* a1);
void r46check_closing(T46* C);
void r46check_opening(T46* C);
void r46runtime_se_string2double(T46* C);
void r46add_u2(T2 a1);
void r46runtime_die_with_code(T46* C);
void r46runtime_sfw_open(T46* C);
void r46runtime_sfr_open(T46* C);
void r46clear(T46* C);
void r46push_position(T46* C,T0* a1);
void r46opcode_new(T46* C,T2 a1);
T2 r46opcode_ifeq(T46* C);
void r46opcode_anewarray(T46* C,T2 a1);
void r46runtime_se_remove(T46* C);
void r46runtime_se_rename(T46* C);
void r46opcode_system_out(T46* C);
void r46runtime_se_system(T46* C);
void r46opcode_string2double(T46* C,T0* a1);
void r46append_u2(T0* a1,T2 a2);
void r46opcode_push_manifest_string(T46* C,T0* a1);
void r46push_strange_integer(T46* C,T2 a1);
extern T0*oBC46tmp_string;
void r46opcode_bytes_array2eiffel_string(T46* C);
void r46opcode_java_string2eiffel_string(T46* C);
T2 r46opcode_ifge(T46* C);
T2 r46opcode_ifle(T46* C);
T2 r46opcode_ifne(T46* C);
void r46runtime_error_bad_target(T46* C,T0* a1,T0* a2,T0* a3);
T2 r46extra_local_size1(T46* C);
void r46opcode_push_as_double(T46* C,T0* a1);
void r46read_byte(T46* C);
void r46runtime_error(T46* C,T0* a1,T0* a2,T0* a3);
void r46opcode_java_string2bytes_array(T46* C);
void r46opcode_bitset_clone(T46* C);
void r46opcode_system_err(T46* C);
void r46opcode_putfield(T46* C,T2 a1,T2 a2);
void r46opcode_getfield(T46* C,T2 a1,T2 a2);
void r46opcode_string2float(T46* C,T0* a1);
void r46runtime_print_run_time_stack(T46* C);
void r46append_u4(T0* a1,T2 a2);
void r46opcode_invokestatic(T46* C,T2 a1,T2 a2);
void r46opcode_system_in(T46* C);
T2 r46opcode_if_acmpeq(T46* C);
T2 r46opcode_if_icmpne(T46* C);
T2 r46opcode_if_acmpne(T46* C);
T2 r46opcode_if_icmpgt(T46* C);
T2 r46opcode_if_icmpge(T46* C);
T2 r46opcode_if_icmplt(T46* C);
T2 r46opcode_if_icmple(T46* C);
T2 r46opcode_if_icmpeq(T46* C);
void r46opcode_checkcast(T46* C,T2 a1);
void r46opcode_push_integer(T46* C,T2 a1);
T2 r46opcode_ifnull(T46* C);
void r46runtime_internal_exception_number(T46* C);
void r46opcode_ldc(T46* C,T2 a1);
void r46runtime_se_getenv(T46* C);
void r46opcode_newarray(T46* C,T2 a1);
T2 r46extra_local(T46* C,T0* a1);
void r46opcode(T46* C,T2 a1,T2 a2);
T2 r46skip_2_bytes(void);
void r46opcode_bipush(T46* C,T2 a1);
void r46opcode_sipush(T46* C,T2 a1);
T2 r46opcode_iflt(T46* C);
T2 r46opcode_ifgt(T46* C);
void r46opcode_goto_backward(T46* C,T2 a1);
void r46store_in(T46* C,T0* a1);
void r46runtime_error_inspect(T46* C,T0* a1);
extern T0*oBC46branches;
T0* r202to_cst_att_character(T202* C,T0* a1);
void r202error(T0* a1,T0* a2);
T0* r202to_cst_att_real(T202* C,T0* a1);
T0* r202to_cst_att_unique(T202* C);
T0* r202to_cst_att_string(T202* C,T0* a1);
T0* r202to_procedure_or_function(T202* C);
T0* r202to_cst_att_bit(T202* C,T0* a1);
T0* r202n(void);
void r202to_cst_att_check_result_type(T202* C);
T0* r202to_cst_att_integer(T202* C,T0* a1);
T0* r202to_external_routine(T202* C,T0* a1,T0* a2);
void r202fatal_error(T0* a1);
void r202set_require(T202* C,T0* a1,T0* a2,T0* a3);
T0* r202to_deferred_routine(T202* C);
T0* r202to_writable_attribute(T202* C);
void r202add_synonym(T0* a1);
void r202set_require_else(T202* C,T0* a1,T0* a2,T0* a3);
void r202initialize(T202* C);
T0* r202to_once_routine(T202* C);
extern T0*oBC202names;
T0* r202to_cst_att_boolean(T202* C,T0* a1);
extern T0*oBC384manifest_array_types;
void r384register(T0* a1);
void r208increment(T208* C);
void r298fatal_error(T0* a1);
void r298fe_c2jvm(T0* a1);
T0* r346type_string(void);
extern T0*oBC346mangling_dictionary;
void r346used_for_c_inline(T0* a1);
T0* r346register(T0* a1);
T2 r305idx_methodref(T0* a1);
void r305jvm_mapping_function(T0* a1,T0* a2,T0* a3);
void r305fatal_error(T0* a1);
extern T0*oBC304tmp_descriptor;
void r305jvm_mapping_procedure(T0* a1,T0* a2,T0* a3);
extern T0*oBC304tmp_name;
extern T0*oBC304tmp_class;
extern T0*oBC364registered;
void r364register_for(T0* a1);
extern T0*oBC364caller_memory;
void r345prepare_result(T0* a1);
void r345add_procedure(T0* a1);
T2 r345idx_name_for_result(T0* a1);
extern T0*oBC345procedure_list;
extern T0*oBC345flag_list;
void r345prepare_descriptor(T0* a1);
T2 r345idx_fieldref_for_result(T0* a1);
T2 r345idx_fieldref_for_flag(T0* a1);
extern T0*oBC345result_string;
void r345prepare_flag(T0* a1);
T2 r345idx_descriptor(T0* a1);
extern T0*oBC345flag_string;
void r345jvm_define_fields(T345* C);
void r345add_function(T0* a1);
extern T0*oBC345descriptor_string;
T0* r345jvm_root_class(void);
extern T0*oBC345function_list;
T2 r345idx_name_for_flag(T0* a1);
T0* r345jvm_root_descriptor(void);
void r297jvm_mapping_native_array_function(T0* a1,T0* a2);
void r297fe_nyi(T0* a1);
void r297jvm_object_size(T0* a1);
void r297jvm_bit_to_int(T2 a1);
void r297jvm_add_method_for_procedure(T0* a1,T0* a2,T0* a3);
void r297jvm_mapping_function(T0* a1,T0* a2,T0* a3);
void r297jvm_mapping_bit_function(T0* a1,T0* a2);
void r297jvm_mapping_double_function(T0* a1,T0* a2);
void r297jvm_int_to_bit(T0* a1,T2 a2);
void r297jvm_define_procedure(T0* a1,T0* a2,T0* a3);
void r297jvm_define_sprintf_double(T0* a1);
void r297fatal_error(T0* a1);
void r297jvm_standard_twin(T0* a1);
void r297jvm_define_twin(T0* a1,T0* a2,T0* a3);
void r297jvm_copy(T0* a1);
void r297jvm_mapping_bit_procedure(T0* a1,T0* a2);
void r297jvm_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r297jvm_standard_twin_aux(T0* a1,T0* a2);
void r297jvm_define_function(T0* a1,T0* a2,T0* a3);
void r297jvm_mapping_native_array_procedure(T0* a1,T0* a2);
T6 r297use_current(T0* a1);
void r297jvm_mapping_integer_function(T0* a1,T0* a2);
void r297jvm_add_method_for_function(T0* a1,T0* a2,T0* a3);
void r297jvm_mapping_real_function(T0* a1,T0* a2);
T2 r303idx_methodref(T0* a1);
void r303jvm_mapping_function(T0* a1,T0* a2,T0* a3);
void r303fatal_error(T0* a1);
void r50clear(T50* C);
void r50start(T50* C,T2 a1,T0* a2,T0* a3);
void r50append_u2(T0* a1,T2 a2);
void r50write_bytes(T50* C);
void r50finish(T50* C);
void r50add_init(T50* C,T0* a1);
extern T0*oBC50storage;
T6 r112is_current(void);
void r112reset(T112* C,T2 a1,T2 a2);
T0* r112to_tag_name(T112* C);
T0* r112to_argument_name2(T112* C,T0* a1,T2 a2);
T0* r112to_e_void(T112* C);
T0* r112to_local_name2(T112* C,T0* a1,T2 a2);
T0* r112to_simple_feature_name(T112* C);
T0* r112to_class_name(T112* C);
T6 r112isa_keyword(void);
T0* r112to_argument_name1(T112* C);
T0* r112start_position(T112* C);
T0* r112to_prefix_name(T112* C);
T0* r112string_aliaser(void);
T0* r112aliased_string(T112* C);
T0* r112to_infix_name(T112* C,T0* a1);
T0* r112pos(T2 a1,T2 a2);
T6 r112is_void(void);
T0* r112to_local_name1(T112* C);
T0* r112to_infix_name_use(T112* C);
T6 r112is_result(void);
void r335update_with(T0* a1);
extern T0*oBC335dictionary;
void r335update(T0* a1,T0* a2);
extern T0*oBC336running;
T2 r336idx_methodref(T0* a1);
void r336jvm_define(T0* a1);
void r336jvm_mapping(T0* a1);
extern T0*oBC336c_code;
T0* r336name(T0* a1);
extern T0*oBC336tmp_jvmd;
T0* r336jvm_descriptor(T0* a1);
T0* r336jvm_root_class(void);
void r336jvm_switch(T0* a1,T0* a2);
T0* r336jvm_root_descriptor(void);
T0* r365type_any(void);
void r365fatal_error(T0* a1);
void r365fill_up(T365* C);
T6 r10is_flag_no_warning(T0* a1);
T6 r10is_flag_debug_check(T0* a1);
T0* r10argument(T2 a1);
T6 r10is_flag_require_check(T10* C,T0* a1);
T0* r10string_aliaser(void);
T6 r10is_flag_verbose(T0* a1);
void r10check_for_level(T10* C,T0* a1);
T6 r10is_flag_no_check(T10* C,T0* a1);
T6 r10is_flag_o(T10* C,T0* a1,T2 a2,T2 a3,T0* a4);
T6 r10is_flag_trace(T0* a1);
T6 r10is_flag_all_check(T10* C,T0* a1);
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
T6 r10is_flag_ensure_check(T10* C,T0* a1);
T6 r10is_flag_cecil(T10* C,T0* a1,T2 a2,T2 a3);
T6 r10is_flag_no_style_warning(T0* a1);
T6 r10is_flag_case_insensitive(T0* a1);
void r10make(T10* C);
T6 r10is_flag_boost(T10* C,T0* a1);
T6 r10is_flag_invariant_check(T10* C,T0* a1);
void r10check_for_root_class(T10* C);
void r10unknown_flag_exit(T10* C,T0* a1);
T0* r10system_tools(void);
T6 r10is_flag_loop_check(T10* C,T0* a1);
T6 r10is_flag_version(T10* C,T0* a1);
void r302fatal_error(T0* a1);
void r302jvm_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r302fe_c2jvm(T0* a1);
void r51clear(T51* C);
void r51append_u2(T0* a1,T2 a2);
void r51add(T51* C,T2 a1,T2 a2,T2 a3);
void r51write_bytes(T51* C);
extern T0*oBC51storage;
void r300fatal_error(T0* a1);
void r300fe_c2jvm(T0* a1);
void r47string_to_utf8(T0* a1,T0* a2);
void r47append_u2(T0* a1,T2 a2);
T2 r47idx_utf8(T47* C,T0* a1);
T2 r47idx_name_and_type2(T47* C,T0* a1,T0* a2);
T2 r47idx_class2(T47* C,T0* a1);
T2 r47idx_fieldref4(T47* C,T2 a1,T0* a2,T0* a3);
T2 r47idx_fieldref(T47* C,T0* a1);
T2 r47idx_string2(T47* C,T0* a1);
T2 r47idx_fieldref_generator(T47* C,T2 a1);
extern T0*oBC47cp;
extern int fBC47jvm_string_descriptor;
extern T0*oBC47jvm_string_descriptor;
T0* r47jvm_string_descriptor(void);
T2 r47idx_fieldref3(T47* C,T0* a1,T0* a2,T0* a3);
T2 r47idx_eiffel_string_class(T47* C);
void r47write_bytes(T47* C);
T2 r47idx_fieldref_for_manifest_string(T47* C,T0* a1);
T2 r47idx_fieldref2(T47* C,T2 a1,T2 a2);
T2 r47idx_name_and_type1(T47* C,T0* a1,T2 a2);
extern T0*oBC47tmp_info;
T2 r47idx_eiffel_string_storage_fieldref(T47* C);
T2 r47idx_eiffel_string_descriptor(T47* C);
T0* r47add_last(T47* C);
T2 r47idx_string(T47* C,T0* a1);
void r47clear(T47* C);
T2 r47idx_fieldref_generating_type(T47* C,T2 a1);
extern T0*oBC47tmp_utf8;
extern int fBC47jvm_string_class;
extern T0*oBC47jvm_string_class;
T0* r47jvm_string_class(void);
T2 r47idx_methodref1(T47* C,T2 a1,T0* a2,T0* a3);
T2 r47idx_methodref(T47* C,T0* a1);
T2 r47idx_methodref2(T47* C,T2 a1,T2 a2);
T2 r47idx_methodref3(T47* C,T0* a1,T0* a2,T0* a3);
T2 r47idx_name_and_type3(T47* C,T2 a1,T2 a2);
T2 r47idx_eiffel_string_capacity_fieldref(T47* C);
T2 r47idx_eiffel_string_count_fieldref(T47* C);
T0* r47jvm_root_class(void);
T2 r47idx_name_and_type(T47* C,T0* a1);
T2 r47idx_fieldref5(T47* C,T2 a1,T2 a2,T2 a3);
void r355mkdir(T0* a1);
void r301fatal_error(T0* a1);
void r301fe_c2jvm(T0* a1);
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 392
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms336_533256;
extern T7*ms287_168036;
extern T7*ms297_140556;
extern T7*ms289_124456;
extern T7*ms180_268167;
extern T7*ms202_147108;
extern T7*ms365_103068;
extern T7*ms348_320658;
extern T7*ms187_106468;
extern T7*ms202_185909;
extern T7*ms179_366828;
extern T7*ms348_203069;
extern T7*ms13_2595a;
extern T7*ms13_7524a;
extern T7*ms13_1684a;
extern T7*ms13_2615a;
extern T7*ms14_1035a;
extern T7*ms14_2765a;
extern T7*ms14_2730a;
extern T7*ms34_1176a;
extern T7*ms34_9260a;
extern T7*ms34_9955a;
extern T7*ms13_48184a;
extern T7*ms13_36393a;
extern T7*ms13_37136a;
extern T7*ms13_28008a;
extern T7*ms13_1684aa;
extern T7*ms14_22824a;
extern T7*ms14_12915a;
extern T7*ms34_78588a;
extern T7*ms34_82473a;
extern T7*ms34_28980a;
extern T7*ms34_13832a;
extern T7*ms34_44694a;
extern T7*ms34_37992a;
extern T7*ms65_56820a;
extern T7*ms39_23814a;
extern T7*ms13_70;
extern T7*ms13_90;
extern T7*ms14_60;
extern T7*ms42_90;
extern T7*ms65_10;
extern T7*ms14_61;
extern T7*ms14_62;
extern T7*ms14_42;
extern T7*ms13_73;
extern T7*ms14_43;
extern T7*ms14_64;
extern T7*ms14_94;
extern T7*ms14_45;
extern T7*ms14_35;
extern T7*ms13_66;
extern T7*ms13_46;
extern T7*ms14_47;
extern T7*ms34_67;
extern T7*ms13_68;
extern T7*ms132_37536a;
extern T7*ms11_270;
extern T7*ms13_430;
extern T7*ms13_960;
extern T7*ms13_440;
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms14_450;
extern T7*ms34_280;
extern T7*ms35_180;
extern T7*ms65_300;
extern T7*ms74_270;
extern T7*ms74_210;
extern T7*ms74_690;
extern T7*ms13_501;
extern T7*ms14_921;
extern T7*ms69_160;
extern T7*ms287_46;
extern T7*ms11_312;
extern T7*ms13_462;
extern T7*ms13_952;
extern T7*ms13_422;
extern T7*ms13_112;
extern T7*ms14_242;
extern T7*ms14_552;
extern T7*ms14_432;
extern T7*ms43_152;
extern T7*ms74_132;
extern T7*ms13_933;
extern T7*ms39_112;
extern T7*ms34_663;
extern T7*ms69_152;
extern T7*ms35_663;
extern T7*ms12_294;
extern T7*ms13_314;
extern T7*ms13_254;
extern T7*ms13_414;
extern T7*ms13_424;
extern T7*ms14_564;
extern T7*ms73_684;
extern T7*ms65_144;
extern T7*ms34_28980aa;
extern T7*ms34_112140a;
extern T7*ms34_145656a;
extern T7*ms34_103845a;
extern T7*ms83_110836a;
extern T7*ms74_285;
extern T7*ms13_976;
extern T7*ms13_996;
extern T7*ms41_366;
extern T7*ms14_696;
extern T7*ms14_246;
extern T7*ms14_216;
extern T7*ms74_636;
extern T7*ms13_987;
extern T7*ms13_957;
extern T7*ms39_336;
extern T7*ms34_657;
extern T7*ms13_868;
extern T7*ms13_188;
extern T7*ms14_368;
extern T7*ms14_188;
extern T7*ms43_728;
extern T7*ms74_948;
extern T7*ms74_738;
extern T7*ms65_208;
extern T7*ms13_939;
extern T7*ms14_669;
extern T7*ms220_174;
extern T7*ms253_174;
extern T7*ms12_6930;
extern T7*ms21_1660;
extern T7*ms13_9270;
extern T7*ms13_7400;
extern T7*ms40_6980;
extern T7*ms13_1020;
extern T7*ms13_2780;
extern T7*ms13_2810;
extern T7*ms13_7320;
extern T7*ms13_2830;
extern T7*ms13_2710;
extern T7*ms13_7260;
extern T7*ms13_8680;
extern T7*ms13_1700;
extern T7*ms13_2670;
extern T7*ms13_2550;
extern T7*ms13_2610;
extern T7*ms13_3720;
extern T7*ms41_2610;
extern T7*ms41_2250;
extern T7*ms14_1980;
extern T7*ms14_2600;
extern T7*ms14_2620;
extern T7*ms14_8750;
extern T7*ms14_2760;
extern T7*ms14_2440;
extern T7*ms14_7380;
extern T7*ms14_2730;
extern T7*ms14_7530;
extern T7*ms14_8820;
extern T7*ms14_1800;
extern T7*ms14_2780;
extern T7*ms51_2580;
extern T7*ms34_6580;
extern T7*ms34_9260;
extern T7*ms34_7530;
extern T7*ms34_7510;
extern T7*ms65_2120;
extern T7*ms39_6110;
extern T7*ms39_5160;
extern T7*ms13_9401;
extern T7*ms14_9801;
extern T7*ms14_1011;
extern T7*ms14_8211;
extern T7*ms14_9051;
extern T7*ms69_5320;
extern T7*ms69_1070;
extern T7*ms252_156;
extern T7*ms11_6582;
extern T7*ms11_6462;
extern T7*ms12_1592;
extern T7*ms13_1032;
extern T7*ms13_1692;
extern T7*ms13_1792;
extern T7*ms13_6912;
extern T7*ms13_6822;
extern T7*ms13_9422;
extern T7*ms13_6852;
extern T7*ms14_6702;
extern T7*ms14_1772;
extern T7*ms14_1672;
extern T7*ms14_6762;
extern T7*ms34_6402;
extern T7*ms34_5302;
extern T7*ms11_7623;
extern T7*ms74_6412;
extern T7*ms74_8092;
extern T7*ms13_7263;
extern T7*ms13_1053;
extern T7*ms14_6643;
extern T7*ms69_3102;
extern T7*ms346_448;
extern T7*ms11_2424;
extern T7*ms13_7824;
extern T7*ms13_1724;
extern T7*ms13_1684;
extern T7*ms13_1744;
extern T7*ms13_7524;
extern T7*ms14_9234;
extern T7*ms14_1644;
extern T7*ms14_1664;
extern T7*ms14_1724;
extern T7*ms14_1744;
extern T7*ms14_7314;
extern T7*ms65_5784;
extern T7*ms13_1425;
extern T7*ms13_2645;
extern T7*ms13_9485;
extern T7*ms13_2615;
extern T7*ms13_2595;
extern T7*ms41_2065;
extern T7*ms14_1915;
extern T7*ms14_6405;
extern T7*ms14_2765;
extern T7*ms14_2785;
extern T7*ms14_1035;
extern T7*ms14_2445;
extern T7*ms14_8505;
extern T7*ms14_9275;
extern T7*ms69_4164;
extern T7*ms34_2595;
extern T7*ms34_9955;
extern T7*ms11_7056;
extern T7*ms74_9785;
extern T7*ms74_2395;
extern T7*ms13_7356;
extern T7*ms13_1716;
extern T7*ms40_6056;
extern T7*ms13_1736;
extern T7*ms50_6846;
extern T7*ms14_1216;
extern T7*ms14_6776;
extern T7*ms14_7576;
extern T7*ms14_4956;
extern T7*ms14_6846;
extern T7*ms14_1656;
extern T7*ms14_9436;
extern T7*ms14_7326;
extern T7*ms69_8175;
extern T7*ms34_1176;
extern T7*ms34_7826;
extern T7*ms47_1516;
extern T7*ms65_1116;
extern T7*ms74_5166;
extern T7*ms74_3636;
extern T7*ms74_9226;
extern T7*ms74_1316;
extern T7*ms74_1296;
extern T7*ms13_8267;
extern T7*ms14_6307;
extern T7*ms14_8547;
extern T7*ms42_7497;
extern T7*ms39_4977;
extern T7*ms21_1688;
extern T7*ms13_1648;
extern T7*ms13_9288;
extern T7*ms13_9878;
extern T7*ms13_7068;
extern T7*ms13_5208;
extern T7*ms13_7008;
extern T7*ms13_1768;
extern T7*ms13_6978;
extern T7*ms13_3038;
extern T7*ms41_8638;
extern T7*ms14_4728;
extern T7*ms14_5508;
extern T7*ms14_7928;
extern T7*ms14_1168;
extern T7*ms14_9408;
extern T7*ms14_1608;
extern T7*ms42_3688;
extern T7*ms42_3328;
extern T7*ms79_9977;
extern T7*ms34_9888;
extern T7*ms35_4248;
extern T7*ms74_8478;
extern T7*ms13_8799;
extern T7*ms69_4949;
extern T7*ms132_9780;
extern T7*ms281_7630;
extern T7*ms373_1020;
extern T7*ms297_2730;
extern T7*ms373_1012;
extern T7*ms11_29440;
extern T7*ms11_20940;
extern T7*ms11_15230;
extern T7*ms11_24020;
extern T7*ms13_32970;
extern T7*ms13_52900;
extern T7*ms13_25640;
extern T7*ms13_12870;
extern T7*ms13_17460;
extern T7*ms13_11460;
extern T7*ms13_30800;
extern T7*ms13_18080;
extern T7*ms13_15400;
extern T7*ms13_23520;
extern T7*ms13_41370;
extern T7*ms40_16400;
extern T7*ms13_66110;
extern T7*ms13_10880;
extern T7*ms13_10720;
extern T7*ms13_41100;
extern T7*ms14_12550;
extern T7*ms14_10740;
extern T7*ms14_12030;
extern T7*ms14_10680;
extern T7*ms14_15070;
extern T7*ms14_15570;
extern T7*ms14_30660;
extern T7*ms14_26880;
extern T7*ms14_33240;
extern T7*ms14_60060;
extern T7*ms14_33270;
extern T7*ms14_53940;
extern T7*ms14_32730;
extern T7*ms14_27580;
extern T7*ms14_33990;
extern T7*ms14_16970;
extern T7*ms14_16770;
extern T7*ms14_16850;
extern T7*ms14_21300;
extern T7*ms14_56720;
extern T7*ms14_15650;
extern T7*ms14_22140;
extern T7*ms42_44080;
extern T7*ms34_14900;
extern T7*ms34_57450;
extern T7*ms34_82140;
extern T7*ms34_70550;
extern T7*ms34_28980;
extern T7*ms34_43830;
extern T7*ms34_11050;
extern T7*ms34_73800;
extern T7*ms34_91880;
extern T7*ms34_20060;
extern T7*ms34_90080;
extern T7*ms34_63690;
extern T7*ms34_37500;
extern T7*ms34_27720;
extern T7*ms34_28940;
extern T7*ms34_75620;
extern T7*ms34_32940;
extern T7*ms34_74830;
extern T7*ms34_97990;
extern T7*ms34_28720;
extern T7*ms34_57210;
extern T7*ms34_65170;
extern T7*ms34_47790;
extern T7*ms34_56460;
extern T7*ms132_1855;
extern T7*ms46_84900;
extern T7*ms46_57980;
extern T7*ms82_23940;
extern T7*ms91_91200;
extern T7*ms74_46640;
extern T7*ms74_41310;
extern T7*ms83_22560;
extern T7*ms65_56820;
extern T7*ms83_71750;
extern T7*ms83_93400;
extern T7*ms83_73570;
extern T7*ms74_82530;
extern T7*ms74_11880;
extern T7*ms74_33210;
extern T7*ms74_26180;
extern T7*ms74_38280;
extern T7*ms74_31980;
extern T7*ms74_19880;
extern T7*ms74_10010;
extern T7*ms39_26520;
extern T7*ms39_98400;
extern T7*ms39_56250;
extern T7*ms39_12960;
extern T7*ms39_24060;
extern T7*ms94_19170;
extern T7*ms94_66660;
extern T7*ms94_41470;
extern T7*ms13_30571;
extern T7*ms13_40851;
extern T7*ms13_38641;
extern T7*ms13_45441;
extern T7*ms69_23730;
extern T7*ms354_2535;
extern T7*ms69_40050;
extern T7*ms69_36270;
extern T7*ms69_17730;
extern T7*ms69_32700;
extern T7*ms297_2775;
extern T7*ms74_43761;
extern T7*ms11_34992;
extern T7*ms11_27832;
extern T7*ms11_10272;
extern T7*ms13_10912;
extern T7*ms13_67082;
extern T7*ms13_11292;
extern T7*ms13_82082;
extern T7*ms40_23562;
extern T7*ms13_14292;
extern T7*ms41_19162;
extern T7*ms14_16692;
extern T7*ms14_27272;
extern T7*ms14_34432;
extern T7*ms14_21192;
extern T7*ms14_13662;
extern T7*ms14_13752;
extern T7*ms34_38352;
extern T7*ms34_85332;
extern T7*ms34_76392;
extern T7*ms34_13832;
extern T7*ms34_19992;
extern T7*ms34_78192;
extern T7*ms34_45252;
extern T7*ms34_25992;
extern T7*ms34_37992;
extern T7*ms34_34992;
extern T7*ms82_50372;
extern T7*ms46_10792;
extern T7*ms46_26572;
extern T7*ms297_1026;
extern T7*ms83_35512;
extern T7*ms11_17743;
extern T7*ms39_26502;
extern T7*ms39_33632;
extern T7*ms39_55332;
extern T7*ms39_48112;
extern T7*ms39_70652;
extern T7*ms94_64152;
extern T7*ms94_82612;
extern T7*ms13_47103;
extern T7*ms13_36393;
extern T7*ms13_63393;
extern T7*ms13_50483;
extern T7*ms86_44172;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms69_63712;
extern T7*ms69_59892;
extern T7*ms69_15152;
extern T7*ms14_16393;
extern T7*ms14_14193;
extern T7*ms14_27443;
extern T7*ms14_13833;
extern T7*ms34_24843;
extern T7*ms34_82473;
extern T7*ms34_60543;
extern T7*ms46_47103;
extern T7*ms46_14193;
extern T7*ms83_98523;
extern T7*ms65_62493;
extern T7*ms11_18304;
extern T7*ms11_32474;
extern T7*ms11_10984;
extern T7*ms39_28313;
extern T7*ms58_36693;
extern T7*ms13_48184;
extern T7*ms13_26894;
extern T7*ms13_14504;
extern T7*ms13_28644;
extern T7*ms40_22284;
extern T7*ms13_60064;
extern T7*ms13_21964;
extern T7*ms13_41814;
extern T7*ms13_50644;
extern T7*ms13_47034;
extern T7*ms13_25714;
extern T7*ms13_10704;
extern T7*ms13_10544;
extern T7*ms14_12804;
extern T7*ms14_19124;
extern T7*ms14_11424;
extern T7*ms14_22524;
extern T7*ms14_19294;
extern T7*ms14_60104;
extern T7*ms14_11144;
extern T7*ms14_18964;
extern T7*ms14_21624;
extern T7*ms14_22824;
extern T7*ms14_12744;
extern T7*ms14_25584;
extern T7*ms79_28313;
extern T7*ms34_62784;
extern T7*ms34_68714;
extern T7*ms34_31374;
extern T7*ms34_70924;
extern T7*ms34_44694;
extern T7*ms34_63104;
extern T7*ms34_83144;
extern T7*ms34_79794;
extern T7*ms34_36624;
extern T7*ms34_48484;
extern T7*ms46_35344;
extern T7*ms46_50974;
extern T7*ms46_80304;
extern T7*ms288_3438;
extern T7*ms83_60064;
extern T7*ms83_34344;
extern T7*ms74_25494;
extern T7*ms74_22824;
extern T7*ms39_23814;
extern T7*ms39_23374;
extern T7*ms39_30744;
extern T7*ms49_61544;
extern T7*ms13_33075;
extern T7*ms13_39165;
extern T7*ms69_72324;
extern T7*ms69_68094;
extern T7*ms69_89544;
extern T7*ms14_12595;
extern T7*ms14_13995;
extern T7*ms14_12915;
extern T7*ms14_14175;
extern T7*ms14_58075;
extern T7*ms42_16065;
extern T7*ms34_41925;
extern T7*ms34_70945;
extern T7*ms34_60295;
extern T7*ms34_38675;
extern T7*ms34_71715;
extern T7*ms34_34845;
extern T7*ms34_74305;
extern T7*ms34_32955;
extern T7*ms34_12285;
extern T7*ms34_37125;
extern T7*ms34_65135;
extern T7*ms46_39165;
extern T7*ms74_76935;
extern T7*ms47_14985;
extern T7*ms39_40975;
extern T7*ms39_53165;
extern T7*ms13_33296;
extern T7*ms40_50576;
extern T7*ms13_14056;
extern T7*ms13_11416;
extern T7*ms40_61446;
extern T7*ms13_11736;
extern T7*ms13_37136;
extern T7*ms13_32336;
extern T7*ms13_37216;
extern T7*ms13_10776;
extern T7*ms13_11256;
extern T7*ms14_11776;
extern T7*ms14_29246;
extern T7*ms14_22596;
extern T7*ms14_60016;
extern T7*ms14_17886;
extern T7*ms14_11496;
extern T7*ms14_11336;
extern T7*ms14_26156;
extern T7*ms14_11376;
extern T7*ms14_22716;
extern T7*ms14_27456;
extern T7*ms34_85576;
extern T7*ms34_43966;
extern T7*ms34_33946;
extern T7*ms34_63096;
extern T7*ms34_47096;
extern T7*ms34_25156;
extern T7*ms34_85386;
extern T7*ms34_82066;
extern T7*ms34_63616;
extern T7*ms34_63456;
extern T7*ms34_98236;
extern T7*ms34_33396;
extern T7*ms34_33286;
extern T7*ms34_84626;
extern T7*ms34_53476;
extern T7*ms74_12816;
extern T7*ms11_24427;
extern T7*ms11_12807;
extern T7*ms39_20556;
extern T7*ms94_51136;
extern T7*ms13_48867;
extern T7*ms13_37417;
extern T7*ms69_35616;
extern T7*ms69_43966;
extern T7*ms69_30576;
extern T7*ms14_14817;
extern T7*ms14_19437;
extern T7*ms14_13707;
extern T7*ms14_13977;
extern T7*ms34_14067;
extern T7*ms34_88647;
extern T7*ms10_28868;
extern T7*ms11_27208;
extern T7*ms11_36958;
extern T7*ms11_34188;
extern T7*ms39_20957;
extern T7*ms21_17578;
extern T7*ms13_21528;
extern T7*ms13_63168;
extern T7*ms13_28008;
extern T7*ms13_33808;
extern T7*ms13_33308;
extern T7*ms13_10608;
extern T7*ms13_10808;
extern T7*ms13_11328;
extern T7*ms13_19808;
extern T7*ms69_82177;
extern T7*ms14_17448;
extern T7*ms14_10528;
extern T7*ms14_22248;
extern T7*ms14_22788;
extern T7*ms14_26908;
extern T7*ms14_21648;
extern T7*ms14_34528;
extern T7*ms14_40358;
extern T7*ms14_12978;
extern T7*ms79_66627;
extern T7*ms79_46407;
extern T7*ms43_25168;
extern T7*ms43_80668;
extern T7*ms34_63328;
extern T7*ms34_71128;
extern T7*ms34_36168;
extern T7*ms34_94248;
extern T7*ms34_42978;
extern T7*ms34_77508;
extern T7*ms34_78588;
extern T7*ms34_22168;
extern T7*ms34_26638;
extern T7*ms34_90558;
extern T7*ms34_40338;
extern T7*ms34_57288;
extern T7*ms34_29148;
extern T7*ms35_26208;
extern T7*ms46_93028;
extern T7*ms46_62958;
extern T7*ms46_50088;
extern T7*ms46_28008;
extern T7*ms11_15759;
extern T7*ms11_37859;
extern T7*ms39_33258;
extern T7*ms39_31538;
extern T7*ms39_12078;
extern T7*ms13_19839;
extern T7*ms121_16290;
extern T7*ms69_33618;
extern T7*ms202_83790;
extern T7*ms87_60608;
extern T7*ms41_10489;
extern T7*ms69_36828;
extern T7*ms14_12529;
extern T7*ms14_13419;
extern T7*ms14_23829;
extern T7*ms42_21679;
extern T7*ms34_53969;
extern T7*ms34_13509;
extern T7*ms132_41400;
extern T7*ms151_56430;
extern T7*ms152_16290;
extern T7*ms152_43200;
extern T7*ms252_45900;
extern T7*ms74_18029;
extern T7*ms253_76570;
extern T7*ms236_94240;
extern T7*ms236_18080;
extern T7*ms58_28899;
extern T7*ms273_29400;
extern T7*ms264_27080;
extern T7*ms237_18400;
extern T7*ms274_38600;
extern T7*ms69_66429;
extern T7*ms149_24320;
extern T7*ms257_22600;
extern T7*ms194_12870;
extern T7*ms132_88031;
extern T7*ms132_45961;
extern T7*ms288_34500;
extern T7*ms288_38600;
extern T7*ms288_71400;
extern T7*ms152_89271;
extern T7*ms199_54060;
extern T7*ms270_43011;
extern T7*ms253_30681;
extern T7*ms274_23751;
extern T7*ms257_53041;
extern T7*ms103_66792;
extern T7*ms103_43392;
extern T7*ms202_98482;
extern T7*ms202_97692;
extern T7*ms112_84672;
extern T7*ms114_63162;
extern T7*ms287_55831;
extern T7*ms152_99162;
extern T7*ms144_50092;
extern T7*ms271_35472;
extern T7*ms191_26532;
extern T7*ms354_86602;
extern T7*ms237_20672;
extern T7*ms246_86032;
extern T7*ms238_14812;
extern T7*ms166_50092;
extern T7*ms248_78192;
extern T7*ms248_24012;
extern T7*ms275_29392;
extern T7*ms278_35952;
extern T7*ms279_41652;
extern T7*ms252_36693;
extern T7*ms282_45873;
extern T7*ms202_86564;
extern T7*ms187_24263;
extern T7*ms12_581900;
extern T7*ms205_98784;
extern T7*ms151_73044;
extern T7*ms152_40404;
extern T7*ms34_120520;
extern T7*ms34_666080;
extern T7*ms34_112140;
extern T7*ms34_112230;
extern T7*ms34_141350;
extern T7*ms34_196560;
extern T7*ms34_115740;
extern T7*ms34_191760;
extern T7*ms34_115650;
extern T7*ms236_11424;
extern T7*ms237_29304;
extern T7*ms255_34344;
extern T7*ms183_36624;
extern T7*ms346_54464;
extern T7*ms184_85234;
extern T7*ms120_53215;
extern T7*ms257_63264;
extern T7*ms248_41834;
extern T7*ms56_116840;
extern T7*ms202_33465;
extern T7*ms269_99414;
extern T7*ms69_107460;
extern T7*ms69_147680;
extern T7*ms79_139750;
extern T7*ms34_124691;
extern T7*ms272_38125;
extern T7*ms335_30015;
extern T7*ms246_20145;
extern T7*ms264_38075;
extern T7*ms103_58386;
extern T7*ms268_37975;
extern T7*ms132_20976;
extern T7*ms132_37536;
extern T7*ms13_101802;
extern T7*ms152_36216;
extern T7*ms260_86756;
extern T7*ms180_63456;
extern T7*ms253_63756;
extern T7*ms34_135632;
extern T7*ms34_349402;
extern T7*ms34_202032;
extern T7*ms34_128352;
extern T7*ms191_36216;
extern T7*ms237_63376;
extern T7*ms255_33396;
extern T7*ms183_18096;
extern T7*ms46_101802;
extern T7*ms391_38496;
extern T7*ms229_18176;
extern T7*ms257_45376;
extern T7*ms248_36096;
extern T7*ms248_14616;
extern T7*ms248_75456;
extern T7*ms365_17496;
extern T7*ms74_716872;
extern T7*ms285_18176;
extern T7*ms39_802392;
extern T7*ms230_32637;
extern T7*ms278_16976;
extern T7*ms69_171472;
extern T7*ms98_233442;
extern T7*ms165_66627;
extern T7*ms46_543543;
extern T7*ms257_66627;
extern T7*ms220_58608;
extern T7*ms230_74948;
extern T7*ms132_41868;
extern T7*ms12_570704;
extern T7*ms152_35088;
extern T7*ms253_11648;
extern T7*ms34_197274;
extern T7*ms285_50008;
extern T7*ms58_783104;
extern T7*ms287_17008;
extern T7*ms69_121824;
extern T7*ms89_101934;
extern T7*ms89_121394;
extern T7*ms34_166375;
extern T7*ms34_115695;
extern T7*ms34_114705;
extern T7*ms34_103845;
extern T7*ms34_116145;
extern T7*ms34_116865;
extern T7*ms237_53969;
extern T7*ms277_49909;
extern T7*ms21_107916;
extern T7*ms69_140505;
extern T7*ms69_228345;
extern T7*ms69_130095;
extern T7*ms43_296296;
extern T7*ms34_145656;
extern T7*ms34_203856;
extern T7*ms83_110836;
extern T7*ms74_131716;
extern T7*ms74_848426;
extern T7*ms69_196786;
extern T7*ms103_500000;
extern T7*ms121_180780;
extern T7*ms202_126960;
extern T7*ms13_554698;
extern T7*ms304_247860;
extern T7*ms82_162378;
extern T7*ms46_321078;
extern T7*ms74_225848;
extern T7*ms336_563430;
extern T7*ms293_139650;
extern T7*ms167_139750;
extern T7*ms69_152958;
extern T7*ms288_116100;
extern T7*ms288_101250;
extern T7*ms46_147849;
extern T7*ms13_960a;
extern T7*ms13_939a;
extern T7*ms41_366a;
extern T7*ms34_280a;
extern T7*ms34_663a;
extern T7*ms34_657a;
extern T7*ms132_382452;
extern T7*ms69_160a;
extern T7*ms283_305382;
extern T7*ms202_235773;
extern T7*ms202_141933;
extern T7*ms181_358643;
extern T7*ms202_157734;
extern T7*ms34_1419840;
extern T7*ms194_120244;
extern T7*ms294_126054;
extern T7*ms202_115695;
extern T7*ms297_165824;
extern T7*ms149_153435;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void se_msi10(void);
void se_msi11(void);
void se_msi12(void);
void se_msi13(void);
void se_msi14(void);
void se_msi15(void);
void se_msi16(void);
void se_msi17(void);
void*se_ma195(int argc,...);
void*se_ma101(int argc,...);
void*se_ma106(int argc,...);
void*se_ma113(int argc,...);
void*se_ma313(int argc,...);
void*se_ma225(int argc,...);
void*se_ma322(int argc,...);
void*se_ma327(int argc,...);
void*se_ma232(int argc,...);
void*se_ma239(int argc,...);
void*se_ma242(int argc,...);
void*se_ma340(int argc,...);
void*se_ma60(int argc,...);
void*se_ma263(int argc,...);
void*se_ma75(int argc,...);
void*se_ma175(int argc,...);
void*se_ma80(int argc,...);
void*se_ma84(int argc,...);
void*se_ma284(int argc,...);
void*se_ma92(int argc,...);
void*se_ma189(int argc,...);
T2 X186rank(void *C);
void X218set_rescue_compound(void *C,T0* a1);
void X360force(void *C,T0* a1,T2 a2);
T2 X165arg_count(void *C);
T0* X165arguments(void *C);
T0* X165make_runnable(void *C,T0* a1,T0* a2,T0* a3);
T2 X45jvm_max_locals(void *C);
T2 X45jvm_argument_offset(void *C,T0* a1);
T6 X45is_deferred(void *C);
T2 X45static_value_mem(void *C);
T0* X45run_class(void *C);
T2 X45jvm_result_offset(void *C);
void X45vape_check_from(void *C,T0* a1);
void X45jvm_define(void *C);
T0* X45local_vars(void *C);
void X45afd_check(void *C);
T6 X45use_current(void *C);
void X45fall_down(void *C);
T0* X45arguments(void *C);
void X45mapping_jvm(void *C);
T6 X45is_static(void *C);
T6 X45is_exported_in(void *C,T0* a1);
T0* X45jvm_descriptor(void *C);
T2 X45jvm_local_variable_offset(void *C,T0* a1);
T0* X45clients(void *C);
T6 X45is_pre_computable(void *C);
T0* X45result_type(void *C);
void X45jvm_field_or_method(void *C);
T6 X45can_be_dropped(void *C);
T0* X45start_position(void *C);
T0* X241to_runnable_integer(void *C,T0* a1);
T0* X241to_runnable_character(void *C,T0* a1);
T0* X241twin(void *C);
T0* X204value(void *C,T2 a1);
T0* X204start_position(void *C);
T0* X144run_feature(void *C);
void X312append_in(void *C,T0* a1);
T2 X312count(void *C);
T6 X61fast_has(void *C,T0* a1);
void X61resize(void *C,T2 a1);
void X43set_output_name(void *C,T0* a1);
void X188set_rank(void *C,T2 a1);
T0* X188to_string(void *C);
T0* X188start_position(void *C);
T2 X120arg_count(void *C);
T0* X120arguments(void *C);
T0* X120run_feature(void *C);
void X316put(void *C,T0* a1,T2 a2);
T0* X306result_type(void *C);
T0* X306start_position(void *C);
void X58jvm_target_descriptor_in(void *C,T0* a1);
T6 X58is_any(void *C);
void X58jvm_xastore(void *C);
T6 X58is_string(void *C);
T0* X58generic_list(void *C);
T2 X58jvm_method_flags(void *C);
T2 X58id(void *C);
T0* X58smallest_ancestor(void *C,T0* a1);
T2 X58jvm_if_x_ne(void *C);
T6 X58is_like_current(void *C);
void X58jvm_check_class_invariant(void *C);
T6 X58is_array(void *C);
T0* X58base_class(void *C);
T6 X58is_double(void *C);
void X58jvm_write_local(void *C,T2 a1);
T6 X58is_none(void *C);
T0* X58look_up_for(void *C,T0* a1,T0* a2);
void X58jvm_descriptor_in(void *C,T0* a1);
T0* X58to_runnable(void *C,T0* a1);
T6 X58has_creation(void *C,T0* a1);
T6 X58is_pointer(void *C);
void X58jvm_standard_is_equal(void *C);
T0* X58static_base_class_name(void *C);
T6 X58is_a_in(void *C,T0* a1,T0* a2);
T0* X58run_time_mark(void *C);
T6 X58is_native_array(void *C);
T6 X58is_a(void *C,T0* a1);
T6 X58is_boolean(void *C);
T6 X58is_generic(void *C);
T0* X58run_class(void *C);
T6 X58is_like_feature(void *C);
void X58jvm_xnewarray(void *C);
T6 X58is_dummy_expanded(void *C);
void X58jvm_xaload(void *C);
void X58jvm_push_local(void *C,T2 a1);
T6 X58is_like_argument(void *C);
T2 X58jvm_push_default(void *C);
T0* X58run_type(void *C);
void X58jvm_return_code(void *C);
T6 X58is_expanded(void *C);
T2 X58jvm_convert_to(void *C,T0* a1);
T0* X58expanded_initializer(void *C);
T2 X58jvm_if_x_eq(void *C);
T6 X58is_basic_eiffel_expanded(void *C);
T6 X58is_formal_generic(void *C);
void X58used_as_reference(void *C);
T2 X58jvm_stack_space(void *C);
T6 X58is_character(void *C);
T2 X58jvm_expanded_from_reference(void *C,T0* a1);
T6 X58is_reference(void *C);
T0* X58written_mark(void *C);
T6 X58is_real(void *C);
T0* X58base_class_name(void *C);
T6 X58is_user_expanded(void *C);
T6 X58is_anchored(void *C);
T6 X58is_run_type(void *C);
T6 X58is_bit(void *C);
T0* X58start_position(void *C);
T6 X58is_integer(void *C);
T0* X269base_class(void *C);
T0* X164add_comment(void *C,T0* a1);
void X164afd_check(void *C);
T6 X164use_current(void *C);
T0* X164to_runnable(void *C,T0* a1);
void X164compile_to_jvm(void *C);
T6 X164is_pre_computable(void *C);
T0* X164start_position(void *C);
void X246set_current_type(void *C,T0* a1);
void X246afd_check(void *C);
T6 X246use_current(void *C);
T0* X246to_runnable(void *C,T0* a1);
void X293jvm_define_function(void *C,T0* a1,T0* a2,T0* a3);
void X293jvm_mapping_function(void *C,T0* a1,T0* a2,T0* a3);
void X293jvm_mapping_procedure(void *C,T0* a1,T0* a2,T0* a3);
T6 X293use_current(void *C,T0* a1);
void X293jvm_define_procedure(void *C,T0* a1,T0* a2,T0* a3);
void X293jvm_add_method_for_procedure(void *C,T0* a1,T0* a2,T0* a3);
void X293jvm_add_method_for_function(void *C,T0* a1,T0* a2,T0* a3);
T0* X121arguments(void *C);
T0* X121run_feature(void *C);
T0* X121start_position(void *C);
T0* X289result_type(void *C);
T0* X289start_position(void *C);
void X56declaration_in(void *C,T0* a1);
void X56undefine_in(void *C,T0* a1);
T0* X56origin_base_class(void *C);
T0* X56to_key(void *C);
T6 X56is_frozen(void *C);
T0* X56to_string(void *C);
T0* X56start_position(void *C);
void X154resize(void *C,T2 a1);
T0* X154twin(void *C);
void X366resize(void *C,T2 a1);
T0* X294start_position(void *C);
void X183add_last(void *C,T0* a1);
void X109compile_to_jvm_old(void *C);
T2 X109static_value(void *C);
T6 X109is_current(void *C);
T0* X109static_result_base_class(void *C);
void X109jvm_assign(void *C);
T6 X109is_manifest_string(void *C);
T0* X109add_comment(void *C,T0* a1);
void X109assertion_check(void *C,T3 a1);
T2 X109compile_to_jvm_into(void *C,T0* a1);
T2 X109jvm_branch_if_true(void *C);
void X109afd_check(void *C);
T6 X109is_result(void *C);
T6 X109use_current(void *C);
T0* X109to_runnable(void *C,T0* a1);
T2 X109to_integer(void *C);
T6 X109is_void(void *C);
void X109compile_to_jvm(void *C);
T6 X109is_static(void *C);
T6 X109is_pre_computable(void *C);
T2 X109isa_dca_inline_argument(void *C);
T0* X109result_type(void *C);
T2 X109jvm_branch_if_false(void *C);
T6 X109can_be_dropped(void *C);
T0* X109start_position(void *C);
void X109compile_target_to_jvm(void *C);
T2 X281jvm_push_default(void *C);
T2 X281nb(void *C);
T2 X281jvm_convert_to(void *C,T0* a1);
T0* X113twin(void *C);
void X94set_header_comment(void *C,T0* a1);
T0* X94ensure_assertion(void *C);
T6 X94is_deferred(void *C);
T6 X94is_merge_with(void *C,T0* a1,T0* a2);
T6 X94is_merge_with2aux(void *C,T0* a1,T0* a2);
T6 X94can_hide(void *C,T0* a1,T0* a2);
void X94add_into(void *C,T0* a1);
T0* X94try_to_undefine(void *C,T0* a1,T0* a2);
T0* X94require_assertion(void *C);
void X94check_obsolete(void *C,T0* a1);
T0* X94arguments(void *C);
T0* X94to_run_feature(void *C,T0* a1,T0* a2);
T0* X94result_type(void *C);
T0* X94start_position(void *C);

