/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A 1  T129  R CALL_PREFIX_NOT 129
D 2  T138  R ABSTRACT_RESULT 139,140
A 1  T140  R ORDINARY_RESULT 140
A 1  T163  R LOCAL_VAR_LIST 163
A 1  T188  E NATIVE_ARRAY[INTEGER_CONSTANT] 188
D 8  T199  R ROUTINE 292,291,289,288,277,276,273,271
A 1  T267  E NATIVE_ARRAY[FORMAL_GENERIC_ARG] 267
A*1  T244  R ARRAY[TYPE] 244
A*1  T43   R SMALL_EIFFEL 43
A*1  T365  R DICTIONARY[TYPE_REF_TO_EXP,STRING] 365
A*1  T360  R DICTIONARY[MANIFEST_STRING,STRING] 360
A*1  T265  R ARRAY[FORMAL_GENERIC_ARG] 265
A 1  T254  R TYPE_NONE 254
A 1  T203  R E_CHECK 203
A*1  T327  R ARRAY[RUN_FEATURE] 327
A*1  T303  R ARRAY[EXPORT_ITEM] 303
A*1  T294  R ARRAY[DECLARATION] 294
A 1  T170  R ARRAY[LOCAL_NAME1] 170
A*1  T72   R ARRAY[RENAME_PAIR] 72
A 1  T230  R LOOP_VARIANT_2 230
A*1  T93   R STRING_ALIASER 93
A 1  T126  R PREFIX_NAME 126
A 1  T258  R TYPE_CLASS 258
A 1  T114  R CALL_INFIX_EQ 114
A*1  T319  R DICTIONARY[RUN_CLASS,STRING] 319
A*1  T75   R DICTIONARY[E_FEATURE,STRING] 75
A 1  T318  E NATIVE_ARRAY[RUN_FEATURE] 318
A 1  T305  E NATIVE_ARRAY[EXPORT_ITEM] 305
A 1  T295  E NATIVE_ARRAY[DECLARATION] 295
A 1  T209  E NATIVE_ARRAY[INSTRUCTION] 209
A 1  T171  E NATIVE_ARRAY[LOCAL_NAME1] 171
A 1  T73   E NATIVE_ARRAY[RENAME_PAIR] 73
A 1  T106  R CALL_INFIX_AND 106
A*1  T37   R STD_OUTPUT 37
A*1  T352  R MEMO[E_OLD] 352
A 1  T247  E NATIVE_ARRAY[TYPE] 247
A 1  T6    E BOOLEAN 6
A 1  T366  R FIXED_ARRAY[TYPE_REF_TO_EXP] 366
A 1  T193  R FIXED_ARRAY[MANIFEST_STRING] 193
A*1  T17   R INTEGER_REF 17
A 1  T196  R CST_ATT_REAL 196
A*1  T80   R FEATURE_CLAUSE 80
A 1  T367  E NATIVE_ARRAY[TYPE_REF_TO_EXP] 367
A 1  T298  E NATIVE_ARRAY[LOCAL_ARGUMENT1] 298
A 1  T194  E NATIVE_ARRAY[MANIFEST_STRING] 194
A 1  T59   E NATIVE_ARRAY[CREATION_CLAUSE] 59
A 1  T104  R CALL_INFIX_OR 104
A*1  T53   R PARSER_BUFFER 53
A 1  T251  R TYPE_CHARACTER 251
A 1  T269  R REVERSE_ASSIGNMENT 269
A 1  T348  R PRECURSOR_NAME 348
A 1  T142  R WRITTEN_CURRENT 142
A 1  T299  R DECLARATION_1 299
A 1  T2    E INTEGER 2
A 1  T291  R ONCE_PROCEDURE 291
A*1  T183  R TMP_FEATURE 183
A*1  T85   R ASSERTION 85
A*1  T353  R MANIFEST_ARRAY_POOL 353
A*1  T78   R FORMAL_GENERIC_LIST 78
A*1  T79   R FEATURE_CLAUSE_LIST 79
A*1  T38   R ERROR_HANDLER 38
A*1  T65   R COMMENT 65
D 3  T146  R PROC_CALL 149,148,147
D 11 T313  R RUN_FEATURE 350,349,347,344,340,339,315,328,335,331,329
A 1  T3    E CHARACTER 3
A 1  T197  R CST_ATT_DOUBLE 197
A 1  T184  R CST_ATT_UNIQUE 184
A*1  T189  R COUNTER 189
A*1  T326  R FIXED_ARRAY[PARENT] 326
A*1  T24   R FIXED_ARRAY[STRING] 24
D 2  T222  R WHEN_ITEM 226,225
A 1  T8    E POINTER 8
A 1  T242  R TYPE_LIKE_CURRENT 242
A 1  T252  R TYPE_DOUBLE 252
A 1  T117  R CALL_INFIX_DIV 117
A 1  T131  R E_STRIP 131
A*1  T228  R LOOP_INVARIANT 228
A 1  T361  R IMPLICIT_CAST 361
A 1  T110  R CALL_INFIX_LT 110
A 1  T108  R CALL_INFIX_GT 108
A*1  T310  R STD_FILE_WRITE 310
A*1  T311  R FMT 311
A 1  T256  R TYPE_REAL 256
A*1  T332  R RUN_REQUIRE 332
A 1  T168  R LOCAL_NAME1 168
D 8  T185  R CST_ATT 198,191,195,190,192,184,197,196
A 1  T177  E NATIVE_ARRAY[ARGUMENT_NAME1] 177
A 1  T82   E NATIVE_ARRAY[FEATURE_CLAUSE] 82
A 1  T246  R TYPE_ARRAY 246
A 1  T279  R NATIVE_WITH_CURRENT 279
A 1  T158  R REAL_CONSTANT 158
A*1  T359  R MANIFEST_STRING_POOL 359
A 1  T286  R NATIVE_JVM_INVOKEVIRTUAL 286
A 1  T165  R LOCAL_NAME2 165
A*1  T356  R ADDRESS_OF_POOL 356
A 1  T249  R TYPE_BOOLEAN 249
A*1  T320  R FIXED_ARRAY[RUN_CLASS] 320
A*1  T76   R FIXED_ARRAY[E_FEATURE] 76
A*1  T354  R DICTIONARY[TYPE,INTEGER] 354
A 1  T257  R TYPE_STRING 257
A 1  T119  R CALL_INFIX_INT_DIV 119
A*1  T341  R ONCE_ROUTINE_POOL 341
A*1  T308  R ARRAY[INDEX_CLAUSE] 308
A 1  T243  R TYPE_LIKE_ARGUMENT 243
D 2  T293  R DECLARATION 299,296
A 3  T317  R FIXED_ARRAY[RUN_FEATURE] 345,342,317
A*1  T202  R FIXED_ARRAY[INSTRUCTION] 202
A 1  T278  R NATIVE_SMALL_EIFFEL 278
A 1  T273  R DEFERRED_FUNCTION 273
A 1  T192  R CST_ATT_STRING 192
A*1  T56   R CREATION_CLAUSE_LIST 56
A 1  T216  R E_RETRY 216
A*1  T35   R STD_ERROR 35
A 1  T95   R MANIFEST_ARRAY 95
A 1  T147  R PROC_CALL_0 147
A 1  T118  R CALL_INFIX_INT_REM 118
D 2  T169  R LOCAL_ARGUMENT1 175,168
A 1  T225  R WHEN_ITEM_1 225
A 1  T215  R EXPRESSION_WITH_COMMENT 215
A 1  T148  R PROC_CALL_1 148
A*1  T34   R ECHO 34
A 1  T271  R DEFERRED_PROCEDURE 271
A*1  T314  R RUN_CLASS 314
A 1  T232  R CREATION_CALL_1 232
A 1  T217  R E_INSPECT 217
A 1  T136  R CALL_1_C 136
A 1  T134  R CALL_0_C 134
A*1  T219  R WHEN_LIST 219
D 2  T297  R ARRAY[LOCAL_ARGUMENT1] 176,170
A 1  T206  R ARRAY[MANIFEST_STRING] 206
A*1  T58   R ARRAY[CREATION_CLAUSE] 58
A 1  T111  R CALL_INFIX_LE 111
A 1  T109  R CALL_INFIX_GE 109
D 4  T287  R EFFECTIVE_ROUTINE 292,288,289,291
A 1  T226  R WHEN_ITEM_2 226
A*1  T201  R COMPOUND 201
A 1  T41   E NATIVE_ARRAY[POSITION] 41
D 22 T63   R TYPE 364,323,266,263,261,260,259,258,257,256,255,254,253,252,251,249,248,246,245,243,242,240
A 1  T144  R ADDRESS_OF 144
A 1  T284  R NATIVE_JVM_INVOKESTATIC 284
A 1  T329  R RUN_FEATURE_1 329
A*1  T30   R STD_FILE_READ 30
A 1  T296  R DECLARATION_GROUP 296
A 1  T157  R BIT_CONSTANT 157
A 1  T207  R IFTHENELSE 207
A*1  T55   R RUN_CONTROL 55
A 1  T266  R TYPE_FORMAL_GENERIC 266
A 1  T358  E NATIVE_ARRAY[ADDRESS_OF] 358
A 1  T182  E NATIVE_ARRAY[CLASS_NAME] 182
A 1  T96   E NATIVE_ARRAY[EXPRESSION] 96
A 1  T49   E NATIVE_ARRAY[BASE_CLASS] 49
A 1  T235  R CREATION_CALL_2 235
A*1  T302  R EXPORT_ITEM 302
A*1  T90   R TAG_NAME 90
A 1  T346  E NATIVE_ARRAY[RUN_FEATURE_6] 346
A 1  T343  E NATIVE_ARRAY[RUN_FEATURE_5] 343
A*1  T200  R E_ENSURE 200
A*1  T50   R CLASS_NAME 50
A 1  T255  R TYPE_POINTER 255
A 1  T253  R TYPE_INTEGER 253
A*1  T29   R SYSTEM_TOOLS 29
A 1  T347  R RUN_FEATURE_2 347
A 1  T122  R INFIX_NAME 122
D 6  T250  R TYPE_BASIC_EIFFEL_EXPANDED 253,255,249,256,252,251
A 1  T105  R CALL_INFIX_OR_ELSE 105
D 17 T145  R INSTRUCTION 269,268,239,237,235,232,229,217,216,207,210,205,203,162,149,148,147
A*1  T46   R FIXED_ARRAY[INTEGER] 46
A 1  T260  R TYPE_EXPANDED 260
A 1  T277  R EXTERNAL_FUNCTION 277
A 1  T107  R CALL_INFIX_AND_THEN 107
A 1  T132  R SIMPLE_FEATURE_NAME 132
A 1  T149  R PROC_CALL_N 149
A*1  T92   R TMP_NAME 92
A 1  T301  R FROZEN_FEATURE_NAME 301
A 1  T237  R CREATION_CALL_3 237
D 2  T227  R LOOP_VARIANT 231,230
A 1  T315  R RUN_FEATURE_3 315
A*1  T71   R RENAME_PAIR 71
D 7  T274  R NATIVE 286,284,283,282,281,279,278
A 1  T300  R WRITABLE_ATTRIBUTE 300
A 1  T276  R EXTERNAL_PROCEDURE 276
A 1  T345  R FIXED_ARRAY[RUN_FEATURE_6] 345
A 1  T342  R FIXED_ARRAY[RUN_FEATURE_5] 342
A 1  T141  R E_VOID 141
A 1  T339  R RUN_FEATURE_4 339
A 1  T239  R CREATION_CALL_4 239
A 1  T162  R E_PRECURSOR_PROCEDURE 162
A*1  T83   R CLIENT_LIST 83
A*1  T7    R STRING 7
D 2  T270  R DEFERRED_ROUTINE 271,273
A 1  T152  R E_TRUE 152
A 1  T221  E NATIVE_ARRAY[E_WHEN] 221
A 1  T214  E NATIVE_ARRAY[IFTHEN] 214
A 1  T64   E NATIVE_ARRAY[PARENT] 64
A 1  T25   E NATIVE_ARRAY[STRING] 25
A 1  T121  R CALL_INFIX_FREEOP 121
A 1  T289  R FUNCTION 289
A 1  T130  R E_OLD 130
A*1  T211  R IFTHEN 211
A 1  T190  R CST_ATT_BOOLEAN 190
A*1  T69   R RENAME_LIST 69
A 1  T283  R NATIVE_INLINE_WITHOUT_CURRENT 283
D 2  T161  R E_PRECURSOR 160,162
A*1  T60   R PARENT_LIST 60
A 1  T340  R RUN_FEATURE_5 340
A 1  T137  R CALL_N 137
A*1  T84   R ID_PROVIDER 84
A 1  T123  R CALL_PREFIX_FREEOP 123
A*1  T40   R POSITION 40
A*1  T264  R FORMAL_GENERIC_ARG 264
A*1  T362  R ARRAY[BOOLEAN] 362
A*1  T156  R ARRAY[INTEGER] 156
A*1  T218  R E_WHEN 218
A 1  T248  R TYPE_NATIVE_ARRAY 248
D 5  T66   R FEATURE_NAME 348,301,132,122,126
A 1  T139  R ONCE_RESULT 139
A*1  T306  R INDEX_CLAUSE 306
A 1  T344  R RUN_FEATURE_6 344
A 1  T229  R E_LOOP 229
A*1  T61   R PARENT 61
A 1  T195  R CST_ATT_BIT 195
A 1  T160  R E_PRECURSOR_FUNCTION 160
A 1  T325  E NATIVE_ARRAY[TYPE_BIT_REF] 325
A 1  T309  E NATIVE_ARRAY[INDEX_CLAUSE] 309
A 1  T70   E NATIVE_ARRAY[FEATURE_NAME] 70
A*1  T304  R EXPORT_LIST 304
A*1  T220  R ARRAY[E_WHEN] 220
A*1  T213  R ARRAY[IFTHEN] 213
A*1  T62   R ARRAY[PARENT] 62
A*1  T33   R ARRAY[STRING] 33
A*1  T333  R ARRAY[E_REQUIRE] 333
A*1  T322  R ARRAY[RUN_CLASS] 322
A*1  T223  R ARRAY[WHEN_ITEM] 223
A*1  T86   R ARRAY[ASSERTION] 86
D 2  T290  R ONCE_ROUTINE 292,291
A 1  T281  R NATIVE_INLINE_WITH_CURRENT 281
A 1  T335  R RUN_FEATURE_7 335
A 1  T259  R TYPE_GENERIC 259
A 1  T357  R FIXED_ARRAY[ADDRESS_OF] 357
A*1  T181  R FIXED_ARRAY[CLASS_NAME] 181
A 4  T135  R FIXED_ARRAY[EXPRESSION] 357,193,187,135
A*1  T48   R FIXED_ARRAY[BASE_CLASS] 48
A 3  T355  R FIXED_ARRAY[TYPE] 366,355,324
D 2  T275  R EXTERNAL_ROUTINE 276,277
D 2  T164  R DECLARATION_LIST 172,163
A 1  T240  R TYPE_LIKE_FEATURE 240
D 51 T89   R EXPRESSION 361,175,168,215,97,103,104,105,106,107,108,110,109,111,112,114,115,116,117,118,119,120,179,121,130,178,173,165,160,159,158,157,155,154,153,152,144,142,141,140,139,137,136,134,132,131,123,127,128,129,95
A 1  T179  R CALL_INFIX_POWER 179
A*1  T316  R DICTIONARY[RUN_FEATURE,STRING] 316
A 1  T328  R RUN_FEATURE_8 328
A*1  T10   R PRETTY 10
A*1  T336  R EXCEPTIONS_HANDLER 336
D 2  T262  R TYPE_BIT 263,261
A*1  T57   R CREATION_CLAUSE 57
A 1  T175  R ARGUMENT_NAME1 175
A*1  T204  R CHECK_INVARIANT 204
A*1  T39   R FIXED_ARRAY[POSITION] 39
A 4  T94   R ARRAY[EXPRESSION] 176,170,206,94
A 1  T331  R RUN_FEATURE_9 331
A 1  T210  R INSTRUCTION_WITH_COMMENT 210
A*1  T337  R C_PRETTY_PRINTER 337
A*1  T133  R EFFECTIVE_ARG_LIST 133
A 1  T128  R CALL_PREFIX_PLUS 128
A 1  T120  R CALL_INFIX_TIMES 120
A 1  T115  R CALL_INFIX_MINUS 115
A*1  T54   R DICTIONARY[STRING,STRING] 54
A 1  T191  R CST_ATT_CHARACTER 191
A 1  T112  R CALL_INFIX_NEQ 112
A 1  T364  R TYPE_REF_TO_EXP 364
D 17 T74   R E_FEATURE 300,292,291,289,288,277,276,273,271,198,197,196,195,192,191,190,184
A 1  T334  E NATIVE_ARRAY[E_REQUIRE] 334
A 1  T321  E NATIVE_ARRAY[RUN_CLASS] 321
A 1  T224  E NATIVE_ARRAY[WHEN_ITEM] 224
A 1  T91   E NATIVE_ARRAY[ASSERTION] 91
A 1  T77   E NATIVE_ARRAY[E_FEATURE] 77
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T127  R CALL_PREFIX_MINUS 127
A*1  T45   R DICTIONARY[BASE_CLASS,STRING] 45
A 1  T323  R TYPE_BIT_REF 323
A 1  T324  R FIXED_ARRAY[TYPE_BIT_REF] 324
A*1  T68   R FIXED_ARRAY[FEATURE_NAME] 68
A 1  T154  R CHARACTER_CONSTANT 154
D 2  T150  R BOOLEAN_CONSTANT 153,152
A 1  T173  R ARGUMENT_NAME2 173
A 1  T288  R PROCEDURE 288
A 1  T198  R CST_ATT_INTEGER 198
A 1  T116  R CALL_INFIX_PLUS 116
A 1  T349  R RUN_FEATURE_10 349
A*1  T212  R IFTHENLIST 212
A*1  T42   R BASE_CLASS 42
A 1  T292  R ONCE_FUNCTION 292
A 1  T187  R FIXED_ARRAY[INTEGER_CONSTANT] 187
A 1  T245  R TYPE_ANY 245
A 1  T312  E FILE_TOOLS 312
A 1  T261  R TYPE_BIT_1 261
A 1  T159  R INTEGER_CONSTANT 159
A 1  T268  R ASSIGNMENT 268
A 1  T153  R E_FALSE 153
A*1  T307  R INDEX_LIST 307
A 1  T103  R CALL_INFIX_XOR 103
A*1  T67   R FEATURE_NAME_LIST 67
A 1  T205  R E_DEBUG 205
A 1  T176  R ARRAY[ARGUMENT_NAME1] 176
A*1  T81   R ARRAY[FEATURE_CLAUSE] 81
A 1  T155  R MANIFEST_STRING 155
A 1  T172  R FORMAL_ARG_LIST 172
A 1  T178  R IMPLICIT_CURRENT 178
A 1  T97   R CALL_INFIX_IMPLIES 97
A*1  T180  R CLASS_NAME_LIST 180
A*1  T87   R CLASS_INVARIANT 87
A*1  T272  R E_REQUIRE 272
A 1  T263  R TYPE_BIT_2 263
A 1  T363  E NATIVE_ARRAY[BOOLEAN] 363
A 1  T47   E NATIVE_ARRAY[INTEGER] 47
A 1  T231  R LOOP_VARIANT_1 231
A 1  T350  R RUN_FEATURE_11 350
A*1  T52   R EIFFEL_PARSER 52
A*1  T330  R ASSERTION_COLLECTOR 330
A 1  T282  R NATIVE_WITHOUT_CURRENT 282
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S129 T129;
typedef struct S140 T140;
typedef struct S163 T163;
typedef struct S159 T159;
typedef struct S264 T264;
typedef struct S244 T244;
typedef struct S43 T43;
typedef struct S365 T365;
typedef struct S360 T360;
typedef struct S265 T265;
typedef struct S254 T254;
typedef struct S203 T203;
typedef struct S327 T327;
typedef struct S303 T303;
typedef struct S294 T294;
typedef struct S170 T170;
typedef struct S72 T72;
typedef struct S230 T230;
typedef void*T93;
typedef struct S126 T126;
typedef struct S258 T258;
typedef struct S114 T114;
typedef struct S319 T319;
typedef struct S75 T75;
typedef struct S302 T302;
typedef struct S168 T168;
typedef struct S71 T71;
typedef struct S106 T106;
typedef void*T37;
typedef struct S352 T352;
typedef struct S366 T366;
typedef struct S193 T193;
typedef struct S17 T17;
typedef struct S196 T196;
typedef struct S80 T80;
typedef struct S364 T364;
typedef struct S155 T155;
typedef struct S57 T57;
typedef struct S104 T104;
typedef struct S53 T53;
typedef struct S251 T251;
typedef struct S269 T269;
typedef struct S348 T348;
typedef struct S142 T142;
typedef struct S299 T299;
typedef struct S291 T291;
typedef struct S183 T183;
typedef struct S85 T85;
typedef void*T353;
typedef struct S78 T78;
typedef struct S79 T79;
typedef struct S38 T38;
typedef struct S65 T65;
typedef struct S197 T197;
typedef struct S184 T184;
typedef struct S189 T189;
typedef struct S326 T326;
typedef struct S24 T24;
typedef struct S242 T242;
typedef struct S252 T252;
typedef struct S117 T117;
typedef struct S131 T131;
typedef struct S228 T228;
typedef struct S361 T361;
typedef struct S110 T110;
typedef struct S108 T108;
typedef struct S310 T310;
typedef struct S311 T311;
typedef struct S256 T256;
typedef struct S332 T332;
typedef struct S175 T175;
typedef struct S246 T246;
typedef struct S279 T279;
typedef struct S158 T158;
typedef void*T359;
typedef struct S286 T286;
typedef struct S165 T165;
typedef void*T356;
typedef struct S249 T249;
typedef struct S320 T320;
typedef struct S76 T76;
typedef struct S354 T354;
typedef struct S257 T257;
typedef struct S119 T119;
typedef void*T341;
typedef struct S308 T308;
typedef struct S243 T243;
typedef struct S317 T317;
typedef struct S202 T202;
typedef struct S278 T278;
typedef struct S273 T273;
typedef struct S192 T192;
typedef struct S56 T56;
typedef struct S216 T216;
typedef void*T35;
typedef struct S95 T95;
typedef struct S147 T147;
typedef struct S118 T118;
typedef struct S225 T225;
typedef struct S215 T215;
typedef struct S148 T148;
typedef struct S34 T34;
typedef struct S271 T271;
typedef struct S314 T314;
typedef struct S232 T232;
typedef struct S217 T217;
typedef struct S136 T136;
typedef struct S134 T134;
typedef struct S219 T219;
typedef struct S206 T206;
typedef struct S58 T58;
typedef struct S111 T111;
typedef struct S109 T109;
typedef struct S226 T226;
typedef struct S201 T201;
typedef struct S40 T40;
typedef struct S144 T144;
typedef struct S284 T284;
typedef struct S329 T329;
typedef struct S30 T30;
typedef struct S296 T296;
typedef struct S157 T157;
typedef struct S207 T207;
typedef struct S55 T55;
typedef struct S266 T266;
typedef struct S50 T50;
typedef struct S42 T42;
typedef struct S235 T235;
typedef struct S90 T90;
typedef struct S344 T344;
typedef struct S340 T340;
typedef struct S200 T200;
typedef struct S255 T255;
typedef struct S253 T253;
typedef struct S29 T29;
typedef struct S347 T347;
typedef struct S122 T122;
typedef struct S105 T105;
typedef struct S46 T46;
typedef struct S260 T260;
typedef struct S277 T277;
typedef struct S107 T107;
typedef struct S132 T132;
typedef struct S149 T149;
typedef struct S92 T92;
typedef struct S301 T301;
typedef struct S237 T237;
typedef struct S315 T315;
typedef struct S300 T300;
typedef struct S276 T276;
typedef struct S345 T345;
typedef struct S342 T342;
typedef struct S141 T141;
typedef struct S339 T339;
typedef struct S239 T239;
typedef struct S162 T162;
typedef struct S83 T83;
typedef struct S7 T7;
typedef struct S152 T152;
typedef struct S218 T218;
typedef struct S211 T211;
typedef struct S61 T61;
typedef struct S121 T121;
typedef struct S289 T289;
typedef struct S130 T130;
typedef struct S190 T190;
typedef struct S69 T69;
typedef struct S283 T283;
typedef struct S60 T60;
typedef struct S137 T137;
typedef struct S84 T84;
typedef struct S123 T123;
typedef struct S362 T362;
typedef struct S156 T156;
typedef struct S248 T248;
typedef struct S139 T139;
typedef struct S306 T306;
typedef struct S229 T229;
typedef struct S195 T195;
typedef struct S160 T160;
typedef struct S323 T323;
typedef struct S304 T304;
typedef struct S220 T220;
typedef struct S213 T213;
typedef struct S62 T62;
typedef struct S33 T33;
typedef struct S333 T333;
typedef struct S322 T322;
typedef struct S223 T223;
typedef struct S86 T86;
typedef struct S281 T281;
typedef struct S335 T335;
typedef struct S259 T259;
typedef struct S357 T357;
typedef struct S181 T181;
typedef struct S135 T135;
typedef struct S48 T48;
typedef struct S355 T355;
typedef struct S240 T240;
typedef struct S179 T179;
typedef struct S316 T316;
typedef struct S328 T328;
typedef struct S10 T10;
typedef struct S336 T336;
typedef struct S204 T204;
typedef struct S39 T39;
typedef struct S94 T94;
typedef struct S331 T331;
typedef struct S210 T210;
typedef struct S337 T337;
typedef struct S133 T133;
typedef struct S128 T128;
typedef struct S120 T120;
typedef struct S115 T115;
typedef struct S54 T54;
typedef struct S191 T191;
typedef struct S112 T112;
typedef struct S272 T272;
typedef struct S127 T127;
typedef struct S45 T45;
typedef struct S324 T324;
typedef struct S68 T68;
typedef struct S154 T154;
typedef struct S173 T173;
typedef struct S288 T288;
typedef struct S198 T198;
typedef struct S116 T116;
typedef struct S349 T349;
typedef struct S212 T212;
typedef struct S292 T292;
typedef struct S187 T187;
typedef struct S245 T245;
typedef int T312;
typedef struct S261 T261;
typedef struct S268 T268;
typedef struct S153 T153;
typedef struct S307 T307;
typedef struct S103 T103;
typedef struct S67 T67;
typedef struct S205 T205;
typedef struct S176 T176;
typedef struct S81 T81;
typedef struct S172 T172;
typedef struct S178 T178;
typedef struct S97 T97;
typedef struct S180 T180;
typedef struct S87 T87;
typedef struct S263 T263;
typedef struct S231 T231;
typedef struct S350 T350;
typedef struct S52 T52;
typedef struct S330 T330;
typedef struct S282 T282;

/*C Header Pass 2 :*/
typedef T0**T188;
typedef T0**T267;
typedef T0**T318;
typedef T0**T305;
typedef T0**T295;
typedef T0**T209;
typedef T0**T171;
typedef T0**T73;
typedef T0**T247;
typedef T0**T367;
typedef T0**T298;
typedef T0**T194;
typedef T0**T59;
typedef T0**T177;
typedef T0**T82;
typedef T0**T41;
typedef T0**T358;
typedef T0**T182;
typedef T0**T96;
typedef T0**T49;
typedef T0**T346;
typedef T0**T343;
typedef T0**T221;
typedef T0**T214;
typedef T0**T64;
typedef T0**T25;
typedef T0**T325;
typedef T0**T309;
typedef T0**T70;
typedef T0**T334;
typedef T0**T321;
typedef T0**T224;
typedef T0**T91;
typedef T0**T77;
typedef T3*T9;
typedef T6*T363;
typedef T2*T47;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S129{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T129 M129;
struct S140{int id;T0* _start_position;T0* _run_feature;};
extern T140 M140;
struct S163{int id;T0* _list;T0* _flat_list;};
extern T163 M163;
struct S244{T247 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T244 M244;
struct S43{T6 _short_flag;T6 _pretty_flag;T2 _magic_count;T2 _top;};
extern T43 M43;
struct S365{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T365 M365;
struct S360{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T360 M360;
struct S265{T267 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T265 M265;
struct S254{int id;T0* _base_class_name;};
extern T254 M254;
struct S203{int id;T0* _check_invariant;T0* _current_type;};
extern T203 M203;
struct S327{T318 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T327 M327;
struct S303{T305 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T303 M303;
struct S294{T295 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T294 M294;
struct S170{int id;T171 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T170 M170;
struct S72{T73 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T72 M72;
struct S230{int id;T0* _comment;T0* _expression;T0* _current_type;T0* _tag;};
extern T230 M230;
extern T93 M93;
struct S126{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T126 M126;
struct S258{int id;T0* _base_class_name;};
extern T258 M258;
struct S114{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T114 M114;
struct S319{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T319 M319;
struct S75{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T75 M75;
struct S106{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T106 M106;
extern T37 M37;
struct S352{T0* _item;};
extern T352 M352;
struct S366{int id;T367 _storage;T2 _capacity;T2 _upper;};
extern T366 M366;
struct S193{int id;T194 _storage;T2 _capacity;T2 _upper;};
extern T193 M193;
struct S17{T2 _item;};
extern T17 M17;
struct S196{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T196 M196;
struct S80{T0* _clients;T0* _comment;T0* _list;};
extern T80 M80;
struct S104{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T104 M104;
struct S53{T0* _path;T2 _count;};
extern T53 M53;
struct S251{int id;T0* _base_class_name;};
extern T251 M251;
struct S269{int id;T0* _left_side;T0* _right_side;T0* _current_type;};
extern T269 M269;
struct S348{int id;T0* _enclosing;T0* _to_key;};
extern T348 M348;
struct S142{int id;T0* _start_position;T0* _result_type;};
extern T142 M142;
struct S299{int id;T0* _name;};
extern T299 M299;
struct S291{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T291 M291;
struct S183{T0* _arguments;T0* _type;T0* _header_comment;T0* _obsolete_mark;T0* _require_assertion;T0* _local_vars;T0* _routine_body;};
extern T183 M183;
struct S85{T0* _tag;T0* _expression;T0* _comment;T0* _current_type;};
extern T85 M85;
extern T353 M353;
struct S78{T0* _start_position;T0* _list;};
extern T78 M78;
struct S79{T0* _list;};
extern T79 M79;
struct S38{T2 _error_counter;T2 _warning_counter;T6 _no_warning;};
extern T38 M38;
struct S65{T0* _start_position;T0* _list;};
extern T65 M65;
struct S197{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T197 M197;
struct S184{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _values;};
extern T184 M184;
struct S189{T2 _value;};
extern T189 M189;
struct S326{T64 _storage;T2 _capacity;T2 _upper;};
extern T326 M326;
struct S24{T25 _storage;T2 _capacity;T2 _upper;};
extern T24 M24;
struct S242{int id;T0* _start_position;T0* _run_type;};
extern T242 M242;
struct S252{int id;T0* _base_class_name;};
extern T252 M252;
struct S117{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T117 M117;
struct S131{int id;T0* _start_position;T0* _current_type;T0* _list;T0* _result_type_memory;};
extern T131 M131;
struct S228{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T228 M228;
struct S361{int id;T0* _expression;T0* _result_type;};
extern T361 M361;
struct S110{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T110 M110;
struct S108{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T108 M108;
struct S310{T0* _path;T8 _output_stream;};
extern T310 M310;
struct S311{T0* _sfw;T2 _mode;T2 _column;T2 _line;T2 _blank_lines;T3 _last_character;T2 _indent_level;T6 _semi_colon_flag;};
extern T311 M311;
struct S256{int id;T0* _base_class_name;};
extern T256 M256;
struct S332{T0* _list;};
extern T332 M332;
struct S168{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;T6 _is_used;};
extern T168 M168;
struct S246{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T246 M246;
struct S279{int id;};
extern T279 M279;
struct S158{int id;T0* _start_position;T0* _to_string;};
extern T158 M158;
extern T359 M359;
struct S286{int id;};
extern T286 M286;
struct S165{int id;T0* _start_position;T2 _rank;T0* _local_var_list;};
extern T165 M165;
extern T356 M356;
struct S249{int id;T0* _base_class_name;};
extern T249 M249;
struct S320{T321 _storage;T2 _capacity;T2 _upper;};
extern T320 M320;
struct S76{T77 _storage;T2 _capacity;T2 _upper;};
extern T76 M76;
struct S354{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T354 M354;
struct S257{int id;T0* _base_class_name;};
extern T257 M257;
struct S119{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T119 M119;
extern T341 M341;
struct S308{T309 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T308 M308;
struct S243{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_feature;};
extern T243 M243;
struct S317{int id;T318 _storage;T2 _capacity;T2 _upper;};
extern T317 M317;
struct S202{T209 _storage;T2 _capacity;T2 _upper;};
extern T202 M202;
struct S278{int id;};
extern T278 M278;
struct S273{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _result_type;};
extern T273 M273;
struct S192{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _first_value;T0* _remainder;};
extern T192 M192;
struct S56{T0* _list;};
extern T56 M56;
struct S216{int id;T0* _start_position;T0* _run_feature;};
extern T216 M216;
extern T35 M35;
struct S95{int id;T0* _start_position;T0* _list;T0* _result_type;T0* _current_type;};
extern T95 M95;
struct S147{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T147 M147;
struct S118{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T118 M118;
struct S225{int id;T0* _e_when;T0* _expression;T2 _expression_value;};
extern T225 M225;
struct S215{int id;T0* _expression;T0* _comment;};
extern T215 M215;
struct S148{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T148 M148;
struct S34{T6 _verbose;};
extern T34 M34;
struct S271{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;};
extern T271 M271;
struct S314{T0* _current_type;T2 _id;T6 _at_run_time;T0* _running;T6 _compile_to_c_done;T0* _feature_dictionary;T0* _actuals_clients;T6 _strip_used;};
extern T314 M314;
struct S232{int id;T0* _start_position;T0* _writable;T0* _current_type;};
extern T232 M232;
struct S217{int id;T0* _start_position;T0* _expression;T0* _when_list;T0* _else_position;T0* _else_compound;T0* _current_type;};
extern T217 M217;
struct S136{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T136 M136;
struct S134{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T134 M134;
struct S219{T0* _e_inspect;T0* _list;};
extern T219 M219;
struct S206{int id;T194 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T206 M206;
struct S58{T59 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T58 M58;
struct S111{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T111 M111;
struct S109{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T109 M109;
struct S226{int id;T0* _e_when;T0* _upper;T0* _lower;T2 _lower_value;T2 _upper_value;};
extern T226 M226;
struct S201{T0* _header_comment;T0* _current_type;T0* _first_one;T0* _remainder;};
extern T201 M201;
struct S144{int id;T0* _feature_name;T0* _current_type;T0* _run_feature;};
extern T144 M144;
struct S284{int id;};
extern T284 M284;
struct S329{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _value;T0* _result_type;};
extern T329 M329;
struct S30{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T30 M30;
struct S296{int id;T0* _name_list;};
extern T296 M296;
struct S157{int id;T0* _start_position;T0* _value;T0* _result_type;T0* _hexa;};
extern T157 M157;
struct S207{int id;T0* _start_position;T0* _ifthenlist;T0* _else_compound;T0* _current_type;};
extern T207 M207;
struct S55{T2 _level;T6 _generating_type_used;T6 _generator_used;};
extern T55 M55;
struct S266{int id;T0* _formal_name;T2 _rank;T0* _run_type;};
extern T266 M266;
struct S235{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _type;};
extern T235 M235;
struct S302{T0* _clients;T0* _list;};
extern T302 M302;
struct S90{T0* _to_string;T0* _start_position;};
extern T90 M90;
struct S200{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_ensure_then;};
extern T200 M200;
struct S50{T0* _to_string;T0* _start_position;};
extern T50 M50;
struct S255{int id;T0* _base_class_name;};
extern T255 M255;
struct S253{int id;T0* _base_class_name;};
extern T253 M253;
struct S29{T0* _system_name;T0* _sys_directory;T0* _bin_directory;};
extern T29 M29;
struct S347{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _result_type;};
extern T347 M347;
struct S122{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T122 M122;
struct S105{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T105 M105;
struct S46{T47 _storage;T2 _capacity;T2 _upper;};
extern T46 M46;
struct S260{int id;T0* _start_position;T0* _written_mark;T0* _mapped;T0* _run_time_mark;T0* _run_type;};
extern T260 M260;
struct S277{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;T0* _result_type;};
extern T277 M277;
struct S107{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T107 M107;
struct S132{int id;T0* _to_string;T0* _start_position;T0* _run_feature_2;};
extern T132 M132;
struct S149{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T149 M149;
struct S92{T2 _column;T2 _line;T0* _aliased_string_memory;};
extern T92 M92;
struct S301{int id;T0* _feature_name;};
extern T301 M301;
struct S237{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _call;};
extern T237 M237;
struct S315{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T315 M315;
struct S71{T0* _new_name;T0* _old_name;};
extern T71 M71;
struct S300{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;};
extern T300 M300;
struct S276{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;};
extern T276 M276;
struct S345{int id;T346 _storage;T2 _capacity;T2 _upper;};
extern T345 M345;
struct S342{int id;T343 _storage;T2 _capacity;T2 _upper;};
extern T342 M342;
struct S141{int id;T0* _start_position;};
extern T141 M141;
struct S339{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T339 M339;
struct S239{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _type;T0* _call;};
extern T239 M239;
struct S162{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T162 M162;
struct S83{T0* _start_position;T0* _list;};
extern T83 M83;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S152{int id;T0* _start_position;};
extern T152 M152;
struct S121{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T121 M121;
struct S289{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T289 M289;
struct S130{int id;T0* _expression;T0* _current_type;};
extern T130 M130;
struct S211{T0* _expression;T0* _then_compound;T0* _current_type;};
extern T211 M211;
struct S190{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T190 M190;
struct S69{T0* _list;};
extern T69 M69;
struct S283{int id;};
extern T283 M283;
struct S60{T0* _base_class;T0* _start_position;T0* _heading_comment;T0* _list;};
extern T60 M60;
struct S340{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T340 M340;
struct S137{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T137 M137;
struct S84{T0* _mem_id;T0* _mem_str;};
extern T84 M84;
struct S123{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T123 M123;
struct S40{T0* _base_class_name;T2 _mem_line_column;};
extern T40 M40;
struct S264{T0* _name;T0* _constraint;};
extern T264 M264;
struct S362{T363 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T362 M362;
struct S156{T47 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T156 M156;
struct S218{T0* _start_position;T0* _list;T0* _header_comment;T0* _compound;T0* _when_list;T0* _values;};
extern T218 M218;
struct S248{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type;};
extern T248 M248;
struct S139{int id;T0* _start_position;T0* _run_feature_6;};
extern T139 M139;
struct S306{T0* _tag;T0* _list;};
extern T306 M306;
struct S344{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T344 M344;
struct S229{int id;T0* _start_position;T0* _initialize;T0* _invariant_clause;T0* _variant_clause;T0* _until_expression;T0* _loop_body;T0* _current_type;};
extern T229 M229;
struct S61{T0* _parent_list;T0* _type;T0* _comment;T0* _rename_list;T0* _export_list;T0* _undefine_list;T0* _redefine_list;T0* _select_list;T0* _undefine_memory1;T0* _undefine_memory2;};
extern T61 M61;
struct S195{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T195 M195;
struct S160{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T160 M160;
struct S304{T0* _start_position;T0* _items;};
extern T304 M304;
struct S220{T221 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T220 M220;
struct S213{T214 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T213 M213;
struct S62{T64 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T62 M62;
struct S33{T25 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T33 M33;
struct S333{T334 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T333 M333;
struct S322{T321 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T322 M322;
struct S223{T224 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T223 M223;
struct S86{T91 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T86 M86;
struct S281{int id;};
extern T281 M281;
struct S335{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _ensure_assertion;};
extern T335 M335;
struct S259{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T259 M259;
struct S357{int id;T358 _storage;T2 _capacity;T2 _upper;};
extern T357 M357;
struct S181{T182 _storage;T2 _capacity;T2 _upper;};
extern T181 M181;
struct S135{int id;T96 _storage;T2 _capacity;T2 _upper;};
extern T135 M135;
struct S48{T49 _storage;T2 _capacity;T2 _upper;};
extern T48 M48;
struct S355{int id;T247 _storage;T2 _capacity;T2 _upper;};
extern T355 M355;
struct S240{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_type;};
extern T240 M240;
struct S179{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T179 M179;
struct S316{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T316 M316;
struct S328{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T328 M328;
struct S10{T2 _state;T0* _style;};
extern T10 M10;
struct S336{T6 _used;};
extern T336 M336;
struct S57{T0* _start_position;T0* _clients;T0* _comment;T0* _procedure_list;};
extern T57 M57;
struct S175{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;};
extern T175 M175;
struct S204{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T204 M204;
struct S39{T41 _storage;T2 _capacity;T2 _upper;};
extern T39 M39;
struct S94{int id;T96 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T94 M94;
struct S331{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T331 M331;
struct S210{int id;T0* _instruction;T0* _comment;};
extern T210 M210;
struct S337{T6 _basic_directory_used;};
extern T337 M337;
struct S133{T0* _first_one;T0* _remainder;T0* _current_type;};
extern T133 M133;
struct S128{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T128 M128;
struct S120{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T120 M120;
struct S115{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T115 M115;
struct S54{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T54 M54;
struct S191{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T191 M191;
struct S112{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T112 M112;
struct S364{int id;T0* _run_class;T0* _written_mark;T0* _expanded_type;};
extern T364 M364;
struct S127{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T127 M127;
struct S45{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T45 M45;
struct S323{int id;T0* _type_bit;T0* _written_mark;T0* _run_time_mark;};
extern T323 M323;
struct S324{int id;T325 _storage;T2 _capacity;T2 _upper;};
extern T324 M324;
struct S68{T70 _storage;T2 _capacity;T2 _upper;};
extern T68 M68;
struct S154{int id;T0* _start_position;T3 _value;T2 _pretty_print_mode;};
extern T154 M154;
struct S173{int id;T0* _start_position;T2 _rank;T0* _formal_arg_list;};
extern T173 M173;
struct S288{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T288 M288;
struct S198{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T198 M198;
struct S116{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T116 M116;
struct S349{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T349 M349;
struct S212{T0* _list;T0* _current_type;};
extern T212 M212;
struct S42{T2 _id;T0* _path;T0* _index_list;T0* _heading_comment1;T6 _is_deferred;T6 _is_expanded;T0* _name;T0* _formal_generic_list;T0* _heading_comment2;T0* _obsolete_type_string;T0* _parent_list;T0* _creation_clause_list;T0* _feature_clause_list;T0* _class_invariant;T0* _end_comment;T0* _feature_dictionary;T0* _isom;};
extern T42 M42;
struct S292{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T292 M292;
struct S187{int id;T188 _storage;T2 _capacity;T2 _upper;};
extern T187 M187;
struct S245{int id;T0* _base_class_name;};
extern T245 M245;
extern T312 M312;
struct S261{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;};
extern T261 M261;
struct S159{int id;T0* _start_position;T2 _value;};
extern T159 M159;
struct S268{int id;T0* _left_side;T0* _right_side;};
extern T268 M268;
struct S153{int id;T0* _start_position;};
extern T153 M153;
struct S307{T0* _list;};
extern T307 M307;
struct S103{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T103 M103;
struct S67{T0* _first;T0* _remainder;};
extern T67 M67;
struct S205{int id;T0* _start_position;T0* _list;T0* _compound;T0* _current_type;};
extern T205 M205;
struct S176{int id;T177 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T176 M176;
struct S81{T82 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T81 M81;
struct S155{int id;T0* _start_position;T0* _to_string;T0* _break;T0* _ascii;T0* _percent;T0* _mangling;};
extern T155 M155;
struct S172{int id;T0* _list;T0* _flat_list;};
extern T172 M172;
struct S178{int id;T0* _start_position;T0* _result_type;};
extern T178 M178;
struct S97{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;};
extern T97 M97;
struct S180{T0* _first;T0* _remainder;};
extern T180 M180;
struct S87{T0* _start_position;T0* _header_comment;T0* _list;};
extern T87 M87;
struct S272{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_require_else;};
extern T272 M272;
struct S263{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;T2 _nb;};
extern T263 M263;
struct S231{int id;T0* _comment;T0* _expression;T0* _current_type;};
extern T231 M231;
struct S350{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T350 M350;
struct S52{T6 _case_insensitive;T6 _no_style_warning;T6 _drop_comments;T6 _is_running;T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_comments;T6 _inside_function;T6 _inside_once_function;T0* _formal_generic_list;T6 _in_ensure;T6 _in_rescue;T0* _arguments;T0* _local_vars;T6 _ok;T2 _last_ascii_code;T0* _last_base_class;T0* _last_base_type;T0* _last_binary;T0* _last_bit_constant;T0* _last_boolean_constant;T0* _last_character_constant;T0* _last_class_name;T0* _last_class_type;T0* _last_expression;T0* _last_feature_declaration;T0* _last_feature_name;T0* _last_feature_name_list;T0* _last_keyword;T0* _last_type_formal_generic;T0* _last_infix;T0* _last_prefix;T0* _last_integer_constant;T0* _last_instruction;T0* _last_index_value;T0* _last_manifest_constant;T0* _last_manifest_string;T0* _last_parent;T0* _last_real_constant;T0* _last_type;T0* _last_tag_mark;T2 _start_column;T2 _start_line;};
extern T52 M52;
struct S330{T6 _processing_require;T0* _header_comment;};
extern T330 M330;
struct S282{int id;};
extern T282 M282;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T6 r6_px_and(T6 C,T6 a1);
T2 r2min(T2 C,T2 a1);
T2 r2max(T2 C,T2 a1);
T2 r2hash_code(T2 C);
T3 r2digit(T2 C);
T3 r2hexadecimal_digit(T2 C);
void r2append_in(T2 C,T0* a1);
T0* r2to_string(T2 C);
T3 r3to_lower(T3 C);
T2 r3value(T3 C);
T6 r3is_letter(T3 C);
T6 r3_px_6061(T3 C,T3 a1);
T6 r3_px_6261(T3 C,T3 a1);
T6 r3is_separator(T3 C);
T6 r3same_as(T3 C,T3 a1);
T6 r3is_digit(T3 C);
T3 r3to_upper(T3 C);
T188 r188realloc(T188 C,T2 a1,T2 a2);
void r188copy_from(T188 C,T188 a1,T2 a2);
void r188set_all_with(T188 C,T0* a1,T2 a2);
void r188clear_all(T188 C,T2 a1);
T267 r267realloc(T267 C,T2 a1,T2 a2);
void r267copy_from(T267 C,T267 a1,T2 a2);
void r318clear(T318 C,T2 a1,T2 a2);
T318 r318realloc(T318 C,T2 a1,T2 a2);
void r318move(T318 C,T2 a1,T2 a2,T2 a3);
void r318copy_from(T318 C,T318 a1,T2 a2);
void r318set_all_with(T318 C,T0* a1,T2 a2);
T2 r318fast_index_of(T318 C,T0* a1,T2 a2);
T305 r305realloc(T305 C,T2 a1,T2 a2);
void r305copy_from(T305 C,T305 a1,T2 a2);
T295 r295realloc(T295 C,T2 a1,T2 a2);
void r295copy_from(T295 C,T295 a1,T2 a2);
T209 r209realloc(T209 C,T2 a1,T2 a2);
void r209copy_from(T209 C,T209 a1,T2 a2);
void r209clear_all(T209 C,T2 a1);
T171 r171realloc(T171 C,T2 a1,T2 a2);
void r171copy_from(T171 C,T171 a1,T2 a2);
void r171set_all_with(T171 C,T0* a1,T2 a2);
T73 r73realloc(T73 C,T2 a1,T2 a2);
void r73copy_from(T73 C,T73 a1,T2 a2);
T247 r247realloc(T247 C,T2 a1,T2 a2);
void r247copy_from(T247 C,T247 a1,T2 a2);
void r247set_all_with(T247 C,T0* a1,T2 a2);
T367 r367realloc(T367 C,T2 a1,T2 a2);
void r367copy_from(T367 C,T367 a1,T2 a2);
void r367set_all_with(T367 C,T0* a1,T2 a2);
T194 r194realloc(T194 C,T2 a1,T2 a2);
void r194copy_from(T194 C,T194 a1,T2 a2);
void r194set_all_with(T194 C,T0* a1,T2 a2);
void r194clear_all(T194 C,T2 a1);
T59 r59realloc(T59 C,T2 a1,T2 a2);
void r59copy_from(T59 C,T59 a1,T2 a2);
T177 r177realloc(T177 C,T2 a1,T2 a2);
void r177copy_from(T177 C,T177 a1,T2 a2);
void r177set_all_with(T177 C,T0* a1,T2 a2);
T82 r82realloc(T82 C,T2 a1,T2 a2);
void r82copy_from(T82 C,T82 a1,T2 a2);
T41 r41realloc(T41 C,T2 a1,T2 a2);
T6 r41equal_like(T0* a1,T0* a2);
void r41copy_from(T41 C,T41 a1,T2 a2);
T2 r41fast_index_of(T41 C,T0* a1,T2 a2);
T2 r41index_of(T41 C,T0* a1,T2 a2);
T358 r358realloc(T358 C,T2 a1,T2 a2);
void r358copy_from(T358 C,T358 a1,T2 a2);
void r358clear_all(T358 C,T2 a1);
T182 r182realloc(T182 C,T2 a1,T2 a2);
void r182copy_from(T182 C,T182 a1,T2 a2);
T96 r96realloc(T96 C,T2 a1,T2 a2);
void r96copy_from(T96 C,T96 a1,T2 a2);
void r96clear_all(T96 C,T2 a1);
T49 r49realloc(T49 C,T2 a1,T2 a2);
void r49copy_from(T49 C,T49 a1,T2 a2);
void r49set_all_with(T49 C,T0* a1,T2 a2);
T2 r49fast_index_of(T49 C,T0* a1,T2 a2);
T346 r346realloc(T346 C,T2 a1,T2 a2);
void r346copy_from(T346 C,T346 a1,T2 a2);
void r346set_all_with(T346 C,T0* a1,T2 a2);
T2 r346fast_index_of(T346 C,T0* a1,T2 a2);
T343 r343realloc(T343 C,T2 a1,T2 a2);
void r343copy_from(T343 C,T343 a1,T2 a2);
void r343set_all_with(T343 C,T0* a1,T2 a2);
T2 r343fast_index_of(T343 C,T0* a1,T2 a2);
T221 r221realloc(T221 C,T2 a1,T2 a2);
void r221copy_from(T221 C,T221 a1,T2 a2);
T214 r214realloc(T214 C,T2 a1,T2 a2);
void r214copy_from(T214 C,T214 a1,T2 a2);
T64 r64realloc(T64 C,T2 a1,T2 a2);
void r64copy_from(T64 C,T64 a1,T2 a2);
T25 r25realloc(T25 C,T2 a1,T2 a2);
T6 r25equal_like(T0* a1,T0* a2);
void r25copy_from(T25 C,T25 a1,T2 a2);
void r25set_all_with(T25 C,T0* a1,T2 a2);
T2 r25fast_index_of(T25 C,T0* a1,T2 a2);
T2 r25index_of(T25 C,T0* a1,T2 a2);
T325 r325realloc(T325 C,T2 a1,T2 a2);
void r325copy_from(T325 C,T325 a1,T2 a2);
void r325set_all_with(T325 C,T0* a1,T2 a2);
T309 r309realloc(T309 C,T2 a1,T2 a2);
void r309copy_from(T309 C,T309 a1,T2 a2);
T70 r70realloc(T70 C,T2 a1,T2 a2);
void r70copy_from(T70 C,T70 a1,T2 a2);
void r70set_all_with(T70 C,T0* a1,T2 a2);
T334 r334realloc(T334 C,T2 a1,T2 a2);
void r334copy_from(T334 C,T334 a1,T2 a2);
T321 r321realloc(T321 C,T2 a1,T2 a2);
void r321copy_from(T321 C,T321 a1,T2 a2);
void r321set_all_with(T321 C,T0* a1,T2 a2);
T2 r321fast_index_of(T321 C,T0* a1,T2 a2);
T224 r224realloc(T224 C,T2 a1,T2 a2);
void r224copy_from(T224 C,T224 a1,T2 a2);
T91 r91realloc(T91 C,T2 a1,T2 a2);
void r91copy_from(T91 C,T91 a1,T2 a2);
void r91set_all_with(T91 C,T0* a1,T2 a2);
T2 r91fast_index_of(T91 C,T0* a1,T2 a2);
T77 r77realloc(T77 C,T2 a1,T2 a2);
void r77copy_from(T77 C,T77 a1,T2 a2);
void r77set_all_with(T77 C,T0* a1,T2 a2);
void r77clear_all(T77 C,T2 a1);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
void r9set_all_with(T9 C,T3 a1,T2 a2);
T363 r363realloc(T363 C,T2 a1,T2 a2);
void r363clear(T363 C,T2 a1,T2 a2);
void r363move(T363 C,T2 a1,T2 a2,T2 a3);
void r363copy_from(T363 C,T363 a1,T2 a2);
void r363set_all_with(T363 C,T6 a1,T2 a2);
T47 r47realloc(T47 C,T2 a1,T2 a2);
void r47copy_from(T47 C,T47 a1,T2 a2);
void r47set_all_with(T47 C,T2 a1,T2 a2);
T2 r47fast_index_of(T47 C,T2 a1,T2 a2);
T6 r7has_string(T7* C,T0* a1);
T6 r7is_equal(T7* C,T0* a1);
T3 r7last(T7* C);
void r7add_first(T7* C,T3 a1);
T8 r7to_external(T7* C);
T6 r7same_as(T7* C,T0* a1);
void r7prepend(T7* C,T0* a1);
void r7swap(T7* C,T2 a1,T2 a2);
void r7copy(T7* C,T0* a1);
void r7head(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7blank(T7* C,T2 a1);
void r7to_lower(T7* C);
void r7remove_first(T7* C,T2 a1);
T2 r7index_of_string(T7* C,T0* a1);
void r7remove_between(T7* C,T2 a1,T2 a2);
void r7make(T7* C,T2 a1);
void r7to_hexadecimal(T7* C);
T6 r7has_prefix(T7* C,T0* a1);
T2 r7hash_code(T7* C);
void r7remove_last(T7* C,T2 a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r244add_last(T244* C,T0* a1);
void r244copy(T244* C,T0* a1);
T0* r244twin(T244* C);
T2 r244count(T244* C);
T0* r244item(T244* C,T2 a1);
void r265add_last(T265* C,T0* a1);
T2 r265count(T265* C);
T0* r265item(T265* C,T2 a1);
void r327make(T327* C,T2 a1,T2 a2);
void r327force(T327* C,T0* a1,T2 a2);
void r327resize(T327* C,T2 a1,T2 a2);
T0* r327item(T327* C,T2 a1);
void r303add_last(T303* C,T0* a1);
T2 r303count(T303* C);
T0* r303item(T303* C,T2 a1);
void r294add_last(T294* C,T0* a1);
T2 r294count(T294* C);
T0* r294item(T294* C,T2 a1);
void r170add_last(T170* C,T0* a1);
void r170make(T170* C,T2 a1,T2 a2);
void r170copy(T170* C,T0* a1);
T0* r170twin(T170* C);
T2 r170count(T170* C);
T0* r170item(T170* C,T2 a1);
void r72add_last(T72* C,T0* a1);
T2 r72count(T72* C);
T0* r72item(T72* C,T2 a1);
void r366make(T366* C,T2 a1);
void r366resize(T366* C,T2 a1);
void r193add_last(T193* C,T0* a1);
void r193with_capacity(T193* C,T2 a1);
void r193make(T193* C,T2 a1);
void r193copy(T193* C,T0* a1);
void r193resize(T193* C,T2 a1);
T0* r193twin(T193* C);
void r326add_last(T326* C,T0* a1);
void r326with_capacity(T326* C,T2 a1);
T6 r326empty(T326* C);
T0* r326last(T326* C);
void r326remove_last(T326* C);
void r24add_last(T24* C,T0* a1);
void r24with_capacity(T24* C,T2 a1);
void r24make(T24* C,T2 a1);
T2 r24fast_index_of(T24* C,T0* a1);
void r24resize(T24* C,T2 a1);
void r320add_last(T320* C,T0* a1);
void r320with_capacity(T320* C,T2 a1);
void r320make(T320* C,T2 a1);
T2 r320fast_index_of(T320* C,T0* a1);
void r320resize(T320* C,T2 a1);
void r76add_last(T76* C,T0* a1);
void r76with_capacity(T76* C,T2 a1);
T6 r76empty(T76* C);
void r76make(T76* C,T2 a1);
void r76copy(T76* C,T0* a1);
void r76resize(T76* C,T2 a1);
T0* r76twin(T76* C);
void r308add_last(T308* C,T0* a1);
T2 r308count(T308* C);
T0* r308item(T308* C,T2 a1);
void r317add_last(T317* C,T0* a1);
void r317with_capacity(T317* C,T2 a1);
void r317make(T317* C,T2 a1);
T6 r317fast_has(T317* C,T0* a1);
T2 r317fast_index_of(T317* C,T0* a1);
void r317resize(T317* C,T2 a1);
T6 r317valid_index(T317* C,T2 a1);
void r317clear_all(T317* C);
T2 r317count(T317* C);
T0* r317item(T317* C,T2 a1);
void r202with_capacity(T202* C,T2 a1);
void r202add_last(T202* C,T0* a1);
void r202copy(T202* C,T0* a1);
T0* r202twin(T202* C);
void r206add_last(T206* C,T0* a1);
void r206copy(T206* C,T0* a1);
T0* r206twin(T206* C);
T2 r206count(T206* C);
T0* r206item(T206* C,T2 a1);
void r58add_last(T58* C,T0* a1);
T2 r58count(T58* C);
T0* r58item(T58* C,T2 a1);
void r46with_capacity(T46* C,T2 a1);
void r46add_last(T46* C,T2 a1);
void r46make(T46* C,T2 a1);
T6 r46fast_has(T46* C,T2 a1);
T2 r46fast_index_of(T46* C,T2 a1);
void r46resize(T46* C,T2 a1);
T6 r46valid_index(T46* C,T2 a1);
void r345add_last(T345* C,T0* a1);
void r345with_capacity(T345* C,T2 a1);
void r345make(T345* C,T2 a1);
T6 r345fast_has(T345* C,T0* a1);
T2 r345fast_index_of(T345* C,T0* a1);
void r345resize(T345* C,T2 a1);
T6 r345valid_index(T345* C,T2 a1);
void r342add_last(T342* C,T0* a1);
void r342with_capacity(T342* C,T2 a1);
void r342make(T342* C,T2 a1);
T6 r342fast_has(T342* C,T0* a1);
T2 r342fast_index_of(T342* C,T0* a1);
void r342resize(T342* C,T2 a1);
T6 r342valid_index(T342* C,T2 a1);
void r362make(T362* C,T2 a1,T2 a2);
void r362set_slice_with(T362* C,T6 a1,T2 a2,T2 a3);
void r362force(T362* C,T6 a1,T2 a2);
void r362resize(T362* C,T2 a1,T2 a2);
T6 r362valid_index(T362* C,T2 a1);
T6 r362item(T362* C,T2 a1);
void r156add_last(T156* C,T2 a1);
T6 r156fast_has(T156* C,T2 a1);
T2 r156fast_index_of(T156* C,T2 a1);
T6 r156valid_index(T156* C,T2 a1);
T2 r156count(T156* C);
void r220add_last(T220* C,T0* a1);
void r220copy(T220* C,T0* a1);
T0* r220twin(T220* C);
T2 r220count(T220* C);
T0* r220item(T220* C,T2 a1);
void r213add_last(T213* C,T0* a1);
void r213copy(T213* C,T0* a1);
T0* r213twin(T213* C);
T2 r213count(T213* C);
T0* r213item(T213* C,T2 a1);
void r62add_last(T62* C,T0* a1);
T2 r62count(T62* C);
T0* r62item(T62* C,T2 a1);
void r33with_capacity(T33* C,T2 a1,T2 a2);
void r33add_last(T33* C,T0* a1);
void r33clear(T33* C);
T6 r33empty(T33* C);
void r33make(T33* C,T2 a1,T2 a2);
T6 r33fast_has(T33* C,T0* a1);
T2 r33fast_index_of(T33* C,T0* a1);
T2 r33index_of(T33* C,T0* a1);
T6 r33valid_index(T33* C,T2 a1);
T2 r33count(T33* C);
T0* r33item(T33* C,T2 a1);
void r333with_capacity(T333* C,T2 a1,T2 a2);
void r333add_last(T333* C,T0* a1);
void r333swap(T333* C,T2 a1,T2 a2);
T2 r333count(T333* C);
T0* r333item(T333* C,T2 a1);
void r322add_last(T322* C,T0* a1);
T6 r322fast_has(T322* C,T0* a1);
T2 r322fast_index_of(T322* C,T0* a1);
T6 r322valid_index(T322* C,T2 a1);
T2 r322count(T322* C);
void r223add_last(T223* C,T0* a1);
void r223copy(T223* C,T0* a1);
T0* r223twin(T223* C);
T2 r223count(T223* C);
T0* r223item(T223* C,T2 a1);
void r86with_capacity(T86* C,T2 a1,T2 a2);
void r86add_last(T86* C,T0* a1);
void r86clear(T86* C);
T6 r86empty(T86* C);
void r86make(T86* C,T2 a1,T2 a2);
T6 r86fast_has(T86* C,T0* a1);
void r86copy(T86* C,T0* a1);
T2 r86fast_index_of(T86* C,T0* a1);
T6 r86valid_index(T86* C,T2 a1);
T0* r86twin(T86* C);
T2 r86count(T86* C);
T0* r86item(T86* C,T2 a1);
void r357add_last(T357* C,T0* a1);
void r357with_capacity(T357* C,T2 a1);
void r357copy(T357* C,T0* a1);
T0* r357twin(T357* C);
void r181with_capacity(T181* C,T2 a1);
void r181add_last(T181* C,T0* a1);
void r135with_capacity(T135* C,T2 a1);
void r135add_last(T135* C,T0* a1);
void r135copy(T135* C,T0* a1);
T0* r135twin(T135* C);
T0* r135item(T135* C,T2 a1);
void r48add_last(T48* C,T0* a1);
void r48with_capacity(T48* C,T2 a1);
void r48make(T48* C,T2 a1);
T6 r48fast_has(T48* C,T0* a1);
T2 r48fast_index_of(T48* C,T0* a1);
void r48resize(T48* C,T2 a1);
T6 r48valid_index(T48* C,T2 a1);
void r355make(T355* C,T2 a1);
void r355resize(T355* C,T2 a1);
void r355clear_all(T355* C);
T2 r355count(T355* C);
void r39add_last(T39* C,T0* a1);
void r39with_capacity(T39* C,T2 a1);
T6 r39fast_has(T39* C,T0* a1);
T2 r39fast_index_of(T39* C,T0* a1);
T2 r39index_of(T39* C,T0* a1);
T6 r39valid_index(T39* C,T2 a1);
T6 r39has(T39* C,T0* a1);
void r94add_last(T94* C,T0* a1);
void r94copy(T94* C,T0* a1);
T0* r94twin(T94* C);
T2 r94count(T94* C);
T0* r94item(T94* C,T2 a1);
void r324add_last(T324* C,T0* a1);
void r324with_capacity(T324* C,T2 a1);
void r324make(T324* C,T2 a1);
void r324resize(T324* C,T2 a1);
void r68with_capacity(T68* C,T2 a1);
void r68add_last(T68* C,T0* a1);
void r68make(T68* C,T2 a1);
void r187add_last(T187* C,T0* a1);
void r187with_capacity(T187* C,T2 a1);
void r187make(T187* C,T2 a1);
void r187copy(T187* C,T0* a1);
T0* r187twin(T187* C);
void r176add_last(T176* C,T0* a1);
void r176make(T176* C,T2 a1,T2 a2);
void r176copy(T176* C,T0* a1);
T0* r176twin(T176* C);
T2 r176count(T176* C);
T0* r176item(T176* C,T2 a1);
void r81add_last(T81* C,T0* a1);
T2 r81count(T81* C);
T0* r81item(T81* C,T2 a1);
void r365with_capacity(T365* C,T2 a1);
void r365resize_buckets(T365* C,T2 a1);
void r365expand(T365* C);
void r365put(T365* C,T0* a1,T0* a2);
T6 r365has(T365* C,T0* a1);
void r360with_capacity(T360* C,T2 a1);
void r360resize_buckets(T360* C,T2 a1);
void r360expand(T360* C);
void r360put(T360* C,T0* a1,T0* a2);
T6 r360has(T360* C,T0* a1);
void r319with_capacity(T319* C,T2 a1);
void r319resize_buckets(T319* C,T2 a1);
void r319expand(T319* C);
T0* r319at(T319* C,T0* a1);
void r319set_cache_user_idx(T319* C,T2 a1);
void r319put(T319* C,T0* a1,T0* a2);
T6 r319has(T319* C,T0* a1);
T0* r319item(T319* C,T2 a1);
void r75with_capacity(T75* C,T2 a1);
void r75resize_buckets(T75* C,T2 a1);
void r75expand(T75* C);
T0* r75at(T75* C,T0* a1);
void r75put(T75* C,T0* a1,T0* a2);
T6 r75has(T75* C,T0* a1);
void r354with_capacity(T354* C,T2 a1);
void r354resize_buckets(T354* C,T2 a1);
void r354expand(T354* C);
void r354put(T354* C,T0* a1,T2 a2);
T6 r354has(T354* C,T2 a1);
void r316with_capacity(T316* C,T2 a1);
void r316resize_buckets(T316* C,T2 a1);
void r316expand(T316* C);
T0* r316at(T316* C,T0* a1);
void r316put(T316* C,T0* a1,T0* a2);
T6 r316has(T316* C,T0* a1);
void r54with_capacity(T54* C,T2 a1);
void r54resize_buckets(T54* C,T2 a1);
void r54expand(T54* C);
T0* r54at(T54* C,T0* a1);
void r54put(T54* C,T0* a1,T0* a2);
T6 r54has(T54* C,T0* a1);
void r45with_capacity(T45* C,T2 a1);
void r45resize_buckets(T45* C,T2 a1);
void r45expand(T45* C);
void r45remove(T45* C,T0* a1);
T0* r45at(T45* C,T0* a1);
void r45put(T45* C,T0* a1,T0* a2);
T6 r45has(T45* C,T0* a1);
T0* r129runnable_expression(T0* a1,T0* a2);
void r129run_feature_has_result(T129* C);
extern T0*oBC12fmt;
T0* r129run_feature_for(T129* C,T0* a1,T0* a2);
T0* r129static_result_base_class(T129* C);
void r129make(T129* C,T0* a1,T0* a2);
extern T0*oBC12eh;
void r129fatal_error(T0* a1);
void r129run_feature_match(T129* C);
void r129assertion_check(T129* C,T3 a1);
T0* r129add_comment(T129* C,T0* a1);
void r129with(T129* C,T0* a1,T0* a2,T0* a3);
T0* r129operator(void);
T0* r129to_runnable(T129* C,T0* a1);
T2 r129to_integer(T129* C);
void r129error(T0* a1,T0* a2);
void r129bracketed_pretty_print(T129* C);
void r129pretty_print(T129* C);
T0* r129result_type(T129* C);
void r129print_as_target(T129* C);
extern T0*oBC12small_eiffel;
T0* r140static_result_base_class(void);
T0* r140add_comment(T140* C,T0* a1);
T0* r140to_runnable(T140* C,T0* a1);
T2 r140to_integer(T140* C);
void r140error(T0* a1,T0* a2);
T0* r140result_type(T140* C);
void r163add_last(T163* C,T0* a1);
T2 r163rank_of(T163* C,T0* a1);
void r163fatal_error(T0* a1);
void r163check_name_clash(T163* C,T0* a1);
void r163declaration_list_make(T163* C,T0* a1);
T0* r163to_runnable(T163* C,T0* a1);
T0* r163twin(T163* C);
T0* r163type(T163* C,T2 a1);
void r163dynamic_runnable(T163* C,T0* a1);
void r163error(T0* a1,T0* a2);
T6 r163is_runnable(T163* C,T0* a1);
void r163pretty_print(T163* C);
extern T0*oBC43parser_buffer_path;
T6 r43re_load_class(T43* C,T0* a1);
extern int fBC43rename_dictionary;
extern T0*oBC43rename_dictionary;
T0* r43rename_dictionary(T43* C);
extern T0*oBC12tmp_file_read;
void r43pop(T43* C);
extern T0*oBC43stack_rf;
T0* r43top_rf(T43* C);
void r43incr_magic_count(T43* C);
T0* r43base_class(T43* C,T0* a1);
extern T0*oBC43base_class_dictionary;
T6 r43parser_buffer_for(T43* C,T0* a1);
void r43push(T43* C,T0* a1);
T6 r43is_used(T0* a1);
T0* r43load_class(T43* C,T0* a1);
void r43add_class(T43* C,T0* a1);
extern int fBC43loading_path;
extern T0*oBC43loading_path;
T0* r43loading_path(void);
T0* r43run_class(T0* a1);
T0* r43get_class(T0* a1);
void r43fatal_error(T0* a1);
extern T0*oBC12echo;
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r43system_tools(void);
extern T0*oBC43run_class_dictionary;
extern int fBC43tmp_class_name;
extern T0*oBC43tmp_class_name;
T0* r43tmp_class_name(void);
extern T0*oBC43tmp_tail;
extern T0*oBC12parser_buffer;
extern T0*oBC12eiffel_parser;
void r254fatal_error_generic_list(T254* C);
T0* r254generic_list(T254* C);
T0* r254smallest_ancestor(T0* a1);
T0* r254base_class(T254* C);
T0* r254look_up_for(T254* C,T0* a1,T0* a2);
T6 r254has_creation(T254* C,T0* a1);
void r254error(T0* a1,T0* a2);
T6 r254is_a_in(T254* C,T0* a1,T0* a2);
T0* r254run_time_mark(void);
void r254make(T254* C,T0* a1);
T0* r254written_mark(void);
void r203make(T203* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC12run_control;
T0* r203add_comment(T203* C,T0* a1);
T0* r203to_runnable(T203* C,T0* a1);
void r203pretty_print(T203* C);
T0* r203start_position(T203* C);
void r230make(T230* C,T0* a1,T0* a2,T0* a3);
T0* r230to_runnable(T230* C,T0* a1);
T0* r230twin(T230* C);
void r230error(T0* a1,T0* a2);
void r230pretty_print(T230* C);
T0* r230start_position(T230* C);
void r122declaration_in(T122* C,T0* a1);
void r122declaration_pretty_print(T122* C);
void r122make(T122* C,T0* a1,T0* a2);
void r122undefine_in(T122* C,T0* a1);
extern int fBC12string_aliaser;
extern T0*oBC12string_aliaser;
T0* r122string_aliaser(void);
T0* r122origin_base_class(T122* C);
void r122error(T0* a1,T0* a2);
void r126declaration_in(T126* C,T0* a1);
void r126declaration_pretty_print(T126* C);
void r126make(T126* C,T0* a1,T0* a2);
void r126undefine_in(T126* C,T0* a1);
T0* r126string_aliaser(void);
T0* r126origin_base_class(T126* C);
void r126error(T0* a1,T0* a2);
void r258fatal_error_generic_list(T258* C);
T0* r258generic_list(T258* C);
T2 r258id(T258* C);
T0* r258smallest_ancestor(T258* C,T0* a1);
T0* r258base_class(T258* C);
T0* r258look_up_for(T258* C,T0* a1,T0* a2);
T0* r258to_runnable(T258* C,T0* a1);
T6 r258has_creation(T258* C,T0* a1);
T6 r258is_a_in(T258* C,T0* a1,T0* a2);
T6 r258is_a(T258* C,T0* a1);
T0* r258run_class(T258* C);
extern T0*oBC258check_memory;
T6 r258is_expanded(T258* C);
T0* r258expanded_initializer(T258* C);
void r258used_as_reference(T258* C);
T6 r258is_reference(T258* C);
T0* r114runnable_expression(T0* a1,T0* a2);
void r114check_comparison(T114* C,T0* a1);
T0* r114add_comment(T114* C,T0* a1);
void r114with(T114* C,T0* a1,T0* a2,T0* a3);
T0* r114operator(void);
T0* r114runnable_args(T0* a1,T0* a2);
T0* r114to_runnable(T114* C,T0* a1);
T2 r114to_integer(T114* C);
void r114bit_limitation(T114* C,T0* a1,T0* a2);
void r114error(T0* a1,T0* a2);
void r114bracketed_pretty_print(T114* C);
void r114print_as_target(T114* C);
void r114print_op(T114* C);
extern int fBC12type_boolean;
extern T0*oBC12type_boolean;
T0* r114type_boolean(void);
T0* r114static_result_base_class(void);
void r114make(T114* C,T0* a1,T0* a2,T0* a3);
void r114fatal_error(T0* a1);
void r114assertion_check(T114* C,T3 a1);
void r114error_comparison(T114* C,T0* a1,T0* a2);
void r114pretty_print(T114* C);
T0* r106runnable_expression(T0* a1,T0* a2);
void r106run_feature_has_result(T106* C);
void r106run_feature_match(T106* C,T0* a1);
T0* r106add_comment(T106* C,T0* a1);
void r106with(T106* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r106operator(void);
T0* r106runnable_args(T0* a1,T0* a2);
T0* r106to_runnable(T106* C,T0* a1);
T2 r106to_integer(T106* C);
void r106error(T0* a1,T0* a2);
void r106bracketed_pretty_print(T106* C);
T0* r106result_type(T106* C);
void r106print_as_target(T106* C);
void r106print_op(T106* C);
T0* r106run_feature_for(T106* C,T0* a1,T0* a2);
T0* r106static_result_base_class(T106* C);
void r106make(T106* C,T0* a1,T0* a2,T0* a3);
void r106fatal_error(T0* a1);
void r106assertion_check(T106* C,T3 a1);
void r106pretty_print(T106* C);
void r37put_string(T37* C,T0* a1);
void r37put_integer(T37* C,T2 a1);
extern T0*oBC36tmp_string;
void r196pretty_tail(T196* C);
T6 r196is_merge_with(T196* C,T0* a1,T0* a2);
T6 r196is_merge_with2aux(T196* C,T0* a1,T0* a2);
T0* r196try_to_undefine_aux(T196* C,T0* a1,T0* a2);
T0* r196try_to_undefine(T196* C,T0* a1,T0* a2);
void r196check_obsolete(T196* C,T0* a1);
T6 r196is_merge_with1(T196* C,T0* a1);
T6 r196is_merge_with2(T196* C,T0* a1,T0* a2);
T0* r196to_run_feature(T196* C,T0* a1,T0* a2);
void r196error(T0* a1,T0* a2);
void r196pretty_print_names(T196* C);
void r196make(T196* C,T0* a1,T0* a2,T0* a3);
void r196pretty_print_profile(T196* C);
void r196add_into(T196* C,T0* a1);
T6 r196can_hide(T196* C,T0* a1,T0* a2);
void r196merge_header_comments(T196* C,T0* a1);
void r196pretty_print(T196* C);
T0* r196start_position(T196* C);
void r80make(T80* C,T0* a1,T0* a2,T0* a3);
void r80add_into(T80* C,T0* a1);
void r80pretty_print(T80* C);
T0* r104runnable_expression(T0* a1,T0* a2);
void r104run_feature_has_result(T104* C);
void r104run_feature_match(T104* C,T0* a1);
T0* r104add_comment(T104* C,T0* a1);
void r104with(T104* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r104operator(void);
T0* r104runnable_args(T0* a1,T0* a2);
T0* r104to_runnable(T104* C,T0* a1);
T2 r104to_integer(T104* C);
void r104error(T0* a1,T0* a2);
void r104bracketed_pretty_print(T104* C);
T0* r104result_type(T104* C);
void r104print_as_target(T104* C);
void r104print_op(T104* C);
T0* r104run_feature_for(T104* C,T0* a1,T0* a2);
T0* r104static_result_base_class(T104* C);
void r104make(T104* C,T0* a1,T0* a2,T0* a3);
void r104fatal_error(T0* a1);
void r104assertion_check(T104* C,T3 a1);
void r104pretty_print(T104* C);
T0* r93key_for_prefix_infix(T0* a1,T0* a2);
T0* r93item(T0* a1);
T0* r93for_prefix(T0* a1);
void r93add2(T0* a1);
T0* r93for_infix(T0* a1);
extern T0*oBC93memory;
void r251fatal_error_generic_list(T251* C);
T0* r251generic_list(T251* C);
T0* r251smallest_ancestor(T251* C,T0* a1);
extern int fBC251check_type;
void r251check_type(T251* C);
extern int fBC12type_character_ref;
extern T0*oBC12type_character_ref;
T0* r251type_character_ref(void);
T0* r251base_class(T251* C);
void r251load_ref(T0* a1);
T0* r251look_up_for(T251* C,T0* a1,T0* a2);
T0* r251to_runnable(T251* C,T0* a1);
T6 r251has_creation(T251* C,T0* a1);
void r251error(T0* a1,T0* a2);
T6 r251is_a_in(T251* C,T0* a1,T0* a2);
T0* r251run_time_mark(void);
T6 r251is_a(T251* C,T0* a1);
T0* r251run_class(T251* C);
void r251make(T251* C,T0* a1);
extern int fBC251used_as_reference;
void r251used_as_reference(void);
T0* r251written_mark(void);
void r269pretty_print_assignment(T0* a1,T0* a2,T0* a3);
T0* r269left_type(T269* C);
void r269make(T269* C,T0* a1,T0* a2);
void r269warning(T0* a1,T0* a2);
T0* r269add_comment(T269* C,T0* a1);
T0* r269right_type(T269* C);
T0* r269to_runnable(T269* C,T0* a1);
void r269error(T0* a1,T0* a2);
T0* r269start_position(T269* C);
void r348refer_to(T348* C,T2 a1,T0* a2);
void r348undefine_in(T348* C,T0* a1);
T0* r348string_aliaser(void);
T0* r348origin_base_class(T348* C);
T6 r348is_frozen(T348* C);
T0* r348to_string(T348* C);
void r348error(T0* a1,T0* a2);
T0* r348start_position(T348* C);
T0* r142add_comment(T142* C,T0* a1);
T0* r142to_runnable(T142* C,T0* a1);
T2 r142to_integer(T142* C);
void r142error(T0* a1,T0* a2);
void r299make(T299* C,T0* a1,T0* a2);
void r299append_in(T299* C,T0* a1);
void r299pretty_print(T299* C);
T6 r291is_merge_with(T291* C,T0* a1,T0* a2);
T6 r291is_merge_with2aux(T291* C,T0* a1,T0* a2);
void r291pretty_print_rescue(T291* C);
T0* r291try_to_undefine_aux(T291* C,T0* a1,T0* a2);
T0* r291try_to_undefine(T291* C,T0* a1,T0* a2);
void r291check_obsolete(T291* C,T0* a1);
T6 r291is_merge_with1(T291* C,T0* a1);
T6 r291is_merge_with2(T291* C,T0* a1,T0* a2);
T0* r291to_run_feature(T291* C,T0* a1,T0* a2);
void r291error(T0* a1,T0* a2);
void r291pretty_print_names(T291* C);
void r291set_header_comment(T291* C,T0* a1);
void r291make_routine(T291* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r291make(T291* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r291pretty_print_profile(T291* C);
void r291pretty_print_routine_body(T291* C);
void r291add_into(T291* C,T0* a1);
T6 r291can_hide(T291* C,T0* a1,T0* a2);
void r291merge_header_comments(T291* C,T0* a1);
void r291pretty_print(T291* C);
void r291pretty_print_arguments(T291* C);
T0* r291start_position(T291* C);
void r85make(T85* C,T0* a1,T0* a2,T0* a3);
T0* r85to_runnable(T85* C,T0* a1,T3 a2);
void r85error(T0* a1,T0* a2);
void r85pretty_print(T85* C);
T0* r85start_position(T85* C);
void r78make(T78* C,T0* a1,T0* a2);
void r78fatal_error(T0* a1);
T2 r78index_of(T78* C,T0* a1);
void r78pretty_print(T78* C);
void r79get_started(T79* C,T0* a1);
void r79pretty_print(T79* C);
void r38add_position(T0* a1);
void r38print_as_fatal_error(T38* C);
extern T0*oBC38explanation;
void r38feature_not_found(T0* a1);
extern T0*oBC38positions;
void r38print_as_warning(T38* C);
void r38add_feature_name(T0* a1);
void r38add_type(T0* a1,T0* a2);
void r38do_print(T0* a1);
void r38print_as_error(T38* C);
void r65good_end(T65* C,T0* a1);
void r65make(T65* C,T0* a1,T0* a2);
void r65warning(T0* a1,T0* a2);
void r65append(T65* C,T0* a1);
void r65pretty_print(T65* C);
T6 r65dummy(T65* C);
void r197pretty_tail(T197* C);
T6 r197is_merge_with(T197* C,T0* a1,T0* a2);
T6 r197is_merge_with2aux(T197* C,T0* a1,T0* a2);
T0* r197try_to_undefine_aux(T197* C,T0* a1,T0* a2);
T0* r197try_to_undefine(T197* C,T0* a1,T0* a2);
void r197check_obsolete(T197* C,T0* a1);
T6 r197is_merge_with1(T197* C,T0* a1);
T6 r197is_merge_with2(T197* C,T0* a1,T0* a2);
T0* r197to_run_feature(T197* C,T0* a1,T0* a2);
void r197error(T0* a1,T0* a2);
void r197pretty_print_names(T197* C);
void r197make(T197* C,T0* a1,T0* a2,T0* a3);
void r197pretty_print_profile(T197* C);
void r197add_into(T197* C,T0* a1);
T6 r197can_hide(T197* C,T0* a1,T0* a2);
void r197merge_header_comments(T197* C,T0* a1);
void r197pretty_print(T197* C);
T0* r197start_position(T197* C);
T6 r184is_merge_with(T184* C,T0* a1,T0* a2);
T6 r184is_merge_with2aux(T184* C,T0* a1,T0* a2);
T0* r184try_to_undefine_aux(T184* C,T0* a1,T0* a2);
extern T0*oBC184counter;
T0* r184try_to_undefine(T184* C,T0* a1,T0* a2);
void r184check_obsolete(T184* C,T0* a1);
T6 r184is_merge_with1(T184* C,T0* a1);
T6 r184is_merge_with2(T184* C,T0* a1,T0* a2);
T0* r184to_run_feature(T184* C,T0* a1,T0* a2);
void r184error(T0* a1,T0* a2);
void r184pretty_print_names(T184* C);
void r184make(T184* C,T0* a1,T0* a2);
void r184pretty_print_profile(T184* C);
void r184add_into(T184* C,T0* a1);
T6 r184can_hide(T184* C,T0* a1,T0* a2);
void r184merge_header_comments(T184* C,T0* a1);
void r184pretty_print(T184* C);
T0* r184start_position(T184* C);
T6 r242is_any(T242* C);
void r242fatal_error_generic_list(T242* C);
T6 r242is_string(T242* C);
T0* r242generic_list(T242* C);
T2 r242id(T242* C);
T0* r242smallest_ancestor(T242* C,T0* a1);
void r242with(T242* C,T0* a1,T0* a2);
T0* r242base_class(T242* C);
T6 r242is_array(T242* C);
T6 r242is_double(T242* C);
T6 r242is_none(T242* C);
T0* r242look_up_for(T242* C,T0* a1,T0* a2);
T0* r242to_runnable(T242* C,T0* a1);
T6 r242has_creation(T242* C,T0* a1);
T6 r242is_pointer(T242* C);
T6 r242is_a_in(T242* C,T0* a1,T0* a2);
T0* r242run_time_mark(T242* C);
T6 r242is_boolean(T242* C);
T6 r242is_a(T242* C,T0* a1);
T0* r242run_class(T242* C);
T6 r242is_generic(T242* C);
T6 r242is_expanded(T242* C);
T0* r242expanded_initializer(T242* C);
T6 r242is_basic_eiffel_expanded(T242* C);
void r242used_as_reference(T242* C);
T6 r242is_character(T242* C);
T6 r242is_reference(T242* C);
T0* r242written_mark(void);
T6 r242is_real(T242* C);
T0* r242base_class_name(T242* C);
T6 r242is_bit(T242* C);
T6 r242is_integer(T242* C);
void r252fatal_error_generic_list(T252* C);
T0* r252generic_list(T252* C);
extern int fBC12type_double_ref;
extern T0*oBC12type_double_ref;
T0* r252type_double_ref(void);
T0* r252smallest_ancestor(T252* C,T0* a1);
extern int fBC252check_type;
void r252check_type(T252* C);
T0* r252base_class(T252* C);
void r252load_ref(T0* a1);
T0* r252look_up_for(T252* C,T0* a1,T0* a2);
T0* r252to_runnable(T252* C,T0* a1);
T6 r252has_creation(T252* C,T0* a1);
void r252error(T0* a1,T0* a2);
T6 r252is_a_in(T252* C,T0* a1,T0* a2);
T0* r252run_time_mark(void);
T6 r252is_a(T252* C,T0* a1);
T0* r252run_class(T252* C);
void r252make(T252* C,T0* a1);
extern int fBC252used_as_reference;
void r252used_as_reference(void);
T0* r252written_mark(void);
T0* r117runnable_expression(T0* a1,T0* a2);
void r117run_feature_has_result(T117* C);
void r117run_feature_match(T117* C,T0* a1);
T0* r117add_comment(T117* C,T0* a1);
void r117with(T117* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r117operator(void);
T0* r117runnable_args(T0* a1,T0* a2);
T0* r117to_runnable(T117* C,T0* a1);
T2 r117to_integer(T117* C);
void r117error(T0* a1,T0* a2);
void r117bracketed_pretty_print(T117* C);
T0* r117result_type(T117* C);
void r117print_as_target(T117* C);
void r117print_op(T117* C);
T0* r117run_feature_for(T117* C,T0* a1,T0* a2);
T0* r117static_result_base_class(T117* C);
void r117make(T117* C,T0* a1,T0* a2,T0* a3);
void r117fatal_error(T0* a1);
void r117assertion_check(T117* C,T3 a1);
void r117pretty_print(T117* C);
extern int fBC12type_any;
extern T0*oBC12type_any;
T0* r131type_any(void);
T0* r131static_result_base_class(void);
void r131make(T131* C,T0* a1,T0* a2);
T0* r131add_comment(T131* C,T0* a1);
extern T0*oBC12manifest_array_pool;
T0* r131to_runnable(T131* C,T0* a1);
T2 r131to_integer(T131* C);
void r131error(T0* a1,T0* a2);
void r131bracketed_pretty_print(T131* C);
void r131pretty_print(T131* C);
T0* r131result_type(T131* C);
void r131print_as_target(T131* C);
void r228make(T228* C,T0* a1,T0* a2,T0* a3);
T0* r228name(void);
T0* r228to_runnable(T228* C,T0* a1);
T0* r228twin(T228* C);
void r228pretty_print(T228* C);
extern T0*oBC12assertion_collector;
T2 r361precedence(T361* C);
T6 r361is_current(T361* C);
T0* r361static_result_base_class(T361* C);
void r361make(T361* C,T0* a1,T0* a2);
T0* r361add_comment(T361* C,T0* a1);
void r361assertion_check(T361* C,T3 a1);
T0* r361to_runnable(T361* C,T0* a1);
T2 r361to_integer(T361* C);
void r361error(T0* a1,T0* a2);
void r361bracketed_pretty_print(T361* C);
void r361pretty_print(T361* C);
void r361print_as_target(T361* C);
T0* r361start_position(T361* C);
T0* r110runnable_expression(T0* a1,T0* a2);
void r110run_feature_has_result(T110* C);
void r110run_feature_match(T110* C,T0* a1);
T0* r110add_comment(T110* C,T0* a1);
void r110with(T110* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r110operator(void);
T0* r110runnable_args(T0* a1,T0* a2);
T0* r110to_runnable(T110* C,T0* a1);
T2 r110to_integer(T110* C);
void r110error(T0* a1,T0* a2);
void r110bracketed_pretty_print(T110* C);
T0* r110result_type(T110* C);
void r110print_as_target(T110* C);
void r110print_op(T110* C);
T0* r110run_feature_for(T110* C,T0* a1,T0* a2);
T0* r110static_result_base_class(T110* C);
void r110make(T110* C,T0* a1,T0* a2,T0* a3);
void r110fatal_error(T0* a1);
void r110assertion_check(T110* C,T3 a1);
void r110pretty_print(T110* C);
T0* r108runnable_expression(T0* a1,T0* a2);
void r108run_feature_has_result(T108* C);
void r108run_feature_match(T108* C,T0* a1);
T0* r108add_comment(T108* C,T0* a1);
void r108with(T108* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r108operator(void);
T0* r108runnable_args(T0* a1,T0* a2);
T0* r108to_runnable(T108* C,T0* a1);
T2 r108to_integer(T108* C);
void r108error(T0* a1,T0* a2);
void r108bracketed_pretty_print(T108* C);
T0* r108result_type(T108* C);
void r108print_as_target(T108* C);
void r108print_op(T108* C);
T0* r108run_feature_for(T108* C,T0* a1,T0* a2);
T0* r108static_result_base_class(T108* C);
void r108make(T108* C,T0* a1,T0* a2,T0* a3);
void r108fatal_error(T0* a1);
void r108assertion_check(T108* C,T3 a1);
void r108pretty_print(T108* C);
void r310disconnect(T310* C);
void r310connect_to(T310* C,T0* a1);
T6 r311zen_mode(T311* C);
void r311put_integer(T311* C,T2 a1);
extern T0*oBC311tmp_string;
void r311skip(T311* C,T2 a1);
void r311indent(T311* C);
T6 r311print_end_debug(T311* C);
void r311put_end(T311* C,T0* a1);
void r311level_incr(T311* C);
void r311level_decr(T311* C);
T6 r311print_end_if(T311* C);
T6 r311print_end_routine(T311* C);
void r311connect_to(T311* C,T0* a1);
void r311put_string(T311* C,T0* a1);
T6 r311print_current(T311* C);
void r311put_character(T311* C,T3 a1);
void r311keyword(T311* C,T0* a1);
T6 r311print_end_check(T311* C);
T6 r311print_end_inspect(T311* C);
T6 r311print_end_loop(T311* C);
void r256fatal_error_generic_list(T256* C);
T0* r256generic_list(T256* C);
T0* r256smallest_ancestor(T256* C,T0* a1);
extern int fBC256check_type;
void r256check_type(T256* C);
T0* r256base_class(T256* C);
void r256load_ref(T0* a1);
T0* r256look_up_for(T256* C,T0* a1,T0* a2);
T0* r256to_runnable(T256* C,T0* a1);
T6 r256has_creation(T256* C,T0* a1);
void r256error(T0* a1,T0* a2);
T6 r256is_a_in(T256* C,T0* a1,T0* a2);
T0* r256run_time_mark(void);
T6 r256is_a(T256* C,T0* a1);
T0* r256run_class(T256* C);
void r256make(T256* C,T0* a1);
extern int fBC12type_real_ref;
extern T0*oBC12type_real_ref;
T0* r256type_real_ref(void);
extern int fBC256used_as_reference;
void r256used_as_reference(void);
T0* r256written_mark(void);
extern int fBC12type_double;
extern T0*oBC12type_double;
T0* r256type_double(void);
void r332make(T332* C,T0* a1);
void r332add(T332* C,T0* a1);
T0* r168base_class_written(T168* C);
T0* r168static_result_base_class(T168* C);
void r168make(T168* C,T0* a1,T0* a2);
void r168name_clash_for(T168* C,T0* a1,T0* a2);
T0* r168add_comment(T168* C,T0* a1);
T0* r168to_runnable(T168* C,T0* a1);
T2 r168to_integer(T168* C);
T0* r168twin(T168* C);
void r168error(T0* a1,T0* a2);
void r168print_as_target(T168* C);
T0* r168written_in(T168* C);
T2 r246id(T246* C);
T0* r246smallest_ancestor(T246* C,T0* a1);
T0* r246string_aliaser(void);
void r246with(T246* C,T0* a1,T0* a2,T0* a3);
T0* r246base_class(T246* C);
T0* r246look_up_for(T246* C,T0* a1,T0* a2);
T0* r246to_runnable(T246* C,T0* a1);
T6 r246has_creation(T246* C,T0* a1);
T6 r246is_a_in(T246* C,T0* a1,T0* a2);
T0* r246run_time_mark(T246* C);
T6 r246is_a(T246* C,T0* a1);
extern T0*oBC246tmp_written_mark;
void r246final(T246* C,T0* a1,T0* a2);
T0* r246run_class(T246* C);
void r246make(T246* C,T0* a1,T0* a2);
void r246fatal_error(T0* a1);
T0* r246run_type(T246* C);
void r246load_basic_features(T246* C);
T6 r246is_run_type(T246* C);
void r159unary_minus(T159* C);
T0* r159static_result_base_class(void);
void r159make(T159* C,T2 a1,T0* a2);
T0* r159add_comment(T159* C,T0* a1);
T0* r159to_real_constant(T159* C);
void r159error(T0* a1,T0* a2);
extern int fBC159result_type;
extern T0*oBC159result_type;
T0* r159result_type(void);
void r159print_as_target(T159* C);
T0* r165static_result_base_class(T165* C);
void r165fatal_error(T0* a1);
void r165refer_to(T165* C,T0* a1,T0* a2,T2 a3);
void r165assertion_check(T165* C,T3 a1);
T0* r165add_comment(T165* C,T0* a1);
T0* r165to_runnable(T165* C,T0* a1);
T2 r165to_integer(T165* C);
T0* r165to_string(T165* C);
void r165error(T0* a1,T0* a2);
T0* r165result_type(T165* C);
void r165print_as_target(T165* C);
void r249fatal_error_generic_list(T249* C);
T0* r249generic_list(T249* C);
T0* r249smallest_ancestor(T249* C,T0* a1);
extern int fBC249check_type;
void r249check_type(T249* C);
T0* r249base_class(T249* C);
void r249load_ref(T0* a1);
T0* r249look_up_for(T249* C,T0* a1,T0* a2);
T0* r249to_runnable(T249* C,T0* a1);
T6 r249has_creation(T249* C,T0* a1);
extern int fBC12type_boolean_ref;
extern T0*oBC12type_boolean_ref;
T0* r249type_boolean_ref(void);
void r249error(T0* a1,T0* a2);
T6 r249is_a_in(T249* C,T0* a1,T0* a2);
T0* r249run_time_mark(void);
T6 r249is_a(T249* C,T0* a1);
T0* r249run_class(T249* C);
void r249make(T249* C,T0* a1);
extern int fBC249used_as_reference;
void r249used_as_reference(void);
T0* r249written_mark(void);
void r257fatal_error_generic_list(T257* C);
T0* r257generic_list(T257* C);
extern int fBC12type_string;
extern T0*oBC12type_string;
T0* r257type_string(void);
T0* r257smallest_ancestor(T257* C,T0* a1);
T0* r257base_class(T257* C);
extern int fBC257set_at_run_time;
void r257set_at_run_time(void);
T0* r257look_up_for(T257* C,T0* a1,T0* a2);
T6 r257has_creation(T257* C,T0* a1);
T6 r257is_a_in(T257* C,T0* a1,T0* a2);
T0* r257run_time_mark(void);
T6 r257is_a(T257* C,T0* a1);
T0* r257run_class(T257* C);
void r257make(T257* C,T0* a1);
T0* r257written_mark(void);
T0* r119runnable_expression(T0* a1,T0* a2);
void r119run_feature_has_result(T119* C);
void r119run_feature_match(T119* C,T0* a1);
T0* r119add_comment(T119* C,T0* a1);
void r119with(T119* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r119operator(void);
T0* r119runnable_args(T0* a1,T0* a2);
T0* r119to_runnable(T119* C,T0* a1);
T2 r119to_integer(T119* C);
void r119error(T0* a1,T0* a2);
void r119bracketed_pretty_print(T119* C);
T0* r119result_type(T119* C);
void r119print_as_target(T119* C);
void r119print_op(T119* C);
T0* r119run_feature_for(T119* C,T0* a1,T0* a2);
T0* r119static_result_base_class(T119* C);
void r119make(T119* C,T0* a1,T0* a2,T0* a3);
void r119fatal_error(T0* a1);
void r119assertion_check(T119* C,T3 a1);
void r119pretty_print(T119* C);
void r172add_last(T172* C,T0* a1);
T6 r172is_a_in(T172* C,T0* a1,T0* a2);
T2 r172rank_of(T172* C,T0* a1);
void r172make(T172* C,T0* a1);
void r172fatal_error(T0* a1);
void r172check_name_clash(T172* C,T0* a1);
void r172declaration_list_make(T172* C,T0* a1);
void r172with(T172* C,T0* a1,T0* a2);
T0* r172type(T172* C,T2 a1);
void r172dynamic_runnable(T172* C,T0* a1);
void r172error(T0* a1,T0* a2);
T6 r172is_runnable(T172* C,T0* a1);
void r172pretty_print(T172* C);
T0* r172start_position(T172* C);
T6 r273is_merge_with(T273* C,T0* a1,T0* a2);
T6 r273is_merge_with2aux(T273* C,T0* a1,T0* a2);
T0* r273try_to_undefine(T273* C,T0* a1,T0* a2);
void r273check_obsolete(T273* C,T0* a1);
T6 r273is_merge_with1(T273* C,T0* a1);
T6 r273is_merge_with2(T273* C,T0* a1,T0* a2);
T0* r273to_run_feature(T273* C,T0* a1,T0* a2);
void r273error(T0* a1,T0* a2);
void r273pretty_print_names(T273* C);
void r273set_header_comment(T273* C,T0* a1);
void r273set_rescue_compound(T273* C,T0* a1);
void r273make_routine(T273* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r273make(T273* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r273pretty_print_profile(T273* C);
void r273add_into(T273* C,T0* a1);
T6 r273can_hide(T273* C,T0* a1,T0* a2);
void r273from_effective(T273* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r273merge_header_comments(T273* C,T0* a1);
void r273pretty_print(T273* C);
void r273pretty_print_arguments(T273* C);
T0* r273start_position(T273* C);
T0* r192value(T192* C,T2 a1);
void r192pretty_tail(T192* C);
T6 r192is_merge_with(T192* C,T0* a1,T0* a2);
T6 r192is_merge_with2aux(T192* C,T0* a1,T0* a2);
T0* r192try_to_undefine_aux(T192* C,T0* a1,T0* a2);
T0* r192try_to_undefine(T192* C,T0* a1,T0* a2);
void r192check_obsolete(T192* C,T0* a1);
T6 r192is_merge_with1(T192* C,T0* a1);
T6 r192is_merge_with2(T192* C,T0* a1,T0* a2);
T0* r192to_run_feature(T192* C,T0* a1,T0* a2);
void r192error(T0* a1,T0* a2);
void r192pretty_print_names(T192* C);
void r192make(T192* C,T0* a1,T0* a2,T0* a3);
void r192pretty_print_profile(T192* C);
void r192add_into(T192* C,T0* a1);
T6 r192can_hide(T192* C,T0* a1,T0* a2);
void r192merge_header_comments(T192* C,T0* a1);
void r192pretty_print(T192* C);
T0* r192start_position(T192* C);
void r56check_expanded_with(T56* C,T0* a1);
void r56fatal_error(T0* a1);
T0* r56expanded_initializer(T56* C,T0* a1);
T0* r56get_clause(T56* C,T0* a1);
void r56pretty_print(T56* C);
T0* r56start_position(T56* C);
T0* r216add_comment(T216* C,T0* a1);
T0* r216to_runnable(T216* C,T0* a1);
void r35put_string(T35* C,T0* a1);
void r35put_integer(T35* C,T2 a1);
T0* r95type_any(void);
T0* r95static_result_base_class(void);
void r95make(T95* C,T0* a1,T0* a2);
void r95assertion_check(T95* C,T3 a1);
T0* r95add_comment(T95* C,T0* a1);
T0* r95to_runnable(T95* C,T0* a1);
T2 r95to_integer(T95* C);
void r95error(T0* a1,T0* a2);
void r95bracketed_pretty_print(T95* C);
void r95pretty_print(T95* C);
void r95print_as_target(T95* C);
T0* r147runnable_expression(T0* a1,T0* a2);
T0* r147run_feature_for(T147* C,T0* a1,T0* a2);
void r147make(T147* C,T0* a1,T0* a2);
void r147fatal_error(T0* a1);
void r147run_feature_has_no_result(T147* C);
void r147run_feature_match(T147* C);
T0* r147add_comment(T147* C,T0* a1);
T0* r147to_runnable(T147* C,T0* a1);
T0* r147make_runnable(T147* C,T0* a1,T0* a2,T0* a3);
void r147pretty_print(T147* C);
T0* r147start_position(T147* C);
T0* r118runnable_expression(T0* a1,T0* a2);
void r118run_feature_has_result(T118* C);
void r118run_feature_match(T118* C,T0* a1);
T0* r118add_comment(T118* C,T0* a1);
void r118with(T118* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r118operator(void);
T0* r118runnable_args(T0* a1,T0* a2);
T0* r118to_runnable(T118* C,T0* a1);
T2 r118to_integer(T118* C);
void r118error(T0* a1,T0* a2);
void r118bracketed_pretty_print(T118* C);
T0* r118result_type(T118* C);
void r118print_as_target(T118* C);
void r118print_op(T118* C);
T0* r118run_feature_for(T118* C,T0* a1,T0* a2);
T0* r118static_result_base_class(T118* C);
void r118make(T118* C,T0* a1,T0* a2,T0* a3);
void r118fatal_error(T0* a1);
void r118assertion_check(T118* C,T3 a1);
void r118pretty_print(T118* C);
T0* r225to_runnable_integer(T225* C,T0* a1);
T0* r225to_runnable_character(T225* C,T0* a1);
T0* r225twin(T225* C);
void r225error(T0* a1,T0* a2);
void r225pretty_print(T225* C);
T0* r225start_position(T225* C);
T2 r215precedence(T215* C);
T6 r215is_current(T215* C);
T0* r215static_result_base_class(T215* C);
void r215make(T215* C,T0* a1,T0* a2);
void r215assertion_check(T215* C,T3 a1);
T0* r215add_comment(T215* C,T0* a1);
T0* r215to_runnable(T215* C,T0* a1);
T2 r215to_integer(T215* C);
T6 r215is_void(T215* C);
void r215error(T0* a1,T0* a2);
void r215bracketed_pretty_print(T215* C);
void r215pretty_print(T215* C);
T0* r215result_type(T215* C);
void r215print_as_target(T215* C);
T0* r215start_position(T215* C);
T0* r148runnable_expression(T0* a1,T0* a2);
T0* r148run_feature_for(T148* C,T0* a1,T0* a2);
void r148make(T148* C,T0* a1,T0* a2,T0* a3);
void r148fatal_error(T0* a1);
void r148run_feature_has_no_result(T148* C);
void r148run_feature_match(T148* C,T0* a1);
T0* r148add_comment(T148* C,T0* a1);
void r148with(T148* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r148runnable_args(T0* a1,T0* a2);
T0* r148to_runnable(T148* C,T0* a1);
T0* r148make_runnable(T148* C,T0* a1,T0* a2,T0* a3);
void r148pretty_print(T148* C);
T0* r148start_position(T148* C);
void r34put_string(T34* C,T0* a1);
void r34put_integer(T34* C,T2 a1);
void r34sfr_connect(T34* C,T0* a1,T0* a2);
void r34w_put_string(T0* a1);
void r34w_put_integer(T2 a1);
void r34w_put_character(T3 a1);
extern T0*oBC1std_error;
void r34put_character(T34* C,T3 a1);
extern T0*oBC1std_output;
T6 r271is_merge_with(T271* C,T0* a1,T0* a2);
T6 r271is_merge_with2aux(T271* C,T0* a1,T0* a2);
T0* r271try_to_undefine(T271* C,T0* a1,T0* a2);
void r271check_obsolete(T271* C,T0* a1);
T6 r271is_merge_with1(T271* C,T0* a1);
T6 r271is_merge_with2(T271* C,T0* a1,T0* a2);
T0* r271to_run_feature(T271* C,T0* a1,T0* a2);
void r271error(T0* a1,T0* a2);
void r271pretty_print_names(T271* C);
void r271set_header_comment(T271* C,T0* a1);
void r271set_rescue_compound(T271* C,T0* a1);
void r271make_routine(T271* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r271pretty_print_profile(T271* C);
void r271add_into(T271* C,T0* a1);
T6 r271can_hide(T271* C,T0* a1,T0* a2);
void r271from_effective(T271* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r271merge_header_comments(T271* C,T0* a1);
void r271pretty_print(T271* C);
void r271pretty_print_arguments(T271* C);
T0* r271start_position(T271* C);
extern int fBC12class_general;
extern T0*oBC12class_general;
T0* r314class_general(void);
T0* r314at(T314* C,T0* a1);
T0* r314base_class(T314* C);
T0* r314get_feature(T314* C,T0* a1);
void r314set_at_run_time(T314* C);
void r314error(T0* a1,T0* a2);
void r314store_feature(T314* C,T0* a1);
void r314make(T314* C,T0* a1);
void r314fatal_error(T0* a1);
extern T0*oBC314to_reference_memory;
void r314efnf(T314* C,T0* a1,T0* a2);
T0* r314get_or_fatal_error(T314* C,T0* a1);
T0* r314get_result_type(T314* C,T0* a1);
T0* r314get_copy(T314* C);
T6 r314is_running_of(T314* C,T0* a1);
T0* r314get_feature_with(T314* C,T0* a1);
void r314used_as_reference(T314* C);
T0* r314get_rf_with(T314* C,T0* a1);
void r314add_running(T314* C,T0* a1);
void r314add_rf(T314* C,T0* a1,T0* a2);
T0* r314class_with(T0* a1);
extern int fBC12id_provider;
extern T0*oBC12id_provider;
T0* r314id_provider(void);
void r314add_client(T314* C,T0* a1);
void r232make(T232* C,T0* a1,T0* a2);
void r232fatal_error(T0* a1);
void r232warning(T0* a1,T0* a2);
T0* r232add_comment(T232* C,T0* a1);
void r232check_created_type(T232* C,T0* a1);
void r232check_creation_clause(T232* C,T0* a1);
void r232check_writable(T232* C,T0* a1);
T0* r232to_runnable(T232* C,T0* a1);
void r232error(T0* a1,T0* a2);
void r232pretty_print(T232* C);
void r217make(T217* C,T0* a1,T0* a2);
T0* r217add_comment(T217* C,T0* a1);
void r217set_else_compound(T217* C,T0* a1,T0* a2);
T0* r217to_runnable(T217* C,T0* a1);
T0* r217twin(T217* C);
void r217error(T0* a1,T0* a2);
void r217pretty_print(T217* C);
void r217add_when(T217* C,T0* a1);
T0* r136runnable_expression(T0* a1,T0* a2);
void r136run_feature_has_result(T136* C);
T0* r136run_feature_for(T136* C,T0* a1,T0* a2);
T0* r136static_result_base_class(T136* C);
void r136make(T136* C,T0* a1,T0* a2,T0* a3);
void r136fatal_error(T0* a1);
void r136run_feature_match(T136* C,T0* a1);
void r136assertion_check(T136* C,T3 a1);
T0* r136add_comment(T136* C,T0* a1);
void r136with(T136* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r136runnable_args(T0* a1,T0* a2);
T0* r136to_runnable(T136* C,T0* a1);
T2 r136to_integer(T136* C);
void r136error(T0* a1,T0* a2);
void r136bracketed_pretty_print(T136* C);
void r136pretty_print(T136* C);
T0* r136result_type(T136* C);
void r136print_as_target(T136* C);
T0* r136start_position(T136* C);
T0* r134runnable_expression(T0* a1,T0* a2);
void r134run_feature_has_result(T134* C);
T0* r134run_feature_for(T134* C,T0* a1,T0* a2);
T0* r134static_result_base_class(T134* C);
void r134make(T134* C,T0* a1,T0* a2);
void r134fatal_error(T0* a1);
void r134run_feature_match(T134* C);
void r134assertion_check(T134* C,T3 a1);
T0* r134add_comment(T134* C,T0* a1);
void r134with(T134* C,T0* a1,T0* a2,T0* a3);
T0* r134to_runnable(T134* C,T0* a1);
T2 r134to_integer(T134* C);
void r134error(T0* a1,T0* a2);
void r134bracketed_pretty_print(T134* C);
void r134pretty_print(T134* C);
T0* r134result_type(T134* C);
void r134print_as_target(T134* C);
T0* r134start_position(T134* C);
T0* r219to_runnable_integer(T219* C,T0* a1);
void r219from_when_list(T219* C,T0* a1);
T0* r219to_runnable_character(T219* C,T0* a1);
T6 r219includes_integer(T219* C,T2 a1);
void r219error(T0* a1,T0* a2);
void r219pretty_print(T219* C);
T0* r219start_position(T219* C);
T0* r111runnable_expression(T0* a1,T0* a2);
void r111run_feature_has_result(T111* C);
void r111run_feature_match(T111* C,T0* a1);
T0* r111add_comment(T111* C,T0* a1);
void r111with(T111* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r111operator(void);
T0* r111runnable_args(T0* a1,T0* a2);
T0* r111to_runnable(T111* C,T0* a1);
T2 r111to_integer(T111* C);
void r111error(T0* a1,T0* a2);
void r111bracketed_pretty_print(T111* C);
T0* r111result_type(T111* C);
void r111print_as_target(T111* C);
void r111print_op(T111* C);
T0* r111run_feature_for(T111* C,T0* a1,T0* a2);
T0* r111static_result_base_class(T111* C);
void r111make(T111* C,T0* a1,T0* a2,T0* a3);
void r111fatal_error(T0* a1);
void r111assertion_check(T111* C,T3 a1);
void r111pretty_print(T111* C);
T0* r109runnable_expression(T0* a1,T0* a2);
void r109run_feature_has_result(T109* C);
void r109run_feature_match(T109* C,T0* a1);
T0* r109add_comment(T109* C,T0* a1);
void r109with(T109* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r109operator(void);
T0* r109runnable_args(T0* a1,T0* a2);
T0* r109to_runnable(T109* C,T0* a1);
T2 r109to_integer(T109* C);
void r109error(T0* a1,T0* a2);
void r109bracketed_pretty_print(T109* C);
T0* r109result_type(T109* C);
void r109print_as_target(T109* C);
void r109print_op(T109* C);
T0* r109run_feature_for(T109* C,T0* a1,T0* a2);
T0* r109static_result_base_class(T109* C);
void r109make(T109* C,T0* a1,T0* a2,T0* a3);
void r109fatal_error(T0* a1);
void r109assertion_check(T109* C,T3 a1);
void r109pretty_print(T109* C);
T0* r226to_runnable_integer(T226* C,T0* a1);
void r226make(T226* C,T0* a1,T0* a2);
T0* r226to_runnable_character(T226* C,T0* a1);
T0* r226twin(T226* C);
void r226error(T0* a1,T0* a2);
void r226pretty_print(T226* C);
T0* r226start_position(T226* C);
void r201make(T201* C,T0* a1,T0* a2,T0* a3);
void r201fatal_error(T0* a1);
T0* r201to_runnable(T201* C,T0* a1);
void r201put(T201* C,T0* a1,T2 a2);
T2 r201count(T201* C);
void r201pretty_print(T201* C);
void r201from_compound(T201* C,T0* a1);
T0* r201item(T201* C,T2 a1);
T0* r201start_position(T201* C);
extern int fBC12type_pointer;
extern T0*oBC12type_pointer;
T0* r144type_pointer(void);
extern T0*oBC12address_of_pool;
T0* r144static_result_base_class(void);
T0* r144add_comment(T144* C,T0* a1);
T0* r144to_runnable(T144* C,T0* a1);
T2 r144to_integer(T144* C);
void r144error(T0* a1,T0* a2);
void r144bracketed_pretty_print(T144* C);
void r144pretty_print(T144* C);
T0* r144start_position(T144* C);
T0* r329run_class(T329* C);
void r329make(T329* C,T0* a1,T0* a2,T0* a3);
void r329initialize(T329* C);
T6 r329is_exported_in(T329* C,T0* a1);
T0* r329clients(T329* C);
T0* r329start_position(T329* C);
void r30disconnect(T30* C);
void r30read_line_in(T30* C,T0* a1);
T6 r30end_of_input(T30* C);
extern T0*oBC31last_string;
void r30read_character(T30* C);
void r30read_line(T30* C);
void r30read_word(T30* C);
void r30connect_to(T30* C,T0* a1);
void r30skip_separators(T30* C);
void r296make(T296* C,T0* a1,T0* a2);
void r296append_in(T296* C,T0* a1);
T2 r296count(T296* C);
void r296pretty_print(T296* C);
T0* r157static_result_base_class(void);
void r157make(T157* C,T0* a1,T0* a2);
T0* r157add_comment(T157* C,T0* a1);
T0* r157to_runnable(T157* C,T0* a1);
T2 r157to_integer(T157* C);
void r157error(T0* a1,T0* a2);
void r157bracketed_pretty_print(T157* C);
void r157pretty_print(T157* C);
void r157print_as_target(T157* C);
T0* r207add_comment(T207* C,T0* a1);
void r207add_if_then(T207* C,T0* a1,T0* a2);
T0* r207to_runnable(T207* C,T0* a1);
T0* r207twin(T207* C);
void r207pretty_print(T207* C);
T6 r55ensure_check(T55* C);
T6 r55debug_check(T55* C);
T6 r55loop_check(T55* C);
T6 r55boost(T55* C);
T6 r55all_check(T55* C);
T6 r55require_check(T55* C);
T6 r266is_any(T266* C);
void r266fatal_error_generic_list(T266* C);
T6 r266is_string(T266* C);
T0* r266generic_list(T266* C);
T0* r266constraint(T266* C);
T2 r266id(T266* C);
T0* r266smallest_ancestor(T266* C,T0* a1);
void r266warning(T0* a1,T0* a2);
T0* r266base_class(T266* C);
T6 r266is_array(T266* C);
T6 r266is_double(T266* C);
T6 r266is_none(T266* C);
T0* r266look_up_for(T266* C,T0* a1,T0* a2);
T0* r266to_runnable(T266* C,T0* a1);
T0* r266make_runnable(T266* C,T0* a1);
T6 r266has_creation(T266* C,T0* a1);
T0* r266twin(T266* C);
T6 r266is_pointer(T266* C);
T0* r266formal_arg(T266* C);
void r266error(T0* a1,T0* a2);
T0* r266static_base_class_name(T266* C);
T6 r266is_a_in(T266* C,T0* a1,T0* a2);
T0* r266run_time_mark(T266* C);
T6 r266is_boolean(T266* C);
T6 r266is_a(T266* C,T0* a1);
T0* r266run_class(T266* C);
T6 r266is_generic(T266* C);
void r266make(T266* C,T0* a1,T2 a2);
void r266fatal_error(T0* a1);
T6 r266is_expanded(T266* C);
T0* r266expanded_initializer(T266* C);
T6 r266is_basic_eiffel_expanded(T266* C);
void r266used_as_reference(T266* C);
T0* r266formal_generic_list(T266* C);
T6 r266is_character(T266* C);
T6 r266is_reference(T266* C);
T6 r266is_real(T266* C);
T0* r266base_class_name(T266* C);
T6 r266is_bit(T266* C);
T6 r266is_integer(T266* C);
void r235make(T235* C,T0* a1,T0* a2,T0* a3);
void r235fatal_error(T0* a1);
void r235warning(T0* a1,T0* a2);
T0* r235add_comment(T235* C,T0* a1);
void r235check_created_type(T235* C,T0* a1);
void r235check_creation_clause(T235* C,T0* a1);
void r235check_writable(T235* C,T0* a1);
T0* r235to_runnable(T235* C,T0* a1);
void r235check_explicit_type(T235* C);
void r235error(T0* a1,T0* a2);
void r235pretty_print(T235* C);
void r302make(T302* C,T0* a1,T0* a2);
void r302make_all(T302* C,T0* a1);
T6 r302affect(T302* C,T0* a1);
void r302pretty_print(T302* C);
void r90make(T90* C,T0* a1,T0* a2);
T0* r330runnable(T0* a1,T0* a2,T0* a3,T3 a4);
T0* r330require_end(T330* C,T0* a1,T0* a2);
void r330assertion_add_last(T330* C,T0* a1);
T0* r330ensure_end(T330* C,T0* a1,T0* a2);
extern T0*oBC330collector;
void r330ensure_start(T330* C);
void r330require_start(T330* C);
void r330error(T0* a1,T0* a2);
T6 r50is_subclass_of(T50* C,T0* a1);
void r50make(T50* C,T0* a1,T0* a2);
T0* r50base_class(T50* C);
void r50make_unknown(T50* C);
void r255fatal_error_generic_list(T255* C);
T0* r255generic_list(T255* C);
T0* r255smallest_ancestor(T255* C,T0* a1);
extern int fBC255check_type;
void r255check_type(T255* C);
T0* r255base_class(T255* C);
void r255load_ref(T0* a1);
T0* r255look_up_for(T255* C,T0* a1,T0* a2);
T0* r255to_runnable(T255* C,T0* a1);
T6 r255has_creation(T255* C,T0* a1);
extern int fBC12type_pointer_ref;
extern T0*oBC12type_pointer_ref;
T0* r255type_pointer_ref(void);
void r255error(T0* a1,T0* a2);
T6 r255is_a_in(T255* C,T0* a1,T0* a2);
T0* r255run_time_mark(void);
T6 r255is_a(T255* C,T0* a1);
T0* r255run_class(T255* C);
void r255make(T255* C,T0* a1);
extern int fBC255used_as_reference;
void r255used_as_reference(void);
T0* r255written_mark(void);
void r253fatal_error_generic_list(T253* C);
T0* r253generic_list(T253* C);
T0* r253smallest_ancestor(T253* C,T0* a1);
extern int fBC253check_type;
void r253check_type(T253* C);
T0* r253base_class(T253* C);
void r253load_ref(T0* a1);
T0* r253look_up_for(T253* C,T0* a1,T0* a2);
T0* r253to_runnable(T253* C,T0* a1);
T6 r253has_creation(T253* C,T0* a1);
extern int fBC12type_integer_ref;
extern T0*oBC12type_integer_ref;
T0* r253type_integer_ref(void);
void r253error(T0* a1,T0* a2);
T6 r253is_a_in(T253* C,T0* a1,T0* a2);
T0* r253run_time_mark(void);
T6 r253is_a(T253* C,T0* a1);
T0* r253run_class(T253* C);
void r253make(T253* C,T0* a1);
extern int fBC253used_as_reference;
void r253used_as_reference(void);
T0* r253written_mark(void);
void r29environment_variable_substitution(T29* C,T0* a1,T0* a2);
T6 r29backslash_separator(T29* C);
T0* r29get_environment_variable(T29* C,T0* a1);
void r29make(T29* C);
extern T0*oBC29system_list;
void r29bad_use_exit(T29* C,T0* a1);
T6 r29slash_separator(T29* C);
void r29append_lp_in(T29* C,T0* a1,T0* a2);
void r29loading_path_add(T29* C,T0* a1,T0* a2,T2 a3);
void r29add_directory(T29* C,T0* a1,T0* a2);
void r29parent_directory(T29* C,T0* a1);
void r29read_loading_path_in(T29* C,T0* a1);
T0* r347run_class(T347* C);
void r347make(T347* C,T0* a1,T0* a2,T0* a3);
void r347initialize(T347* C);
T6 r347is_exported_in(T347* C,T0* a1);
T0* r347clients(T347* C);
T0* r105runnable_expression(T0* a1,T0* a2);
void r105run_feature_has_result(T105* C);
void r105run_feature_match(T105* C,T0* a1);
T0* r105add_comment(T105* C,T0* a1);
void r105with(T105* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r105operator(void);
T0* r105runnable_args(T0* a1,T0* a2);
T0* r105to_runnable(T105* C,T0* a1);
T2 r105to_integer(T105* C);
void r105error(T0* a1,T0* a2);
void r105bracketed_pretty_print(T105* C);
T0* r105result_type(T105* C);
void r105print_as_target(T105* C);
void r105print_op(T105* C);
T0* r105run_feature_for(T105* C,T0* a1,T0* a2);
T0* r105static_result_base_class(T105* C);
void r105make(T105* C,T0* a1,T0* a2,T0* a3);
void r105fatal_error(T0* a1);
void r105assertion_check(T105* C,T3 a1);
void r105pretty_print(T105* C);
void r260from_other(T260* C,T0* a1,T0* a2);
T0* r260generic_list(T260* C);
T2 r260id(T260* C);
T0* r260smallest_ancestor(T260* C,T0* a1);
T0* r260string_aliaser(void);
T0* r260base_class(T260* C);
T6 r260is_double(T260* C);
T0* r260look_up_for(T260* C,T0* a1,T0* a2);
T0* r260to_runnable(T260* C,T0* a1);
T6 r260has_creation(T260* C,T0* a1);
T6 r260is_pointer(T260* C);
T0* r260compute_mark(T0* a1);
T6 r260is_a_in(T260* C,T0* a1,T0* a2);
T6 r260is_boolean(T260* C);
T6 r260is_a(T260* C,T0* a1);
extern T0*oBC260tmp_written_mark;
T6 r260is_generic(T260* C);
T0* r260run_class(T260* C);
void r260make(T260* C,T0* a1,T0* a2);
void r260fatal_error(T0* a1);
T0* r260expanded_initializer(T260* C);
T6 r260is_basic_eiffel_expanded(T260* C);
void r260used_as_reference(T260* C);
T6 r260is_character(T260* C);
T6 r260is_real(T260* C);
T0* r260base_class_name(T260* C);
T6 r260is_bit(T260* C);
T6 r260is_integer(T260* C);
T6 r277is_merge_with(T277* C,T0* a1,T0* a2);
T6 r277is_merge_with2aux(T277* C,T0* a1,T0* a2);
T0* r277try_to_undefine_aux(T277* C,T0* a1,T0* a2);
T0* r277try_to_undefine(T277* C,T0* a1,T0* a2);
void r277check_obsolete(T277* C,T0* a1);
T6 r277is_merge_with1(T277* C,T0* a1);
T6 r277is_merge_with2(T277* C,T0* a1,T0* a2);
T0* r277to_run_feature(T277* C,T0* a1,T0* a2);
void r277error(T0* a1,T0* a2);
void r277pretty_print_names(T277* C);
T0* r277external_c_name(T277* C);
void r277set_header_comment(T277* C,T0* a1);
void r277set_rescue_compound(T277* C,T0* a1);
void r277make_routine(T277* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r277make(T277* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r277pretty_print_profile(T277* C);
void r277make_external_routine(T277* C,T0* a1,T0* a2);
void r277pretty_print_routine_body(T277* C);
void r277add_into(T277* C,T0* a1);
T6 r277can_hide(T277* C,T0* a1,T0* a2);
void r277merge_header_comments(T277* C,T0* a1);
void r277pretty_print(T277* C);
void r277pretty_print_arguments(T277* C);
T0* r277start_position(T277* C);
T0* r107runnable_expression(T0* a1,T0* a2);
void r107run_feature_has_result(T107* C);
void r107run_feature_match(T107* C,T0* a1);
T0* r107add_comment(T107* C,T0* a1);
void r107with(T107* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r107operator(void);
T0* r107runnable_args(T0* a1,T0* a2);
T0* r107to_runnable(T107* C,T0* a1);
T2 r107to_integer(T107* C);
void r107error(T0* a1,T0* a2);
void r107bracketed_pretty_print(T107* C);
T0* r107result_type(T107* C);
void r107print_as_target(T107* C);
void r107print_op(T107* C);
T0* r107run_feature_for(T107* C,T0* a1,T0* a2);
T0* r107static_result_base_class(T107* C);
void r107make(T107* C,T0* a1,T0* a2,T0* a3);
void r107fatal_error(T0* a1);
void r107assertion_check(T107* C,T3 a1);
void r107pretty_print(T107* C);
T0* r132static_result_base_class(T132* C);
void r132make(T132* C,T0* a1,T0* a2);
void r132fatal_error(T0* a1);
void r132undefine_in(T132* C,T0* a1);
T0* r132origin_base_class(T132* C);
T0* r132add_comment(T132* C,T0* a1);
void r132with(T132* C,T0* a1,T0* a2);
T0* r132to_runnable(T132* C,T0* a1);
T2 r132to_integer(T132* C);
void r132error(T0* a1,T0* a2);
void r132print_as_target(T132* C);
T0* r132run_feature(T132* C,T0* a1);
T0* r149runnable_expression(T0* a1,T0* a2);
T0* r149run_feature_for(T149* C,T0* a1,T0* a2);
void r149make(T149* C,T0* a1,T0* a2,T0* a3);
void r149fatal_error(T0* a1);
void r149run_feature_has_no_result(T149* C);
void r149run_feature_match(T149* C,T0* a1);
T0* r149add_comment(T149* C,T0* a1);
void r149with(T149* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r149runnable_args(T0* a1,T0* a2);
T0* r149to_runnable(T149* C,T0* a1);
T0* r149make_runnable(T149* C,T0* a1,T0* a2,T0* a3);
void r149pretty_print(T149* C);
T0* r149start_position(T149* C);
void r301declaration_in(T301* C,T0* a1);
void r301declaration_pretty_print(T301* C);
void r301undefine_in(T301* C,T0* a1);
T0* r301origin_base_class(T301* C);
T0* r301to_key(T301* C);
T0* r301to_string(T301* C);
void r301error(T0* a1,T0* a2);
void r301pretty_print(T301* C);
T0* r301start_position(T301* C);
void r237make(T237* C,T0* a1,T0* a2,T0* a3);
void r237fatal_error(T0* a1);
void r237warning(T0* a1,T0* a2);
T0* r237add_comment(T237* C,T0* a1);
void r237check_created_type(T237* C,T0* a1);
T2 r237arg_count(T237* C);
void r237check_creation_clause(T237* C,T0* a1);
void r237check_writable(T237* C,T0* a1);
T0* r237to_runnable(T237* C,T0* a1);
void r237error(T0* a1,T0* a2);
void r237pretty_print(T237* C);
void r237cp_not_found(T237* C,T0* a1);
T0* r315run_ensure(T315* C);
T0* r315run_class(T315* C);
void r315make(T315* C,T0* a1,T0* a2,T0* a3);
T0* r315run_require(T315* C);
void r315initialize(T315* C);
extern T0*oBC12exceptions_handler;
T6 r315is_exported_in(T315* C,T0* a1);
T0* r315clients(T315* C);
void r71make(T71* C,T0* a1,T0* a2);
void r71fatal_error(T0* a1);
void r71pretty_print(T71* C);
T6 r300is_merge_with(T300* C,T0* a1,T0* a2);
T6 r300is_merge_with2aux(T300* C,T0* a1,T0* a2);
T0* r300try_to_undefine_aux(T300* C,T0* a1,T0* a2);
T0* r300try_to_undefine(T300* C,T0* a1,T0* a2);
void r300check_obsolete(T300* C,T0* a1);
T6 r300is_merge_with1(T300* C,T0* a1);
T6 r300is_merge_with2(T300* C,T0* a1,T0* a2);
T0* r300to_run_feature(T300* C,T0* a1,T0* a2);
void r300error(T0* a1,T0* a2);
void r300pretty_print_names(T300* C);
void r300make(T300* C,T0* a1,T0* a2);
void r300pretty_print_profile(T300* C);
void r300add_into(T300* C,T0* a1);
T6 r300can_hide(T300* C,T0* a1,T0* a2);
void r300merge_header_comments(T300* C,T0* a1);
void r300pretty_print(T300* C);
T0* r300start_position(T300* C);
T6 r276is_merge_with(T276* C,T0* a1,T0* a2);
T6 r276is_merge_with2aux(T276* C,T0* a1,T0* a2);
T0* r276try_to_undefine_aux(T276* C,T0* a1,T0* a2);
T0* r276try_to_undefine(T276* C,T0* a1,T0* a2);
void r276check_obsolete(T276* C,T0* a1);
T6 r276is_merge_with1(T276* C,T0* a1);
T6 r276is_merge_with2(T276* C,T0* a1,T0* a2);
T0* r276to_run_feature(T276* C,T0* a1,T0* a2);
void r276error(T0* a1,T0* a2);
void r276pretty_print_names(T276* C);
T0* r276external_c_name(T276* C);
void r276set_header_comment(T276* C,T0* a1);
void r276set_rescue_compound(T276* C,T0* a1);
void r276make_routine(T276* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r276make(T276* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r276pretty_print_profile(T276* C);
void r276make_external_routine(T276* C,T0* a1,T0* a2);
void r276pretty_print_routine_body(T276* C);
void r276add_into(T276* C,T0* a1);
T6 r276can_hide(T276* C,T0* a1,T0* a2);
void r276merge_header_comments(T276* C,T0* a1);
void r276pretty_print(T276* C);
void r276pretty_print_arguments(T276* C);
T0* r276start_position(T276* C);
T0* r141add_comment(T141* C,T0* a1);
T2 r141to_integer(T141* C);
void r141error(T0* a1,T0* a2);
extern int fBC141result_type;
extern T0*oBC141result_type;
T0* r141result_type(void);
T0* r339run_ensure(T339* C);
T0* r339run_class(T339* C);
void r339make(T339* C,T0* a1,T0* a2,T0* a3);
T0* r339run_require(T339* C);
void r339initialize(T339* C);
T6 r339is_exported_in(T339* C,T0* a1);
T0* r339clients(T339* C);
void r239make(T239* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r239fatal_error(T0* a1);
void r239warning(T0* a1,T0* a2);
T0* r239add_comment(T239* C,T0* a1);
void r239check_created_type(T239* C,T0* a1);
T2 r239arg_count(T239* C);
void r239check_creation_clause(T239* C,T0* a1);
void r239check_writable(T239* C,T0* a1);
T0* r239to_runnable(T239* C,T0* a1);
void r239check_explicit_type(T239* C);
void r239error(T0* a1,T0* a2);
void r239pretty_print(T239* C);
void r239cp_not_found(T239* C,T0* a1);
void r162prepare_arguments(T162* C,T0* a1);
void r162make(T162* C,T0* a1,T0* a2,T0* a3);
void r162fatal_error(T0* a1);
T0* r162precursor_name(T0* a1,T0* a2);
T0* r162add_comment(T162* C,T0* a1);
T0* r162super_feature(T162* C,T0* a1);
T0* r162to_runnable(T162* C,T0* a1);
void r162error(T0* a1,T0* a2);
void r162pretty_print(T162* C);
void r83make(T83* C,T0* a1,T0* a2);
T0* r83merge_with(T83* C,T0* a1);
void r83merge(T83* C,T0* a1,T0* a2,T0* a3);
T6 r83gives_permission_to_any(T83* C);
T6 r83gives_permission_to(T83* C,T0* a1);
T0* r83append(T83* C,T0* a1);
void r83pretty_print(T83* C);
void r83vape_check(T83* C,T0* a1,T0* a2);
void r83gives_permission_error(T83* C,T6 a1,T0* a2);
T0* r152type_boolean(void);
T0* r152static_result_base_class(void);
T0* r152add_comment(T152* C,T0* a1);
T0* r152to_string(void);
void r152error(T0* a1,T0* a2);
T0* r121runnable_expression(T0* a1,T0* a2);
void r121run_feature_has_result(T121* C);
void r121run_feature_match(T121* C,T0* a1);
T0* r121add_comment(T121* C,T0* a1);
void r121with(T121* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r121runnable_args(T0* a1,T0* a2);
T0* r121to_runnable(T121* C,T0* a1);
T2 r121to_integer(T121* C);
void r121error(T0* a1,T0* a2);
void r121bracketed_pretty_print(T121* C);
T0* r121result_type(T121* C);
void r121print_as_target(T121* C);
void r121print_op(T121* C);
T0* r121run_feature_for(T121* C,T0* a1,T0* a2);
T0* r121static_result_base_class(T121* C);
void r121make(T121* C,T0* a1,T0* a2,T0* a3);
void r121fatal_error(T0* a1);
void r121assertion_check(T121* C,T3 a1);
void r121pretty_print(T121* C);
T6 r289is_merge_with(T289* C,T0* a1,T0* a2);
T6 r289is_merge_with2aux(T289* C,T0* a1,T0* a2);
void r289pretty_print_rescue(T289* C);
T0* r289try_to_undefine_aux(T289* C,T0* a1,T0* a2);
T0* r289try_to_undefine(T289* C,T0* a1,T0* a2);
void r289check_obsolete(T289* C,T0* a1);
T6 r289is_merge_with1(T289* C,T0* a1);
T6 r289is_merge_with2(T289* C,T0* a1,T0* a2);
T0* r289to_run_feature(T289* C,T0* a1,T0* a2);
void r289error(T0* a1,T0* a2);
void r289pretty_print_names(T289* C);
void r289set_header_comment(T289* C,T0* a1);
void r289make_routine(T289* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r289make(T289* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r289pretty_print_profile(T289* C);
void r289pretty_print_routine_body(T289* C);
void r289add_into(T289* C,T0* a1);
T6 r289can_hide(T289* C,T0* a1,T0* a2);
void r289merge_header_comments(T289* C,T0* a1);
void r289make_effective_routine(T289* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r289pretty_print(T289* C);
void r289pretty_print_arguments(T289* C);
T0* r289start_position(T289* C);
T0* r130static_result_base_class(T130* C);
void r130assertion_check(T130* C,T3 a1);
T0* r130add_comment(T130* C,T0* a1);
T0* r130to_runnable(T130* C,T0* a1);
T2 r130to_integer(T130* C);
void r130error(T0* a1,T0* a2);
void r130bracketed_pretty_print(T130* C);
void r130pretty_print(T130* C);
T0* r130result_type(T130* C);
void r130print_as_target(T130* C);
extern T0*oBC130vaol_check_memory;
T0* r130start_position(T130* C);
void r211make(T211* C,T0* a1,T0* a2);
T0* r211to_runnable(T211* C,T0* a1);
void r211error(T0* a1,T0* a2);
void r211pretty_print(T211* C);
void r190pretty_tail(T190* C);
T6 r190is_merge_with(T190* C,T0* a1,T0* a2);
T6 r190is_merge_with2aux(T190* C,T0* a1,T0* a2);
T0* r190try_to_undefine_aux(T190* C,T0* a1,T0* a2);
T0* r190try_to_undefine(T190* C,T0* a1,T0* a2);
void r190check_obsolete(T190* C,T0* a1);
T6 r190is_merge_with1(T190* C,T0* a1);
T6 r190is_merge_with2(T190* C,T0* a1,T0* a2);
T0* r190to_run_feature(T190* C,T0* a1,T0* a2);
void r190error(T0* a1,T0* a2);
void r190pretty_print_names(T190* C);
void r190make(T190* C,T0* a1,T0* a2,T0* a3);
void r190pretty_print_profile(T190* C);
void r190add_into(T190* C,T0* a1);
T6 r190can_hide(T190* C,T0* a1,T0* a2);
void r190merge_header_comments(T190* C,T0* a1);
void r190pretty_print(T190* C);
T0* r190start_position(T190* C);
void r69fatal_error(T0* a1);
T0* r69name_in_child(T69* C,T0* a1);
T0* r69name_in_parent(T69* C,T0* a1);
void r69get_started(T69* C,T0* a1);
void r69pretty_print(T69* C);
T0* r60first_parent_for(T60* C,T0* a1);
T0* r60going_up(T60* C,T0* a1,T0* a2,T0* a3);
void r60inherit_cycle_check(T60* C);
T6 r60has_redefine(T60* C,T0* a1);
T0* r60repeated_inheritance(T60* C,T0* a1,T0* a2,T0* a3);
T0* r60precursor_for(T60* C,T0* a1,T0* a2);
void r60make(T60* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r60fatal_error(T0* a1);
T0* r60smallest_ancestor(T60* C,T0* a1,T0* a2);
T6 r60has_parent(T60* C,T0* a1);
T6 r60is_a_vncg(T60* C,T0* a1,T0* a2);
void r60collect_assertion(T60* C,T0* a1);
T0* r60clients_for(T60* C,T0* a1);
T0* r60look_up_for(T60* C,T0* a1,T0* a2);
T0* r60e_feature(T60* C,T0* a1);
void r60get_started(T60* C);
T0* r60up_to_original(T60* C,T0* a1,T0* a2);
T0* r60next_parent_for(T60* C,T0* a1,T0* a2);
void r60pretty_print(T60* C);
T0* r340run_ensure(T340* C);
T0* r340run_class(T340* C);
void r340make(T340* C,T0* a1,T0* a2,T0* a3);
T0* r340run_require(T340* C);
extern T0*oBC12once_routine_pool;
void r340initialize(T340* C);
T6 r340is_exported_in(T340* C,T0* a1);
T0* r340clients(T340* C);
T0* r137runnable_expression(T0* a1,T0* a2);
void r137run_feature_has_result(T137* C);
T0* r137run_feature_for(T137* C,T0* a1,T0* a2);
T0* r137static_result_base_class(T137* C);
void r137make(T137* C,T0* a1,T0* a2,T0* a3);
void r137fatal_error(T0* a1);
void r137run_feature_match(T137* C,T0* a1);
void r137assertion_check(T137* C,T3 a1);
T0* r137add_comment(T137* C,T0* a1);
void r137with(T137* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r137runnable_args(T0* a1,T0* a2);
T0* r137to_runnable(T137* C,T0* a1);
T2 r137to_integer(T137* C);
void r137error(T0* a1,T0* a2);
void r137bracketed_pretty_print(T137* C);
void r137pretty_print(T137* C);
T0* r137result_type(T137* C);
void r137print_as_target(T137* C);
T0* r137start_position(T137* C);
void r84make(T84* C);
T2 r84max_id(T84* C);
void r84add2(T84* C,T0* a1,T2 a2);
T2 r84hash_code(T0* a1);
T2 r84item(T84* C,T0* a1);
T0* r123runnable_expression(T0* a1,T0* a2);
void r123run_feature_has_result(T123* C);
T0* r123run_feature_for(T123* C,T0* a1,T0* a2);
T0* r123static_result_base_class(T123* C);
void r123make(T123* C,T0* a1,T0* a2);
void r123fatal_error(T0* a1);
void r123run_feature_match(T123* C);
void r123assertion_check(T123* C,T3 a1);
T0* r123add_comment(T123* C,T0* a1);
void r123with(T123* C,T0* a1,T0* a2,T0* a3);
T0* r123to_runnable(T123* C,T0* a1);
T2 r123to_integer(T123* C);
void r123error(T0* a1,T0* a2);
void r123bracketed_pretty_print(T123* C);
void r123pretty_print(T123* C);
T0* r123result_type(T123* C);
void r123print_as_target(T123* C);
T6 r40is_equal(T40* C,T0* a1);
void r40make(T40* C,T2 a1,T2 a2);
void r40fatal_error(T0* a1);
void r40set_line_column(T40* C,T2 a1,T2 a2);
void r40with(T40* C,T2 a1,T2 a2,T0* a3);
T0* r40base_class(T40* C);
void r40show(T40* C);
T0* r40path(T40* C);
T0* r40get_line(T40* C);
void r264make(T264* C,T0* a1,T0* a2);
void r264pretty_print(T264* C);
void r218add_when_item_2(T218* C,T0* a1);
void r218add_value(T218* C,T0* a1);
T0* r218to_runnable_integer(T218* C,T0* a1);
void r218make(T218* C,T0* a1,T0* a2);
void r218from_e_when(T218* C,T0* a1);
void r218err_occ(T218* C,T2 a1,T0* a2);
T0* r218to_runnable_character(T218* C,T0* a1);
void r218add_when_item_1(T218* C,T0* a1);
void r218add_slice(T218* C,T0* a1,T0* a2);
T6 r218includes_integer(T218* C,T2 a1);
void r218error(T0* a1,T0* a2);
void r218pretty_print(T218* C);
T0* r248type_any(void);
T2 r248id(T248* C);
T0* r248smallest_ancestor(T248* C,T0* a1);
T0* r248string_aliaser(void);
T0* r248base_class(T248* C);
T0* r248look_up_for(T248* C,T0* a1,T0* a2);
T0* r248to_runnable(T248* C,T0* a1);
void r248make_runnable(T248* C,T0* a1,T0* a2);
T0* r248twin(T248* C);
T6 r248is_a_in(T248* C,T0* a1,T0* a2);
T0* r248run_time_mark(T248* C);
T6 r248is_a(T248* C,T0* a1);
T0* r248run_class(T248* C);
void r248make(T248* C,T0* a1,T0* a2);
void r248fatal_error(T0* a1);
void r248load_basic_features(T248* C);
T6 r248is_run_type(T248* C);
T0* r139static_result_base_class(void);
T0* r139add_comment(T139* C,T0* a1);
T0* r139to_runnable(T139* C,T0* a1);
T2 r139to_integer(T139* C);
void r139error(T0* a1,T0* a2);
void r306add_last(T306* C,T0* a1);
void r306pretty_print(T306* C);
T0* r344run_ensure(T344* C);
T0* r344run_class(T344* C);
void r344make(T344* C,T0* a1,T0* a2,T0* a3);
void r344fatal_error(T0* a1);
T0* r344run_require(T344* C);
void r344initialize(T344* C);
T6 r344is_exported_in(T344* C,T0* a1);
T0* r344clients(T344* C);
void r344fe_vffd7(T344* C);
void r229make(T229* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T0* r229add_comment(T229* C,T0* a1);
T0* r229to_runnable(T229* C,T0* a1);
void r229error(T0* a1,T0* a2);
void r229pretty_print(T229* C);
T0* r61going_down(T61* C,T0* a1,T0* a2);
T0* r61runnable_type(T61* C,T0* a1);
T0* r61do_rename(T61* C,T0* a1);
T0* r61precursor_for(T61* C,T0* a1,T0* a2);
T0* r61consider_export(T61* C,T0* a1);
T0* r61apply_undefine(T61* C,T0* a1,T0* a2);
T6 r61is_a_vncg(T61* C,T0* a1,T0* a2);
T0* r61base_class(T61* C);
T0* r61look_up_for(T61* C,T0* a1,T0* a2);
void r61get_started(T61* C,T0* a1);
extern T0*oBC61forbidden_parent_list;
T0* r61up_to_original(T61* C,T0* a1,T0* a2);
void r61missing_select(T0* a1,T0* a2);
T0* r61going_up(T61* C,T0* a1,T0* a2,T0* a3);
T6 r61has_redefine(T61* C,T0* a1);
T0* r61get_new_name(T61* C,T0* a1);
void r61make(T61* C,T0* a1);
T0* r61get_old_name(T61* C,T0* a1);
void r61fatal_error(T0* a1);
void r61multiple_check(T61* C,T0* a1);
T6 r61has_select_for(T61* C,T0* a1);
T0* r61name_in_parent(T61* C,T0* a1);
T0* r61has_undefine(T61* C,T0* a1);
T0* r61clients_for(T61* C,T0* a1);
T0* r61e_feature(T61* C,T0* a1);
void r61select_conflict(T0* a1,T0* a2);
void r61pretty_print(T61* C);
void r61add_rename(T61* C,T0* a1);
T0* r61start_position(T61* C);
void r195pretty_tail(T195* C);
T6 r195is_merge_with(T195* C,T0* a1,T0* a2);
T6 r195is_merge_with2aux(T195* C,T0* a1,T0* a2);
T0* r195try_to_undefine_aux(T195* C,T0* a1,T0* a2);
T0* r195try_to_undefine(T195* C,T0* a1,T0* a2);
void r195check_obsolete(T195* C,T0* a1);
T6 r195is_merge_with1(T195* C,T0* a1);
T6 r195is_merge_with2(T195* C,T0* a1,T0* a2);
T0* r195to_run_feature(T195* C,T0* a1,T0* a2);
void r195error(T0* a1,T0* a2);
void r195pretty_print_names(T195* C);
void r195make(T195* C,T0* a1,T0* a2,T0* a3);
void r195pretty_print_profile(T195* C);
void r195add_into(T195* C,T0* a1);
T6 r195can_hide(T195* C,T0* a1,T0* a2);
void r195merge_header_comments(T195* C,T0* a1);
void r195pretty_print(T195* C);
T0* r195start_position(T195* C);
void r160prepare_arguments(T160* C,T0* a1);
T0* r160static_result_base_class(T160* C);
void r160make(T160* C,T0* a1,T0* a2,T0* a3);
void r160fatal_error(T0* a1);
T0* r160precursor_name(T0* a1,T0* a2);
T0* r160add_comment(T160* C,T0* a1);
T0* r160super_feature(T160* C,T0* a1);
T0* r160to_runnable(T160* C,T0* a1);
T2 r160to_integer(T160* C);
void r160error(T0* a1,T0* a2);
void r160pretty_print(T160* C);
void r160print_as_target(T160* C);
void r304make(T304* C,T0* a1,T0* a2);
T0* r304clients_for(T304* C,T0* a1);
void r304pretty_print(T304* C);
T0* r335run_ensure(T335* C);
T0* r335run_class(T335* C);
void r335make(T335* C,T0* a1,T0* a2,T0* a3);
T0* r335run_require(T335* C);
void r335initialize(T335* C);
T6 r335is_exported_in(T335* C,T0* a1);
T0* r335clients(T335* C);
T0* r259type_any(void);
T6 r259is_written_runnable(T259* C);
T2 r259id(T259* C);
T0* r259smallest_ancestor(T259* C,T0* a1);
extern T0*oBC259tmp_mark;
T0* r259string_aliaser(void);
T0* r259base_class(T259* C);
T0* r259look_up_for(T259* C,T0* a1,T0* a2);
T0* r259to_runnable(T259* C,T0* a1);
void r259make_runnable(T259* C,T0* a1,T0* a2);
T6 r259has_creation(T259* C,T0* a1);
T0* r259twin(T259* C);
void r259basic_checks(T259* C);
T6 r259is_a_in(T259* C,T0* a1,T0* a2);
T0* r259run_time_mark(T259* C);
T6 r259is_a(T259* C,T0* a1);
T0* r259run_class(T259* C);
void r259make(T259* C,T0* a1,T0* a2);
void r259fatal_error(T0* a1);
T0* r259run_type(T259* C);
T6 r259is_expanded(T259* C);
T0* r259expanded_initializer(T259* C);
void r259used_as_reference(T259* C);
T6 r259is_reference(T259* C);
T6 r259is_run_type(T259* C);
T6 r240is_any(T240* C);
void r240fatal_error_generic_list(T240* C);
T6 r240is_string(T240* C);
T0* r240generic_list(T240* C);
T2 r240id(T240* C);
T0* r240smallest_ancestor(T240* C,T0* a1);
T0* r240string_aliaser(void);
void r240with(T240* C,T0* a1,T0* a2);
T0* r240base_class(T240* C);
T6 r240is_array(T240* C);
T6 r240is_double(T240* C);
T6 r240is_none(T240* C);
T0* r240look_up_for(T240* C,T0* a1,T0* a2);
T0* r240to_runnable(T240* C,T0* a1);
T6 r240has_creation(T240* C,T0* a1);
T6 r240is_pointer(T240* C);
T0* r240static_base_class_name(T240* C);
T6 r240is_a_in(T240* C,T0* a1,T0* a2);
T0* r240run_time_mark(T240* C);
T6 r240is_boolean(T240* C);
T6 r240is_a(T240* C,T0* a1);
T0* r240run_class(T240* C);
void r240anchor_cycle_start(T240* C);
T6 r240is_generic(T240* C);
void r240make(T240* C,T0* a1,T0* a2);
void r240fatal_error(T0* a1);
T6 r240is_expanded(T240* C);
T0* r240expanded_initializer(T240* C);
T6 r240is_basic_eiffel_expanded(T240* C);
void r240anchor_cycle_end(T240* C);
void r240used_as_reference(T240* C);
T6 r240is_character(T240* C);
T6 r240is_reference(T240* C);
T6 r240is_real(T240* C);
T0* r240base_class_name(T240* C);
extern T0*oBC241visited;
T6 r240is_bit(T240* C);
T6 r240is_integer(T240* C);
T0* r179runnable_expression(T0* a1,T0* a2);
void r179run_feature_has_result(T179* C);
void r179run_feature_match(T179* C,T0* a1);
T0* r179add_comment(T179* C,T0* a1);
void r179with(T179* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r179operator(void);
T0* r179runnable_args(T0* a1,T0* a2);
T0* r179to_runnable(T179* C,T0* a1);
T2 r179to_integer(T179* C);
void r179error(T0* a1,T0* a2);
void r179bracketed_pretty_print(T179* C);
T0* r179result_type(T179* C);
void r179print_as_target(T179* C);
void r179print_op(T179* C);
T0* r179run_feature_for(T179* C,T0* a1,T0* a2);
T0* r179static_result_base_class(T179* C);
void r179make(T179* C,T0* a1,T0* a2,T0* a3);
void r179fatal_error(T0* a1);
void r179assertion_check(T179* C,T3 a1);
void r179pretty_print(T179* C);
extern T0*oBC12cpp;
T2 r328integer_value(T328* C,T0* a1);
T0* r328type_string(void);
T0* r328run_require(T328* C);
T6 r328is_exported_in(T328* C,T0* a1);
T0* r328clients(T328* C);
T0* r328run_ensure(T328* C);
T0* r328run_class(T328* C);
void r328make(T328* C,T0* a1,T0* a2,T0* a3);
void r328fatal_error(T0* a1);
void r328initialize(T328* C);
void r57check_expanded_with(T57* C,T0* a1);
void r57make(T57* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r57fatal_error(T0* a1);
T0* r57expanded_initializer(T57* C,T0* a1);
T6 r57has(T57* C,T0* a1);
void r57pretty_print(T57* C);
T0* r175base_class_written(T175* C);
T0* r175static_result_base_class(T175* C);
void r175make(T175* C,T0* a1,T0* a2);
void r175name_clash_for(T175* C,T0* a1,T0* a2);
T0* r175add_comment(T175* C,T0* a1);
T0* r175to_runnable(T175* C,T0* a1);
T2 r175to_integer(T175* C);
T0* r175twin(T175* C);
void r175error(T0* a1,T0* a2);
void r175print_as_target(T175* C);
T0* r175written_in(T175* C);
void r204make(T204* C,T0* a1,T0* a2,T0* a3);
T0* r204name(void);
T0* r204to_runnable(T204* C,T0* a1);
T0* r204twin(T204* C);
void r204pretty_print(T204* C);
T0* r331run_ensure(T331* C);
T0* r331run_class(T331* C);
void r331make(T331* C,T0* a1,T0* a2,T0* a3);
T0* r331run_require(T331* C);
void r331initialize(T331* C);
T6 r331is_exported_in(T331* C,T0* a1);
T0* r331clients(T331* C);
T0* r331start_position(T331* C);
void r210make(T210* C,T0* a1,T0* a2);
T0* r210add_comment(T210* C,T0* a1);
T0* r210to_runnable(T210* C,T0* a1);
void r210error(T0* a1,T0* a2);
void r210pretty_print(T210* C);
T0* r210start_position(T210* C);
void r133match_with(T133* C,T0* a1,T0* a2);
void r133make_n(T133* C,T0* a1,T0* a2);
T0* r133run_class(T133* C);
T6 r133is_like_argument(T133* C,T0* a1,T0* a2,T0* a3);
void r133assertion_check(T133* C,T3 a1);
T0* r133to_runnable(T133* C,T0* a1);
T0* r133expression(T133* C,T2 a1);
void r133put(T133* C,T0* a1,T2 a2);
T2 r133count(T133* C);
void r133from_model(T133* C,T0* a1);
void r133error(T0* a1,T0* a2);
void r133pretty_print(T133* C);
T0* r133start_position(T133* C);
T0* r128runnable_expression(T0* a1,T0* a2);
void r128run_feature_has_result(T128* C);
T0* r128run_feature_for(T128* C,T0* a1,T0* a2);
T0* r128static_result_base_class(T128* C);
void r128make(T128* C,T0* a1,T0* a2);
void r128fatal_error(T0* a1);
void r128run_feature_match(T128* C);
void r128assertion_check(T128* C,T3 a1);
T0* r128add_comment(T128* C,T0* a1);
void r128with(T128* C,T0* a1,T0* a2,T0* a3);
T0* r128operator(void);
T0* r128to_runnable(T128* C,T0* a1);
T2 r128to_integer(T128* C);
void r128error(T0* a1,T0* a2);
void r128bracketed_pretty_print(T128* C);
void r128pretty_print(T128* C);
T0* r128result_type(T128* C);
void r128print_as_target(T128* C);
T0* r120runnable_expression(T0* a1,T0* a2);
void r120run_feature_has_result(T120* C);
void r120run_feature_match(T120* C,T0* a1);
T0* r120add_comment(T120* C,T0* a1);
void r120with(T120* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r120operator(void);
T0* r120runnable_args(T0* a1,T0* a2);
T0* r120to_runnable(T120* C,T0* a1);
T2 r120to_integer(T120* C);
void r120error(T0* a1,T0* a2);
void r120bracketed_pretty_print(T120* C);
T0* r120result_type(T120* C);
void r120print_as_target(T120* C);
void r120print_op(T120* C);
T0* r120run_feature_for(T120* C,T0* a1,T0* a2);
T0* r120static_result_base_class(T120* C);
void r120make(T120* C,T0* a1,T0* a2,T0* a3);
void r120fatal_error(T0* a1);
void r120assertion_check(T120* C,T3 a1);
void r120pretty_print(T120* C);
T0* r115runnable_expression(T0* a1,T0* a2);
void r115run_feature_has_result(T115* C);
void r115run_feature_match(T115* C,T0* a1);
T0* r115add_comment(T115* C,T0* a1);
void r115with(T115* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r115operator(void);
T0* r115runnable_args(T0* a1,T0* a2);
T0* r115to_runnable(T115* C,T0* a1);
T2 r115to_integer(T115* C);
void r115error(T0* a1,T0* a2);
void r115bracketed_pretty_print(T115* C);
T0* r115result_type(T115* C);
void r115print_as_target(T115* C);
void r115print_op(T115* C);
T0* r115run_feature_for(T115* C,T0* a1,T0* a2);
T0* r115static_result_base_class(T115* C);
void r115make(T115* C,T0* a1,T0* a2,T0* a3);
void r115fatal_error(T0* a1);
void r115assertion_check(T115* C,T3 a1);
void r115pretty_print(T115* C);
void r191pretty_tail(T191* C);
T6 r191is_merge_with(T191* C,T0* a1,T0* a2);
T6 r191is_merge_with2aux(T191* C,T0* a1,T0* a2);
T0* r191try_to_undefine_aux(T191* C,T0* a1,T0* a2);
T0* r191try_to_undefine(T191* C,T0* a1,T0* a2);
void r191check_obsolete(T191* C,T0* a1);
T6 r191is_merge_with1(T191* C,T0* a1);
T6 r191is_merge_with2(T191* C,T0* a1,T0* a2);
T0* r191to_run_feature(T191* C,T0* a1,T0* a2);
void r191error(T0* a1,T0* a2);
void r191pretty_print_names(T191* C);
void r191make(T191* C,T0* a1,T0* a2,T0* a3);
void r191pretty_print_profile(T191* C);
void r191add_into(T191* C,T0* a1);
T6 r191can_hide(T191* C,T0* a1,T0* a2);
void r191merge_header_comments(T191* C,T0* a1);
void r191pretty_print(T191* C);
T0* r191start_position(T191* C);
T0* r112runnable_expression(T0* a1,T0* a2);
void r112check_comparison(T112* C,T0* a1);
T0* r112add_comment(T112* C,T0* a1);
void r112with(T112* C,T0* a1,T0* a2,T0* a3);
T0* r112operator(void);
T0* r112runnable_args(T0* a1,T0* a2);
T0* r112to_runnable(T112* C,T0* a1);
T2 r112to_integer(T112* C);
void r112bit_limitation(T112* C,T0* a1,T0* a2);
void r112error(T0* a1,T0* a2);
void r112bracketed_pretty_print(T112* C);
void r112print_as_target(T112* C);
void r112print_op(T112* C);
T0* r112type_boolean(void);
T0* r112static_result_base_class(void);
void r112make(T112* C,T0* a1,T0* a2,T0* a3);
void r112fatal_error(T0* a1);
void r112assertion_check(T112* C,T3 a1);
void r112error_comparison(T112* C,T0* a1,T0* a2);
void r112pretty_print(T112* C);
T0* r364generic_list(T364* C);
T0* r364smallest_ancestor(T0* a1);
T0* r364string_aliaser(void);
T0* r364base_class(T364* C);
T0* r364look_up_for(T364* C,T0* a1,T0* a2);
T0* r364static_base_class_name(T364* C);
T6 r364is_a_in(T364* C,T0* a1,T0* a2);
T6 r364is_a(T364* C,T0* a1);
T6 r364is_generic(T364* C);
void r364make(T364* C,T0* a1);
void r364fatal_error(T0* a1);
T0* r364base_class_name(T364* C);
T0* r127runnable_expression(T0* a1,T0* a2);
void r127run_feature_has_result(T127* C);
T0* r127run_feature_for(T127* C,T0* a1,T0* a2);
T0* r127static_result_base_class(T127* C);
void r127make(T127* C,T0* a1,T0* a2);
void r127fatal_error(T0* a1);
void r127run_feature_match(T127* C);
void r127assertion_check(T127* C,T3 a1);
T0* r127add_comment(T127* C,T0* a1);
void r127with(T127* C,T0* a1,T0* a2,T0* a3);
T0* r127operator(void);
T0* r127to_runnable(T127* C,T0* a1);
T2 r127to_integer(T127* C);
void r127error(T0* a1,T0* a2);
void r127bracketed_pretty_print(T127* C);
void r127pretty_print(T127* C);
T0* r127result_type(T127* C);
void r127print_as_target(T127* C);
void r323fatal_error_generic_list(T323* C);
T0* r323type_any(void);
T0* r323generic_list(T323* C);
T2 r323id(T323* C);
T0* r323smallest_ancestor(T323* C,T0* a1);
T0* r323string_aliaser(void);
T0* r323base_class(T323* C);
T0* r323look_up_for(T323* C,T0* a1,T0* a2);
T6 r323is_a_in(T323* C,T0* a1,T0* a2);
T6 r323is_a(T323* C,T0* a1);
T0* r323run_class(T323* C);
void r323make(T323* C,T0* a1);
extern int fBC323base_class_name;
extern T0*oBC323base_class_name;
T0* r323base_class_name(void);
T0* r154static_result_base_class(void);
void r154make(T154* C,T0* a1,T3 a2,T2 a3);
T0* r154add_comment(T154* C,T0* a1);
T0* r154to_string(T154* C);
void r154character_coding(T3 a1,T0* a2);
void r154error(T0* a1,T0* a2);
extern int fBC154result_type;
extern T0*oBC154result_type;
T0* r154result_type(void);
void r154print_as_target(T154* C);
T0* r173static_result_base_class(T173* C);
void r173refer_to(T173* C,T0* a1,T0* a2,T2 a3);
T0* r173add_comment(T173* C,T0* a1);
void r173with(T173* C,T0* a1,T0* a2);
T0* r173to_runnable(T173* C,T0* a1);
T2 r173to_integer(T173* C);
T0* r173to_string(T173* C);
void r173error(T0* a1,T0* a2);
T0* r173result_type(T173* C);
void r173print_as_target(T173* C);
T6 r288is_merge_with(T288* C,T0* a1,T0* a2);
T6 r288is_merge_with2aux(T288* C,T0* a1,T0* a2);
void r288pretty_print_rescue(T288* C);
T0* r288try_to_undefine_aux(T288* C,T0* a1,T0* a2);
T0* r288try_to_undefine(T288* C,T0* a1,T0* a2);
void r288check_obsolete(T288* C,T0* a1);
T6 r288is_merge_with1(T288* C,T0* a1);
T6 r288is_merge_with2(T288* C,T0* a1,T0* a2);
T0* r288to_run_feature(T288* C,T0* a1,T0* a2);
void r288error(T0* a1,T0* a2);
void r288pretty_print_names(T288* C);
void r288set_header_comment(T288* C,T0* a1);
void r288make_routine(T288* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r288make(T288* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r288pretty_print_profile(T288* C);
void r288pretty_print_routine_body(T288* C);
void r288add_into(T288* C,T0* a1);
T6 r288can_hide(T288* C,T0* a1,T0* a2);
void r288merge_header_comments(T288* C,T0* a1);
void r288pretty_print(T288* C);
void r288pretty_print_arguments(T288* C);
T0* r288start_position(T288* C);
void r198pretty_tail(T198* C);
T6 r198is_merge_with(T198* C,T0* a1,T0* a2);
T6 r198is_merge_with2aux(T198* C,T0* a1,T0* a2);
T0* r198try_to_undefine_aux(T198* C,T0* a1,T0* a2);
T0* r198try_to_undefine(T198* C,T0* a1,T0* a2);
void r198check_obsolete(T198* C,T0* a1);
T6 r198is_merge_with1(T198* C,T0* a1);
T6 r198is_merge_with2(T198* C,T0* a1,T0* a2);
T0* r198to_run_feature(T198* C,T0* a1,T0* a2);
void r198error(T0* a1,T0* a2);
void r198pretty_print_names(T198* C);
void r198make(T198* C,T0* a1,T0* a2,T0* a3);
void r198pretty_print_profile(T198* C);
void r198add_into(T198* C,T0* a1);
T6 r198can_hide(T198* C,T0* a1,T0* a2);
void r198merge_header_comments(T198* C,T0* a1);
void r198pretty_print(T198* C);
T0* r198start_position(T198* C);
T0* r116runnable_expression(T0* a1,T0* a2);
void r116run_feature_has_result(T116* C);
void r116run_feature_match(T116* C,T0* a1);
T0* r116add_comment(T116* C,T0* a1);
void r116with(T116* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r116operator(void);
T0* r116runnable_args(T0* a1,T0* a2);
T0* r116to_runnable(T116* C,T0* a1);
T2 r116to_integer(T116* C);
void r116error(T0* a1,T0* a2);
void r116bracketed_pretty_print(T116* C);
T0* r116result_type(T116* C);
void r116print_as_target(T116* C);
void r116print_op(T116* C);
T0* r116run_feature_for(T116* C,T0* a1,T0* a2);
T0* r116static_result_base_class(T116* C);
void r116make(T116* C,T0* a1,T0* a2,T0* a3);
void r116fatal_error(T0* a1);
void r116assertion_check(T116* C,T3 a1);
void r116pretty_print(T116* C);
T0* r349run_ensure(T349* C);
T0* r349run_class(T349* C);
void r349make(T349* C,T0* a1,T0* a2,T0* a3);
T0* r349run_require(T349* C);
void r349initialize(T349* C);
T6 r349is_exported_in(T349* C,T0* a1);
T0* r349clients(T349* C);
T0* r349start_position(T349* C);
T0* r212to_runnable(T212* C,T0* a1);
void r212pretty_print(T212* C);
void r42check_expanded_with(T42* C,T0* a1);
T6 r42is_subclass_of(T42* C,T0* a1);
void r42inherit_cycle_check(T42* C);
T0* r42super_e_feature(T42* C,T0* a1);
void r42set_parent_list(T42* C,T0* a1,T0* a2,T0* a3);
extern int fBC12class_any;
extern T0*oBC12class_any;
T0* r42class_any(void);
void r42add_index_clause(T42* C,T0* a1);
void r42set_invariant(T42* C,T0* a1,T0* a2,T0* a3);
void r42warning(T0* a1,T0* a2);
void r42collect_assertion(T42* C,T0* a1);
void r42set_obsolete_type_string(T42* C,T0* a1);
T0* r42look_up_for(T42* C,T0* a1,T0* a2);
T6 r42has_creation(T42* C,T0* a1);
T0* r42up_to_original(T42* C,T0* a1,T0* a2);
void r42error(T0* a1,T0* a2);
void r42add_creation_clause(T42* C,T0* a1);
T6 r42proper_has(T42* C,T0* a1);
T6 r42has_redefine(T42* C,T0* a1);
T0* r42run_ensure(T42* C,T0* a1);
void r42make(T42* C);
void r42vdrd6(T0* a1,T0* a2,T0* a3);
T0* r42new_name_of_original(T42* C,T0* a1,T0* a2);
extern int fBC42mem_fn;
extern T0*oBC42mem_fn;
T0* r42mem_fn(void);
void r42set_is_expanded(T42* C);
void r42set_is_deferred(T42* C);
void r42add_feature_clause(T42* C,T0* a1);
T0* r42new_name_of(T42* C,T0* a1,T0* a2);
T6 r42has(T42* C,T0* a1);
T6 r42is_any(T42* C);
void r42fatal_undefine(T42* C,T0* a1);
T0* r42type_any(void);
T0* r42super_look_up_for(T42* C,T0* a1,T0* a2);
T0* r42smallest_ancestor(T42* C,T0* a1,T0* a2);
T0* r42run_require(T42* C,T0* a1);
T0* r42string_aliaser(void);
T6 r42is_a_vncg(T42* C,T0* a1,T0* a2);
T6 r42is_general(T42* C);
T6 r42has_simple_feature_name(T42* C,T0* a1);
void r42fatal_error_vdrd6(T0* a1,T0* a2,T0* a3);
void r42get_started(T42* C);
T0* r42going_up(T42* C,T0* a1,T0* a2,T0* a3);
T0* r42run_class(T42* C);
T0* r42run_feature_for(T42* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r42fatal_error(T0* a1);
T0* r42get_copy(T42* C);
T0* r42expanded_initializer(T42* C,T0* a1);
T6 r42is_subclass_of_aux(T42* C,T0* a1);
T0* r42clients_for(T42* C,T0* a1);
T0* r42e_feature(T42* C,T0* a1);
extern T0*oBC42going_up_trace;
extern T0*oBC42visited;
void r42pretty_print(T42* C);
T0* r42id_provider(void);
T0* r42class_with(T0* a1);
T6 r292is_merge_with(T292* C,T0* a1,T0* a2);
T6 r292is_merge_with2aux(T292* C,T0* a1,T0* a2);
void r292pretty_print_rescue(T292* C);
T0* r292try_to_undefine_aux(T292* C,T0* a1,T0* a2);
T0* r292try_to_undefine(T292* C,T0* a1,T0* a2);
void r292check_obsolete(T292* C,T0* a1);
T6 r292is_merge_with1(T292* C,T0* a1);
T6 r292is_merge_with2(T292* C,T0* a1,T0* a2);
T0* r292to_run_feature(T292* C,T0* a1,T0* a2);
void r292error(T0* a1,T0* a2);
void r292pretty_print_names(T292* C);
void r292set_header_comment(T292* C,T0* a1);
void r292make_routine(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r292make(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r292pretty_print_profile(T292* C);
void r292pretty_print_routine_body(T292* C);
void r292add_into(T292* C,T0* a1);
T6 r292can_hide(T292* C,T0* a1,T0* a2);
void r292merge_header_comments(T292* C,T0* a1);
void r292make_effective_routine(T292* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r292pretty_print(T292* C);
void r292pretty_print_arguments(T292* C);
T0* r292start_position(T292* C);
void r245fatal_error_generic_list(T245* C);
T0* r245generic_list(T245* C);
T2 r245id(T245* C);
extern int fBC245check_type;
void r245check_type(T245* C);
T0* r245base_class(T245* C);
T0* r245look_up_for(T245* C,T0* a1,T0* a2);
T0* r245to_runnable(T245* C,T0* a1);
T6 r245has_creation(T245* C,T0* a1);
void r245error(T0* a1,T0* a2);
T6 r245is_a_in(T245* C,T0* a1,T0* a2);
T0* r245run_time_mark(void);
T6 r245is_a(T245* C,T0* a1);
T0* r245run_class(T245* C);
void r245make(T245* C,T0* a1);
T0* r245written_mark(void);
void r261fatal_error_generic_list(T261* C);
T0* r261type_any(void);
T0* r261generic_list(T261* C);
T2 r261id(T261* C);
T0* r261smallest_ancestor(T261* C,T0* a1);
extern T0*oBC262mem_type_bit_ref;
T0* r261string_aliaser(void);
T0* r261base_class(T261* C);
T0* r261look_up_for(T261* C,T0* a1,T0* a2);
T0* r261to_runnable(T261* C,T0* a1);
extern T0*oBC262mem_ref_nb;
T6 r261is_a_in(T261* C,T0* a1,T0* a2);
T6 r261is_a(T261* C,T0* a1);
T0* r261run_class(T261* C);
void r261make(T261* C,T0* a1,T0* a2);
void r261used_as_reference(T261* C);
void r261to_runnable_1_2(T261* C);
extern int fBC262base_class_name;
extern T0*oBC262base_class_name;
T0* r261base_class_name(void);
void r261set_run_time_mark(T261* C);
void r268pretty_print_assignment(T0* a1,T0* a2,T0* a3);
T0* r268left_type(T268* C);
void r268make(T268* C,T0* a1,T0* a2);
void r268fatal_error(T0* a1);
void r268warning(T0* a1,T0* a2);
void r268implicit_conversion(T268* C);
T0* r268add_comment(T268* C,T0* a1);
T0* r268right_type(T268* C);
T0* r268to_runnable(T268* C,T0* a1);
T0* r268start_position(T268* C);
T0* r153type_boolean(void);
T0* r153static_result_base_class(void);
T0* r153add_comment(T153* C,T0* a1);
T0* r153to_string(void);
void r153error(T0* a1,T0* a2);
void r307pretty_print(T307* C);
T0* r103runnable_expression(T0* a1,T0* a2);
void r103run_feature_has_result(T103* C);
void r103run_feature_match(T103* C,T0* a1);
T0* r103add_comment(T103* C,T0* a1);
void r103with(T103* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r103operator(void);
T0* r103runnable_args(T0* a1,T0* a2);
T0* r103to_runnable(T103* C,T0* a1);
T2 r103to_integer(T103* C);
void r103error(T0* a1,T0* a2);
void r103bracketed_pretty_print(T103* C);
T0* r103result_type(T103* C);
void r103print_as_target(T103* C);
void r103print_op(T103* C);
T0* r103run_feature_for(T103* C,T0* a1,T0* a2);
T0* r103static_result_base_class(T103* C);
void r103make(T103* C,T0* a1,T0* a2,T0* a3);
void r103fatal_error(T0* a1);
void r103assertion_check(T103* C,T3 a1);
void r103pretty_print(T103* C);
void r67add_last(T67* C,T0* a1);
void r67make_n(T67* C,T0* a1);
T0* r67feature_name(T67* C,T0* a1);
void r67fatal_error(T0* a1);
void r67fe_multiple(T0* a1,T0* a2);
T2 r67index_of(T67* C,T0* a1);
T2 r67count(T67* C);
void r67pretty_print(T67* C);
T6 r67has(T67* C,T0* a1);
T0* r67item(T67* C,T2 a1);
void r205make(T205* C,T0* a1,T0* a2,T0* a3);
T0* r205add_comment(T205* C,T0* a1);
T0* r205to_runnable(T205* C,T0* a1);
void r205pretty_print(T205* C);
T0* r155type_string(void);
extern T0*oBC155tmp_string;
void r155add_ascii(T155* C,T3 a1);
T0* r155add_comment(T155* C,T0* a1);
T6 r155is_on_next_line(T155* C,T2 a1);
T0* r155to_runnable(T155* C,T0* a1);
T2 r155to_integer(T155* C);
T0* r155twin(T155* C);
void r155error(T0* a1,T0* a2);
void r155bracketed_pretty_print(T155* C);
void r155pretty_print_character(T155* C,T2 a1);
void r155print_as_target(T155* C);
extern T0*oBC12manifest_string_pool;
void r155break_line(T155* C);
T0* r155static_result_base_class(void);
void r155make(T155* C,T0* a1);
void r155character_coding(T3 a1,T0* a2);
void r155pretty_print(T155* C);
void r155add_percent(T155* C,T3 a1);
T0* r178add_comment(T178* C,T0* a1);
T0* r178to_runnable(T178* C,T0* a1);
T2 r178to_integer(T178* C);
void r178error(T0* a1,T0* a2);
T0* r97runnable_expression(T0* a1,T0* a2);
void r97run_feature_has_result(T97* C);
void r97run_feature_match(T97* C,T0* a1);
T0* r97add_comment(T97* C,T0* a1);
void r97with(T97* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r97operator(void);
T0* r97runnable_args(T0* a1,T0* a2);
T0* r97to_runnable(T97* C,T0* a1);
T2 r97to_integer(T97* C);
void r97error(T0* a1,T0* a2);
void r97bracketed_pretty_print(T97* C);
T0* r97result_type(T97* C);
void r97print_as_target(T97* C);
void r97print_op(T97* C);
T0* r97run_feature_for(T97* C,T0* a1,T0* a2);
T0* r97static_result_base_class(T97* C);
void r97make(T97* C,T0* a1,T0* a2,T0* a3);
void r97fatal_error(T0* a1);
void r97assertion_check(T97* C,T3 a1);
void r97pretty_print(T97* C);
void r180add_last(T180* C,T0* a1);
void r180warning(T0* a1,T0* a2);
void r180merge(T180* C,T0* a1,T0* a2);
T6 r180gives_permission_to_any(T180* C);
T2 r180index_of(T180* C,T0* a1);
T6 r180gives_permission_to(T180* C,T0* a1);
T2 r180count(T180* C);
void r180pretty_print(T180* C);
T0* r180item(T180* C,T2 a1);
void r87make(T87* C,T0* a1,T0* a2,T0* a3);
T0* r87name(void);
void r87pretty_print(T87* C);
void r272make(T272* C,T0* a1,T0* a2,T0* a3);
T0* r272name(T272* C);
void r272add_into(T272* C,T0* a1);
void r272make_runnable(T272* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r272pretty_print(T272* C);
void r263fatal_error_generic_list(T263* C);
T0* r263type_any(void);
T0* r263generic_list(T263* C);
T2 r263id(T263* C);
T0* r263smallest_ancestor(T263* C,T0* a1);
T0* r263string_aliaser(void);
T0* r263base_class(T263* C);
T0* r263look_up_for(T263* C,T0* a1,T0* a2);
T0* r263to_runnable(T263* C,T0* a1);
T6 r263is_a_in(T263* C,T0* a1,T0* a2);
T6 r263is_a(T263* C,T0* a1);
T0* r263run_class(T263* C);
void r263make(T263* C,T0* a1,T0* a2);
void r263fatal_error(T0* a1);
void r263used_as_reference(T263* C);
void r263to_runnable_1_2(T263* C);
T0* r263base_class_name(void);
void r263set_run_time_mark(T263* C);
void r231make(T231* C,T0* a1,T0* a2);
T0* r231to_runnable(T231* C,T0* a1);
T0* r231twin(T231* C);
void r231error(T0* a1,T0* a2);
void r231pretty_print(T231* C);
T0* r231start_position(T231* C);
T0* r350run_ensure(T350* C);
T0* r350run_class(T350* C);
void r350make(T350* C,T0* a1,T0* a2,T0* a3);
T0* r350run_require(T350* C);
void r350initialize(T350* C);
T6 r350is_exported_in(T350* C,T0* a1);
T0* r350clients(T350* C);
T0* r350start_position(T350* C);
T6 r52a_manifest_string(T52* C);
void r52a_indexing(T52* C);
T0* r52current_position(T52* C);
T0* r52a_actuals(T52* C);
T0* r52a_clients(T52* C);
T6 r52a_strip(T52* C);
extern T0*oBC52forbidden_class;
extern T0*oBC52tmp_name;
void r52a_after_a_dot(T52* C,T6 a1,T0* a2);
extern T0*oBC52faof;
T6 r52a_integer(T52* C);
void r52a_parent_list(T52* C,T0* a1,T0* a2);
T6 r52a_actual(T52* C);
void r52a_rename_list(T52* C);
T6 r52a_local_variable(T52* C);
T6 r52a_infix(T52* C);
T0* r52analyse_class(T52* C,T0* a1);
void r52skip_comments(T52* C);
T6 r52a_inspect(T52* C);
T6 r52a_current(T52* C);
void r52next_char(T52* C);
T6 r52a_unary(T52* C);
T6 r52a_conditional(T52* C);
void r52a_base_class_name1(T52* C);
T6 r52a_retry(T52* C);
extern T0*oBC52tmp_string;
T6 r52a_e10(T52* C);
T6 r52a_tag_mark(T52* C);
T0* r52a_routine_body(T52* C);
T6 r52a_feature_declaration(T52* C);
void r52a_r10(T52* C,T6 a1,T0* a2,T0* a3,T0* a4);
T6 r52a_keyword(T52* C,T0* a1);
T6 r52a_class_type(T52* C);
T6 r52a_feature_name_list(T52* C);
T6 r52a_feature_name(T52* C);
T0* r52a_assertion(T52* C);
void r52a_ascii_code(T52* C);
T6 r52a_void(T52* C);
void r52a_formal_generic_list(T52* C);
T6 r52a_index_value(T52* C);
void r52a_assignment_aux(T52* C,T6 a1);
T0* r52to_proc_call(T52* C,T0* a1,T0* a2,T0* a3);
T6 r52a_expression(T52* C);
T0* r52a_routine(T52* C);
T6 r52a_creation(T52* C);
T6 r52a_bit_constant(T52* C);
T6 r52a_boolean_constant(T52* C);
T0* r52a_external(T52* C);
T6 r52a_type(T52* C);
T6 r52skip1unless2(T52* C,T3 a1,T3 a2);
T6 r52a_real(T52* C);
T6 r52a_index_clause(T52* C);
void r52a_procedure_call(T52* C);
T6 r52a_parent(T52* C);
T0* r52a_compound1(T52* C);
T6 r52a_instruction(T52* C);
T6 r52a_debug(T52* C);
void r52to_frozen_feature_name(T52* C);
T6 r52a_manifest_constant(T52* C);
T6 r52a_base_type(T52* C);
T6 r52a_result(T52* C);
T6 r52a_base_class_name(T52* C);
void r52a_formal_arg_list(T52* C);
T6 r52a_identifier(T52* C);
void r52wcpefnc(T52* C,T0* a1,T0* a2);
T6 r52skip1(T52* C,T3 a1);
T6 r52skip2(T52* C,T3 a1,T3 a2);
T6 r52a_integer_constant(T52* C);
T0* r52a_compound2(T52* C,T0* a1,T0* a2);
void r52a_new_export_list(T52* C);
void r52a_creation_clause(T52* C,T0* a1);
void r52show_nb(T2 a1,T0* a2);
T6 r52a_identifier1(T52* C);
void r52fcp(T52* C,T0* a1);
T6 r52a_character_constant(T52* C);
extern T0*oBC52lcs;
void r52a_local_var_list(T52* C);
T0* r52pos(T2 a1,T2 a2);
T6 r52a_loop(T52* C);
T6 r52a_free_operator(T52* C);
T6 r52a_binary(T52* C,T0* a1);
T6 r52a_check(T52* C);
void r52a_then_part_list(T52* C,T0* a1);
T6 r52a_precursor(T52* C,T6 a1);
T6 r52a_prefix(T52* C);
void r52fatal_error(T0* a1);
T6 r52a_identifier2(T52* C);
void r52warning(T0* a1,T0* a2);
extern T0*oBC52tmp_feature;
T0* r52get_comments(T52* C);
void r52error(T0* a1,T0* a2);
T0* r52to_call(T0* a1,T0* a2,T0* a3);
T6 r52a_then_part(T52* C,T0* a1);
T6 r52a_type_formal_generic(T52* C);
void r52go_back_at(T52* C,T2 a1,T2 a2);
T6 r52a_when_part(T52* C,T0* a1);
T6 r52a_argument(T52* C);
T6 r52a_assignment_or_call(T52* C);
T6 r52a_constant(T52* C);
T6 r52a_e0(T52* C);
T6 r52a_e1(T52* C);
T6 r52a_e2(T52* C);
T6 r52a_e3(T52* C);
T6 r52a_e4(T52* C);
T6 r52a_e5(T52* C);
T6 r52a_e6(T52* C);
T6 r52a_e7(T52* C);
void r52a_function_call(T52* C);
T6 r52a_e8(T52* C);
T6 r52a_e9(T52* C);
T6 r52a_real_constant(T52* C);
T6 r52a_rename_pair(T52* C);
void r52a_r1(T52* C,T0* a1);
void r52a_r2(T52* C,T0* a1);
void r52a_r3(T52* C,T0* a1);
void r52a_r4(T52* C,T0* a1);
void r52a_r5(T52* C,T0* a1);
void r52a_r6(T52* C,T0* a1);
void r52a_r7(T52* C,T0* a1);
T0* r52last_result(T52* C);
void r52a_r8(T52* C,T0* a1);
T0* r52a_alias(T52* C);
void r52a_feature_clause(T52* C);
void r52err_exp(T0* a1,T0* a2);
void r52a_class_declaration(T52* C);
void r53load_file(T53* C,T0* a1);
extern T0*oBC53text;
T0* r53get_line(T2 a1);
T0* r53item(T2 a1);
T0* r158static_result_base_class(void);
void r158make(T158* C,T0* a1,T0* a2);
T0* r158add_comment(T158* C,T0* a1);
T2 r158to_integer(T158* C);
void r158error(T0* a1,T0* a2);
extern int fBC158result_type;
extern T0*oBC158result_type;
T0* r158result_type(void);
void r158print_as_target(T158* C);
T6 r243is_any(T243* C);
void r243fatal_error_generic_list(T243* C);
T6 r243is_string(T243* C);
T0* r243generic_list(T243* C);
T2 r243id(T243* C);
T0* r243smallest_ancestor(T243* C,T0* a1);
T0* r243string_aliaser(void);
void r243with(T243* C,T0* a1,T0* a2);
T0* r243base_class(T243* C);
T6 r243is_array(T243* C);
T6 r243is_double(T243* C);
T6 r243is_none(T243* C);
T0* r243look_up_for(T243* C,T0* a1,T0* a2);
T0* r243to_runnable(T243* C,T0* a1);
T6 r243has_creation(T243* C,T0* a1);
T6 r243is_pointer(T243* C);
T0* r243static_base_class_name(T243* C);
T6 r243is_a_in(T243* C,T0* a1,T0* a2);
T0* r243run_time_mark(T243* C);
T6 r243is_boolean(T243* C);
T6 r243is_a(T243* C,T0* a1);
T0* r243run_class(T243* C);
void r243anchor_cycle_start(T243* C);
T6 r243is_generic(T243* C);
void r243make(T243* C,T0* a1,T0* a2);
void r243fatal_error(T0* a1);
T0* r243run_type(T243* C);
T6 r243is_expanded(T243* C);
T0* r243expanded_initializer(T243* C);
T6 r243is_basic_eiffel_expanded(T243* C);
void r243anchor_cycle_end(T243* C);
void r243used_as_reference(T243* C);
T6 r243is_character(T243* C);
T6 r243is_reference(T243* C);
T6 r243is_real(T243* C);
T0* r243base_class_name(T243* C);
T6 r243is_run_type(T243* C);
T6 r243is_bit(T243* C);
T6 r243is_integer(T243* C);
void r200make(T200* C,T0* a1,T0* a2,T0* a3);
T0* r200name(T200* C);
void r200add_into(T200* C,T0* a1);
void r200make_runnable(T200* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r200pretty_print(T200* C);
T0* r183to_cst_att_character(T183* C,T0* a1);
void r183error(T0* a1,T0* a2);
T0* r183to_cst_att_real(T183* C,T0* a1);
T0* r183to_cst_att_unique(T183* C);
T0* r183to_cst_att_string(T183* C,T0* a1);
T0* r183to_procedure_or_function(T183* C);
T0* r183to_cst_att_bit(T183* C,T0* a1);
T0* r183n(void);
void r183to_cst_att_check_result_type(T183* C);
T0* r183to_cst_att_integer(T183* C,T0* a1);
T0* r183to_external_routine(T183* C,T0* a1,T0* a2);
void r183fatal_error(T0* a1);
void r183set_require(T183* C,T0* a1,T0* a2,T0* a3);
T0* r183to_deferred_routine(T183* C);
T0* r183to_writable_attribute(T183* C);
void r183add_synonym(T0* a1);
void r183set_require_else(T183* C,T0* a1,T0* a2,T0* a3);
void r183initialize(T183* C);
T0* r183to_once_routine(T183* C);
extern T0*oBC183names;
T0* r183to_cst_att_boolean(T183* C,T0* a1);
extern T0*oBC353manifest_array_types;
void r353register(T0* a1);
void r189increment(T189* C);
T0* r279language_name(void);
extern T0*oBC359mangling_dictionary;
T0* r359register(T0* a1);
T0* r286language_name(void);
extern T0*oBC356registered;
void r356register_for(T0* a1);
extern T0*oBC356caller_memory;
void r341add_procedure(T0* a1);
extern T0*oBC341procedure_list;
void r341add_function(T0* a1);
extern T0*oBC341function_list;
T0* r278language_name(void);
T0* r284language_name(void);
T6 r92is_current(void);
void r92reset(T92* C,T2 a1,T2 a2);
T0* r92to_tag_name(T92* C);
T0* r92to_argument_name2(T92* C,T0* a1,T2 a2);
T0* r92to_e_void(T92* C);
T0* r92to_local_name2(T92* C,T0* a1,T2 a2);
T0* r92to_simple_feature_name(T92* C);
T0* r92to_class_name(T92* C);
T6 r92isa_keyword(void);
T0* r92to_argument_name1(T92* C);
T0* r92start_position(T92* C);
T0* r92to_prefix_name(T92* C);
T0* r92string_aliaser(void);
T0* r92aliased_string(T92* C);
T0* r92to_infix_name(T92* C,T0* a1);
T0* r92pos(T2 a1,T2 a2);
T6 r92is_void(void);
T0* r92to_local_name1(T92* C);
T0* r92to_infix_name_use(T92* C);
T6 r92is_result(void);
T0* r283language_name(void);
T0* r281language_name(void);
T6 r10is_flag_no_warning(T0* a1);
extern int fBC10class_names;
extern T0*oBC10class_names;
T0* r10class_names(void);
T0* r10argument(T2 a1);
extern T0*oBC10backup;
void r10error_style(T10* C,T0* a1);
void r10sfw_connect(T10* C,T0* a1,T0* a2);
void r10pretty_for(T10* C,T0* a1);
extern T312 oBC1file_tools;
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
T6 r10is_flag_no_style_warning(T0* a1);
extern T0*oBC10new_file;
void r10make(T10* C);
void r10fatal_error(T0* a1);
void r10automat(T10* C);
T6 r10file_exists(T0* a1);
T0* r10system_tools(void);
T6 r10is_flag_version(T10* C,T0* a1);
extern T0*oBC10path;
void r10pretty_print(T10* C);
T6 r312is_readable(T0* a1);
void r312rename_to(int C,T0* a1,T0* a2);
T6 r312file_exists(T0* a1);
extern T0*oBC312std_fr1;
void r312delete(int C,T0* a1);
T0* r282language_name(void);
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 368
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms270_124456;
extern T7*ms268_168036;
extern T7*ms161_268167;
extern T7*ms160_366828;
extern T7*ms344_320658;
extern T7*ms183_147108;
extern T7*ms168_106468;
extern T7*ms344_203069;
extern T7*ms183_185909;
extern T7*ms207_414a;
extern T7*ms13_7524a;
extern T7*ms13_1684a;
extern T7*ms13_2615a;
extern T7*ms14_2765a;
extern T7*ms14_2730a;
extern T7*ms14_1035a;
extern T7*ms52_1176a;
extern T7*ms52_9260a;
extern T7*ms52_9955a;
extern T7*ms205_2595a;
extern T7*ms40_56820a;
extern T7*ms14_22824a;
extern T7*ms14_12915a;
extern T7*ms43_23814a;
extern T7*ms52_78588a;
extern T7*ms52_82473a;
extern T7*ms52_28980a;
extern T7*ms52_13832a;
extern T7*ms52_44694a;
extern T7*ms52_37992a;
extern T7*ms40_10;
extern T7*ms14_60;
extern T7*ms14_61;
extern T7*ms14_62;
extern T7*ms14_42;
extern T7*ms14_43;
extern T7*ms14_64;
extern T7*ms14_94;
extern T7*ms14_45;
extern T7*ms14_35;
extern T7*ms78_44;
extern T7*ms13_46;
extern T7*ms14_47;
extern T7*ms52_67;
extern T7*ms131_41;
extern T7*ms113_37536a;
extern T7*ms155_94;
extern T7*ms10_160;
extern T7*ms13_240;
extern T7*ms40_300;
extern T7*ms13_440;
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms14_450;
extern T7*ms42_160;
extern T7*ms52_280;
extern T7*ms74_180;
extern T7*ms83_840;
extern T7*ms65_180;
extern T7*ms29_270;
extern T7*ms29_210;
extern T7*ms29_690;
extern T7*ms85_180;
extern T7*ms14_921;
extern T7*ms268_46;
extern T7*ms13_422;
extern T7*ms14_242;
extern T7*ms14_552;
extern T7*ms14_432;
extern T7*ms42_152;
extern T7*ms43_112;
extern T7*ms74_152;
extern T7*ms29_132;
extern T7*ms13_933;
extern T7*ms67_152;
extern T7*ms85_182;
extern T7*ms69_152;
extern T7*ms52_663;
extern T7*ms12_294;
extern T7*ms40_144;
extern T7*ms13_414;
extern T7*ms13_424;
extern T7*ms50_684;
extern T7*ms14_564;
extern T7*ms71_424;
extern T7*ms52_28980aa;
extern T7*ms52_112140a;
extern T7*ms52_145656a;
extern T7*ms52_103845a;
extern T7*ms61_110836a;
extern T7*ms29_285;
extern T7*ms14_246;
extern T7*ms14_216;
extern T7*ms14_696;
extern T7*ms43_336;
extern T7*ms38_366;
extern T7*ms29_636;
extern T7*ms13_957;
extern T7*ms52_657;
extern T7*ms13_248;
extern T7*ms13_138;
extern T7*ms13_188;
extern T7*ms40_208;
extern T7*ms14_368;
extern T7*ms14_188;
extern T7*ms29_948;
extern T7*ms29_738;
extern T7*ms13_939;
extern T7*ms14_669;
extern T7*ms230_180;
extern T7*ms306_180;
extern T7*ms296_180;
extern T7*ms299_180;
extern T7*ms232_132;
extern T7*ms180_152;
extern T7*ms172_182;
extern T7*ms237_132;
extern T7*ms296_152;
extern T7*ms207_933;
extern T7*ms201_174;
extern T7*ms161_834;
extern T7*ms207_414;
extern T7*ms234_174;
extern T7*ms226_184;
extern T7*ms264_214;
extern T7*ms10_7710;
extern T7*ms40_2120;
extern T7*ms13_1020;
extern T7*ms13_2780;
extern T7*ms13_2810;
extern T7*ms13_7320;
extern T7*ms13_2830;
extern T7*ms13_2710;
extern T7*ms13_7260;
extern T7*ms13_8680;
extern T7*ms13_1700;
extern T7*ms13_2670;
extern T7*ms13_2550;
extern T7*ms13_2610;
extern T7*ms13_3720;
extern T7*ms14_1980;
extern T7*ms14_2600;
extern T7*ms14_2620;
extern T7*ms14_8750;
extern T7*ms14_2760;
extern T7*ms14_2440;
extern T7*ms14_7380;
extern T7*ms14_2730;
extern T7*ms14_7530;
extern T7*ms14_8820;
extern T7*ms14_1800;
extern T7*ms14_2780;
extern T7*ms42_5320;
extern T7*ms42_2670;
extern T7*ms42_1070;
extern T7*ms61_7320;
extern T7*ms61_1480;
extern T7*ms52_6580;
extern T7*ms52_9260;
extern T7*ms52_7530;
extern T7*ms52_7510;
extern T7*ms43_5160;
extern T7*ms38_2250;
extern T7*ms38_2610;
extern T7*ms311_366;
extern T7*ms93_1660;
extern T7*ms13_9401;
extern T7*ms14_1011;
extern T7*ms14_8211;
extern T7*ms14_9051;
extern T7*ms14_9801;
extern T7*ms233_156;
extern T7*ms10_1512;
extern T7*ms12_1392;
extern T7*ms12_1592;
extern T7*ms13_1792;
extern T7*ms13_6912;
extern T7*ms13_6822;
extern T7*ms13_9422;
extern T7*ms13_6852;
extern T7*ms14_6702;
extern T7*ms14_1772;
extern T7*ms14_1672;
extern T7*ms14_6762;
extern T7*ms42_3102;
extern T7*ms60_9422;
extern T7*ms52_6402;
extern T7*ms52_5302;
extern T7*ms199_366;
extern T7*ms307_237;
extern T7*ms10_7623;
extern T7*ms83_4032;
extern T7*ms29_6412;
extern T7*ms29_8092;
extern T7*ms13_7263;
extern T7*ms13_1053;
extern T7*ms14_6643;
extern T7*ms69_6822;
extern T7*ms42_5553;
extern T7*ms306_108;
extern T7*ms155_168;
extern T7*ms10_8694;
extern T7*ms10_1424;
extern T7*ms11_2424;
extern T7*ms302_939;
extern T7*ms40_5784;
extern T7*ms13_1724;
extern T7*ms13_1684;
extern T7*ms13_1744;
extern T7*ms13_7524;
extern T7*ms268_238;
extern T7*ms14_9234;
extern T7*ms14_1644;
extern T7*ms14_1664;
extern T7*ms14_1724;
extern T7*ms14_1744;
extern T7*ms14_7314;
extern T7*ms359_448;
extern T7*ms269_248;
extern T7*ms42_4164;
extern T7*ms13_9485;
extern T7*ms13_2615;
extern T7*ms13_2595;
extern T7*ms14_2765;
extern T7*ms14_2785;
extern T7*ms14_2445;
extern T7*ms14_8505;
extern T7*ms14_9275;
extern T7*ms14_1035;
extern T7*ms14_1915;
extern T7*ms14_6405;
extern T7*ms42_8175;
extern T7*ms52_2595;
extern T7*ms52_9955;
extern T7*ms65_4725;
extern T7*ms65_1875;
extern T7*ms29_9785;
extern T7*ms38_2065;
extern T7*ms29_2395;
extern T7*ms40_1116;
extern T7*ms13_1736;
extern T7*ms14_1216;
extern T7*ms14_7576;
extern T7*ms14_6846;
extern T7*ms14_1656;
extern T7*ms14_9436;
extern T7*ms14_7326;
extern T7*ms14_4956;
extern T7*ms14_6776;
extern T7*ms52_1176;
extern T7*ms52_7826;
extern T7*ms29_5166;
extern T7*ms29_3636;
extern T7*ms29_9226;
extern T7*ms29_1316;
extern T7*ms29_1296;
extern T7*ms12_7497;
extern T7*ms13_8267;
extern T7*ms14_8547;
extern T7*ms14_6307;
extern T7*ms83_4557;
extern T7*ms57_9977;
extern T7*ms12_3688;
extern T7*ms13_9878;
extern T7*ms13_7008;
extern T7*ms13_1768;
extern T7*ms13_6978;
extern T7*ms13_3038;
extern T7*ms14_5508;
extern T7*ms14_7928;
extern T7*ms14_1608;
extern T7*ms14_9408;
extern T7*ms14_1168;
extern T7*ms14_4728;
extern T7*ms52_9888;
extern T7*ms38_8638;
extern T7*ms29_8478;
extern T7*ms93_1688;
extern T7*ms13_8799;
extern T7*ms42_4949;
extern T7*ms301_7260;
extern T7*ms113_9780;
extern T7*ms203_1480;
extern T7*ms203_2550;
extern T7*ms205_1480;
extern T7*ms323_1020;
extern T7*ms314_6980;
extern T7*ms216_2830;
extern T7*ms207_1700;
extern T7*ms207_1480;
extern T7*ms270_5140;
extern T7*ms217_1480;
extern T7*ms262_7630;
extern T7*ms229_1480;
extern T7*ms275_2610;
extern T7*ms212_6852;
extern T7*ms323_1012;
extern T7*ms211_1724;
extern T7*ms130_1404;
extern T7*ms131_5894;
extern T7*ms304_7524;
extern T7*ms10_38650;
extern T7*ms11_24020;
extern T7*ms13_25640;
extern T7*ms13_12870;
extern T7*ms13_18080;
extern T7*ms13_11460;
extern T7*ms13_17460;
extern T7*ms13_23520;
extern T7*ms13_66110;
extern T7*ms13_10880;
extern T7*ms13_10720;
extern T7*ms13_41100;
extern T7*ms40_56820;
extern T7*ms14_12550;
extern T7*ms14_10740;
extern T7*ms14_12030;
extern T7*ms14_10680;
extern T7*ms14_15070;
extern T7*ms14_15570;
extern T7*ms14_30660;
extern T7*ms14_26880;
extern T7*ms14_33240;
extern T7*ms14_60060;
extern T7*ms14_33270;
extern T7*ms14_53940;
extern T7*ms14_32730;
extern T7*ms14_27580;
extern T7*ms14_33990;
extern T7*ms14_16970;
extern T7*ms14_16770;
extern T7*ms14_16850;
extern T7*ms14_21300;
extern T7*ms14_56720;
extern T7*ms14_15650;
extern T7*ms14_22140;
extern T7*ms42_23730;
extern T7*ms42_36270;
extern T7*ms60_23940;
extern T7*ms42_17730;
extern T7*ms42_32700;
extern T7*ms61_22560;
extern T7*ms52_57450;
extern T7*ms52_82140;
extern T7*ms52_70550;
extern T7*ms52_28980;
extern T7*ms52_43830;
extern T7*ms52_11050;
extern T7*ms52_73800;
extern T7*ms52_91880;
extern T7*ms52_20060;
extern T7*ms52_90080;
extern T7*ms52_63690;
extern T7*ms52_37500;
extern T7*ms52_27720;
extern T7*ms52_28940;
extern T7*ms52_75620;
extern T7*ms52_32940;
extern T7*ms52_74830;
extern T7*ms52_97990;
extern T7*ms52_28720;
extern T7*ms52_57210;
extern T7*ms52_65170;
extern T7*ms52_47790;
extern T7*ms52_56460;
extern T7*ms61_71750;
extern T7*ms61_93400;
extern T7*ms61_73570;
extern T7*ms43_12960;
extern T7*ms43_24060;
extern T7*ms113_1855;
extern T7*ms71_91200;
extern T7*ms205_2595;
extern T7*ms74_19170;
extern T7*ms74_66660;
extern T7*ms74_41470;
extern T7*ms29_82530;
extern T7*ms29_11880;
extern T7*ms29_33210;
extern T7*ms29_46640;
extern T7*ms29_41310;
extern T7*ms29_26180;
extern T7*ms29_38280;
extern T7*ms29_31980;
extern T7*ms29_19880;
extern T7*ms29_10010;
extern T7*ms163_2615;
extern T7*ms13_38641;
extern T7*ms13_45441;
extern T7*ms364_2535;
extern T7*ms161_1256;
extern T7*ms314_6056;
extern T7*ms29_43761;
extern T7*ms13_67082;
extern T7*ms13_11292;
extern T7*ms13_14292;
extern T7*ms14_16692;
extern T7*ms14_27272;
extern T7*ms14_34432;
extern T7*ms14_21192;
extern T7*ms14_13662;
extern T7*ms14_13752;
extern T7*ms60_50372;
extern T7*ms42_63712;
extern T7*ms42_15152;
extern T7*ms185_1136;
extern T7*ms52_38352;
extern T7*ms52_85332;
extern T7*ms52_76392;
extern T7*ms52_13832;
extern T7*ms52_19992;
extern T7*ms52_78192;
extern T7*ms52_45252;
extern T7*ms52_25992;
extern T7*ms52_37992;
extern T7*ms52_34992;
extern T7*ms61_35512;
extern T7*ms43_55332;
extern T7*ms43_48112;
extern T7*ms43_70652;
extern T7*ms83_66792;
extern T7*ms83_43392;
extern T7*ms74_64152;
extern T7*ms74_82612;
extern T7*ms10_70473;
extern T7*ms92_84672;
extern T7*ms65_44172;
extern T7*ms38_19162;
extern T7*ms11_17743;
extern T7*ms95_63162;
extern T7*ms13_63393;
extern T7*ms13_50483;
extern T7*ms40_62493;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms200_6978;
extern T7*ms14_16393;
extern T7*ms14_14193;
extern T7*ms14_27443;
extern T7*ms14_13833;
extern T7*ms52_82473;
extern T7*ms52_60543;
extern T7*ms61_98523;
extern T7*ms63_36693;
extern T7*ms10_10984;
extern T7*ms10_37224;
extern T7*ms57_28313;
extern T7*ms11_10984;
extern T7*ms13_14504;
extern T7*ms13_28644;
extern T7*ms13_60064;
extern T7*ms13_47034;
extern T7*ms13_25714;
extern T7*ms13_10704;
extern T7*ms13_10544;
extern T7*ms14_12804;
extern T7*ms14_19124;
extern T7*ms14_11424;
extern T7*ms14_22524;
extern T7*ms14_19294;
extern T7*ms14_60104;
extern T7*ms14_11144;
extern T7*ms14_18964;
extern T7*ms14_21624;
extern T7*ms14_22824;
extern T7*ms14_12744;
extern T7*ms14_25584;
extern T7*ms42_72324;
extern T7*ms42_68094;
extern T7*ms42_89544;
extern T7*ms42_10544;
extern T7*ms61_60064;
extern T7*ms61_10704;
extern T7*ms43_23814;
extern T7*ms61_34344;
extern T7*ms52_62784;
extern T7*ms52_68714;
extern T7*ms52_31374;
extern T7*ms52_70924;
extern T7*ms52_44694;
extern T7*ms52_63104;
extern T7*ms52_83144;
extern T7*ms52_79794;
extern T7*ms52_36624;
extern T7*ms52_48484;
extern T7*ms43_30744;
extern T7*ms269_3438;
extern T7*ms10_16915;
extern T7*ms10_15075;
extern T7*ms29_25494;
extern T7*ms29_22824;
extern T7*ms272_8799;
extern T7*ms13_15045;
extern T7*ms14_12595;
extern T7*ms14_13995;
extern T7*ms14_12915;
extern T7*ms14_14175;
extern T7*ms14_58075;
extern T7*ms52_41925;
extern T7*ms52_70945;
extern T7*ms52_60295;
extern T7*ms52_38675;
extern T7*ms52_71715;
extern T7*ms52_34845;
extern T7*ms52_74305;
extern T7*ms52_32955;
extern T7*ms52_12285;
extern T7*ms52_37125;
extern T7*ms52_65135;
extern T7*ms43_53165;
extern T7*ms29_76935;
extern T7*ms13_14056;
extern T7*ms13_32336;
extern T7*ms13_37216;
extern T7*ms13_10776;
extern T7*ms13_11256;
extern T7*ms14_11776;
extern T7*ms14_29246;
extern T7*ms14_22596;
extern T7*ms14_60016;
extern T7*ms14_17886;
extern T7*ms14_11496;
extern T7*ms14_11336;
extern T7*ms14_26156;
extern T7*ms14_11376;
extern T7*ms14_22716;
extern T7*ms14_27456;
extern T7*ms42_35616;
extern T7*ms42_43966;
extern T7*ms42_30576;
extern T7*ms52_85576;
extern T7*ms52_43966;
extern T7*ms52_33946;
extern T7*ms52_63096;
extern T7*ms52_47096;
extern T7*ms52_25156;
extern T7*ms52_85386;
extern T7*ms52_82066;
extern T7*ms52_63616;
extern T7*ms52_63456;
extern T7*ms52_98236;
extern T7*ms52_33396;
extern T7*ms52_33286;
extern T7*ms52_84626;
extern T7*ms52_53476;
extern T7*ms83_58386;
extern T7*ms74_51136;
extern T7*ms10_41557;
extern T7*ms29_12816;
extern T7*ms57_11256;
extern T7*ms13_37417;
extern T7*ms14_14817;
extern T7*ms14_19437;
extern T7*ms14_13707;
extern T7*ms14_13977;
extern T7*ms42_82177;
extern T7*ms52_14067;
extern T7*ms52_88647;
extern T7*ms10_14658;
extern T7*ms57_66627;
extern T7*ms57_46407;
extern T7*ms13_21528;
extern T7*ms13_33308;
extern T7*ms13_10608;
extern T7*ms13_10808;
extern T7*ms13_11328;
extern T7*ms13_19808;
extern T7*ms14_17448;
extern T7*ms14_10528;
extern T7*ms14_22248;
extern T7*ms14_22788;
extern T7*ms14_26908;
extern T7*ms14_21648;
extern T7*ms14_34528;
extern T7*ms14_40358;
extern T7*ms14_12978;
extern T7*ms42_10808;
extern T7*ms42_36828;
extern T7*ms61_10608;
extern T7*ms52_63328;
extern T7*ms52_71128;
extern T7*ms52_36168;
extern T7*ms52_94248;
extern T7*ms52_42978;
extern T7*ms52_77508;
extern T7*ms52_78588;
extern T7*ms52_22168;
extern T7*ms52_26638;
extern T7*ms52_90558;
extern T7*ms52_40338;
extern T7*ms52_57288;
extern T7*ms52_29148;
extern T7*ms34_26208;
extern T7*ms10_19839;
extern T7*ms11_37859;
extern T7*ms12_21679;
extern T7*ms67_60608;
extern T7*ms102_16290;
extern T7*ms130_24320;
extern T7*ms14_12529;
extern T7*ms14_13419;
extern T7*ms14_23829;
extern T7*ms42_66429;
extern T7*ms113_41400;
extern T7*ms52_53969;
extern T7*ms52_13509;
extern T7*ms132_56430;
extern T7*ms133_16290;
extern T7*ms133_43200;
extern T7*ms63_28899;
extern T7*ms233_45900;
extern T7*ms314_16400;
extern T7*ms234_76570;
extern T7*ms180_54060;
extern T7*ms29_18029;
extern T7*ms38_10489;
extern T7*ms217_94240;
extern T7*ms217_18080;
extern T7*ms307_10880;
extern T7*ms254_29400;
extern T7*ms245_27080;
extern T7*ms218_18400;
extern T7*ms255_38600;
extern T7*ms183_83790;
extern T7*ms238_22600;
extern T7*ms184_14110;
extern T7*ms175_12870;
extern T7*ms113_88031;
extern T7*ms113_45961;
extern T7*ms269_34500;
extern T7*ms269_38600;
extern T7*ms269_71400;
extern T7*ms133_89271;
extern T7*ms251_43011;
extern T7*ms234_30681;
extern T7*ms255_23751;
extern T7*ms238_53041;
extern T7*ms268_55831;
extern T7*ms133_99162;
extern T7*ms125_50092;
extern T7*ms260_41652;
extern T7*ms314_23562;
extern T7*ms252_35472;
extern T7*ms172_26532;
extern T7*ms218_20672;
extern T7*ms227_86032;
extern T7*ms228_14292;
extern T7*ms219_14812;
extern T7*ms147_50092;
extern T7*ms183_98482;
extern T7*ms183_97692;
extern T7*ms364_86602;
extern T7*ms229_78192;
extern T7*ms229_24012;
extern T7*ms256_29392;
extern T7*ms259_35952;
extern T7*ms233_36693;
extern T7*ms263_45873;
extern T7*ms168_24263;
extern T7*ms12_581900;
extern T7*ms250_99414;
extern T7*ms133_40404;
extern T7*ms314_22284;
extern T7*ms217_11424;
extern T7*ms52_120520;
extern T7*ms52_666080;
extern T7*ms52_112140;
extern T7*ms52_112230;
extern T7*ms52_141350;
extern T7*ms52_196560;
extern T7*ms52_115740;
extern T7*ms52_191760;
extern T7*ms52_115650;
extern T7*ms218_29304;
extern T7*ms236_34344;
extern T7*ms272_21144;
extern T7*ms164_36624;
extern T7*ms165_85234;
extern T7*ms183_86564;
extern T7*ms101_53215;
extern T7*ms238_63264;
extern T7*ms229_41834;
extern T7*ms83_500000;
extern T7*ms186_98784;
extern T7*ms57_139750;
extern T7*ms66_116840;
extern T7*ms359_54464;
extern T7*ms253_38125;
extern T7*ms52_124691;
extern T7*ms227_20145;
extern T7*ms245_38075;
extern T7*ms183_33465;
extern T7*ms210_18176;
extern T7*ms249_37975;
extern T7*ms113_20976;
extern T7*ms113_37536;
extern T7*ms133_36216;
extern T7*ms241_86756;
extern T7*ms161_63456;
extern T7*ms314_61446;
extern T7*ms314_50576;
extern T7*ms234_63756;
extern T7*ms42_171472;
extern T7*ms172_36216;
extern T7*ms43_802392;
extern T7*ms52_135632;
extern T7*ms52_349402;
extern T7*ms52_202032;
extern T7*ms52_128352;
extern T7*ms218_63376;
extern T7*ms236_33396;
extern T7*ms164_18096;
extern T7*ms238_45376;
extern T7*ms229_36096;
extern T7*ms229_14616;
extern T7*ms229_75456;
extern T7*ms200_19437;
extern T7*ms266_18176;
extern T7*ms29_716872;
extern T7*ms211_32637;
extern T7*ms259_16976;
extern T7*ms78_233442;
extern T7*ms146_66627;
extern T7*ms238_66627;
extern T7*ms201_58608;
extern T7*ms211_74948;
extern T7*ms113_41868;
extern T7*ms12_570704;
extern T7*ms133_35088;
extern T7*ms234_11648;
extern T7*ms42_121824;
extern T7*ms52_197274;
extern T7*ms63_783104;
extern T7*ms275_11328;
extern T7*ms266_50008;
extern T7*ms268_17008;
extern T7*ms69_101934;
extern T7*ms69_121394;
extern T7*ms42_228345;
extern T7*ms42_130095;
extern T7*ms52_115695;
extern T7*ms52_114705;
extern T7*ms52_103845;
extern T7*ms52_116145;
extern T7*ms52_116865;
extern T7*ms218_53969;
extern T7*ms258_49909;
extern T7*ms10_208456;
extern T7*ms42_196786;
extern T7*ms52_145656;
extern T7*ms52_203856;
extern T7*ms61_110836;
extern T7*ms29_131716;
extern T7*ms29_848426;
extern T7*ms93_107916;
extern T7*ms13_554698;
extern T7*ms60_162378;
extern T7*ms144_100560;
extern T7*ms29_225848;
extern T7*ms183_126960;
extern T7*ms269_101250;
extern T7*ms10_160a;
extern T7*ms13_939a;
extern T7*ms42_160a;
extern T7*ms52_280a;
extern T7*ms52_663a;
extern T7*ms52_657a;
extern T7*ms113_382452;
extern T7*ms38_366a;
extern T7*ms162_358643;
extern T7*ms183_235773;
extern T7*ms183_141933;
extern T7*ms52_1419840;
extern T7*ms183_157734;
extern T7*ms175_120244;
extern T7*ms275_126054;
extern T7*ms130_153435;
extern T7*ms183_115695;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void se_msi10(void);
void se_msi11(void);
void se_msi12(void);
void se_msi13(void);
void se_msi14(void);
void se_msi15(void);
void se_msi16(void);
void*se_ma294(int argc,...);
void*se_ma206(int argc,...);
void*se_ma303(int argc,...);
void*se_ma308(int argc,...);
void*se_ma213(int argc,...);
void*se_ma220(int argc,...);
void*se_ma223(int argc,...);
void*se_ma33(int argc,...);
void*se_ma322(int argc,...);
void*se_ma244(int argc,...);
void*se_ma58(int argc,...);
void*se_ma156(int argc,...);
void*se_ma62(int argc,...);
void*se_ma72(int argc,...);
void*se_ma265(int argc,...);
void*se_ma170(int argc,...);
void*se_ma176(int argc,...);
void*se_ma81(int argc,...);
void*se_ma86(int argc,...);
void*se_ma94(int argc,...);
void X199set_rescue_compound(void *C,T0* a1);
T2 X146arg_count(void *C);
T0* X146arguments(void *C);
T0* X146make_runnable(void *C,T0* a1,T0* a2,T0* a3);
void X146pretty_print(void *C);
T0* X313run_class(void *C);
void X313vape_check_from(void *C,T0* a1);
T0* X313local_vars(void *C);
T0* X313arguments(void *C);
T6 X313is_exported_in(void *C,T0* a1);
T0* X313clients(void *C);
T0* X313result_type(void *C);
T0* X313start_position(void *C);
T0* X222to_runnable_integer(void *C,T0* a1);
T0* X222to_runnable_character(void *C,T0* a1);
T0* X222twin(void *C);
void X222pretty_print(void *C);
T0* X185value(void *C,T2 a1);
T0* X185start_position(void *C);
void X293append_in(void *C,T0* a1);
T2 X293count(void *C);
void X293pretty_print(void *C);
T6 X317fast_has(void *C,T0* a1);
void X317resize(void *C,T2 a1);
void X169set_rank(void *C,T2 a1);
T0* X169to_string(void *C);
void X169pretty_print(void *C);
T0* X169start_position(void *C);
void X297put(void *C,T0* a1,T2 a2);
T0* X287result_type(void *C);
T0* X287start_position(void *C);
T6 X63is_any(void *C);
T6 X63is_string(void *C);
T0* X63generic_list(void *C);
T2 X63id(void *C);
T0* X63smallest_ancestor(void *C,T0* a1);
T6 X63is_like_current(void *C);
T6 X63is_array(void *C);
T0* X63base_class(void *C);
T6 X63is_double(void *C);
T6 X63is_none(void *C);
T0* X63look_up_for(void *C,T0* a1,T0* a2);
T0* X63to_runnable(void *C,T0* a1);
T6 X63has_creation(void *C,T0* a1);
T6 X63is_pointer(void *C);
T0* X63static_base_class_name(void *C);
T6 X63is_a_in(void *C,T0* a1,T0* a2);
T0* X63run_time_mark(void *C);
T6 X63is_boolean(void *C);
T6 X63is_a(void *C,T0* a1);
T6 X63is_generic(void *C);
T0* X63run_class(void *C);
T6 X63is_like_feature(void *C);
T6 X63is_like_argument(void *C);
T0* X63run_type(void *C);
T6 X63is_expanded(void *C);
T0* X63expanded_initializer(void *C);
T6 X63is_basic_eiffel_expanded(void *C);
T6 X63is_formal_generic(void *C);
void X63used_as_reference(void *C);
T6 X63is_character(void *C);
T6 X63is_reference(void *C);
T0* X63written_mark(void *C);
T6 X63is_real(void *C);
T0* X63base_class_name(void *C);
T6 X63is_anchored(void *C);
T6 X63is_run_type(void *C);
void X63pretty_print(void *C);
T6 X63is_bit(void *C);
T0* X63start_position(void *C);
T6 X63is_integer(void *C);
T0* X250base_class(void *C);
T0* X145add_comment(void *C,T0* a1);
T0* X145to_runnable(void *C,T0* a1);
void X145pretty_print(void *C);
T0* X145start_position(void *C);
void X227set_current_type(void *C,T0* a1);
T0* X227to_runnable(void *C,T0* a1);
void X227pretty_print(void *C);
void X274pretty_print(void *C);
T0* X270result_type(void *C);
T0* X270start_position(void *C);
void X66declaration_in(void *C,T0* a1);
void X66declaration_pretty_print(void *C);
void X66undefine_in(void *C,T0* a1);
T0* X66origin_base_class(void *C);
T0* X66to_key(void *C);
T6 X66is_frozen(void *C);
T0* X66to_string(void *C);
void X66pretty_print(void *C);
T0* X66start_position(void *C);
T0* X135twin(void *C);
void X355resize(void *C,T2 a1);
void X164add_last(void *C,T0* a1);
T2 X89precedence(void *C);
T6 X89is_current(void *C);
T0* X89static_result_base_class(void *C);
T0* X89add_comment(void *C,T0* a1);
void X89assertion_check(void *C,T3 a1);
T0* X89to_runnable(void *C,T0* a1);
T2 X89to_integer(void *C);
T6 X89is_void(void *C);
void X89bracketed_pretty_print(void *C);
void X89pretty_print(void *C);
T0* X89result_type(void *C);
void X89print_as_target(void *C);
T0* X89start_position(void *C);
T2 X262nb(void *C);
T0* X94twin(void *C);
void X74set_header_comment(void *C,T0* a1);
T0* X74ensure_assertion(void *C);
T6 X74is_deferred(void *C);
T6 X74is_merge_with(void *C,T0* a1,T0* a2);
T6 X74is_merge_with2aux(void *C,T0* a1,T0* a2);
T6 X74can_hide(void *C,T0* a1,T0* a2);
void X74add_into(void *C,T0* a1);
T0* X74try_to_undefine(void *C,T0* a1,T0* a2);
T0* X74require_assertion(void *C);
void X74check_obsolete(void *C,T0* a1);
T0* X74arguments(void *C);
T0* X74to_run_feature(void *C,T0* a1,T0* a2);
void X74pretty_print(void *C);
T0* X74result_type(void *C);
T0* X74start_position(void *C);
void X150pretty_print(void *C);

