--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
--                       http://SmallEiffel.loria.fr
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class INSTALL
   --
   -- The `install' command may be used to INSTALL SmallEiffel on all platforms.
   --

inherit COMMAND_FLAGS;

creation make

feature {NONE}

   command_name: STRING is "install";

   make is
      local
         argc: INTEGER;
         arg: STRING;
      do
         echo.set_verbose;
         argc := argument_count;
         if argc = 0 then
         elseif argc = 2 then
            if ("-skip").is_equal(argument(1)) then
               arg := argument(2);
               if arg.is_integer then
                  skip_step := arg.to_integer;
               else
                  echo_usage_exit;
               end;
            else
               echo_usage_exit;
            end;
         else
            echo_usage_exit;
         end;
         !!st.install;
         echo.put_string("SmallEiffel install program started.%N");
         if is_flag_version("-version") then end;
         --
         force_step("Checking %"SmallEiffel%" environment variable");
         environment_variable;
         finish_step;
         --
         if start_step("System name detection") then
            system_name_detection;
            finish_step;
         end;
         st.make;
         system_name := st.system_name;
         --
         force_step("Writing default loadpath.se file");
         default_loadpath;
         finish_step;
         --
         if start_step("C compiler selection") then
            c_compiler_selection;
            finish_step;
         end;
         --
         if start_step("Garbage collector selection") then
            garbage_collector_selection;
            finish_step;
         end;
         --
         ch_dir_to("bin_c");
         --
         if start_step("Prepare `compile' command") then
            prepare_no_split("compile.c");
            finish_step;
         end;
         --
         echo.put_string("--%NSmallEiffel install done (congratulations).%N");
      end;

   environment_variable is
      local
         var: STRING;
      do
         system_se_path := get_environment_variable(fz_se);
         if system_se_path = Void or else system_se_path.count = 0 then
            var := fz_se.twin;
            var.to_upper;
            system_se_path := get_environment_variable(var);
         end;
         if system_se_path = Void or else system_se_path.count = 0 then
            fatal_problem_description_start;
            echo.put_string(
            "Environment variable %"SmallEiffel%" is not set.%N%
            %Please, set this variable with the absolute path of %N%
            %the %"SmallEiffel/sys/system.se%" file.%N%
            %A file %"system.se%" must exists in the sub-directory %"sys%"%
            % of the%NSmallEiffel directory.%N");
            fatal_problem_description_end;
         end;
         if not system_se_path.has_suffix("system.se") then
            fatal_problem_description_start;
            echo.put_string(
            "Value of the Environment variable %"SmallEiffel%" value%Nis %"");
            echo.put_string(system_se_path);
            echo.put_string("%".%N");
            echo.put_string(
            "Please, set this variable with the absolute path of%N%
            %the %"SmallEiffel/sys/system.se%" file.%N%
            %For example, on Linux, the value is%N%
            %often %"/usr/lib/SmallEiffel/sys/system.se%".%N%
            %On Windows, %"C:\SmallEiffel\sys\system.se%" is a correct value%N%
            %when the SmallEiffel directory is at toplevel of the C hard %
            %disk.%N");
            fatal_problem_description_end;
         end;
         if not file_exists(system_se_path) then
            fatal_problem_description_start;
            echo.put_string(
            "Value of the Environment variable %"SmallEiffel%" value%Nis %"");
            echo.put_string(system_se_path);
            echo.put_string(
            "%".%N%
            %There is no readable file %"");
            echo.put_string(system_se_path);
            echo.put_string(
            "%".%N%
            %Check this absolute path as well as read permission.%N");
            fatal_problem_description_end;
         end;
      end;

   system_name_detection is
      local
         sfw: STD_FILE_WRITE;
      do
         if file_exists("s:startup-sequence") then
            -- This check has to be performed BEFORE the Unix check
            -- ("/bin/ls"), because the latter might be true if the user
            -- installed GeekGadgets and one of those perverted patches
            -- to handle Unix-style paths !
            echo.put_string("System seems to be an Amiga.%N");
            system_name := "Amiga";
         elseif file_exists("/bin/ls") then
            echo.put_string("System seems to be UNIX.%N");
            system_name := "UNIX";
         else
            system_name := choice_in("System name selection",st.system_list);
         end;
         echo.put_string("System is %"");
         echo.put_string(system_name);
         echo.put_string("%".%NTry to update %"");
         echo.put_string(system_se_path);
         echo.put_string("%".%N");
         !!sfw.connect_to(system_se_path);
         if not sfw.is_connected then
            fatal_problem_description_start;
            echo.put_string("Cannot write file %"");
            echo.put_string(system_se_path);
            echo.put_string("%".%NCheck write permissions.");
            fatal_problem_description_end;
         end;
         sfw.put_string(system_name);
         sfw.put_character('%N');
         sfw.disconnect;
         echo.put_string("Update of %"");
         echo.put_string(system_se_path);
         echo.put_string("%" done.%N");
      end;

   default_loadpath is
      local
         path, directory: STRING;
         list: ARRAY[STRING];
         sfw: STD_FILE_WRITE;
         i: INTEGER;
      do
         path := system_se_path.twin;
         path.remove_suffix("system.se");
         path.append("loadpath.");
         path.append(system_name);
         echo.put_string("Try to update %"");
         echo.put_string(path);
         echo.put_string("%".%N");
         !!sfw.connect_to(path);
         if not sfw.is_connected then
            fatal_problem_description_start;
            echo.put_string("Cannot write file %"");
            echo.put_string(path);
            echo.put_string("%".%NCheck write permissions.");
            fatal_problem_description_end;
         end;
         -- Current directory :
         if ("UNIX").is_equal(system_name) then
            sfw.put_string("./%N");
         elseif ("DOS").is_equal(system_name) then
            sfw.put_string(".\%N");
         elseif ("Windows").is_equal(system_name) then
            sfw.put_string(".\%N");
         elseif ("BeOS").is_equal(system_name) then
            sfw.put_string("./%N");
         elseif ("Macintosh").is_equal(system_name) then
            sfw.put_string(":%N");
         elseif ("VMS").is_equal(system_name) then
            -- Don't know (mail the good one to colnet@loria.fr)
         elseif ("OS2").is_equal(system_name) then
            -- Don't know (mail the good one to colnet@loria.fr)
         elseif ("Amiga").is_equal(system_name) then
            sfw.put_string("%N");
         end;
         list := <<"lib_std", "lib_rand", "lib_show", "lib_se">>;
         from
            i := 1;
         until
            i > list.upper
         loop
            directory := system_se_path.twin;
            directory.remove_suffix("system.se");
            st.parent_directory(directory);
            st.add_directory(directory,list.item(i));
            sfw.put_string(directory);
            if i < list.upper then
               sfw.put_character('%N');
            end;
            i := i + 1;
         end;
         sfw.disconnect;
         echo.put_string("Update of %"");
         echo.put_string(path);
         echo.put_string("%" done.%N");
      end;

   c_compiler_selection is
      local
         path, name: STRING;
         sfw: STD_FILE_WRITE;
      do
         name := choice_in("C compiler selection",st.compiler_list);
         echo.put_string("Selected C compiler is %"");
         echo.put_string(name);
         echo.put_string("%".%N");
         path := system_se_path.twin;
         path.remove_suffix("system.se");
         path.append("compiler.se");
         echo.put_string("Try to update %"");
         echo.put_string(path);
         echo.put_string("%".%N");
         !!sfw.connect_to(path);
         if not sfw.is_connected then
            fatal_problem_description_start;
            echo.put_string("Cannot write file %"");
            echo.put_string(path);
            echo.put_string("%".%NCheck write permissions.");
            fatal_problem_description_end;
         end;
         sfw.put_string(name);
         std_input.last_string.clear;
         echo.put_string(
         "If you want to add some defaults C-compiler/Linker options,%N%
         %type your options using one single line.%N%
         %If you don't know, type <CR> only.%N%
         %options ? ");
         std_input.read_line;
         if std_input.last_string.count > 0 then
            if std_input.last_string.item(1) /= ' ' then
               sfw.put_character(' ');
            end;
            sfw.put_string(std_input.last_string);
         end;
         sfw.put_character('%N');
         sfw.disconnect;
         echo.put_string("Update of %"");
         echo.put_string(path);
         echo.put_string("%" done.%N");
      end;

   garbage_collector_selection is
      local
         cmd: STRING;
      do
         if system_name.is_equal("UNIX") then
            cmd := system_se_path.twin;
            cmd.remove_suffix("sys/system.se");
            cmd.append("misc/GC.SH");
            echo.put_string("Launching script %"");
            echo.put_string(cmd);
            echo.put_string("%".%N");
            system(cmd);
         elseif system_name.is_equal("Amiga") then
            cmd := "echo m68k-amigaos.c >%"";
            cmd.append(system_se_path.twin);
            cmd.remove_suffix("sys/system.se");
            cmd.append("sys/gc%"");
            system(cmd);
         elseif system_name.is_equal("Windows") then
         elseif system_name.is_equal("BeOS") then

         end;
      end;

   prepare_no_split(c_file: STRING) is
      local
         cmd: STRING;
      do
         !!cmd.make(128);
         st.no_split_mode_command(cmd,c_file);
         echo.put_string("<<");
         echo.put_string(cmd);
         echo.put_string(">>");

      end;

   ch_dir_to(dest: STRING) is
      local
         path: STRING;
         p: POINTER;
      do
         path := system_se_path.twin;
         path.remove_suffix("system.se");
         st.parent_directory(path);
         st.add_directory(path,dest);
         p := path.to_external;
         echo.put_string("Try to change directory to %"");
         echo.put_string(path);
         echo.put_string("%".%N");
         c_inline_c("chdir(_p);%N");
      end;

   system_se_path: STRING;

   step_number: INTEGER;

   step_name: STRING;

   skip_step: INTEGER;

   start_step(sn: STRING): BOOLEAN is
      do
         step_number := step_number + 1;
         step_name := sn;
         if skip_step < step_number then
            Result := true;
            echo.put_string("--%NStep #");
            echo.put_integer(step_number);
            echo.put_string(": ");
            echo.put_string(sn);
            echo.put_string(".%N");
         else
            echo.put_string("--%NSkipping step #");
            echo.put_integer(step_number);
            echo.put_string(": ");
            echo.put_string(sn);
            echo.put_string(".%N");
         end;
      end;

   finish_step is
      do
         echo.put_string("Done : (Step #");
         echo.put_integer(step_number);
         echo.put_string(": ");
         echo.put_string(step_name);
         echo.put_string(").%N");
      end;

   force_step(sn: STRING) is
      local
         save: INTEGER;
      do
         save := skip_step;
         skip_step := 0;
         if start_step(sn) then end;
         skip_step := save;
      end;

   fatal_problem_description_start is
      do
         echo.put_string(
         "*** Fatal problem during installation of SmallEiffel.%N%
         %    Read carefully the following information before starting%N%
         %    again the `install' command.%N%
         %******************************************************************%N");
      end;

   fatal_problem_description_end is
      do
         echo.put_string(
         "******************************************************************%N%
         %Fix the previously described problem and launch again `install'.%N");
         die_with_code(exit_failure_code);
      end;

   choice_in(title: STRING; names: ARRAY[STRING]): STRING is
      local
         i: INTEGER;
         w: STRING;
      do
         from
         until
            Result /= Void
         loop
            echo.put_string(title);
            echo.put_string(" :%N  ");
            from
               i := 1;
            until
               i > names.upper
            loop
               echo.put_string(names.item(i));
               i := i + 1;
               if i <= names.upper then
                  echo.put_string(", ");
               end;
            end;
            echo.put_string("%N? ");
            std_input.read_word;
            from
               i := names.upper;
               w := std_input.last_string.twin;
            until
               i = 0 or else Result /= Void
            loop
               if w.same_as(names.item(i)) then
                  Result := names.item(i);
               end;
               i := i - 1;
            end;
            if Result = Void then
               echo.put_string("%"");
               echo.put_string(w);
               echo.put_string("%" is not a valid choice.%N");
            end;
         end;
      end;

   echo_usage_exit is
      do
         echo.put_string("usage : ");
         echo.put_string(command_name);
         echo.put_string(" [-skip <step_number>]%N");
         die_with_code(exit_failure_code);
      end;

   system_name: STRING;

   st: SYSTEM_TOOLS;

end -- INSTALL

