/*
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>
   and Michael L.H. Brouwer <michael@thi.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: trt_send.S,v 1.8 1999/10/03 16:56:12 tiggr Exp $  */


#include <tom/trt.h>
#include <target.h>

/* return_type
   trt_send (tom_State_c_ref self, selector *_cmd)
   {
     int sel_id = _cmd->sel_id;
     int bucket_idx = sel_id / TRT_BUCKET_SIZE;
     int imp_idx = sel_id % TRT_BUCKET_SIZE;

     jump (self->isa->mdt->b[bucket_idx].m[imp_idx]);
   }
 */

#ifdef AS_LABEL_UNDERSCORES
#define TRT_SEND  _trt_send
#define TRT_SEND_NIL  _trt_send_nil
#else
#define TRT_SEND  trt_send
#define TRT_SEND_NIL  trt_send_nil
#endif

.text
	.align 4
.globl TRT_SEND
/* Maybe we should check for gas version instead.  Nextstep 3 uses gas
   version 1.38.  */
#ifndef NeXT
	.type	 TRT_SEND,@function
#endif /* not NeXT */
TRT_SEND:
	movl	4(%esp),%eax
	movl	8(%esp),%edx
	movl	(%edx),%ecx
#if defined (DEBUG) || defined (ALWAYS_CHECK_NIL_RECEIVER)
	testl	%eax,%eax
	je	TRT_SEND_NIL
#endif
	movl	(%eax),%eax
	movl	8(%eax),%edx
	movl	%ecx,%eax
	shrl	$4,%eax
	movl	8(%edx,%eax,4),%edx
	movl	%ecx,%eax
	andl	$15,%eax
	movl	(%edx,%eax,4),%eax
	jmp	*%eax
#ifndef NeXT
.Lfe1:
	.size	 TRT_SEND,.Lfe1-TRT_SEND
#endif /* not NeXT */

#ifdef NEED_MEMCPY_NO_UNDERSCORE_UNTIL_GCC_IS_FIXED
.text
	.align 4
.globl	memcpy
	.type	memcpy,@function
memcpy:	jmp	_memcpy
#endif
