/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIMeta.m,v 1.16 1998/01/05 00:57:10 tiggr Exp $  */

#define LTIMETA_DECLARE_PRIVATE_METHODS
#import "lti.h"

TLVector *ordered_instances, *ordered_classes;
TLVector *ordered_state_instances, *ordered_state_classes;

@implementation LTTMeta (Semantics)

+(id) semanticsForInstance: (LTTInstance *) inst
{
  return [[CO_LTIInstance gcAlloc] initWithStructure: inst];
}

+(id) semanticsForClass: (LTTClass *) cls
{
  return [[CO_LTIClass gcAlloc] initWithStructure: cls];
}

@end

@implementation LTIMeta

+(void) generateClassSequences
{
  // XXX Does this use the right class?
  ordered_instances = [TLVector vectorWithSequence:
				[[ltt_instance_any semantics]
				 generateClassSequence: nil
				 stateOnly: NO mark: ++search_mark]];
  [ordered_instances gcLock];
  ordered_classes = [TLVector vectorWithSequence:
			      [[ltt_class_any semantics]
			       generateClassSequence: nil
			       stateOnly: NO mark: ++search_mark]];
  [ordered_classes gcLock];
  ordered_state_instances = [TLVector vectorWithSequence:
				      [[ltt_instance_state semantics]
				       generateClassSequence: nil
				       stateOnly: YES mark: ++search_mark]];
  [ordered_state_instances gcLock];
  ordered_state_classes = [TLVector vectorWithSequence:
				    [[ltt_class_state semantics]
				     generateClassSequence: nil
				     stateOnly: YES mark: ++search_mark]];
  [ordered_state_classes gcLock];
}

-(void) addDeferredMethod: (LTIMethod *) m
{
  if (!deferred_methods)
    deferred_methods = [TLSet set];

  [deferred_methods addElement: m];
}

-(void) addSuperReference: (LTIMeta *) m
{
  if (!ref_supers)
    ref_supers = [TLSet set];

  [ref_supers addElement: m];
}

-(BOOL) classp
{
  return NO;
}

-(TLSet *) deferredSelectors
{
  return deferred_selectors;
}

-equal: o
{
  return self == o ? self : nil;
}

-(void) gcReference
{
  MARK (structure);
  MARK (imps);
  MARK (ref_supers);
  MARK (deferred_methods);
  MARK (deferred_selectors);

  [super gcReference];
}

-(TLCons *) generateClassSequence: (TLCons *) list
			stateOnly: (BOOL) statep
			     mark: (int) k
{
  TLVector *v;
  LTTMeta *m;
  int i, n;

  if (mark == k)
    return list;
  mark = k;

  if (!statep)
    {
      v = [structure behaviourSubs];
      for (i = 0, n = [v length]; i < n; i++)
	{
	  m = [v _elementAtIndex: i];
	  list = [[m semantics] generateClassSequence: list
				stateOnly: statep mark: k];
	}
    }

  v = [structure stateSubs];
  for (i = 0, n = [v length]; i < n; i++)
    {
      m = [v _elementAtIndex: i];
      list = [[m semantics] generateClassSequence: list
			    stateOnly: statep mark: k];
    }

  return CONS (self, list);
}

-(BOOL) haveDeferredMethods
{
  return deferred_selectors && [deferred_selectors length];
}

-(id) implementations
{
  return imps;
}

-initWithStructure: (LTTMeta *) str
{
  if (![super init])
    return nil;

  structure = str;

  return self;
}

-(LTTMeta *) structure
{
  return structure;
}

-(void) print: (id <TLMutableStream>) stream quoted: (BOOL) qp
{
  const char *s = class_get_class_name (isa);

  formac (stream, @"(%s %x %@)", s, self, ltt_meta_name (structure));
}

@end
