/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIMethod.h,v 1.5 1998/01/05 00:57:11 tiggr Exp $  */

#import "lti.h"

@class LTISelector, LTIMeta;

@interface LTIMethod: LTTTop
{
  /* Our name.  */
  TLString *name;

  /* Our selector.  */
  LTISelector *sel;

  /* The meta.  */
  LTIMeta *meta;
}

+(LTIMethod *) withSelector: (LTISelector *) sel
		       name: (TLString *) name
		       meta: (LTIMeta *) meta;

-(LTIMeta *) meta;

-(id <TLString>) methodName;

-(LTISelector *) selector;

#ifdef LTIMETHOD_DECLARE_PRIVATE_METHODS

-initWithSelector: (LTISelector *) sel
	     name: (TLString *) name
	     meta: (LTIMeta *) meta;

#endif

@end
