/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIMethod.m,v 1.6 1998/01/05 00:57:12 tiggr Exp $  */

#define LTIMETHOD_DECLARE_PRIVATE_METHODS
#import "lti.h"

@implementation LTIMethod

+(LTIMethod *) withSelector: (LTISelector *) s
		       name: (TLString *) n
		       meta: (LTIMeta *) m
{
  return [[self gcAlloc] initWithSelector: s name: n meta: m];
}

-(void) gcReference
{
  MARK (sel);
  MARK (name);
  MARK (meta);

  [super gcReference];
} /* gcReference */

-initWithSelector: (LTISelector *) s
	     name: (TLString *) n
	     meta: (LTIMeta *) m
{
  if (![super init])
    return nil;

  sel = s;

  [sel addMethod: self];

  meta = m;
  name = n;

  if (!name)
    [meta addDeferredMethod: self];

  return self;
}

-(LTIMeta *) meta
{
  return meta;
} /* -meta */

-(id <TLString>) methodName
{
  return name;
} /* -methodName */

-(LTISelector *) selector
{
  return sel;
} /* -selector */

@end
