/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIStringCST.m,v 1.9 1998/01/05 00:57:16 tiggr Exp $  */

#define LTISTRINGCST_DECLARE_PRIVATE_METHODS
#import "LTIStringCST.h"

static TLVector *all_strings;

static TLDictionary *strings;

@implementation LTTStringCST (Semantics)

+(id) semanticsForString: (LTTStringCST *) s
{
  return [[CO_LTIStringCST gcAlloc] initWithStructure: s];
}

@end

@implementation LTIStringCST

+(TLVector *) allStrings
{
  return all_strings;
}

+initialize
{
  if (!all_strings)
    {
      all_strings = [TLVector vector];
      [all_strings gcLock];
      strings = [TLDictionary dictionary];
      [strings gcLock];
    }
  return self;
}

+(LTIStringCST *) stringForString: (id <TLString>) string
{
  return [strings objectForKey: string];
}

+(id <TLEnumerator>) strings
{
  return [strings valueEnumerator];
}

+(void) sufferAmnesia
{
  strings = nil;
  all_strings = nil;
  [self initialize];
}

-(LTTStringCST *) structure
{
  return structure;
}

-(void) gcReference
{
  MARK (structure);

  [super gcReference];
}

-initWithStructure: (LTTStringCST *) str
{
  if (![super init])
    return nil;

  structure = str;

  [all_strings addElement: self];
  if (![strings objectForKey: [structure string]])
    [strings setObject: self forKey: [structure string]];

  return self;
}

-(void) print: (id <TLMutableStream>) stream quoted: (BOOL) qp
{
  formac (stream, @"#<%s %p %@ %@>", class_get_class_name (isa), self,
	  [structure lttName], [structure string]);
}

@end
