/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: lti.h,v 1.17 1998/01/05 00:57:20 tiggr Exp $  */

#import "ltt/ltt.h"
#import "LTIClass.h"
#import "LTIExtension.h"
#import "LTIInstance.h"
#import "LTIMeta.h"
#import "LTIMethod.h"
#import "LTISelector.h"
#import "LTIStringCST.h"
#import "LTIVariable.h"

/* Keys in the info file.  */
extern TLSymbol *Qfile_version, *Qotmc_version, *Qcompile_date, *Qselectors;
extern TLSymbol *Qextension, *Qclass, *Qsupers, *Qmethods, *Qinstance, *Qfile;
extern TLSymbol *Qdynamic_selectors, *Qvariables, *Qstatic, *Qsuper_refs;
extern TLSymbol *Qconstants, *Qlocal;

extern id CO_LTIClass, CO_LTIExtension, CO_LTIInstance, CO_LTIMeta;
extern id CO_LTIMethod, CO_LTISelector, CO_LTIStringCST, CO_LTIVariable;

/* Dictionary from actual selector to its dynamic definition.  */
extern TLDictionary *dynamic_selectors;

/* The `void load' selector.  */
extern LTISelector *load_selector;

/* All implementations of `load'.  */
extern TLCons *load_imps;

/* Initialize lti, and anything below it (like ltt and libtl).  */
void lti_init (int argc, char **argv);

/* Finish initialization.  */
void lti_finish_init (void);

/* Load the info file for the file F.  */
void lti_load_file_info (LTTFile *f);

/* Load the info files from the unit U.  */
void lti_load_unit_info (LTTUnit *u);

/* Get the meta from L, which should be something like `("unit" "meta")'
   or qualified like `(instance|class "unit" "meta")'.  Upon a non-nil
   return, *WAS_QUALIFIED is updated to indicate whether it was qualified.
   QUALIFIED can be -1 (may be qualified), 0 (qualification not allowed)
   or 1 (must be qualified).  Moan iff applicable.  */
LTIMeta *lti_retrieve_meta (TLCons *l, int qualified, int *was_qualified);
