/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTExtension.h,v 1.11 1998/01/05 00:57:58 tiggr Exp $  */

#import "LTTFileItem.h"

@class LTTFile, LTTMeta, LTTVariable;

@interface LTTExtension: LTTFileItem
{
  /* The meta we extend.  */
  LTTMeta *meta;

  /* Our variables, both on key and in order.  */
  TLDictionary *vars_keyed;
  TLVector *vars_order;

  /* Our static variables (not included in the preceding tables).  */
  TLDictionary *vars_static;
}

+(LTTExtension *) extensionWithName: (TLString *) n
			       file: (LTTFile *) f
			       meta: (LTTMeta *) m;

-(id) initWithName: (TLString *) n
	      file: (LTTFile *) f
	      meta: (LTTMeta *) m;

-(LTTMeta *) meta;

-(BOOL) isMainExtension;

/* Return the output name of variable holding the extension identity.  */
-(id <TLString>) outputExtensionIdentityName;

/* Return the output name of the structure declared holding the
   extension's variables.  */
-(id <TLString>) outputExtensionStructName;

/* Return the name of the field in a meta which holds this extenion's
   variables.  */
-(id <TLString>) outputExtensionFieldName;

/* Return the name of the variable being the struct describing the
   variables contained in this extension.  */
-(id <TLString>) outputExtensionDescriptionName;

/******************** variables ********************/

/* Add a non-static variable.  */
-(void) addVariable: (LTTVariable *) v;

/* Return whether we have any non-static variables.  */
-(BOOL) hasVariables;

/* Return the number of non-static variables.  */
-(int) numVariables;

/* Return the non-static variables, in order.  */
-(id <TLEnumerator>) variables;

/* Add a static variable.  */
-(void) addStaticVariable: (LTTVariable *) v;

/* Return whether we have any static variables.  */
-(BOOL) hasStaticVariables;

/* Return the static variables.  */
-(id <TLEnumerator>) staticVariables;

@end

@interface LTTExtension (Semantics)

+(id) semanticsForExtension: (LTTExtension *) self;

@end
