/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTSelector.m,v 1.12 1998/01/05 00:58:15 tiggr Exp $  */

#define LTTSELECTOR_DECLARE_PRIVATE_METHODS
#import "LTTSelector.h"
#import "ltt.h"

/* A dictionary from frobnicated name to selector.  */
static TLDictionary *selectors;

static TLSet *used_selectors;

@implementation LTTSelector

+(LTTSelector *) searchSelectorNamed: (id <TLString>) n
{
  return [selectors objectForKey: n];
}

-(void) updateArgs: (id <TLString>) i : (id <TLString>) o
{
  if (!in)
    {
      in = [CO_LTTSelArgTypes argumentTypesWithString: i];
      out = [CO_LTTSelArgTypes argumentTypesWithString: o];
    }
}

+(LTTSelector *) selectorWithName: (id <TLString>) n
			   inArgs: (id <TLString>) i
			  outArgs: (id <TLString>) o
{
  LTTSelector *s = [selectors objectForKey: n];

  if (!s)
    {
      s = [[self gcAlloc] initWithName: n inArgs: i outArgs: o];
      [selectors setObject: s forKey: n];
    }
  else if (i)
    [s updateArgs: i : o];

  return s;
}

+(LTTSelector *) selectorWithMangledName: (id <TLString>) n
{
  LTTSelector *s = [selectors objectForKey: n];

  if (!s)
    {
      s = [[self gcAlloc] initWithName: n inArgs: nil outArgs: nil];
      [selectors setObject: s forKey: n];
    }

  return s;
}

+initialize
{
  if (!selectors)
    {
      selectors = [TLDictionary dictionary];
      [selectors gcLock];
      used_selectors = [TLSet set];
      [used_selectors gcLock];
    }

  return self;
}

+(id <TLEnumerator>) selectors
{
  return [used_selectors enumerator];
}

-(void) noteUsage
{
  [used_selectors addElement: self];
}

-(void) gcReference
{
  MARK (in);
  MARK (out);

  [super gcReference];
}

-(LTTSelArgTypes *) inArgumentTypes
{
  return in;
}

-(id) initWithName: (id <TLString>) n
	    inArgs: (id <TLString>) i
	   outArgs: (id <TLString>) o
{
  if (![super initWithName: [CO_LTTName nameWithInternal: n]])
    return nil;

  semantics = [isa semanticsForSelector: self];
  if (i)
    {
      in = [CO_LTTSelArgTypes argumentTypesWithString: i];
      out = [CO_LTTSelArgTypes argumentTypesWithString: o];
    }

  return self;
}

/* XXX This is unused.  */
-(id) initWithMangledName: (id <TLString>) n
{
  const char *c_name = [n cString];
  int len = [n length];
  char *buf_in = alloca (len), *buf_out = alloca (len);
  char *bin = buf_in, *bout = buf_out;
  const char *s, *c_end = c_name + len;

  /* XXX This method loses for selectors with an underscore in one of the
     name parts...  */

  /* Copy the flattened output types.  */
  for (s = c_name; *s != '_'; s++)
    if (*s != '(' && *s != ')')
      *bout++ = *s;
  s++;

  while (s != c_end)
    {
      /* Skip the name.  */
      while (s != c_end && *s != '_')
	s++;

      if (s != c_end)
	{
	  /* Augment the flattened in-argument types.  */
	  for (s++; s != c_end && *s != '_'; s++)
	    if (*s != '(' && *s != ')')
	      *bin++ = *s;

	  if (s != c_end)
	    /* Skip the `_'.  */
	    s++;
	}
    }

  return [self initWithName: n
	  inArgs: [TLString stringWithCString: buf_in length: bin - buf_in]
	  outArgs: [TLString stringWithCString: buf_out
		    length: bout - buf_out]];
}

-(LTTSelArgTypes *) outArgumentTypes
{
  return out;
}

-(id <TLString>) outputDefinitionName
{
  if (ltt_current_unit)
    return (id) formac (nil, @"%@%@_%@", TO_SELECTOR_PREFIX,
			[ltt_current_unit outputName], [name external]);
  else
    return (id) formac (nil, @"%@%@", TO_SELECTOR_PREFIX, [name external]);
}

@end
