/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: report.h,v 1.13 1998/01/05 00:58:28 tiggr Exp $  */

#import <stdarg.h>
#import <time.h>

/* The name of current file being parsed, by any parser, and the current
   line.  */
extern id <TLString> current_filename;
extern int current_line;

/* The total number of lines processed.  */
extern int total_num_lines;

/* The number of reported errors and warnings for `this' file.  */
extern int this_num_errors, this_num_warnings;

/* The number of reported errors and warnings for all previous files.  */
extern int total_num_errors, total_num_warnings;

/* Verbosity, as indicated on the commandline.  */
extern int flag_verbose;

/* The total number of errors and warnings, including those of this file
   and all previous files.  */
#define NUM_ERRORS	(this_num_errors + total_num_errors)
#define NUM_WARNINGS	(this_num_warnings + total_num_warnings)

/* Basic error reporting.  RC is the return code passed to exit(2).  The
   OBJECT must respond to `<int> line' and `<TLString> filename'.  */
void fatal (int rc, id <TLString> s, ...);
void internal (id <TLString> s, ...);
void error (id <TLString> s, ...);
void error_for (id object, id <TLString> s, ...);
void warning (id <TLString> s, ...);
void warning_for (id object, id <TLString> s, ...);

/* Same as the above, but continued versions, i.e. the do not bump the
   number of errors or warnings.  */
void cerror (id <TLString> s, ...);
void cerror_for (id object, id <TLString> s, ...);
void cwarning (id <TLString> s, ...);
void cwarning_for (id object, id <TLString> s, ...);

/* va_arg versions of the above.  */
void vcerror (id <TLString> s, va_list ap);
void vcerror_for (id object, id <TLString> s, va_list ap);
void vcwarning (id <TLString> s, va_list ap);
void vcwarning_for (id object, id <TLString> s, va_list ap);

/* Push or pop a report context.  */
void push_report_context (id string);
void pop_report_context (void);

#define ABORT()  \
  do									\
    {									\
      fprintf (stderr, __FILE__ ":%d: abort (%s:%d)\n",			\
	       __LINE__, [current_filename cString], current_line);	\
      abort ();								\
    } while (0)

#define PARSE_START_CONTEXT(FILENAME)  \
  do {							\
    int previous_num_errors = this_num_errors;		\
    int previous_num_warnings = this_num_warnings;	\
    int previous_line = current_line;			\
    id previous_filename = current_filename;		\
							\
    current_filename = FILENAME;			\
    ASGN_SPROT (current_filename);			\
    current_line = 1;					\
    this_num_errors = 0;				\
    this_num_warnings = 0;

#define PARSE_STOP_CONTEXT  \
    if (flag_verbose > 1)						    \
      formac (V_stderr_,						    \
	      @"%@: %d line%s, %d error%s, %d warning%s\n",		    \
	      current_filename, current_line, current_line == 1 ? "" : "s", \
	      this_num_errors, this_num_errors == 1 ? "" : "s",		    \
	      this_num_warnings, this_num_warnings == 1 ? "" : "s")

#define PARSE_END_CONTEXT  \
    total_num_errors += this_num_errors;		\
    total_num_warnings += this_num_warnings;		\
    this_num_errors = previous_num_errors;		\
    this_num_warnings = previous_num_warnings;		\
    total_num_lines += current_line;			\
    current_line = previous_line;			\
    current_filename = previous_filename;		\
  } while (0)
