/* Implementation of TLStreamStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLStreamStream.m,v 1.2 1998/02/23 14:17:40 tiggr Exp $  */

#define TLSTREAMSTREAM_DECLARE_PRIVATE_METHODS
#import "tl/support.h"
#import "tl/TLStreamStream.h"
#import "tl/TLSymbol.h"

@implementation TLStreamStream

+(id) streamWithStream: (id <TLStream>) str
{
  return ([[self gcAlloc] initWithStream: str]);
} /* +streamWithStream: */

-(int) compare: (id) o
{
  return ([stream compare: o]);
} /* -compare: */

-initWithStream: (id) str
{
  ASGN_IVAR (stream, str);
  return (self);
} /* -initWithStream: */

/******************** TLStream ********************/

-close
{
  return ([stream close]);
} /* -close */

-(int) fileDescriptor
{
  return (stream ? [stream fileDescriptor] : -1);
} /* -fileDescriptor */

-streamp
{
  return (Qt);
} /* -streamp */

/******************** TLInputStream ********************/

-flushInput
{
  return ([stream flushInput]);
} /* -flushInput */

/******************** TLOutputStream ********************/

-flushOutput
{
  return ([stream flushOutput]);
} /* -flushOutput */

/******************** garbage collection ********************/

-(void) gcReference
{
  MARK (stream);
} /* -gcReference */

@end
