<copyright> C class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: C.t,v 1.7 1998/01/05 01:05:19 tiggr Exp $</id>
    </copyright>

// If we do not inherit from the instance All, operators do not work!
// Thus, the `num * bytes' in calloc will not be resolvable...
// Thu Aug 21 10:56:33 1997, tiggr@natlab.research.philips.com
<doc> The {C} class provides low-level memory manipulation functionality.
    With it, a lot of collection and string methods can be written in TOM
    instead of needing to be written in C.  </doc>
implementation class
C: instance (All)

<doc> Release the memory at {address}.  </doc>
extern void
  free pointer address;

<doc> Return a pointer to a newly allocated memory region of {length}
    bytes.  </doc>
extern pointer
  malloc int length;

<doc> Return a pointer to newly allocated and zeroed memory region of
    {num} elements of each {bytes} size.  </doc>
pointer
  calloc (int, int) (num, bytes)
{
  int num_bytes = num * bytes;
  pointer p = [self malloc num_bytes];
  [self bzero (p, num_bytes)];
  = p;
}

<doc> Return a pointer to the resized memory region at {address} which
    must hold {length} bytes.  The address returned can differ from the
    previous {address}.  </doc>
extern pointer
  realloc (pointer, int) (address, length);

<doc> Return 0 iff the {length} bytes at {one} equal the bytes at {other}.
    </doc>
extern int
  memcmp (pointer, pointer, int) (one, other, length);

<doc> Copy the {length} bytes from {from} to {to}.  Return {to}.  </doc>
extern pointer
  memcpy (pointer, pointer, int) (to, from, length);

<doc> Copy the {length} bytes from {from} to {to}, safely.  Return {to}.
    </doc>
extern pointer
  memmove (pointer, pointer, int) (to, from, length);

<doc> Set the {num} bytes at {p} to 0.  </doc>
extern void
  bzero (pointer, int) (p, num);

end;

<doc> The {C} instance can be and is totally empty.  </doc>
implementation instance C end;
