<copyright> Conditions.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996-1998 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Condition.t,v 1.20 1998/01/19 13:28:03 tiggr Exp $</id>
    </copyright>

/******************** Condition ********************/

implementation class
Condition: State

<doc> Return a new {Condition} for the indicated circumstances.  </doc>
instance (id)
      for All object
    class ConditionClass condition_class
  message String msg
{
  = [[self alloc] initFor object class condition_class message msg];
}

end;

implementation instance
Condition
{
  <doc> The condition class of the condition indicated by this
      {Condition}.  </doc>
  public ConditionClass condition_class;

  <doc> The object by/for which this condition was raised.  </doc>
  public Any object;

  <doc> The message explaing what actually happened.  </doc>
  public String message;

  <doc> Iff {TRUE}, this condition was raised, otherwise it was signaled.
      </doc>
  public boolean raised;
}

protected id
  initFor All o
    class ConditionClass cc
  message String msg
{
  (condition_class, object, message) = (cc, Any (o), msg);

  = self;
}

<doc> Raise this condition; guaranteed never to return.  </doc>
extern void
  raise;

<doc> Signal this condition.  If a handler performs a non-local break,
    this method does not return.  If no handler is installed, {nil} is
    returned.  If a handler returns something different from this condition,
    signaling is terminated and that value is returned.  </doc>
extern Any
  signal;

OutputStream (s)
  writeFields OutputStream s
{
  String n;

  s = [super writeFields s];
  if (condition_class != nil)
    n = [condition_class name];
  = [s print (" class=", n, " object=", object, " msg=", message)];
}

end;

/******************** SelectorCondition ********************/

implementation class
SelectorCondition: Condition

<doc> Return a new {SelectorCondition} for the indicated circumstances.
    </doc>
instance (id)
       for All object
     class ConditionClass condition_class
   message String msg
  selector selector sel
{
  = [[self alloc] initFor object class condition_class
		  message msg selector sel];
}

end;

implementation instance
SelectorCondition
{
  <doc> The selector which was sent to the {object}.  </doc>
  selector sel;
}

protected id
   initFor All o
     class ConditionClass cc
   message String msg
  selector selector s
{
  [super initFor o class cc message msg];

  sel = s;

  = self;
}

<doc> Return the selector, {sel}.  </doc>
selector
  selector
{
  = sel;
}

OutputStream (s)
  writeFields OutputStream s
{
  s = [super writeFields s];

  [[s print " selector="] print [Runtime nameOfSelector sel]];
}

end;
