<copyright> MutableByteString class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: MutableByteString.t,v 1.21 1998/01/05 01:06:37 tiggr Exp $</id>
    </copyright>

implementation class
MutableByteString: ByteString, MutableString, MutableByteArray

end;

implementation instance
MutableByteString

void
  freeze
{
  // isa = [ByteString self];
}

ByteString
  frozen
{
  = [[ByteString alloc] initCopy (contents, length)];
}

protected id
  init (pointer, int) (p, num)
{
  [super init (p, num)];
  capacity = num;

  = self;
}

<doc> In addition to what our {super} does, adjust our (new) {capacity} to
    fit our {length}.  </doc>
id
  initCopy (pointer, int) (p, num)
{
  [super initCopy (p, num)];

  capacity = length;

  = self;
}

<doc> Set the byte at {index} to the character {c}, converted to a {byte}
    according to the {default_encoding}.  </doc>
void
  set char c
   at int index
{
  self[index] = [default_encoding encode c];
}

<doc> Add the byte encoding of the {char} {c} to this string.  </doc>
void
  add char c
{
  self[length++] = [default_encoding encode c];
}

<doc> Override the {ByteString} implementation of this {substring} method,
    since that actually employs {ByteSubstring} objects which we can't
    use.  </doc>
extern ByteString
  substring (int, int) (start, len);

end;
