<copyright> Random classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    Some of the algorithms used in these classes are described in
    ``Numerical Recipies'' by Press et al.

    <id>$Id: Random.t,v 1.2 1998/01/05 01:07:03 tiggr Exp $</id>
    </copyright>

implementation class
Random: instance (All)

end;

implementation instance
Random: instance (All)

deferred int
  next;

// This postcondition is a clear example of being elegant because of its
// documentational clarity, but which also never needs to be checked since
// it it so obviously always true.
// Wed Apr  9 01:35:52 1997, tiggr@tricky.es.ele.tue.nl
<doc> Return a number in the range [0, limit).  </doc>
int (result)
  next int limit
pre
  limit > 1
post
  result >= 0 && result < limit
{
  = [self next] % limit;
}

end;

/******************** MinimalRandom ********************/

implementation class
MinimalRandom: State, Random
{
  <doc> Constants needed by the algorithm.  </doc>
  const ia = 16807;
  const im = 2147483647;
  const iq = 12773;
  const ir = 2836;
}

end;

implementation instance
MinimalRandom
{
  // Does a 32-bit seed suffice in any way?
  // Wed Apr  9 01:12:20 1997, tiggr@tricky.es.ele.tue.nl
  <doc> The seed from which we feed.  </doc>
  int seed;
}

<doc> Designated initializer.  </doc>
id (self)
  init int s
pre
  s > 0
{
  seed = s;
}

<doc> Initialize this instance with a seed derived from the current moment
    in time and the {hashq} value of {self}.  </doc>
id
  init
{
  int seed;

  do
    {
      // CCC `2e8' is lexed as an int...
      // Wed Apr  9 02:00:00 1997, tiggr@tricky.es.ele.tue.nl
      seed = int (2.0e8 * [Date relativeTimeIntervalSinceNow]) ^ [self hashq];

      if (seed < 0)
	seed = -seed - 1;
    } while (!seed);

  = [self init seed];
}

<doc> Return the next random positive {int} value.  </doc>
int
  next
{
  int i = seed / iq;

  seed = ia * (seed - i * iq) - i * ir;
  if (seed < 0)
    seed += im;

  = seed;
}

end;

/******************** StandardRandom ********************/

implementation class
StandardRandom: MinimalRandom

end;

implementation instance
StandardRandom

end;
