/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMArgument.h,v 1.5 1998/01/05 01:12:03 tiggr Exp $  */

#ifdef OTMARGUMENT_DECLARE_PRIVATE_METHODS
#define OTMVARIABLE_DECLARE_PRIVATE_METHODS
#endif

#import "OTMVariable.h"

@interface OTMArgument: OTMVariable
{
  /* The index number of this (flat) argument in the argument list of the
     method.  */
  int number;
}

+(OTMArgument *) variableWithName: (id) n
			     type: (OTMType *) t
			   number: (int) x;

+(OTMArgument *) temporaryVariableWithType: (OTMType *) t
				    number: (int) x;

/* Return this argument if the NUMBER matches N, otherwise return NIL.  */
-(OTMArgument *) argumentNumbered: (int) n;

-(int) argumentNumber;
-(void) setArgumentNumber: (int) n;

#ifdef OTMARGUMENT_DECLARE_PRIVATE_METHODS

#endif

@end
