/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMAssignment.m,v 1.19 1998/01/05 01:12:09 tiggr Exp $  */

#define OTMASSIGNMENT_DECLARE_PRIVATE_METHODS
#import "OTMAssignment.h"
#import "OTMMethod.h"
#import "OTMTuple.h"
#import "OTMType.h"
#import "global.h"

@implementation OTMAssignment

+(OTMAssignment *) assignmentWithLhs: (OTMExpr *) l
				 rhs: (OTMExpr *) r
{
  return [[self gcAlloc] initWithLhs: l rhs: r];
}

-(void) compile
{
  [rhs compile];
  [lhs compileAssignment: rhs];
}

-(void) compileAssignmentToTuple: (OTMTuple *) l
{
  [lhs compileAssignmentToTuple: l];
}

-(void) description: (id <TLMutableStream>) stream
{
  [super description: stream];

  formac (stream, @" lhs=%@ rhs=%@", lhs, rhs);
}

-(id) elaborate
{
  rhs = [implicit_cast (rhs, [lhs type]) elaborate];

  /* If the left hand side is not a temporary, emit an assignment
     to a newly created temporary as well, to be able to handle
     (a, b) = (b, a) = (1, 2).  */
  if ([lhs isTuple] && ![(OTMTuple *) lhs isTemporary]
      && [[rhs value] isTuple] && ![(OTMTuple *) [rhs value] isTemporary])
    {
      OTMType *rt = [rhs type];

      if (rt)
	{
	  OTMExpr *e = temp_something_with_type (rt, YES);

	  rhs = [CO_OTMAssignment assignmentWithLhs: e rhs: rhs];
	  [rhs setType: rt];

	  emit_statement (rhs);
	  rhs = [rhs value];
	}
    }

  return self;
}

-(void) gcReference
{
  MARK (lhs);
  MARK (rhs);

  [super gcReference];
}

-(id) initWithLhs: (OTMExpr *) l
	      rhs: (OTMExpr *) r
{
  if (![super initWithType: nil])
    return nil;

  lhs = l;
  rhs = r;

  return self;
}

-(id) precompile
{
  lhs = [lhs precompile];
  rhs = [rhs precompile];

  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  if (!type)
    {
      OTMType *m = (id) [current_either semantics];

      lhs = resolve_expr (lhs, nil, nil, m);
      type = [lhs type];
      rhs = resolve_expr (rhs, type ? CONS (type, nil) : nil, nil, m);
    }

  return [super resolveWithExpected: expected convertible: to
		context: cxt indices: indices index: index];
}

-(OTMExpr *) result
{
  return [lhs result];
}

-(OTMExpr *) value
{
  return lhs;
}

@end
