/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMContinue.m,v 1.8 1998/01/05 01:12:38 tiggr Exp $  */

#define OTMCONTINUE_DECLARE_PRIVATE_METHODS
#import "OTMContinue.h"
#import "OTMLoop.h"
#import "OTMLabel.h"
#import "global.h"

@implementation OTMContinue

-(void) compileJump
{
  formac (of, @"%@goto %@;", [self nl],
	  [[enclosing_loop continueLabel] labelName]);
}

-(id) initWithValue: (OTMExpr *) e
{
  enclosing_loop = [current_compound loopForContinue: 0];

  return [super initWithValue: e];
}

@end
