/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMError.m,v 1.6 1998/01/05 01:12:49 tiggr Exp $  */

#define OTMERROR_DECLARE_PRIVATE_METHODS
#import "OTMError.h"
#import "OTMType.h"

OTMError *an_error;

@implementation OTMError

+(void) init
{
  an_error = [[self alloc] init];
  [an_error gcLock];
}

+(OTMError *) sharedError
{
  return an_error;
}

-(void) compile
{
  internal (@"-compile invoked of error object");
}

-elaborate
{
  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  return expected;
}

-result
{
  return self;
}

@end
