/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMExtension.h,v 1.33 1998/01/05 01:12:53 tiggr Exp $  */

#import "OTMTop.h"

@class LTTMeta;
@class OTMAliasAlias, OTMConstant, OTMMeta, OTMMethod, OTMObjectVar;

@interface OTMExtension: OTMTop
{
  /* The structural counterpart of this extension.  */
  LTTExtension *structure;

  /* Mapping from method names to vectors of methods with the same name
     (and different types).  Only the first name part is used as a key
     into the dictionary.  */
  TLDictionary *methods;

  /* Non-static variables introduced by this extension.  Both keyed on the
     name and in order.  */
  TLDictionary *vars_keyed;
  TLVector *vars_order;

  /* The alignment desired by this extension.  */
  int vars_align;

  /* Static variables introduced by this extension.  */
  TLDictionary *vars_static;

  /* Aliases introduced by this extension.  */
  TLDictionary *aliases;

  /* Constants.  */
  TLDictionary *constants;

  /* Supers inherited by us.  Used only for compiling the extension
     description.  */
  TLSet *supers;

  /* Iff !0, we've compiled the declaration of our extension identity.  */
  unsigned int declared_eid;

  /* Iff !0, we've compiled the declaration of our extension variables
     struct.  */
  unsigned int declared_ivar_struct;
}

-(void) checkImplementation;

-(void) compileDeclareExtensionIdentityName;

-(void) compileObjVarTypeDeclarations;

-(void) handlePostponedAlias: (OTMAliasAlias *) alias;

-(void) startCompile;
-(void) endCompile;

-initWithStructure: (LTTExtension *) str;

-(TLCons *) methodsNamed: (TLVector *) name_parts
		  sender: (OTMMeta *) sender
		    list: (TLCons *) l;

-(void) resolveIdentifiers: (OTMMeta *) meta;

-(OTMMethod *) searchSimilarMethod: (OTMMethod *) method;

-(OTMExpr *) collectConditions: (BOOL) pre_not_post
			   for: (OTMCustomMethod *) method;

-(TLDictionary *) methods;

/* Return the output structure definition for the variables defined in
   this extension.  This returns NIL if this extension does not any
   variables.  */
-(id <TLString>) outputDeclaration;

/* Return an expression in the output language for the pointer to the
   extension struct holding this extension's variables.  */
-(id <TLString>) outputOffsetFrom: (LTTMeta *) m;

/* Return the object holding this extension's structural information.  */
-(LTTExtension *) structure;

/* Output the info on the supers and methods defined in this extension to
   the stream s.  */
-(void) dumpInfo: (id <TLOutputStream>) s;

-(void) addSuper: (OTMMeta *) m;

/********** methods **********/

-(void) addMethod: (OTMMethod *) m;

/* Return all methods with the FIRST_NAME_PART, creating their container
   iff CREATE.  */
-(TLVector *) methodsNamed: (id <TLString>) first_name_part
		    create: (BOOL) create;

/********** variables **********/

-(BOOL) hasVariables;

-(OTMObjectVar *) aliasWithName: (id <TLString>) n
			   type: (id) t
		     qualifiers: (otm_qualifiers) q;

-(OTMObjectVar *) variableWithName: (id <TLString>) n
			      type: (id) t
			qualifiers: (otm_qualifiers) q;

/* Return the variable with the name N, if declared in this extension.
   Otherwise, return nil.  */
-(OTMObjectVar *) variableNamed: (id <TLString>) n;

/********** constants **********/

-(OTMConstant *) constantWithName: (id <TLString>) n
		       qualifiers: (otm_qualifiers) q
			    value: (OTMExpr *) val;

/* Return the costant with the name N, if declared in this extension.
   Otherwise, return nil.  */
-(OTMConstant *) constantNamed: (id <TLString>) n;

#ifdef OTMEXTENSION_DECLARE_PRIVATE_METHODS

-(BOOL) cvDeclarationOK: (id <TLString>) n;

#endif

@end
