/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMLoop.h,v 1.6 1998/01/05 01:13:15 tiggr Exp $  */

#import "OTMCompound.h"

@class OTMLabel;

@interface OTMLoop: OTMCompound
{
  /* Condition to be tested.  */
  OTMExpr *condition;

  /* When used, the continue label.  */
  OTMLabel *continue_label;

  /* Whether the test must be executed before or after the body.  */
  unsigned int post_not_pre: 1;
}

+(OTMLoop *) loopWithContainer: (OTMCompound *) c;

-(void) setCondition: (OTMExpr *) e atEnd: (BOOL) end_not_start;

-(OTMLabel *) continueLabel;

@end
