/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMTuple.h,v 1.20 1998/01/05 01:13:54 tiggr Exp $  */

#import "OTMExpr.h"

@class OTMArgument;

@interface OTMTuple: OTMExpr
{
  TLVector *elements;

  /* Vector of variables holding the results.  */
  TLVector *results;

  /* Iff !0, we're a temporary.  */
  unsigned int temporary: 1;
}

+(OTMTuple *) tuple;

+(OTMTuple *) tupleWithSequence: (id) s;

-initWithSequence: (id) s;

-addElement: (id) o;

-(TLVector *) elements;

-(id) outputDeclaration: (id) stream;

-(id) outputDeclaration: (id) stream separator: (id <TLString>) sep;

-(id <TLString>) result: (int) index;

-(BOOL) isTemporary;
-(void) setIsTemporary;

-(OTMArgument *) argumentNumbered: (int) n;

#ifdef OTMTUPLE_DECLARE_PRIVATE_METHODS

#endif

@end
