<copyright> TOO DescriptorSet.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright (C) 1996 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: DescriptorSet.t,v 1.6 1998/01/05 01:16:40 tiggr Exp $</id>
    </copyright>

implementation class
DescriptorSet: State, C

end;

implementation instance
DescriptorSet
{
  <doc> The bitset of descriptors usable to select(2).  </doc>
  pointer set;

  <doc> One beyond the highest descriptor that can be put in the set.  </doc>
  int cap;

  <doc> One beyond the highest descriptor present in the set.  </doc>
  int beyond_last;

  <doc> The number of descriptors present in the set.  </doc>
  int num;

  <doc> The array of {Descriptor} objects.  </doc>
  MutableObjectArray descriptors;

  <doc> The array of {DescriptorDelegate} objects.  </doc>
  MutableObjectArray delegates;
}

<doc> Deallocate the memory occupied by the {set}.  </doc>
void
  dealloc
{
  free (set);
}

<doc> Designated initializer.  </doc>
id (self)
  init
{
  descriptors = [MutableObjectArray new];
  delegates = [MutableObjectArray new];
}

extern void
  remove Descriptor descriptor;

extern void
  set DescriptorDelegate delegate
   at Descriptor descriptor;

<doc> Return a pointer to the low-level descriptor {set}, and the one
    beyond the highest value in that set.  </doc>
(pointer, int)
  vitals
{
  = (set, beyond_last);
}

/********** event dispatching **********/
<doc><h4>Event dispatching</h4></doc>

<doc> Dispatch a read event on the file descriptor {d}, to the delegate at
    index {d} in the delegates.  </doc>
void
  readEvent int d
{
  DescriptorReadDelegate delegate = delegates[d];

  [delegate readEventOnDescriptor descriptors[d]];
}

<doc> Dispatch a write event on the file descriptor {d}, to the delegate at
    index {d} in the delegates.  </doc>
void
  writeEvent int d
{
  DescriptorWriteDelegate delegate = delegates[d];

  [delegate writeEventOnDescriptor descriptors[d]];
}

end;
