<copyright> Sending objects over the wire.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: PortEncoder.t,v 1.6 1998/01/05 01:16:47 tiggr Exp $</id>
    </copyright>

implementation class
PortEncoder: BinaryEncoder, PortCoder

end;

implementation instance
PortEncoder

<doc> Designated initializer.  </doc>
id
  initWithConnection ConnectedConnection c
{
  [super (BinaryEncoder) init];
  = [super (PortCoder) initWithConnection c];
}

<doc> Return the object returned by asking {replacementForPortCoder} to
    the argument {object}.  </doc>
protected State
  replacementObjectFor State object
{
  = [object replacementForPortCoder self];
}

<doc> Encode the proxy {p} and return {TRUE}.  </doc>
boolean
  encodeProxy Proxy p
{
  // Note that the local and remote proxies should have different
  // implementations for {encodeUsingCoder}, so that the distinction, by
  // invoking different {encodeProxy} methods, does not cost another
  // method call ({isProxy}).
  // Mon Jan  6 00:55:41 1997, tiggr@tricky.es.ele.tue.nl
  /* A local proxy returns {NO} when asked {isProxy}.  */
  if ([p isProxy])
    {
      Connection con = [p proxy_connection];

      if (con != connection)
	[self unimplemented cmd message: "different-connection proxy encoding"];

      [self writeByte '!'];
    }
  else
    [self writeByte '$'];

  [self writeInt [p proxy_identity]];

  = TRUE;
}

<doc> Forward to the {port}.  </doc>
void
  flushOutput
{
  [port flushOutput];
}

void
  reportDeaths IntArray deaths
{
  int i, n = [deaths length];

  for (i = 0; i < n; i++)
    {
      [self writeByte '~'];
      [self writeInt deaths[i]];
    }
}

protected void
  writeByte byte b
{
  [port write b];
}

protected void
  writeBytes (int, int) (start, length)
	from ByteArray r
{
  int written = [port writeRange (start, length) from r];

  if (written != length)
    [[SelectorCondition for self class program-condition
      message [[MutableByteString new]
	       print ("wrote ", written, " instead of ", length)]
      selector cmd] raise];
}

protected void
  writeBytes (pointer, int) (address, length)
{
  [port writeBytes length from address];
}

end;
