/*
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1999 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: auto.c,v 1.2 1999/03/03 16:23:28 tiggr Exp $  */

#include "trt.h"
#include <tom/tom-r.h>

int
main (int argc, char **argv, char **envp)
{
  int r;

  trt_environ = envp;

#ifdef PATCH_387_CW
  {
    volatile short cw;

    __asm__ volatile ("fstcw (%0)" : : "g" (&cw));
    cw |= 1;			/* Mask the `invalid' exception.  */
    __asm__ volatile ("fldcw (%0)" : : "g" (&cw));
  }
#endif

  trt_init_main (argc, argv);

  if (!trt_main_class || !trt_main_selector)
    fatal ("no main class or selector");

  r = TRT_SEND (_II_, _mr_c_tom_Runtime, SEL (i_start__rs__arguments_r),
		*trt_main_class, trt_main_selector,
		c_tom_Runtime_arguments);

  tini_streams ();

  return r;
}
