/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#define VERBOSE 0
#include <locale.h>
#include <vdkb/vdkb_locale.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_about.h>
#include <vdkb/waitcursor.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/param.h>
#if HAVE_GNOME
#include <gnome.h>
#endif
//////////////////////////////
#include "./pixmaps/cube.xpm"
//////// ide defaults ///////////////
VDKBDefaults VDKBuilder::ideDefaults;
VDKBuilder* TheApp = NULL;
extern char *gear_xpm[];
char buff[512];
// non vdk modal window stuff
static gboolean cmw_destroy_cb(GtkWidget *widget);
static bool install_resources(char* home);
void create_nonvdk_modal_window (char* prompt);
///////global operational state //////
OpState  OperationalState = { op_ready, act_nope, tgt_no_target , NULL, NULL};
// global widget clipboard
VDKBWidgetClipboard* WidgetClipboard = NULL;
/*
  global DnD support
*/
enum {
  TARGET_STRING,
  TARGET_ROOTWIN,
  TARGET_URL
};

static GtkTargetEntry target_table[] = {
  { "STRING",0, TARGET_STRING },
  { "TEXT", 0, TARGET_STRING },
  { "URL", 0, TARGET_URL },
  { "application/x-rootwin-drop", 0, TARGET_ROOTWIN }
};
static guint n_targets = sizeof(target_table) / sizeof(target_table[0]);
VDKDnD *DragAndDrop = NULL;
DnDBuilderList* DragAndDropTable = NULL;
/*
 a C interface with gtkeditor and al.
*/
extern "C"
{
  int GetEditorTab();
};

int GetEditorTab()
{
  return atoi((char*) VDKBuilder::ideDefaults.editor.tab);
}

/*
this code denies to run
a second builder instance on the
same user
 */
/*
 */
static
bool create_lock_file(char* flock)
{
  int lockFile;
  if((lockFile=open(flock,O_CREAT|O_EXCL|O_WRONLY,0600)) != -1)
    {
      pid_t mypid=getpid();
      write(lockFile, (void*) &mypid, sizeof(pid_t));
      close(lockFile);
      return true;
    }
  else
    return false;
}
/*
 */
static
bool is_first_instance(char* flock)
{
  if(!create_lock_file(flock))
    {
    int lockFile;
    pid_t pid;
    lockFile = open(flock,O_RDONLY);
    read(lockFile, (void*) &pid, sizeof(pid_t));
    close(lockFile);
    if( (kill(pid,0)!= 0) && (errno == ESRCH) )
      { /*no process is holding the lock*/
	remove(flock);
	return create_lock_file(flock);
      }
    else /*another process is holding the lock*/
      return false;
    }
  else
    return true;
}
//////////////////////////////////////////////////////
/*
 */
int  AskUserToSaveFile(char* name)
{
  if( !TheApp)
    return IDNO;
  char local[256];
  VDKString Yes = CHECK_YES;
  if(VDKBuilder::ideDefaults.project.autosave == Yes)
    return IDYES;
  sprintf(local,"%s\n%s",name,
	  user_messages[user_request_save]);
  return TheApp->MessageBox(APPNAME,
			    local,
			    MB_ICONQUESTION|MB_YESNO,
			    user_messages[user_ok],
			    user_messages[user_no]);
}
/////////////////////////////////////
//      VDK BUILDER ENTRY
/////////////////////////////////
int LANG = 1;
int main (int argc, char *argv[])
{
  char user_home[256];
  struct stat info;
  // look for lang support
  if (argc==2)
    {
      if(! strcmp(argv[1],"-h"))
	{
	  printf(VDKB_USAGE);
	  fflush(stdout);
	  exit(0);
	}
      else if(! strcmp(argv[1],"-it"))
	LANG = ITALIAN;
      else if(! strcmp(argv[1],"-fr"))
	LANG = FRENCH;
      else if(! strcmp(argv[1],"-sp"))
	LANG = SPANISH;
      else if(! strcmp(argv[1],"-de"))
	LANG = GERMAN;
      else
	LANG = ENGLISH;
    }
  else
    LANG = ENGLISH;
  //----------------------------------------------------
  // initialize gtk, safe since further inits do nothing
  //----------------------------------------------------

  gtk_init(&argc,&argv);
  // store home and pwd
  // get HOME
  char* homedir = getenv("HOME");
  if(!homedir)
    {
      create_nonvdk_modal_window ("No user home found,\n\
sorry i can't run VDKBuilder");
      exit(1);
    }
  else
    strcpy(user_home,homedir);
  //------------------------------------------------
  // set resource file, so will be loaded and parsed
  //------------------------------------------------
  sprintf(buff,"%s/.vdkb/%s",user_home,VDKB_RESOURCE_FILE);
  if (stat(buff,&info) == -1)
    {
      //-------------------------------------
      // install local copy of resources file
      // into: <homedir>/.vdkb/res
      //------------------------------------
      if(install_resources(homedir))
	sprintf(buff,
"VDKBuilder has installed:\
\nvdkide.defaults\
\nvdkbrc\
\nplugins.db\
\ninto your home: %s/.vdkb/res",homedir);
      else
	sprintf(buff,"* WARNING * VDKBuilder couldn't install \
vdkbuilder resources into your home: %s",homedir);
      create_nonvdk_modal_window (buff);
      sprintf(buff,"%s/.vdkb/%s",user_home,VDKB_RESOURCE_FILE);
    }
  // something went wrong on installing resource files
  if (stat(buff,&info) == -1)
    {
      sprintf(buff,
      "Local resource file:%s/.vdkb/%s not found\nrevert to default one",
	      user_home,VDKB_RESOURCE_FILE);
      create_nonvdk_modal_window (buff);
      sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_RESOURCE_FILE);
    }
  //---------------------------------------------------------------
  // check for a lock file (denies more than one instance per user)
  //---------------------------------------------------------------
  char *local = new char[512];
  sprintf(local,"%s/.vdkb/%s",user_home,VDKB_LOCKFILE);
  if(!is_first_instance(local))
    {

      sprintf(buff,"Lock file:%s\ndetected another instance\n\
sorry i can't run VDKBuilder twice,\n\
either kill running instance or remove lock file",local);
      create_nonvdk_modal_window (buff);
      delete[] local;
      exit(1);
    }
  else
    delete[] local;
  //-------------------
  // builds application
  // with VDKB_RESOURCE_FILE
  // and setting localization
  //-------------------
#if VDKBDEBUG
  printf("\ngtk_set_locale():%s",gtk_set_locale()); 
  fflush(stdout);
#endif
  VDKBuilder app(&argc, argv);
  app.SetResourceFile(buff);
  // set global <TheApp>
  TheApp = &app;
  // sets home dir
  if(homedir)
    app.user_home = homedir;
   // gets and sets prg work dir
  char* cwd = getcwd(NULL,MAXPATHLEN);
  if(cwd)
    {
      app.user_cwd = cwd;
      free(cwd);
    }
  else
    app.user_cwd = app.user_home;
  //------------------
  // load ide defaults
  //------------------
  VDKBuilder::ideDefaults.LoadDefaults(app.user_home);
  // change to HOME or to startup dir
  VDKString startupdir = VDKBuilder::ideDefaults.project.startupdir;
  VDKString Home = "home";
  if(startupdir == Home)
    chdir((char*) app.user_home);
  else
    {
      if(chdir((char*) startupdir) < 0)
	{
	  sprintf(buff,"\nCould not change to dir:%s\nreverting to home",
		 (char*) startupdir);
	  create_nonvdk_modal_window (buff);	
	  chdir((char*) app.user_home);
	}
    }
  //-------------
  // load plugins
  //-------------
  sprintf(buff,"%s/.vdkb/%s",(char*) app.user_home,VDKB_PLUGIN_FILE);
  if (stat(buff,&info) == -1)
      {
	char local[256];
	sprintf(local,"\nUser file:%s\nnot found, using default",buff);
	create_nonvdk_modal_window (local);
	sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_PLUGIN_FILE);
      }
  if(!app.PluginList().Load(buff))
    {
      sprintf(buff,"\nError during loading plugins.db");
      create_nonvdk_modal_window (buff);	
    }
  else if(! app.PluginList().DlOpen())
    {
      sprintf(buff,"\nError during opening plugins");
      create_nonvdk_modal_window (buff);	
    }

  //-------------
  // builder runs
  //-------------
  app.Run();
  //---------------
  // builder quiets
  //---------------
  /*
    this tricks avoid to segfault if plugins are disconnected before
    main form deleting.  Otherwise garbage collection finds corrupted
    object pointers. So before delete MainForm and after disconnect plugins.
  */
  delete app.MainForm;
  // this must be done otherwise mainForm will be deleted twice.
  // by app destructor
  app.MainForm = NULL;
  // closes plugins
  if(!app.PluginList().DlClose())
    {
      sprintf(buff,"\nError during closing plugins");
      create_nonvdk_modal_window (buff);	
    }
  // delete locale
  FreeInternational();
  // destroy lock file
  sprintf(buff,"%s/.vdkb/%s",
	  (char*) app.user_home,
	  VDKB_LOCKFILE);
  remove(buff);
  // change to current cwd
  chdir((char*) app.user_cwd);
  return 0;
}
////////////////////////////////
// VDKBUILDER MAIN FORM CLASS
////////////////////////////////
/*
 */
bool
VDKBMainForm::About(VDKObject*)
{
WaitCursor *c = new WaitCursor(this);
VDKBAboutForm *about = new VDKBAboutForm(this);
about->Setup();
delete c;
about->ShowModal();
return true;
}
/*
 */
bool
VDKBMainForm::Quit(VDKObject*)
{
Close();
return true;
}
/*
Constructor
*/
VDKBMainForm::VDKBMainForm( VDKApplication* app, gchar* title):
  VDKForm(app,title)
{
  // set subsystem pointers to NULL
  editor = NULL;
  prjman = NULL;
  maker = NULL;
  formlistform = NULL;
  // global widget clipboard
  WidgetClipboard = new VDKBWidgetClipboard;
  // global drag and drop
  DragAndDrop = new VDKDnD(this, target_table,n_targets);
  DragAndDropTable = new DnDBuilderList;
}
/*
Destructor
 */
VDKBMainForm::~VDKBMainForm()
{
if(WidgetClipboard)
  delete WidgetClipboard;
if(DragAndDropTable)
  delete DragAndDropTable;
}
/*
Setup
 */
void
VDKBMainForm::Setup()
{
  logo = new VDKBLogo(this);
  logo->Setup();
  logo->Show();
  // load locale stuff
  VDKBuilder* app = (VDKBuilder*) Application();
  LoadInternational(LANG,app->user_home);
  // setup for Mozilla
  mozpid = 0;
  SignalConnect("KillMozillaSignal",&VDKBMainForm::MozillaMourn, false);
  struct sigaction *sac = new struct sigaction;
  sigemptyset(&(sac->sa_mask));
  sac->sa_flags=0;
  sac->sa_handler = VDKBMainForm::MozillaReaper;
  sigaction(SIGCHLD, sac, NULL);
  //
  }
/*
Manages child closing
*/
void
VDKBMainForm::OnChildClosing(VDKForm* child)
{
if(child == logo)
  {
      logo = NULL;
      ContinueSetup(NULL);
      Visible = true;
  }
else if(child == editor)
  {
    Automa(automa_editor_off);
    editor = NULL;
  }
else if(child == prjman)
  {
    Automa(automa_prjman_off);
    prjman = NULL;
  }
else if(child == maker)
  {
    if(! maker->IsModal())
      {
	// load editor with errors
	VDKBStringList* list = maker->ErrorList();
	if(list)
	  {

	    sprintf(buff,"VDKBuilder maker terminated %s",
		    list->size() ? "with errors or messages" : "successfully");
	    Application()->MessageBox(APPNAME,buff,
				      MB_OK| MB_ICONINFORMATION,
				      user_messages[user_ok],
				      NULL, 3000);
	    // if list size == 0 then no erros, so
	    // we add an happy message
	    if(! list->size())
	      list->add((char*) "Compilation successfull");
	    // in vdkb_acsupport.cc
	    LoadEditorWithErrors(list);
	    delete list;
	  }
      }
    maker = NULL;
  }
else if(child == formlistform)
  {
    formlistform = NULL;
  }
}
/*
Finishes main form set up
 */
const int FOLDER_PAGES = 5;
bool
VDKBMainForm::ContinueSetup(VDKObject*)
{
  SetIcon(new VDKRawPixmap(this,cube_xpm));
  SetIconName(APPNAME);
  //timer = new VDKTimer(this,1000,false);
  MakeMainMenu();
  VDKBox* hbox = new VDKBox(this,h_box);
   hbox->Add(MakeToolBox(),FALSE,FALSE,0);
   hbox->Add(new VDKSeparator(this,v_separator),FALSE,FALSE,0);
     VDKBox* vbox = new VDKBox(this);
     widget_folder = new VDKNotebook(this);
     vbox->Add(widget_folder);
   hbox->Add(vbox);
  Add(hbox);
  widget_folder->AddPage(MakeContainerWidgetFolder(),folder_widget_titles[1]);
  widget_folder->AddPage(MakeButtonsWidgetFolder(),folder_widget_titles[0]);
  widget_folder->AddPage(MakeMiscWidgetFolder(),folder_widget_titles[3]);
  widget_folder->AddPage(MakeTextWidgetFolder(),folder_widget_titles[4]);
  widget_folder->AddPage(MakePluginWidgetFolder(),"Plugins");
#if HAVE_GNOME
  widget_folder->AddPage(MakeGnomeWidgetFolder(),"Gnome widgets");
#endif
  _defSize = VDKPoint((gdk_screen_width()*4)/5,110);
  SetSize(_defSize.x,_defSize.y);
  // does not allow to shrink or grow
  gtk_window_set_policy(GTK_WINDOW(Window()),false,false,true);
  return true;
}
/*
 */
void
VDKBMainForm::OnShow(VDKForm* )
{
  // set main form position to upper right
  // screen corner
  Position = VDKPoint(10,30);
  // set automa initial state
  Automa(automa_init);
  // make and open project manager
  if(!prjman)
  {
    prjman = new VDKBProjectManager(this);
    prjman->Setup();
    prjman->Visible = true;
  }
}
/*
Intercepts moving
 */
void
VDKBMainForm::OnMove(VDKForm* )
{
}

/*
Intercepts resizing, forcing
to default size
Changed: 30.12.98 mm
using gtk_window_set_policy()
that's better
 */
void
VDKBMainForm::OnResize(VDKForm* ,VDKPoint& )
{
  /*
  if(_defSize != p)
    SetFormSize(_defSize);
  */
}
//////////////////////////////////////////
// Makes main form interface
// all pixmaps, prompts, menus
// loaded from locale
//////////////////////////////////////////
/*
Makes VDKBuilder ManForm main menu
 */
void
VDKBMainForm::MakeMainMenu()
{
  menubar       =   new VDKMenubar(this);
  // file menu
  file_menu     =   new VDKMenuItem(menubar,
				    main_menu_prompts[0]);
  VDKMenu *menuf =   new VDKMenu(this);
  new_item      =   new VDKMenuItem(menuf,
				    main_menu_prompts[1]);
     VDKMenu      *newmenu = new VDKMenu(this);
     newprj_item  = new VDKMenuItem(newmenu,
				    main_menu_prompts[2],
				    main_menu_pixmaps[0]);
     newunit_item = new VDKMenuItem(newmenu,
				    main_menu_prompts[3],
				    main_menu_pixmaps[1]);
     newform_item = new VDKMenuItem(newmenu,
				    main_menu_prompts[4],
				    main_menu_pixmaps[2]);
       newformmenu = new VDKMenu(this);
       newformdefault_item = new VDKMenuItem(newformmenu,
					     main_menu_prompts[5],
					     main_menu_pixmaps[2]);
       newform_item->Add(newformmenu);
       new_item->Add(newmenu);
       open_item     =   new VDKMenuItem(menuf,
				    main_menu_prompts[8]);
  VDKMenu      *openmenu = new VDKMenu(this);
     openprj_item  = new VDKMenuItem(openmenu,
				     main_menu_prompts[9],
				     main_menu_pixmaps[3]);
     openfile_item = new VDKMenuItem(openmenu,
				     main_menu_prompts[10],
				     main_menu_pixmaps[4]);
  open_item->Add(openmenu);
  save_item     =   new VDKMenuItem(menuf,
				    main_menu_prompts[11],
				    main_menu_pixmaps[5]);
  saveall_item   =   new VDKMenuItem(menuf,
				     main_menu_prompts[12],
				     main_menu_pixmaps[6]);
  menuf->Separator();
  quit_item     =   new VDKMenuItem(menuf,main_menu_prompts[13]);
  file_menu->Add(menuf);
  // Edit menu
  //edit_menu = new VDKMenuItem(menubar,main_menu_prompts[14]);
  // Search menu
  search_menu = new VDKMenuItem(menubar,main_menu_prompts[15]);
  VDKMenu *searchv = new VDKMenu(this);
  search_item = new VDKMenuItem(searchv,main_menu_prompts[30],
				 main_menu_pixmaps[11]);
  repeat_search_item = new VDKMenuItem(searchv,main_menu_prompts[31]
				 /*, main_menu_pixmaps[xx]*/);
  replace_item = new VDKMenuItem(searchv,main_menu_prompts[32]
				  /*, main_menu_pixmaps[yy]*/);
  search_menu->Add(searchv);

  // View menu
  view_menu = new VDKMenuItem(menubar,main_menu_prompts[16]);
  VDKMenu *menuv = new VDKMenu(this);
  viewunits_item = new VDKMenuItem(menuv,main_menu_prompts[17],
				   main_menu_pixmaps[7]);
  viewforms_item = new VDKMenuItem(menuv,main_menu_prompts[18],
				   main_menu_pixmaps[8]);
  view_menu->Add(menuv);
  // Project menu
  prj_menu = new VDKMenuItem(menubar,main_menu_prompts[19]);
  VDKMenu *menup = new VDKMenu(this);
  prjmake_item = new VDKMenuItem(menup,main_menu_prompts[27],
				 // stolen to project manager
				 gear_xpm);
  prjmakeclean_item = new VDKMenuItem(menup,main_menu_prompts[29],
				 NULL);
  prjdebug_item = new VDKMenuItem(menup,main_menu_prompts[36],
				 NULL);
  menup->Separator();
  prjoptions_item = new VDKMenuItem(menup,main_menu_prompts[28]);
  prj_menu->Add(menup);
  // Component menu
  compo_menu = new VDKMenuItem(menubar,main_menu_prompts[22]);
  // Tools menu
  tools_menu = new VDKMenuItem(menubar,main_menu_prompts[23]);
  VDKMenu* menut = new VDKMenu(this);
  // environment setup
  envset_item = new VDKMenuItem(menut,main_menu_prompts[37],
				 NULL);
  // grep
  exec_item = new VDKMenuItem(menut,main_menu_prompts[38],
				 NULL);
  exec_item->Enabled = false;
  tools_menu->Add(menut);
  // automake/autoconf support
  ac_menu = new VDKMenuItem(menubar,main_menu_prompts[39],
				 main_menu_pixmaps[12]);
  VDKMenu *menuac = new VDKMenu(this);
  ac_autogen = new VDKMenuItem(menuac,main_menu_prompts[40],
				 NULL);
  ac_make = new VDKMenuItem(menuac,main_menu_prompts[41],
				 NULL);
  ac_makeclean = new VDKMenuItem(menuac,main_menu_prompts[42],
				 NULL);
  ac_makedist = new VDKMenuItem(menuac,main_menu_prompts[43],
				 NULL);
  ac_makedistclean = new VDKMenuItem(menuac,main_menu_prompts[44],
				 NULL);
  ac_menu->Add(menuac);
  ac_menu->Enabled = false;
  // help menu
  help_menu     =   new VDKMenuItem(menubar,main_menu_prompts[24],
				    NULL,r_justify);
  VDKMenu *menuh =  new VDKMenu(this);
  help_index    =   new VDKMenuItem(menuh,main_menu_prompts[25]);
  help_about    =   new VDKMenuItem(menuh,main_menu_prompts[26]);
  help_menu->Add(menuh);
  Add(menubar,FALSE,FALSE,0);
}
/*
 */
VDKBox*
VDKBMainForm::MakeToolBox()
{
  int t;
  VDKBox* vbox = new VDKBox(this,v_box);
  toolbar = new VDKToolbar(this);
  toolbar->Spacing = 2;
  for( t=0; main_toolbar_pixmaps[t]; t++)
    {
      toolbar->AddButton(main_toolbar_pixmaps[t],
			 main_toolbar_tips[t],
			 NULL);
      toolbar->AddSpace();
    }
  vbox->Add(toolbar);
  vbox->Add(new VDKSeparator(this,h_separator),FALSE,FALSE,0);


  toolbar1 = new VDKToolbar(this);
  toolbar1->Spacing = 2;
  toolbar1->AddButton(main_menu_pixmaps[7],main_menu_prompts[17],NULL);
  toolbar1->AddSpace();
  toolbar1->AddButton(main_toolbar1_pixmaps[0],main_toolbar1_tips[0],NULL);
  toolbar1->AddSpace();
  toolbar1->AddButton(main_menu_pixmaps[8],main_menu_prompts[18],NULL);
  toolbar1->AddSpace();
  toolbar1->AddButton(main_toolbar1_pixmaps[1],main_toolbar1_tips[1],NULL);
  toolbar1->AddSpace();
  reset = new VDKPixmapButton(this,main_toolbar1_pixmaps[2],NULL,
				   main_toolbar1_tips[2]);
   toolbar1->AddWidget(reset);
   //=====================
   reset->Enabled = false;
   //====================
  vbox->Add(toolbar1);
  return vbox;
}
/*
 */
VDKToolbar*
VDKBMainForm::MakeContainerWidgetFolder()
{
  int t = 0;
  containers_widgets_bar = new VDKToolbar(this);
  for(; t < CONTAINER_WIDGETS_TIPS; t++)
    {
	containers_widgets_bar->AddButton(container_widgets_pixmaps[t],
					  container_widgets_tips[t],NULL);
	// add toolbar buttons to dnd support
	if(DragAndDrop)
	  {
	    DragAndDrop->AddSource((*containers_widgets_bar)[t]);
	    DragAndDrop->SetIcon((*containers_widgets_bar)[t],
			     new VDKRawPixmap(this,
					      container_widgets_pixmaps[t]));
	    // load builder dnd table
	    DnDBuilderEntry entry((*containers_widgets_bar)[t],
				  CONTAINERS_TOOL_BEGIN+t);
	    DragAndDropTable->add(entry);
	  }
    }
  return containers_widgets_bar;
}
/*
 */
VDKToolbar*
VDKBMainForm::MakeButtonsWidgetFolder()
{
  int t = 0;
  button_widgets_bar = new VDKToolbar(this);
  for(; t < BUTTON_WIDGETS_TIPS; t++)
    {
	button_widgets_bar->AddButton(button_widgets_pixmaps[t],
				      button_widgets_tips[t],NULL);
	// add toolbar buttons to dnd support
	if(DragAndDrop)
	  {
	    DragAndDrop->AddSource((*button_widgets_bar)[t]);
	    DragAndDrop->SetIcon((*button_widgets_bar)[t],
			     new VDKRawPixmap(this,button_widgets_pixmaps[t]));
	    // load builder dnd table
	    DnDBuilderEntry entry((*button_widgets_bar)[t],
				  BUTTON_TOOL_BEGIN+t);
	    DragAndDropTable->add(entry);
	  }
    }

  return button_widgets_bar;
}
/*
 */
VDKToolbar*
VDKBMainForm::MakeTextWidgetFolder()
{
  int t = 0;
  text_widgets_bar = new VDKToolbar(this);
  for(; t < TEXT_WIDGETS_TIPS; t++)
    {
      text_widgets_bar->AddButton(text_widgets_pixmaps[t],
				  text_widgets_tips[t],NULL);
      // add toolbar buttons to dnd support
      if(DragAndDrop)
	{
	  DragAndDrop->AddSource((*text_widgets_bar)[t]);
	  DragAndDrop->SetIcon((*text_widgets_bar)[t],
			       new VDKRawPixmap(this,
						text_widgets_pixmaps[t]));
	  // load builder dnd table
	  DnDBuilderEntry entry((*text_widgets_bar)[t],
				TEXT_TOOL_BEGIN+t);
	  DragAndDropTable->add(entry);
	}
    }
  return text_widgets_bar;
}
/*
 */
VDKToolbar*
VDKBMainForm::MakePluginWidgetFolder()
{
  int t = 0;
  plugin_widgets_bar = new VDKToolbar(this);
  // scanning plugin table
  // add plugin tool icon and tip
  VDKBPluginListIterator li(TheApp->PluginList());
  for(;li;li++,t++)
    {
      if(li.current().IsValid())
	{
	  VDKBAbstractComponentInterface* interface =
	  li.current().Interface();
	  if(interface)
	    {
	      plugin_widgets_bar->AddButton((char**) interface->Icon(),
					    (char*) interface->Tip(),
					    NULL);
	      // add toolbar buttons to dnd support
	      if(DragAndDrop)
		{
		  DragAndDrop->AddSource((*plugin_widgets_bar)[t]);
		  DragAndDrop->SetIcon((*plugin_widgets_bar)[t],
				 new VDKRawPixmap(this,
						  (char**) interface->Icon()));
		  // load builder dnd table
		  DnDBuilderEntry entry((*plugin_widgets_bar)[t],
					PLUGIN_TOOL_BEGIN+t);
		  DragAndDropTable->add(entry);
		}
	    }
	}
    }
  return plugin_widgets_bar;
}
/*
 */
VDKToolbar*
VDKBMainForm::MakeMiscWidgetFolder()
{
  int t = 0;
  misc_widgets_bar = new VDKToolbar(this);
  for(; t < MISC_WIDGETS_TIPS; t++)
    {
      misc_widgets_bar->AddButton(misc_widgets_pixmaps[t],
				  misc_widgets_tips[t],NULL);
            // add toolbar buttons to dnd support
      if(DragAndDrop)
	{
	  DragAndDrop->AddSource((*misc_widgets_bar)[t]);
	  DragAndDrop->SetIcon((*misc_widgets_bar)[t],
			       new VDKRawPixmap(this,
						misc_widgets_pixmaps[t]));
	  // load builder dnd table
	  DnDBuilderEntry entry((*misc_widgets_bar)[t],
				MISC_TOOL_BEGIN+t);
	  DragAndDropTable->add(entry);
	}
    }
  return misc_widgets_bar;
}
/*
 */
#if HAVE_GNOME
VDKToolbar*
VDKBMainForm::MakeGnomeWidgetFolder()
{
  int t = 0;
  gnome_widgets_bar = new VDKToolbar(this);
  for(; t < GNOME_WIDGETS_TIPS; t++)
    {
      gnome_widgets_bar->AddButton(gnome_widgets_pixmaps[t],
				  gnome_widgets_tips[t],NULL);
      // add toolbar buttons to dnd support
      if(DragAndDrop)
	{
	  DragAndDrop->AddSource((*gnome_widgets_bar)[t]);
	  DragAndDrop->SetIcon((*gnome_widgets_bar)[t],
			       new VDKRawPixmap(this,
						gnome_widgets_pixmaps[t]));
	  // load builder dnd table
	  DnDBuilderEntry entry((*gnome_widgets_bar)[t],
				GNOME_TOOL_BEGIN+t);
	  DragAndDropTable->add(entry);
	}
    }
  return gnome_widgets_bar;
}
/*
 */
void
VDKBMainForm::EnableGnomeWidgets(bool flag)
{
     for(int t = 0; t < GNOME_WIDGETS_TIPS; t++)
	 (*gnome_widgets_bar)[t]->Enabled = flag;
}
#endif
/*
disabled for now
VDKToolbar*
VDKBMainForm::MakeDlgWidgetFolder()
{
int t = 0;
dlg_widgets_bar = new VDKToolbar(this);
for(; t < DLG_WIDGETS_TIPS; t++)
dlg_widgets_bar->AddButton(dlg_widgets_pixmaps[t],
dlg_widgets_tips[t],NULL);
return dlg_widgets_bar;
}
*/

//////////////// INTERFACE COMPLETE /////////////////////
/*
makes editor
*/

VDKBEditor*
VDKBMainForm::MakeEditor()
{
  if(!editor)
    {
      editor = new VDKBEditor(this);
      editor->Setup();
      editor->Visible = true;
    }
  else if(! editor->Visible)
    editor->Visible = true;
  else if(editor->Iconized )
    editor->Iconized = false;
  // anyways raise
  else
    editor->Raise();
  Automa(automa_editor_on);
  return editor;
}
/*
manages main form and VDKBuilder termination
*/
bool
VDKBMainForm::CanClose()
{
int answer =
  Application()->MessageBox(
	APPNAME,
	user_messages[user_can_close],
	MB_YESNO| MB_ICONQUESTION,
	user_messages[user_ok],
	user_messages[user_no],
	6000); /*  after 6 seconds without answer
		   closes with IDNO */
// closes project manager,editor
// and mozilla (if activated)
if(answer == IDYES)
   {
     if(prjman)
       prjman->ForceToClose = true;
     if(editor)
       editor->ForceToClose = true;
     if(mozpid)
       kill(mozpid, SIGTERM);
   }
return answer == IDYES;
}
/*
 */
void
VDKBMainForm::EnableToggleFormUnit(bool active, char* file)
{
(*toolbar1)[1]->Enabled = active;
ToBeToggled = file;
}

////////////////////////////////
// Application class
///////////////////////////////
void
VDKBuilder::Setup()
  {
     // install auto timed gc
    SetGarbageCollection(1000);
    MainForm = new VDKBMainForm(this,VDKBVERSION);
    MainForm->Setup();
  }


/*
=========================================
NON VDK STUFF
used to install vdkbuilder resource files
=========================================
*/
/*
install resources
*/
static bool
install_resources(char* home)
{
  char* cwd;
  char command1[256],command2[256],command3[256];
  int result = -1;
   // makes .vdkb dir
  cwd = getcwd(NULL,MAXPATHLEN);
  if(!cwd)
    return false;
  if(chdir(home) < 0)
    {
      free(cwd);
      return false;
    }
  sprintf(command1,"cp %s/%s .vdkb/res",VDKB_DATADIR,DEFAULTS_FILE);
  sprintf(command2,"cp %s/%s .vdkb/res",VDKB_DATADIR,VDKB_RESOURCE_FILE);
  sprintf(command3,"cp %s/%s .vdkb/res",VDKB_DATADIR,VDKB_PLUGIN_FILE);
  result = system("mkdir .vdkb");
  if( result != 127 && result >= 0)
    {
      result = system("mkdir .vdkb/res");
      if( result != 127 && result >= 0)
	{
	  result = system(command1);
	  if( result != 127 && result >= 0)
	    {
	      result = system(command2);
	      if( result != 127 && result >= 0)
		  {	
		result = system(command3);
		  }
	    }
	
	}
    }
  chdir(cwd);
  free(cwd);
  return result != 127 && result >= 0;
}
/*
destroy
 */
static gboolean
cmw_destroy_cb(GtkWidget *widget)
{
  /* This is needed to get out of gtk_main */
  gtk_main_quit ();
  return FALSE;
}

void
create_nonvdk_modal_window (char* prompt)
{
  GtkWidget *window = NULL;
  GtkWidget *box1,*box2,*box3;
  GtkWidget *label;
  GtkWidget *btnOk;
  /* Create modal window*/
  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW(window),"VDKBuilder");
  /* Set window as modal */
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
  /* Create widgets */
  box1 = gtk_vbox_new (FALSE,5);
  box2 = gtk_vbox_new (TRUE,5);
  box3 = gtk_hbox_new (TRUE,5);
  btnOk = gtk_button_new_with_label ("Dismiss");
  label = gtk_label_new(prompt);
  /* Init widgets */
  gtk_container_set_border_width (GTK_CONTAINER(box1),3);
  gtk_container_set_border_width (GTK_CONTAINER(box2),3);
  /* Pack widgets */
  gtk_container_add (GTK_CONTAINER (window), box1);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 4);
  gtk_box_pack_start (GTK_BOX (box2), label, FALSE, FALSE, 4);
  gtk_box_pack_start (GTK_BOX (box3), btnOk, FALSE, FALSE, 4);
  gtk_box_pack_start (GTK_BOX (box1), gtk_hseparator_new (), FALSE, FALSE, 4);
  gtk_box_pack_start (GTK_BOX (box1), box3, FALSE, FALSE, 4);
  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (btnOk), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (cmw_destroy_cb),NULL);
  /* Show widgets */
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_widget_show_all(window);
  /* wait until dialog get destroyed */
  gtk_main();
}









