/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */ 
#include <vdkb/vdkb_about.h>
#include <vdkb/vdkb.h>

#include <config.h>

static char buff[256];
extern char *simpson1_xpm[];
extern char *simpson2_xpm[];

DEFINE_SIGNAL_MAP(VDKBAboutForm, VDKForm)
  ON_SIGNAL(ok,clicked_signal,Quit)
END_SIGNAL_MAP

/*
 */
bool
VDKBAboutForm::Quit(VDKObject*) { Close(); return true; }
/*
 */
VDKBAboutForm::VDKBAboutForm(VDKForm* owner)
  :VDKForm(owner,VDKBVERSION/*,v_box,GTK_WINDOW_POPUP*/)
{
}
/*
 */
void
VDKBAboutForm::Setup()
{
  GtkStyle *new_style;
  VDKBox *box1;
  VDKRawPixmap *rawpixmap;
  sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_LOGO);
  rawpixmap = new VDKRawPixmap(this,buff);
  Box()->BorderWidth(2);
  Box()->SetSize(rawpixmap->Width(),rawpixmap->Height()+20);

  /*
    since a particular
    theme engine might not respect the background pixmap, instead
    of copying the widget's current style, i would create a
    new style from scratch:
    new_style = gtk_style_copy( gtk_widget_get_style(Window()));
  */
  new_style = gtk_style_new ();
  new_style->bg_pixmap[GTK_STATE_NORMAL] = *rawpixmap;
  gtk_widget_set_style( Window(), new_style ); 
  /*
    Don't forget to unref the new style, or it will leak.
  */
  gtk_style_unref(new_style);

  box1 = new VDKBox(this,h_box);
  VDKLabel *author1 = new VDKLabel(this,about_dlg_text[1],
				 GTK_JUSTIFY_CENTER);
  VDKLabel *author2 = new VDKLabel(this,about_dlg_text[2],
				 GTK_JUSTIFY_CENTER);
  /*
  VDKLabel *author3 = new VDKLabel(this,"Raffaele Salmaso",
				 GTK_JUSTIFY_CENTER);
  */
  ok = new VDKLabelButton(this," Dismiss ");
  ok->SetSize(-1,30);
  box1->Add(ok,l_justify,true,false,2);
  box1->Add(author2,r_justify,true,false,2);
  box1->Add(author1,r_justify,true,false,2);
  //  box1->Add(author3,l_justify,true,false,2);
  Add(box1,r_justify,false,false,2);
  gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_CENTER);
}

void 
VDKBAboutForm::OnShow(VDKForm* sender) 
{
;
}
