/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.4
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb.h>
#include <stdio.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_prj.h>
#include <sys/param.h>

static char *making[] = 
{ NULL, NULL, NULL, NULL ,NULL, NULL, NULL, NULL,NULL,NULL
};
static char buff[512];
// below this index does not overwrites
#define DO_NOT_OVERWRITE 6
static char *tobecopied[] =
/*
  { 
  "AUTHORS","COPYING","ChangeLog", "INSTALL",
  "NEWS ", "README", "autogen.sh","install-sh",
  "missing","mkinstalldirs","stamp-h","stamp-h.in",
  "config.guess","config.status","config.sub",0
  };
*/ 
{ 
 "AUTHORS","COPYING","ChangeLog", "INSTALL",
 "NEWS ", "README", "autogen.sh",0
};
bool
VDKBMainForm::AcAutogen(VDKObject* sender)
{
  int t;
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  // request user confirmation
  sprintf(buff,
"Autoconf/Automake support will\
\n\t* generate:\
\n\t\t - acconfig.h\
\n\t\t - configure.in\
\n\t\t - Makefile.am\
\n\t* copy all required files into %s\
\n\t* invoke ./autogen.sh\
\n\nDo you want apply Automake/Autoconf support ?", (char*) tgtPath);
  if(Application()->MessageBox(APPNAME,
			     buff,
			     MB_ICONQUESTION|MB_YESNO,
			     user_messages[user_ok],
			     user_messages[user_no]) == IDNO)
    return true;
  /*
    copies all default files from vdkbuilder data dir
    to project path
  */
  for(t = 0; tobecopied[t]; t++)
    {
      /* 
	 does not overwrites :
	 AUTHORS,COPYING,ChangeLog, INSTALL,
	 NEWS, and README
      */
      if( (t < DO_NOT_OVERWRITE) &&  !access(tobecopied[t],F_OK) )
	;
      else
	{
	  sprintf(buff,"cp -a %s/res/%s %s/",
		  VDKB_DATADIR,
		  tobecopied[t],
		  (char*) tgtPath);
	  system(buff);
	}
    }
  sprintf(buff,"chmod +x %s/autogen.sh",(char*) tgtPath);
  system(buff);
  /*
    writes acconfig.h
  */
  sprintf(buff,"%s/acconfig.h",(char*) tgtPath);
  FILE* fp = fopen(buff,"w+");
  if(! fp)
    return true;
  char* defines = (char*) project->Options()->defines;
  strcpy(buff,defines);
  char* token = strtok(buff,"-D");
  if(token)
    {
      fprintf(fp,"\n#undef %s\n",token);
      while( (token = strtok(NULL,"-D")) )
	fprintf(fp,"\n#undef %s \n",token);
    }  
  fclose(fp);
  /*
    writes configure.in
  */
  sprintf(buff,"%s/configure.in",(char*) tgtPath);
  fp = fopen(buff,"w+");
  if(! fp)
    return true;
  fprintf(fp,
"dnl ****************************************\n\
dnl Copyright Mario Motta <mmotta@guest.net>\n\
dnl ****************************************\n\
dnl VDKBuilder autoconf/automake support\n\
dnl ** WARNING ** overwritten by builder\n\n");
  char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  VDKString prname = project->Name;
  char* p = get_extension((char*) prname);
  if(p)
    *p = '\0';
  fprintf(fp,"AC_INIT(%s.%s)\n\n",(char*) prname,cc_ext);
  char* version = (char*) project->Options()->version;
  fprintf(fp,"VERSION=%s\n",version);
  fprintf(fp,"PACKAGE=%s\n\n",(char*) prname);
  fprintf(fp,
	  "dnl Initialize automake stuff\n\
AM_INIT_AUTOMAKE($PACKAGE, $VERSION)\n\
\n\
AC_CANONICAL_HOST\n\
\n\
dnl with this line you check libvdk version and set 3 variables for\n\
dnl your Makefile.am:\n\
dnl VDK_LIBS: every libs you need\n\
dnl VDK_CFLAGS: every include dir you need\n\
dnl VDK_CONFIG: the absolute path to vdk-config\n\
AM_PATH_VDK(`vdk-config --version`,,AC_MSG_ERROR(Correct version of VDK is not installed))\n\
\n\
dnl check for C++ compiler, C++ pre-processor flag\n\
AC_PROG_CXX\n\
AC_PROG_CXXCPP\n\
AC_LANG_CPLUSPLUS\n\
\n");
  char* c_flags = (char*) project->Options()->c_flags;
  fprintf(fp,"CXXFLAGS=\"%s\"\n",c_flags);
  fprintf(fp,"AC_SUBST(CXXFLAGS)\n\n");
  // defines
  strcpy(buff,defines);
  token = strtok(buff,"-D");
  if(token)
    {
      fprintf(fp,"\nAC_DEFINE(%s)\n",token);
      while( (token = strtok(NULL,"-D")) )
	fprintf(fp,"\nAC_DEFINE(%s)\n",token);
    }
  // almost done
  fprintf(fp,"dnl create a config.h header\n\
AM_CONFIG_HEADER(config.h)\n\
\n\
AC_OUTPUT(Makefile)\n\n");
  fclose(fp);
  
  /* 
     writes Makefile.am 
  */
  sprintf(buff,"%s/Makefile.am",(char*) tgtPath);
  fp = fopen(buff,"w+");
  if(! fp)
    return true;
  fprintf(fp,
"#****************************************\n\
# Copyright Mario Motta <mmotta@guest.net>\n\
# ****************************************\n\
# VDKBuilder autoconf/automake support\n\
# ** WARNING ** overwritten by builder\n\n");

  fprintf(fp,
  "#To make any subdir just give a SUBDIRS variable\n\nSUBDIRS =\n\n"); 
  fprintf(fp,"bin_PROGRAMS = %s\n\n",(char*) prname);
  fprintf(fp,"%s_SOURCES = ",(char*) prname);
  project->WriteSourcesForAutomake(fp);
  char* includes = (char*) project->Options()->includes;
  fprintf(fp,"\nINCLUDES = %s\n\n",includes);
  char* libs = (char*) project->Options()->libs;
  fprintf(fp,"%s_LDFLAGS = %s\n\n",(char*) prname,libs);
  fprintf(fp,
"#In EXTRA_DIST variable you must put every file which is not used\n\
#to be compiled.\nEXTRA_DIST = \\\n\tautogen.sh");
  // search for <extra_dist.am>
  if(!access("extra_dist.am",F_OK))
    {
      char local[512];
      FILE* extra;
      fprintf(fp,"\\\n\textra_dist.am");
      extra = fopen("extra_dist.am","r");
      if(extra)
	{
	  while(fgets(local,512,extra))
	    {
	      local[strlen(local)-1] = '\0';
	      fprintf(fp,"\\\n\t%s",local);
	    }
	  fclose(extra);
	}
    }
  
  fclose(fp);
  // save changed files
  if(editor && editor->Visible)
    editor->UpdateFiles();
  // writes gui files 
  PrjManager()->WriteGuiFiles();
  // writes makefile
  VDKString path = project->Path;
  char* file = new char[strlen((char*) path)+16];
  strcpy(file, (char*) path);
  strcat(file,"/vdkbMakefile");
  fp = fopen(file,"w+");
  if(fp)
    {
      project->WriteMakefile(fp);
      fclose(fp);
    }
  else
    {
      delete[] file;
      return true; // FIX ME: with user warning !!!!
    }
  delete[] file;
  /*
    save project
  */
  project->Save();
  /*
    invloke vdkbmaker &&
    runs autogen.sh
  */
  making[0] = "./autogen.sh";
  making[1] = NULL;
  CallMaker(making,(char*) tgtPath,0);
  bool have_config = !access("./configure",F_OK);
  ac_make->Enabled = have_config;
  ac_makeclean->Enabled = have_config;
  ac_makedist->Enabled = have_config;
  ac_makedistclean->Enabled = have_config;
  return true;
}
/*
 */
bool
VDKBMainForm:: AcMake(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  making[0] = "make";
  making[1] = NULL;
  // save changed files,
  if(editor && editor->Visible)
    editor->UpdateFiles();
  CallMaker(making,(char*) tgtPath,0);
  return true;
}
/*
 */
bool 
VDKBMainForm::AcMakeClean(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
 making[0] = "make";
 making[1] = "clean";
 making[2] = NULL;
 CallMaker(making,(char*) tgtPath,0);
 return true;
}
/*
 */
bool 
VDKBMainForm::AcMakeDist(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  making[0] = "make";
  making[1] = "dist";
  making[2] = NULL;
  CallMaker(making,(char*) tgtPath,0);
  return true;
}
/*
 */
bool 
VDKBMainForm::AcMakeDistclean(VDKObject* sender)
{
  VDKString tgtPath;
  VDKBProject* project = PrjManager()->Project();
  if(!project)
    return true;
  tgtPath = project->Path;
  making[0] = "make";
  making[1] = "distclean";
  making[2] = NULL;
  CallMaker(making,(char*) tgtPath,0);
  ac_make->Enabled = false;
  ac_makeclean->Enabled = false;
  ac_makedist->Enabled = false;
  ac_makedistclean->Enabled = false;
  return true;
}
/*
output = 0 uses stderr, 1 stdout
 */
void
VDKBMainForm::CallMaker(char * args[], char* pth,int output)
{
  /*
 VDKString cwd;
 char* p = getcwd(NULL,MAXPATHLEN);
 if(p)
   {
     cwd = p; 
     free(p);
   }
  */
  if(!maker)
    {
      chdir(pth);
      VDKBStringList* list = new VDKBStringList;
      maker = new VDKBMaker(this,args,list,false,output);
      maker->Setup();
      maker->Show();//Modal();
      //  chdir( (char*) cwd);
    }
  else
      Application()->MessageBox(
				APPNAME,
				"A compilation process is already running",
				MB_ICONINFORMATION|MB_OK,
				user_messages[user_ok],
				NULL,
				3000);
}


void
VDKBMainForm::LoadEditorWithErrors(VDKBStringList* list)
{
  if( (editor) && 
      (editor->Visible) && 
      (list->size() > 0))
    { 
      int t = 0;
      VDKBStringList slist;
      for(; t < list->size(); t++)
	{
	  char* p;
	  char* local = new char[strlen((char*) (*list)[t]) +1 ];
	  strcpy(local,(char*) (*list)[t]);
	  // tokenize
	  if( (p = strtok(local,"\n")) )
	    {
	      slist.add(p);
	      while( ( p = strtok(NULL,"\n")) )
		slist.add(p);
	    }
	  else
	    slist.add(local);
	  delete[] local;
	}
      editor->FillMessages(&slist);
    } 
}





