/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <stdlib.h>
#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_notebook.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_widpopmenu.h>
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBGuiNotebook
// put here vdk class name string
#define VDK_CLASS "VDKNotebook"
// put here vdk class name
#define VDK_ANCESTOR  VDKNotebook
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "notebook"
static char buff[128];
int CLASS::Counter = 0;

/*
 notebook properties names
 */
char* vdknotebook_props[] =
{
"Scrollable","PopUp",0
};
/*
notebook signal names && nicknames
Default response method name will be made by:
On<object name><nickname>.
For instance if object name = <Abutton> and nickname = <Click>
default response method name will be: <OnAbuttonClick>
*/
char* vdknotebook_signals[] =
{
"switch_page_signal", 0
};
char* vdknotebook_nicknames[] =
{
"SwitchPage",0
};

DEFINE_EVENT_LIST(CLASS,VDKBEventContainer);
DEFINE_SIGNAL_LIST(CLASS,VDKBEventContainer);


/*
 */
bool
CLASS:: DelBox(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
CLASS::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}
/*
 */
bool
CLASS::AddNewPage(VDKObject* sender)
{
  char local[64];
  sprintf(local,"%s_page%d",(char*) Name(), nbook->Pages.size());
  VDKBEventBox *box = new VDKBEventBox(local,this);
  AddWidget(box);
  pagelist.add(box);
  return true;
}
/*
 */
bool
CLASS::OnButtonPressed(VDKObject* sender, GdkEvent* event)
{
  // pass to ancestor so widget will be marked
  VDKBEventContainer::OnButtonPressed(this,event);
  return true;

}
/*
 */
bool
CLASS::RemovePage(VDKObject* sender)
{
  int ndx = nbook->ActivePage;
  VDKBObject *page = pagelist[ndx];
  VDKBEventBox* box = dynamic_cast<VDKBEventBox*>(page);
  if(box)
    {
      pagelist.remove(page);
      // calling with sender NULL override
      // embedded deleting deny.
      box->DelBox(NULL);
      delpage->Enabled = pagelist.size() > 1;
    }
  else
    {
      printf("\nbad conversion");
      fflush(stdout);
    }
  return true;
}

//===========================================
/*
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  Init();
}

/*
 */
CLASS::CLASS(char* name,VDKBEventContainer* outer):
    VDKBEventContainer(name,outer->Owner())
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  Init();
 }
/*
 */
void
CLASS::Init()
{
  int t;
  AddBox();
  // add to VDKBObject properties list
  for(t=0; vdknotebook_props[t]; t++)
    proplist.add(VDKBProperty(vdknotebook_props[t]));
  // add to VDKBObject signal list  signals
  for(t=0; vdknotebook_signals[t]; t++)
    siglist.add(VDKBSignal(vdknotebook_signals[t],
			   this,
			   vdknotebook_nicknames[t]));
  // makes a pop menu
  popmenu = new VDKBContainerPopMenu(this);
  addwidget = new VDKMenuItem(popmenu,"Add a new page");
  delpage = new VDKMenuItem(popmenu,"Remove current page");
  popmenu->Separator();
  delBox = new VDKMenuItem(popmenu,"Remove notebook");
  setsize = new VDKMenuItem(popmenu,"Set min size");
  selectparent =  new VDKMenuItem(popmenu,"Select parent container");
  SignalConnect(selectparent,"activate",
		&CLASS::SelectParentContainer);
  SignalConnect(delBox,"activate",&CLASS::DelBox);
  SignalConnect(setsize,"activate",&CLASS::SetBoxSize);
  SignalConnect(addwidget,"activate",&CLASS::AddNewPage);
  SignalConnect(delpage,"activate",&CLASS::RemovePage);
  // connect after so switch page signal can be handled.
  EventConnect("button_press_event",&CLASS::ButtonPressed,true);
  EventConnect("button_release_event",&VDKBObject::ButtonReleased);
  EventConnect("enter_notify_event",&VDKBObject::OnEnter);
  EventConnect("leave_notify_event",&VDKBObject::OnLeave);
  CONNECT_COMMON_EVENTS;
  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  popmenu->Setup();
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
}
/*
 */
void
CLASS::AddBox()
{
  nbook = new VDK_ANCESTOR(Owner());
  widget = sigwid = container = nbook->Widget();
  gtk_widget_show(container);
  Owner()->Objects().add(nbook);
  nbook->Parent(this);
}

/*
only tab pages can be added to notebook
 */
void
CLASS::AddWidget(VDKObject* obj, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(obj);
  nbook->AddPage(obj,vdkbobj ? (char*) vdkbobj->Name() : (char*) "#none");
  VDKBEventContainer::Add(obj,justify,expand,fill,padding);
  nbook->Visible = true;
  pagelist.add(vdkbobj);
  if(tablabels.size() >= pagelist.size())
    {
      int ndx = pagelist.size()-1;
      nbook->Pages[ndx]->TabLabel->Caption =  (char*) tablabels[ndx];
      if(vdkbobj)
	vdkbobj->SetPropValue("Label",(char*) tablabels[ndx]);
    }
  else
    {
      tablabels.add(vdkbobj->Name());
      if(vdkbobj)
	vdkbobj->SetPropValue("Label",(char*) vdkbobj->Name());
    }
  delpage->Enabled = pagelist.size() > 1;
}
/*
extra args used
 */
void
CLASS::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  AddWidget(wid,justify, expand, fill , padding,forceArgs);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
  4 - unuseful call
*/
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  VDKBEventBox *box1 = NULL;
  CLASS* notebook = NULL;
  if(owner->Active)
    {
      char local[64];
      for(sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  CLASS::Counter++)
	sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
      notebook = new CLASS(buff,owner);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      char local[16];
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(local,"%d",int(event->x));
	      notebook->SetPropValue(JUSTIFY_INTERNAL,local);
	      sprintf(local,"%d",int(event->y));
	      notebook->SetPropValue(EXPAND_INTERNAL,local);
	      // others than justify and flag unuseful
	      container->AddWidget(notebook,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(notebook);
	  notebook->outerbox = container;
	  sprintf(local,"%s_page%d",buff,notebook->nbook->Pages.size());
	  box1 = new VDKBEventBox(local,notebook);
	  notebook->AddWidget(box1);
	}
      else if( owner->Active->AddToParent(notebook,ev))
	{
	  sprintf(local,"%s_page%d",buff,notebook->nbook->Pages.size());
	  box1 = new VDKBEventBox(local,notebook);
	  notebook->AddWidget(box1);
	}
      else
	// target isn't a container
	result =  2;
    }
  else
    // no active widget
    result = 3;

  // 0 on success
  if(result && notebook)
       notebook->Destroy();
  return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\tBorderWidth:%s;", (char*) GetProp("BorderWidth"));
  // writes tab labels number
  fprintf(fp,"\n\tPages:%d;",tablabels.size());
  // writes tab labels
  fprintf(fp,"\n\tLabels:\"");
  int t,last = tablabels.size();
  for(t = 0; t < last-1 ; t++)
    fprintf(fp,"%s,", (char*) tablabels[t]);
  fprintf(fp,"%s\";", (char*) tablabels[last-1]);
  fprintf(fp,"\n\tScrollable:%s;", (char*) GetProp("Scrollable"));
  fprintf(fp,"\n\tPopUp:%s;", (char*) GetProp("PopUp"));
}

char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char temp[256];
  char bw[16];
  char arg[16];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];
  sprintf(temp,"\n%s = new %s(this);" ,obj_name,VDK_CLASS);
  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(temp,"\nAdd(%s",obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }

  if(parser.GetParam(bw,buffer,"BorderWidth:") &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }
  if(parser.GetParam(arg,buffer,"Scrollable:") &&
     strcmp(arg,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->Scrollable = %s;",obj_name,arg);
      strcat(source,temp);
    }
  if(parser.GetParam(arg,buffer,"PopUp:") &&
     strcmp(arg,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->PopUp = %s;",obj_name,arg);
      strcat(source,temp);
    }
  return source;
}
/*
 */
bool
CLASS::LoadTabLabels(char* buffer,VDKBParser& parser)
{
  int n = 0 ;
  char arg[16],*local,*p;
  if(parser.GetParam(arg,buffer,"Pages:"))
    n = atoi(arg);
  else
    return false;
  local = new char[1024];
  if(!parser.GetParam(local,buffer,"Labels:"))
    {
      delete[] local;
      return false;
    }
  // now in local there are a list of labels
  p = strtok(local,",");
  while(p)
    {
      tablabels.add(VDKString(p));
      p = strtok(NULL,",");
    }
  delete[] local;
  return tablabels.size() == n;
}
/*
 */
bool
CLASS::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[32];
  CLASS* box;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand = 0,fill = 0,padding = 0;
  int bw; // border width
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand =  atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding = atoi(arg);
  if(parser.GetParam(arg,buffer,"BorderWidth:") &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new CLASS(obj_name,owner->InnerBox());
      box->LoadTabLabels(buffer, parser);
      owner->AddWidget(box,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new CLASS(obj_name,container);
	  box->LoadTabLabels(buffer, parser);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  box->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  //
  if(parser.GetParam(arg,buffer,"Scrollable:") && strcmp(arg,NIHIL_PROP))
    {
      box->SetPropValue("Scrollable",arg);
      box->nbook->Scrollable = !strcmp(arg,CHECK_TRUE);
    }
  if(parser.GetParam(arg,buffer,"PopUp:") && strcmp(arg,NIHIL_PROP))
    box->SetPropValue("PopUp",arg);
  // call ancestor to set common properties
  VDKBObject::CreateWidget(box,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
  if(bw >= 0)
    {
      box->BorderWidth(bw);
      box->SetPropValue("BorderWidth",arg);
    }
  return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own property controls.
 */

VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  VDKTable *table = new VDKTable(inspector,3,2);
  table->SetSize(219,-1);
  VDKLabelButton* button = new VDKLabelButton(inspector,"Set border width");
  table->AddToCell(button,0,0);
  int bw = atoi( (char*) GetProp("BorderWidth"));
  border = new VDKSpinButton(inspector, bw, 0, 20 , 1 ,0 );
  table->AddToCell(border,0,1);
  button->Parent(this);

  table->AddToCell(new VDKLabel(inspector,"Tab label: "),1,0);
  tablabel = new VDKEntry(inspector,64, (char*) tablabels[nbook->ActivePage]);
  tablabel->SetSize(100,-1);
  table->AddToCell(tablabel,1,1);
  tablabel->Parent(this);

  scrollable = new VDKCheckButton(inspector,"Scrollable");
  table->AddToCell(scrollable,2,0);
  scrollable->Checked = GetProp("Scrollable") == True;
  scrollable->Parent(this);
  popup = new VDKCheckButton(inspector,"PopUp");
  table->AddToCell(popup,2,1);
  popup->Checked = GetProp("PopUp") == True;
  popup->Parent(this);

  SignalConnect(button,"clicked",&CLASS::OnBorderWidth);
  SignalConnect(tablabel,"activate",&CLASS::OnSetTabLabel);
  SignalConnect(scrollable,"toggled",&CLASS::OnSetScrollable);
  SignalConnect(popup,"toggled",&CLASS::OnSetPopUp);

  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
/*
 */
bool
CLASS::OnBorderWidth(VDKObject*)
{
  sprintf(buff,"%d",(int) border->ValueAsInt);
  SetPropValue("BorderWidth",buff);
  BorderWidth((int) border->ValueAsInt);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetTabLabel(VDKObject*)
{
  int activepage;
  activepage = nbook->ActivePage;
  if( (activepage >= 0) && (activepage < nbook->Pages.size()))
    {
      if(strlen(tablabel->Text) <= 0)
	*buff = '\0';
      else
	sprintf(buff,"%s",(char*) tablabel->Text);
      nbook->Pages[nbook->ActivePage]->TabLabel->Caption = buff;
      tablabels[nbook->ActivePage] = buff;
      //  sprintf(local,"%s",buff);
      pagelist[activepage]->SetPropValue("Label",buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetScrollable(VDKObject*)
{
  SetPropValue("Scrollable", scrollable->Checked ? CHECK_TRUE : CHECK_FALSE);
  nbook->Scrollable = scrollable->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetPopUp(VDKObject*)
{
  SetPropValue("PopUp", popup->Checked ? CHECK_TRUE : CHECK_FALSE);
  inspector->FormNeedToBeChanged();
  return true;
}


