(*
    Generated parser for VisualOberon preferences.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details. 

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

MODULE -->modulename;

IMPORT
  -->scanner;

CONST 
  -->constants
  setSize = MAX(SET) + 1;
  nSets = (maxT DIV setSize) + 1;

TYPE
  SymbolSet = ARRAY nSets OF SET;

VAR
  sym:    INTEGER;   (* current input symbol *)
  symSet: ARRAY nrSets OF SymbolSet;

-->declarations

(* ==================================================================== *)

PROCEDURE Error (n: INTEGER);
BEGIN
  -->errors
END Error;

PROCEDURE Get ();
BEGIN
  -->scanProc
END Get;

PROCEDURE Expect (n: INTEGER);
BEGIN
  IF sym = n THEN Get(); ELSE Error(n); END;
END Expect;

PROCEDURE StartOf (s: INTEGER): BOOLEAN;
BEGIN
  RETURN (sym MOD setSize) IN symSet[s, sym DIV setSize];
END StartOf;

PROCEDURE ExpectWeak(n, follow: INTEGER);
BEGIN
  IF sym = n THEN
    Get ();
  ELSE
    Error (n);
    WHILE ~StartOf (follow) DO Get(); END;
  END;
END ExpectWeak;

PROCEDURE WeakSeparator (n, syFol, repFol: INTEGER): BOOLEAN;
VAR
  s: SymbolSet; i: INTEGER;
BEGIN
  IF sym = n THEN
    Get ();
    RETURN TRUE;
  ELSIF StartOf (repFol) THEN
    RETURN FALSE;
  ELSE
    FOR i := 0 TO nSets-1 DO
      s[i] := symSet[syFol, i] + symSet[repFol, i] + symSet[0, i];
    END;
    Error (n);
    WHILE ~((sym MOD setSize) IN s[sym DIV setSize]) DO Get(); END;
    RETURN StartOf (syFol);
  END;
END WeakSeparator;

-->productions

PROCEDURE Parse*;
BEGIN
  Get ();
-->parseRoot
END Parse;

BEGIN
-->initialization
END -->modulename.