MODULE VOButtonPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       BG  := VOBackground,
       BO  := VOBool,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       L   := VOLabel,
       O   := VOObject,
       P   := VOPanel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       SP  := VOSpace,
       V   := VOValue;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs       : B.PrefsDesc;
                frmSelDlg   : FSD.FrmSelDlg;
                sFrmSelDlg  : FSD.FrmSelDlg;
                iFrmSelDlg  : FSD.FrmSelDlg;
                tFrmSelDlg  : FSD.FrmSelDlg;
                frame       : F.Frame;
                sFrame      : F.Frame;
                iFrame      : F.Frame;
                tFrame      : F.Frame;
                highlight   : V.BoolModel;
                gridDisable : V.BoolModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Button";
    PG.settings.AddItem(d);

    NEW(d.frmSelDlg);
    d.frmSelDlg.Init;

    NEW(d.sFrmSelDlg);
    d.sFrmSelDlg.Init;

    NEW(d.iFrmSelDlg);
    d.iFrmSelDlg.Init;

    NEW(d.tFrmSelDlg);
    d.tFrmSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.prefs:=B.prefs^;

    d.frame.SetInternalFrame(d.prefs.frame);
    d.sFrame.SetInternalFrame(d.prefs.sFrame);
    d.iFrame.SetInternalFrame(d.prefs.iFrame);
    d.tFrame.SetInternalFrame(d.prefs.tFrame);
    d.frmSelDlg.SetFrame(d.prefs.frame);
    d.sFrmSelDlg.SetFrame(d.prefs.sFrame);
    d.iFrmSelDlg.SetFrame(d.prefs.iFrame);
    d.tFrmSelDlg.SetFrame(d.prefs.tFrame);
    d.highlight.SetBoolean(d.prefs.highlight);
    d.gridDisable.SetBoolean(d.prefs.gridDisable);
  END Refresh;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button    : B.Button;
    frame     : FG.FrameGroup;
    label     : L.Label;
    panel     : P.Panel;
    space     : SP.Space;
    bool      : BO.Bool;

  BEGIN
    d.frmSelDlg.SetDisplay(d.display);
    d.frmSelDlg.Forward(FSD.setMsg,d);

    d.sFrmSelDlg.SetDisplay(d.display);
    d.sFrmSelDlg.Forward(FSD.setMsg,d);

    d.iFrmSelDlg.SetDisplay(d.display);
    d.iFrmSelDlg.Forward(FSD.setMsg,d);

    d.tFrmSelDlg.SetDisplay(d.display);
    d.tFrmSelDlg.Forward(FSD.setMsg,d);

    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Frames");

        NEW(label);
        label.Init;

          button:=PG.CreateFrameButton(d.prefs.frame,d.frame,d.display,d.frmSelDlg,
                                       d.window.keyHandler,"Select button frame");
        label.AddTextLabel("normal",button);

          button:=PG.CreateFrameButton(d.prefs.sFrame,d.sFrame,d.display,d.sFrmSelDlg,
                                       d.window.keyHandler,"Select small button frame");
        label.AddTextLabel("small",button);

          button:=PG.CreateFrameButton(d.prefs.iFrame,d.iFrame,d.display,d.iFrmSelDlg,
                                       d.window.keyHandler,"Select button frame");
        label.AddTextLabel("image",button);

          button:=PG.CreateFrameButton(d.prefs.tFrame,d.tFrame,d.display,d.tFrmSelDlg,
                                       d.window.keyHandler,"Select toolbar frame");
        label.AddTextLabel("toolbar",button);
      frame.Add(label);

    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,SP.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Options");

        NEW(label);
        label.Init;

          NEW(d.highlight);
          d.highlight.Init;
          d.highlight.SetBoolean(d.prefs.highlight);

          NEW(bool);
          bool.Init;
          bool.SetModel(d.highlight);
          d.window.keyHandler.AddFocusObject(bool);
          bool.Forward(BO.clickedMsg,d);
        label.AddTextLabel("Highlight label",bool);

          NEW(d.gridDisable);
          d.gridDisable.Init;
          d.gridDisable.SetBoolean(d.prefs.gridDisable);

          NEW(bool);
          bool.Init;
          bool.SetModel(d.gridDisable);
          d.window.keyHandler.AddFocusObject(bool);
          bool.Forward(BO.clickedMsg,d);
        label.AddTextLabel("disable with grid",bool);
      frame.Add(label);
    panel.Add(frame);

    RETURN panel;
  END GetObject;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer   : ARRAY 256 OF CHAR;
    pos      : LONGINT;
    top      : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Button",appName);
    IF top=NIL THEN
      RETURN;
    END;
    top:=top.GetEntry("BUTTON");
    IF top=NIL THEN
      RETURN;
    END;

    IF top.GetStringEntry("frame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        B.prefs.frame:=pos;
      ELSE
        p.ErrorWrongData("BUTTON/frame",buffer);
      END;
    END;

    IF top.GetStringEntry("sFrame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        B.prefs.sFrame:=pos;
      ELSE
        p.ErrorWrongData("BUTTON/sFrame",buffer);
      END;
    END;

    IF top.GetStringEntry("iFrame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        B.prefs.iFrame:=pos;
      ELSE
        p.ErrorWrongData("BUTTON/iFrame",buffer);
      END;
    END;

    IF top.GetStringEntry("tFrame",buffer) THEN
      pos:=F.GetFrameEntry(buffer);
      IF pos>=0 THEN
        B.prefs.tFrame:=pos;
      ELSE
        p.ErrorWrongData("BUTTON/tFrame",buffer);
      END;
    END;

    B.prefs.highlight:=top.GetBoolEntry("highlight",B.prefs.highlight);
    B.prefs.gridDisable:=top.GetBoolEntry("gridDisable",B.prefs.gridDisable);

    B.prefs.background:=BG.LoadBackground(top);
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    B.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("BUTTON");
      NEW(value);
      value.Init;
      value.SetValue("frame",F.internalFrames[p.prefs.frame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("sFrame",F.internalFrames[p.prefs.sFrame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("iFrame",F.internalFrames[p.prefs.iFrame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("tFrame",F.internalFrames[p.prefs.tFrame]);
    block.AddItem(value);

      NEW(value);
      value.Init;
      value.SetBool("highlight",p.prefs.highlight);
    block.AddItem(value);

      NEW(value);
      value.Init;
      value.SetBool("gridDisable",p.prefs.gridDisable);
    block.AddItem(value);

    BG.SaveBackground(block,p.prefs.background);

    p.SaveItems("Button",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        IF message.source=p.frmSelDlg THEN
          p.frame.SetInternalFrame(message.frame);
          p.prefs.frame:=message.frame;
        ELSIF message.source=p.sFrmSelDlg THEN
          p.sFrame.SetInternalFrame(message.frame);
          p.prefs.sFrame:=message.frame;
        ELSIF message.source=p.iFrmSelDlg THEN
          p.iFrame.SetInternalFrame(message.frame);
          p.prefs.iFrame:=message.frame;
        ELSE
          p.tFrame.SetInternalFrame(message.frame);
          p.prefs.tFrame:=message.frame;
        END;
    | message : BO.ClickedMsg DO
        p.prefs.highlight:=p.highlight.GetBoolean();
        p.prefs.gridDisable:=p.gridDisable.GetBoolean();
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOButtonPrefs.