/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_linux_audiofile.h
|
| Revision    : 1.0
| Date        : 26/03/97
|
| Object      : None
|
| Description : Audiofile replacement code for linux
|
| (c) Richard Kent 1997
|
| $Id$
|
****************************************************************************/

#ifdef LINUX

#ifndef _DPTich_linux_audiofile_h
#define _DPTich_linux_audiofile_h

//#define AMIGA

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <fcntl.h>
#include <unistd.h>
#include "DPTich_linux_ieee.h"

typedef struct
{
  unsigned long timeStamp;
  short marker;
  unsigned short count;
  char *text;
} commentType;

typedef struct
{
  long id;
  char *name;
  long position;
} markType;

typedef struct
{
  long id;
  long midibasenote;
  long midihinote;
  long midihivelocity;
  long midilonote;
  long midilovelocity;
  long numcentsdetune;
  long numdbsgain;
  long susloopid;
  long relloopid;
} instType;

typedef struct
{
  long id;
  long mode;
  long start;
  long end;
} loopType;

typedef struct
{
  long id;
  long type;
  long size;
  long current;
  char *data;
} miscType;

typedef struct
{
  long filefmt;
  unsigned long version;
  long audiotrack;
  double rate;
  long sampfmt;
  long width;
  long channels;
  long compression;
  long aesdatapresent;
  unsigned char aesdata [24];
  long framecount;
  long marks;
  markType *mark;
  long insts;
  instType *inst;
  long loops;
  loopType *loop;
  long miscs;
  miscType *misc;
} aiffType;

typedef struct
{
  long mode;
  int file;
  long actualBytes;
  long actualFrames;
  long ssndStart;
  aiffType aiff;
} aiffHandle;

typedef aiffType *AFfilesetup;
typedef aiffHandle *AFfilehandle;
typedef void (*AFerrfunc) (long,const char *);

#define AF_NULL_FILESETUP                       0
#define AF_NULL_FILEHANDLE                      0
#define AF_DEFAULT_TRACK                        1001
#define AF_DEFAULT_INST                         2001
#define AF_SAMPFMT_TWOSCOMP                     401
#define AF_FILE_UNSUPPORTED                     -2
#define AF_FILE_UNKNOWN                         -1
#define AF_FILE_AIFFC                           1
#define AF_FILE_AIFF                            2
#define AF_LOOP_MODE_NOLOOP                     0
#define AF_LOOP_MODE_FORW                       1
#define AF_LOOP_MODE_FORWBAKW                   2
#define AF_INST_MIDI_BASENOTE                   301   
#define AF_INST_NUMCENTS_DETUNE                 302   
#define AF_INST_MIDI_LONOTE                     303
#define AF_INST_MIDI_HINOTE                     304
#define AF_INST_MIDI_LOVELOCITY                 305
#define AF_INST_MIDI_HIVELOCITY                 306
#define AF_INST_NUMDBS_GAIN                     307
#define AF_INST_SUSLOOPID                       308
#define AF_INST_RELLOOPID                       309
#define AF_MISC_AIFF_COPY                       201
#define AF_MISC_AIFF_AUTH                       202
#define AF_MISC_AIFF_NAME                       203
#define AF_MISC_AIFF_ANNO                       204
#define AF_MISC_AIFF_APPL                       205
#define AF_MISC_AIFF_MIDI                       206
#define AF_MISC_AIFF_UNRECOGNIZED               0
#define AF_COMPRESSION_UNKNOWN                  -1
#define AF_COMPRESSION_NONE                     0
#define AF_COMPRESSION_G722                     501
#define AF_COMPRESSION_G711_ULAW                502
#define AF_COMPRESSION_G711_ALAW                503
#define AF_COMPRESSION_APPLE_ACE2               504
#define AF_COMPRESSION_APPLE_ACE8               505
#define AF_COMPRESSION_APPLE_MAC3               506
#define AF_COMPRESSION_APPLE_MAC6               507
#define AF_COMPRESSION_AWARE_MPEG               515 
#define AF_COMPRESSION_AWARE_MULTIRATE          516
#ifndef AMIGA
#define AF_COMPRESSION_AWARE_DEFAULT_MPEG_I	    508
#define AF_COMPRESSION_AWARE_DEFAULT_MPEG_II	509
#endif
#define AF_COMPRESSION_AWARE_DEFAULT_MULTIRATE	513
#define AF_COMPRESSION_AWARE_DEFAULT_LOSSLESS	514
#define AU_LICENSE_AWARE_MPEG_ENCODER           1
#define AU_LICENSE_AWARE_MPEG_DECODER           2
#define AU_LICENSE_AWARE_MULTIRATE_ENCODER      3
#define AU_LICENSE_AWARE_MULTIRATE_DECODER      4
#define AU_LICENSE_OK                           0
#define AU_LICENSE_ERR                          -1
#define AU_BAD_PRODUCT                          -2
#define AU_PVTYPE_LONG                          1
#define AU_PVTYPE_DOUBLE                        2
#define AU_PVTYPE_PTR                           3
#define AU_NULL_PVLIST                          0
#define AIFCVersion1                            0xA2805140

#define READONLY                                0
#define WRITEONLY                               1
#define TRUE                                    1
#define FALSE                                   0

AFerrfunc AFseterrorhandler (AFerrfunc efunc);
AFfilesetup AFnewfilesetup (void);
void AFfreefilesetup (AFfilesetup setup);
void AFinitfilefmt (AFfilesetup setup,long fmt);
void AFinitrate (AFfilesetup setup,long trackid,double rate);
void AFinitsampfmt (AFfilesetup setup,long trackid,long fmt,long width);
void AFinitchannels (AFfilesetup setup,long trackid,long channels);
void AFinitaeschanneldata (AFfilesetup setup,long trackid);
void AFsetaeschanneldata (
  AFfilehandle file,
  long trackid,
  unsigned char buf [24]);
void AFinitcompression (AFfilesetup setup,long trackid,long compression);
void AFinitmarkids (
  AFfilesetup setup,
  long trackid,
  long *markids,
  long nmarks);
void AFinitmarkname (
  AFfilesetup setup,
  long trackid,
  long markid,
  const char *name);
void AFinitinstids (AFfilesetup setup,long *instids,long ninsts);
void AFinitloopids (AFfilesetup setup,long instid,long *loopids,long nloops);
void AFinitmiscids (AFfilesetup setup,long *miscids,long nmiscs);
void AFinitmisctype (AFfilesetup setup,long miscid,long type);
void AFinitmiscsize (AFfilesetup setup,long miscid,long size);
int AUchecklicense (int product,int *errorval,char **message);
AFfilehandle AFopenfile (
  const char *name,
  const char *mode,
  AFfilesetup setup);
AFfilehandle AFopenfd (int file,const char *mode,AFfilesetup setup);
int AFgetfd (AFfilehandle handle);
long AFclosefile (AFfilehandle handle);
long AFgetfilefmt (AFfilehandle handle,long *version);
long AFidentifyfd (int fd);
double AFgetrate (AFfilehandle handle,long trackid);
void AFgetsampfmt (
  AFfilehandle handle,
  long trackid,
  long *sampfmt,
  long *width);
long AFgetchannels (AFfilehandle handle,long trackid); 
long AFgetaeschanneldata (
  AFfilehandle handle,
  long trackid,
  unsigned char buf [24]);
long AFgetcompression (AFfilehandle handle,long trackid);
char *AFgetcompressionname (AFfilehandle handle,long trackid);
long AFgetframecnt (AFfilehandle handle,long trackid);
long AFgetmarkids (AFfilehandle handle,long trackid,long *markids);
char *AFgetmarkname (AFfilehandle handle,long trackid,long markid);
long AFgetmarkpos (AFfilehandle handle,long trackid,long markid);
void AFsetmarkpos (
  AFfilehandle handle,
  long trackid,
  long markid,
  long markpos);
long AFgetinstids (AFfilehandle handle,long *instids);
long AFgetinstparamlong (AFfilehandle handle,long instid,long param);
void AFsetinstparamlong (
  AFfilehandle handle,
  long instid,
  long param,
  long value);
long AFgetloopids (AFfilehandle handle,long *loopids);
long AFgetloopmode (AFfilehandle handle,long instid,long loopid);
void AFsetloopmode (AFfilehandle handle,long instid,long loopid,long mode);
long AFgetloopstart (AFfilehandle handle,long instid,long loopid);
void AFsetloopstart (
  AFfilehandle handle,
  long instid,
  long loopid,
  long markid);
long AFgetloopend (AFfilehandle handle,long instid,long loopid);
void AFsetloopend (AFfilehandle handle,long instid,long loopid,long markid);
long AFgetmiscids (AFfilehandle handle,long *miscids);
long AFgetmisctype (AFfilehandle handle,long miscid);
long AFgetmiscsize (AFfilehandle handle,long miscid);
long AFreadmisc (AFfilehandle handle,long miscid,void *buf,long nbytes);
long AFwritemisc (AFfilehandle handle,long miscid,void *buf,long nbytes);
void AFseekmisc (AFfilehandle handle,long miscid,long offset);
long AFreadframes (
  AFfilehandle handle,
  long trackid,
  void *frames,
  long count);
long AFwriteframes (
  AFfilehandle handle,
  long trackid,
  void *frames,
  long count);
long AFseekframe (AFfilehandle handle,long trackid,long offset);
void initialiseMiscs (AFfilehandle handle);
void initialiseSetup (AFfilesetup setup);
void blankSetup (AFfilesetup setup);
void copySetup (AFfilesetup from,AFfilesetup to);
void freeSetup (AFfilesetup setup);

/* Unused defines */

#define AF_AWARE_PARAM_LAYER                    530000
#define AF_AWARE_LAYER_I                        530001
#define AF_AWARE_LAYER_II                       530002
#define AF_AWARE_PARAM_CHANNEL_POLICY           510000
#define AF_AWARE_JOINT_STEREO                   510001
#define AF_AWARE_STEREO                         510002
#define AF_AWARE_INDEPENDENT                    510003
#define AF_AWARE_PARAM_BITRATE_TARGET           511000
#define AF_AWARE_PARAM_CONST_QUAL_NMR           514000
#define AF_AWARE_PARAM_BITRATE_POLICY           517000
#define AF_AWARE_FIXED_RATE                     517001
#define AF_AWARE_CONST_QUAL                     517002
#define AF_AWARE_LOSSLESS                       517003
#define AF_BAD_NOT_IMPLEMENTED                  0
#define AF_BAD_FILEHANDLE                       1
#define AF_BAD_OPEN                             3
#define AF_BAD_CLOSE                            4
#define AF_BAD_READ                             5  
#define AF_BAD_WRITE                            6  
#define AF_BAD_LSEEK                            7  
#define AF_BAD_NO_FILEHANDLE                    8  
#define AF_BAD_ACCMODE                          10 
#define AF_BAD_NOWRITEACC                       11 
#define AF_BAD_NOREADACC                        12 
#define AF_BAD_FILEFMT                          13 
#define AF_BAD_RATE                             14 
#define AF_BAD_CHANNELS                         15 
#define AF_BAD_SAMPCNT                          16 
#define AF_BAD_WIDTH                            17 
#define AF_BAD_SEEKMODE                         18 
#define AF_BAD_NO_LOOPDATA                      19 
#define AF_BAD_MALLOC                           20 
#define AF_BAD_LOOPID                           21
#define AF_BAD_SAMPFMT                          22 
#define AF_BAD_FILESETUP                        23 
#define AF_BAD_TRACKID                          24 
#define AF_BAD_NUMTRACKS                        25 
#define AF_BAD_NO_FILESETUP                     26 
#define AF_BAD_LOOPMODE                         27 
#define AF_BAD_INSTID                           28 
#define AF_BAD_NUMLOOPS                         29 
#define AF_BAD_NUMMARKS                         30 
#define AF_BAD_MARKID                           31 
#define AF_BAD_MARKPOS                          32 
#define AF_BAD_NUMINSTS                         33 
#define AF_BAD_NOAESDATA                        34 
#define AF_BAD_MISCID                           35
#define AF_BAD_NUMMISC                          36
#define AF_BAD_MISCSIZE                         37
#define AF_BAD_MISCTYPE                         38
#define AF_BAD_MISCSEEK                         39
#define AF_BAD_STRLEN                           40 
#define AF_BAD_RATECONV                         45
#define AF_BAD_SYNCFILE                         46
#define AF_BAD_CODEC_CONFIG                     47 
#define AF_BAD_CODEC_STATE                      48 
#define AF_BAD_CODEC_LICENSE                    49 
#define AF_BAD_CODEC_TYPE                       50 
#define AF_BAD_COMPRESSION                      AF_BAD_CODEC_CONFIG
#define AF_BAD_COMPTYPE                         AF_BAD_CODEC_TYPE
#define AF_BAD_AIFF_HEADER                      108  
#define AF_BAD_AIFF_FORM                        109  
#define AF_BAD_AIFF_SSND                        110  
#define AF_BAD_AIFF_CHUNKID                     111  
#define AF_BAD_AIFF_COMM                        112  
#define AF_BAD_AIFF_INST                        113  
#define AF_BAD_AIFF_MARK                        114  
#define AF_BAD_AIFF_SKIP                        115  
#define AF_BAD_AIFF_LOOPMODE                    116  

/* Unimplemented code

typedef struct
{
} audioList;

typedef audioList *AUpvlist;

long AFsyncfile (AFfilehandle handle);
long AFgettrackids (AFfilehandle handle,long *trackids);
void AFinittrackids (AFfilesetup setup,long *trackids,long ntracks);
void AFsetlooptrack (AFfilehandle handle,long inst,long loopid,long trackid);
long AFgetlooptrack (AFfilehandle handle,long inst,long loopid);
void AFinitcompressionparams (
  AFfilesetup setup,
  long trackid,
  long compression,
  AUpvlist pvlist,
  long numitems);
void AFgetcompressionparams (
  AFfilehandle handle,
  long trackid,
  long *compression,
  AUpvlist pvlist,
  long numitems);
AUpvlist AUpvnew (int maxitems);
int AUpvgetmaxitems (AUpvlist pvlist);
int AUpvfree (AUpvlist pvlist);
int AUpvsetparam (AUpvlist pvlist,int item,int param);
int AUpvsetvaltype (AUpvlist pvlist,int item,int type);
int AUpvsetval (AUpvlist pvlist,int item,void *val);
int AUpvgetparam (AUpvlist pvlist,int item,int *param);
int AUpvgetvaltype (AUpvlist pvlist,int item,int *type);
int AUpvgetval (AUpvlist pvlist,int item,void *val);

*/

#endif // _DPTich_linux_audiofile_h

#endif // linux

/***************************************************************************/
