/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : bwlowpas.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitBWLowPassFilter
|
| Description : DSPKitBWLowPassFilter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char bwlowpas_cc [] = "$Id$";

#include "bwlowpas.h"

void DSPKitBWLowPassFilter::setCutOffFreq (double f)
{
  cutOffFreq = f;
  C = 1.0 / tan (M_PI * cutOffFreq / inputSamplingRate);

  a [0] = 1.0 / (1.0 + sqrt (2.0) * C + C * C);
  a [1] = 2.0 * a [0];
  a [2] = a [0];

  b [0] = 2.0 * (1.0 - C * C) * a [0];
  b [1] = (1.0 - sqrt (2.0) * C + C * C) * a [0];
}

/***************************************************************************/
