/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : comb.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitComb
|
| Description : DSPKitComb
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_COMB_H_
#define _DSPKIT_COMB_H_

#include "processo.h"
#include "fbdelay.h"
#include "amp.h"
#include "mux.h"
#include "feedback.h"

class DSPKitComb : public DSPKitProcessor
{
  public:

    long setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    void setReverbTime (double rt);
    void setG (double newG);
    double getReverbTime () const;
    double getG () const;

  protected:

    double         reverbTime;
    double         delayTime;
    double         g;
    DSPKitFeedback feedback;
    DSPKitFBDelay  fbdelay;
    DSPKitAmp      amp;
    DSPKitMux      mux;
};

inline double DSPKitComb::getReverbTime () const
{
  return reverbTime;
}

inline double DSPKitComb::getG () const
{
  return g;
}

#endif

/***************************************************************************/
