/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : combint.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitCombInt
|
| Description : DSPKitCombInt
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_COMBINT_H_
#define _DSPKIT_COMBINT_H_

#include "processo.h"
#include "delayint.h"
#include "amp.h"
#include "mux.h"
#include "feedback.h"

class DSPKitCombInt : public DSPKitProcessor
{
  public:

    long setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    long setModInput (DSPKitProcessor *mip);
    void setReverbTime (double rt);
    void setG (double newG);
    double getReverbTime () const;
    double getG () const;

  protected:

    double         reverbTime;
    double         delayTime;
    double         g;
    DSPKitFeedback feedback;
    DSPKitDelayInt fbdelay;
    DSPKitAmp      amp;
    DSPKitMux      mux;
};

inline double DSPKitCombInt::getReverbTime () const
{
  return reverbTime;
}

inline double DSPKitCombInt::getG () const
{
  return g;
}

#endif

/***************************************************************************/
