/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : schroede.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitSchroederReverb
|
| Description : DSPKitSchroederReverb
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char schroede_cc [] = "$Id$";

#include "schroede.h"

long DSPKitSchroederReverb::setInput (DSPKitProcessor *ip)
{
  return setInput (ip,1.0,1.0);
}

long DSPKitSchroederReverb::setInput
  (DSPKitProcessor *ip,double size,double spread)
{
  mux.setInput (ip);
  comb1.setInputAndDelayTime (&mux,0.0297 * size);
  comb2.setInputAndDelayTime (&mux,0.0371 * size);
  comb3.setInputAndDelayTime (&mux,0.0411 * size);
  comb4.setInputAndDelayTime (&mux,0.0437 * size);
  sum.setInput (&comb1);
  sum.addInput (&comb2);
  sum.addInput (&comb3);
  sum.addInput (&comb4);
  amp.setInput (&sum);
  amp.setGain (0.25);
  allpass1.setInputAndDelayTime (&amp,0.005 * spread);
  allpass2.setInputAndDelayTime (&allpass1,0.0017 * spread);
  return DSPKitProcessor::setInput (&allpass2);
}

void DSPKitSchroederReverb::setReverbTime (double rt)
{
  reverbTime = rt;
  comb1.setReverbTime (reverbTime);
  comb2.setReverbTime (reverbTime);
  comb3.setReverbTime (reverbTime);
  comb4.setReverbTime (reverbTime);
  allpass1.setReverbTime (0.096835);
  allpass2.setReverbTime (0.032924);
}

/***************************************************************************/
