/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : waveshap.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitWaveShaper
|
| Description : DSPKitWaveShaper
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_WAVESHAPER_H_
#define _DSPKIT_WAVESHAPER_H_

#include "processo.h"
#include "dpreader.h"
#include "dist.h"

class DSPKitWaveShaper : public DSPKitProcessor
{
  public:

    DSPKitWaveShaper ();
    ~DSPKitWaveShaper ();
    long setInputAndBuffer (DSPKitProcessor *ip,DSPKitDPReader *bip);
    long setInputAndBuffer (DSPKitProcessor *ip,DSPKitDistortion *bip);
    long getSample (double &outputSample);

  protected:

    long   size;
    double *buffer;
    double maxValue;
    double minValue;
    double range;
};

inline DSPKitWaveShaper::DSPKitWaveShaper ()
{
  buffer = 0;
  size   = 0;
}

inline DSPKitWaveShaper::~DSPKitWaveShaper ()
{
  if (buffer) delete [] buffer;
}

#endif

/***************************************************************************/
