#!/bin/sh
# setcolor: Programma per il settaggio dei colori della console
#           scritto da Paolo Bongiorno <p_bongiorno@oasi.net>
#           Favara (AG). 13/12/97.
# ===============================================================#
# /*   ----- SCRIVE LINEE E COLONNE -----  */
cup() {
	tput cup $1 $2
}
##################################################################
##### SCRIPT DI ESTRAZIONE DEI CARATTERI GRAFICI DA TERMINFO #####
##################################################################
grf() {
## Questa funzione assicura la compatibilita' con i vari
## terminali grafici.

## COLORE:
setterm -foreground white -background blue -store
clear
###
####
#####  tput acsc: -- Estrae Tutto il set sei caratteri grafici --

##      --------------  VARIABILI ---------------
        REV=`tput rev`  ### MODO REVERSE
        NOR=`tput sgr0` ### RIPORTA A ZERO TUTTI I PAREMETRI
	SG=`tput smacs` ### SET DI CARATTERI ALTERNATO (Carattere su fondo nero)
	RG=`tput rmacs` ### FINE DEL SET DI CARATTERI ALTERNATO
	CS=`tput acsc`  ### SET DI CARATTERI GRAFICI DOPPI

	if [ "$CS" = "" ]  # Se non ci sono caratteri grafici le
	then  	# variabili assumono questi valori:
		CAS="+";  CCS="+";  CAI="+";  CCI="+"; LC="-"
                L="-------------------"; LCO=$L$L$L$L 
	else
        cup 01 01;echo -e "\033[33;40;5m\033[1mCaricamento dei caratteri semigrafici in corso\033[0m\c"
        cup 03 01;echo -e "\033[33;44;1m\c"
		S=1
                #  -------- Estrae i C.S.G due alla volta ----------
        	CG=`echo $CS $S | awk '{z=substr($1,$2,2);print z}'` 
		while [ "$CG" != "" ]
		do
			# Isola il carattere che precede quello grafico
			I=`echo $CG | awk '{z=substr($1,1,1);print z}'`
			# Estrae i caratteri grafici uno alla volta
			H=`echo $CG | awk '{z=substr($1,2,1);print z}'`
			case $I in
				l) CAS=$H;;
				m) CAI=$H;;
				k) CCS=$H;;
				j) CCI=$H;;
				x) LV=$H;;
				q) LL=$H
			esac
			S=`expr $S + 2`
			CG=`echo $CS $S | awk '{z=substr($1,$2,2);print z}'`
			echo -e "\033[31;7m \c"
		done
	        echo -e "\033[0m\c"
	fi
###
IN=`echo "$SG$L$LV$RG$REV"`  ### INGLOBA VARIABILI: Ingresso
US=`echo "$NOR$SG$LV$RG"`    ### INGLOBA VARIABILI: Uscita
# LINEA ORIZZONTALE (se preceduta da SG )
L=$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL$LL 
LCO=$L$L$L$L                      # LINEA COMPLETA ORIZZONTALE
LC=$LL                            # LINEA CARATTERE
}
grf

## Main
main() {
clear
## -------- INTESTAZIONE ---------
 head() {
 cup 00 01; echo $SG$CAS$LCO$CCS$RG
 cup 01 01; echo -e "$IN\033[42;30;7m *** Setcolor ***    ---  Script Per la Selezione Veloce Dei Colori  ---    $US\033[0m"
 cup 02 01; echo $SG$CAI$LCO$C$CCI$RG
 }
 head||break

## ----------- PIEDE ------------
pie() {
 cup 21 01; echo $SG$CAS$LCO$CCS$RG
 cup 22 01; echo -e "$IN\033[42;30;7m -- Free Software By Paolo Bongiorno -- *  Email: p_bongiorno@oasi.net * -  $US\033[0m"
 cup 23 01; echo $SG$CAI$LCO$C$CCI$RG
 }
 pie||break

## Menu
menu() {
cup 04 01;echo -e "$SG$CAS$L$L$CCS$RG"
cup 05 01;echo -e "$IN\033[42;30;7m Menu:                                $US\033[0m"
cup 06 01;echo -e "$SG$LV$RG 1) Seleziona La Griglia Dei Colori   $SG$LV$RG"
cup 07 01;echo -e "$SG$LV$RG 2) Uscita    $SG$CAS$L$LC$LC$LC$LC$CCI$RG"
cup 08 01;echo -e "$SG$CAI$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$CCI$RG"
echo
}

## Dati
dati() {
cup 11 45;echo -e "\033[33;44;1mTerminale    : `tty`"
cup 12 45;echo -e "Utente       : `id -un`"
cup 13 45;echo -e "Nome Sistema : `hostname`"
cup 14 45;echo -e "Kernel       : `uname -r`"
cup 15 45;echo -e "Processore   : `uname -m`\033[0m"
}
dati||break

## Menu
menu||break
scl() {
cup 09 01; echo "$SG$CAS$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$SG$CCS$RG"
cup 11 01; echo "$SG$CAI$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$SG$CCI$RG"
while cup 10 01;echo -e "$IN$REV\033[42;30;7mSCELTA :__    $NOR$US\b\b\b\b\b\b\b\c"
do read r
case $r in
"1") clear
  setta() {
    uscita() {
        setterm -$BOLD -foreground $FORE -background $BACK -store
        clear
        exit
     }
  profile() {
  while cup 16 04;echo -e "\033[;32;44;1mVuoi Aggiornare ".bash_profile" ? S/N: \033[;0m\c"
  do read r
  case $r in
  S|s) if grep setterm $HOME/.bash_profile >/dev/null
       then
         sost() {
         echo "setterm -$BOLD -foreground $FORE -background $BACK -store" \
         >/tmp/colore
        awk '/setterm/ { getline <"/tmp/colore" } { print }' $HOME/.bash_profile
	}
	sost >$HOME/temp 
	cp $HOME/temp $HOME/.bash_profile
        rm $HOME/temp /tmp/colore
        uscita||break
        else 
             cp -f $HOME/.bash_profile $HOME/.bash_profile.old
             prf() {
             echo "# - setcolor - Settaggio Del Colore:"
             echo "setterm -$BOLD -foreground $FORE -background $BACK -store" 
             echo
             }
             prf >$HOME/.bash_profile
             cat $HOME/.bash_profile.old >>$HOME/.bash_profile
        uscita||break
        fi;;
   N|n) uscita||break;;
   *) echo -e "\007";profile||break
  esac
  done
 }

  conf() {
  cup 12 50; setterm -$BOLD -foreground $FORE -background $BACK -store;echo -e \
  "\033[;5m Colore Selezionato \033[;0m";setterm -foreground white -background blue \
  -store
  while cup 16 04;echo -e "\033[;33;44;1mConfermi ? S/N/Q: \033[;0m\c"
  do read r
  case $r in
  S|s) profile||break;;
  N|n) ssf||break;;
  Q|q) setterm -default -store
       clear;exit;;
    *) echo -e "\007"
  esac
  done
  }
  conf||break
 }

  evid() {
  # Numeri dei colori In Primo Piano
  # l=Luminoso.
  # Nero=30; Grigio=30;1m; Rosso=31; Rosso_l=31;1m; Verde=32; Verde_l=32;1m
  # Marrone=33; Giallo=33;1m; Blu=34; Blu_l=34;1m; Viola=35;
  # Viola_l=35;1m; Celeste=36; Celeste_l=36;1m; Bianco=37; Bianco_l=371m;
  cup 03 20;echo  -e "\033[;31;44;1m$SG$LC$LC$RG Griglia Dei Colori In \
Evidenza $SG$LC$LC$RG\033[;0m"
  VAL=0
  RIGA=5
  COLONNA=5
  COLORE=30
  while [ $VAL -lt 8 ]
  do
  cup $RIGA $COLONNA;echo -e "$COLORE\033[$COLORE;3m$SG$LV$LC$LC$LC$LC$LC$LC$SG$LV$RG\033[0m"
  COLONNA=`expr $COLONNA + 11`
  cup $RIGA $COLONNA;echo -e "$COLORE"L"\033[$COLORE;1m$SG$LV$LC$LC$LC$LC$LC$SG$LV$RG\033[0m"
  COLONNA=`expr $COLONNA + 11`
  VAL=`expr $VAL + 1`
  if [ $COLONNA -gt 60 ]
  then RIGA=`expr $RIGA + 2`
       COLONNA=5
  fi
  COLORE=`expr $COLORE + 1`
  done
  }
  ssf() {
  ## Numeri dei colori di fondo:
  # Nero=40; Rosso=41; Verde=42; Marrone=43; Blu=44; Viola=45;
  # Celeste=46; Grigio=47.
  clear
  head||break
  pie||break
  cup 03 20;echo  -e "\033[;31;44;1m$SG$LC$LC$RG Griglia Dei Colori Di \
Fondo $SG$LC$LC$RG\033[;0m"
  VAL=0
  RIGA=5
  COLONNA=5
  COLORE=40
  while [ $VAL -lt 8 ]
  do
  cup $RIGA $COLONNA;echo -e "$COLORE\033[$COLORE;1m$SG$LV$RG      $SG$LV$RG\033[0m"
  VAL=`expr $VAL + 1`
  COLONNA=`expr $COLONNA + 11`
  if [ $COLONNA -gt 60 ]
  then RIGA=`expr $RIGA + 2`
       COLONNA=5
  fi
  COLORE=`expr $COLORE + 1`
  done
  sfondo() {
cup 12 01; echo "$SG$CAS$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$SG$CCS$RG"
cup 14 01; echo "$SG$CAI$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$LC$SG$CCI$RG"
while cup 13 01;echo -e "$IN$REV\033[42;30;7mSCELTA :__    $NOR$US\b\b\b\b\b\b\b\c"
  do read r
  case $r in
  "40") BACK=black; evid||break;;
  "41") BACK=red; evid||break;;
  "42") BACK=green; evid||break;;
  "43") BACK=yellow; evid||break;;
  "44") BACK=blue; evid||break;;
  "45") BACK=magenta; evid||break;;
  "46") BACK=cyan; evid||break;;
  "47") BACK=white; evid||break;;
  "30") FORE=black;BOLD="bold off";setta||break;;
  "30L"|"30l") FORE=black;BOLD="bold on";setta||break;;
  "31") FORE=red;BOLD="bold off";setta||break;;
  "31L"|"31l") FORE=red;BOLD="bold on";setta||break;;
  "32") FORE=green;BOLD="bold off";setta||break;;
  "32L"|"32l") FORE=green;BOLD="bold on";setta||break;;
  "33") FORE=yellow;BOLD="bold off";setta||break;;
  "33L"|"33l") FORE=yellow;BOLD="bold on";setta||break;;
  "34") FORE=blue;BOLD="bold off";setta||break;;
  "34L"|"34l") FORE=blue;BOLD="bold on";setta||break;;
  "35") FORE=magenta;BOLD="bold off";setta||break;;
  "35L"|"35l") FORE=magenta;BOLD="bold on";setta||break;;
  "36") FORE=cyan;BOLD="bold off";setta||break;;
  "36L"|"36l") FORE=cyan;BOLD="bold on";setta||break;;
  "37") FORE=white;BOLD="bold off";setta||break;;
  "37L"|"37l") FORE=white;BOLD="bold on";setta||break;;
  *) echo -e "\007"
  esac
  done
  }
  sfondo||break
 }
 ssf||break;;
"2") clear
     exit;;
 *) echo -e "\007"
 esac
done
}
scl||break
}
main||break
#fine
