/*$Id: c_help.cc,v 14.12 1999/07/23 10:13:54 al Exp $ -*- C++ -*-
 * Accesses a help file to provide on-line documentation.
 * Will follow the executables path to find it.
 */
#include "ap.h"
#include "md.h"
#include "c_comand.h"
// testing=nonstrict
/*--------------------------------------------------------------------------*/
//	void	CMD::help(CS&);
/*--------------------------------------------------------------------------*/
void CMD::help(CS& cmd)
{
  static FILE *hfn;
  char buffer[BUFLEN];
  
  if (hfn)
    fclose(hfn);
  std::string name = findfile(HELPFILE, HELPPATH, R_OK);
  if (name.empty())
    error(bERROR, "Help not available\n");
  hfn = fopen(name.c_str(), "r");
  if (!hfn)
    error(bERROR, "internal error: Can't open help file " + name + '\n');
  if (cmd.more())
    do {
      if (!fgets(buffer, BUFLEN, hfn)) {
	error(bWARNING, "No help on %s\n", cmd.tail());
	break;
      }
    } while (buffer[0]!=':'  ||  !cmd.pmatch(&buffer[1]));

  for (int line = 0; ; ++line){
    if (!fgets(buffer,BUFLEN,hfn))
      break;
    if (buffer[0]==':')
      break;
    if (line%23 == 22){		/* BUG: fixed screen length */
      CS nil("");
      pause(nil);
    }
    IO::error << buffer;
  }
  fclose(hfn);
  hfn = NULL;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
