/*$Id: d_coil.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * inductors
 * two levels: linear (lin) and nonlinear (nl) (not really)
 * x = amps, y.f0 = flux, ev = y.f1 = henrys
 */
#include "d_cccs.h"
#include "ap.h"
#include "d_coil.h"
/*--------------------------------------------------------------------------*/
//		DEV_MUTUAL_L::DEV_MUTUAL_L();
//		DEV_MUTUAL_L::DEV_MUTUAL_L(const DEV_MUTUAL_L& p);
//	void	DEV_MUTUAL_L::parse(CS&);
//	void	DEV_MUTUAL_L::print(int where, int detail)const;
//	void	DEV_MUTUAL_L::expand();

// 	bool	DEV_INDUCTANCE::do_tr();
// 	void	DEV_INDUCTANCE::tr_load();
// 	void	DEV_INDUCTANCE::tr_unload();
// 	void	DEV_INDUCTANCE::do_ac();
//	double	DEV_INDUCTANCE::tr_review();
//	void	DEV_INDUCTANCE::integrate();
/*--------------------------------------------------------------------------*/
DEV_MUTUAL_L::DEV_MUTUAL_L()
  :COMPONENT(),
   _output_label(),
   _output(0),
   _input_label(),
   _input(0)
{
}
/*--------------------------------------------------------------------------*/
DEV_MUTUAL_L::DEV_MUTUAL_L(const DEV_MUTUAL_L& p)
  :COMPONENT(p),
   _output_label(p._output_label),
   _output(p._output),
   _input_label(p._input_label),
   _input(p._input)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void DEV_MUTUAL_L::parse(CS& cmd)
{
  parse_Label(cmd);
  _output_label = cmd.ctos(TOKENTERM);
  _output_label[0] = toupper(_output_label[0]);
  _input_label = cmd.ctos(TOKENTERM);
  _input_label[0] = toupper(_input_label[0]);
  set_value(cmd.ctof());
}
/*--------------------------------------------------------------------------*/
void DEV_MUTUAL_L::print(OMSTREAM where, int)const
{
  where << short_label();
  {if (_output){
    where << ' ' << _output->short_label();
  }else{
    where << "  " << _output_label;
  }}
  {if (_input){
    where << ' ' << _input->short_label();
  }else{
    where << "  " << _input_label;
  }}
  where.setfloatwidth(7) << ' ' << value() << '\n';
}
/*--------------------------------------------------------------------------*/
// replace both primary and secondary (both simple L's)
// with the CCCS - L equivalent
// only works for 2.
void DEV_MUTUAL_L::expand()
{
  _output = find_in_scope(_output_label);
  _input  = find_in_scope(_input_label);
  _output->subckt().destroy();
  _input->subckt().destroy();

  double l1 = _output->value();
  double l2 = _input->value();
  double lm  = value() * sqrt(l1 * l2);
  double det = l1 * l2 - lm * lm;
  
  DEV_INDUCTANCE* pri = dynamic_cast<DEV_INDUCTANCE*>(_output->clone());
  if (!pri){
    untested();
    error(bERROR, 
	  long_label() + ": " + _output_label + " is not an inductor\n");
  }
  pri->set_owner(_output);
  pri->set_value(det / l2);
  _output->subckt().push_back(pri);

  DEV_INDUCTANCE* sec = dynamic_cast<DEV_INDUCTANCE*>(_input->clone());
  if (!sec){
    untested();
    error(bERROR, 
	  long_label() + ": " + _input_label + " is not an inductor\n");
  }
  sec->set_owner(_input);
  sec->set_value(det / l1);
  _input->subckt().push_back(sec);

  DEV_CCCS* sub = new DEV_CCCS;
  assert(sub);
  sub->set_owner(_output);
  sub->_input  = sec;
  sub->set_label("F" + sub->_input->short_label());
  sub->n[OUT1] = _output->n[OUT1];
  sub->n[OUT2] = _output->n[OUT2];
  sub->set_value(-lm / l1);
  _output->subckt().push_back(sub).expand();
  
  sub = new DEV_CCCS;
  assert(sub);
  sub->set_owner(_input);
  sub->_input  = pri;
  sub->set_label("F" + sub->_input->short_label());
  sub->n[OUT1] = _input->n[OUT1];
  sub->n[OUT2] = _input->n[OUT2];
  sub->set_value(-lm / l2);
  _input->subckt().push_back(sub).expand();

  assert(!constant()); /* because of integration */
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::dc_begin()
{
  {if (subckt().exists()){
    untested();
    subckt().dc_begin();
  }else{
    begin_core();
  }}
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::tr_begin()
{
  {if (subckt().exists()){
    subckt().tr_begin();
  }else{
    begin_core();
  }}
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::tr_restore()
{
  {if (subckt().exists()){
    untested();
    subckt().tr_restore();
  }else{
    begin_core();
  }}
}
/*--------------------------------------------------------------------------*/
bool DEV_INDUCTANCE::tr_needs_eval()
{
  {if (subckt().exists()){
    untested();
    return subckt().tr_needs_eval();
  }else{
    untested();
    return true;
  }}
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::tr_queue_eval()
{
  {if (subckt().exists()){
    subckt().tr_queue_eval();
  }else{
    q_eval();
  }}
}
/*--------------------------------------------------------------------------*/
bool DEV_INDUCTANCE::do_tr()
{
  {if (subckt().exists()){
    set_converged(subckt().do_tr());
  }else{
    initial_condition = NOT_INPUT;
    {if (has_tr_eval()){
      m0.x = volts_limited(n[OUT1],n[OUT2]);
      y0.x = m0.c0 + m0.c1 * m0.x;
      tr_eval();
      if (y0.f1 == 0.){
	untested();
	error(bPICKY, long_label() + ": short circuit\n");
	y0.f1 = OPT::shortckt;
      }
    }else{
      m0.x = n[OUT1].v0() - n[OUT2].v0();
      y0.x = m0.c0 + m0.c1 * m0.x;
      assert(y0.f1 == value());
      y0.f0 = y0.x * y0.f1;
      assert(converged());
    }}
    store_values();
    q_load();
    integrate();
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::tr_load()
{
  {if (subckt().exists()){
    subckt().tr_load();
  }else{
    tr_load_passive();
  }}
}
/*--------------------------------------------------------------------------*/
double DEV_INDUCTANCE::tr_review()
{
  {if (subckt().exists()){
    return subckt().tr_review();
  }else{
    return review(m0.x, mt1.x);    
  }}
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::tr_unload()
{
  {if (subckt().exists()){
    untested();
    subckt().tr_unload();
  }else{
    untested();
    tr_unload_passive();
  }}
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::ac_begin()
{
  {if (subckt().exists()){
    subckt().ac_begin();
  }else{
    ev = y0.f1;
  }}
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::do_ac()
{
  {if (subckt().exists()){
    subckt().do_ac();
  }else{
    {if (has_ac_eval()){
      ac_eval();
    }else{
      assert(ev == y0.f1);
      assert(has_tr_eval() || ev == value());
    }}
    {if (ev * SIM::jomega == 0.){
      untested();
      acg = 1. / OPT::shortckt;
    }else{
      acg = 1. / (ev * SIM::jomega);
    }}
    ac_load_passive();
  }}
}
/*--------------------------------------------------------------------------*/
void DEV_INDUCTANCE::integrate()
{
  {if (SIM::mode == sDC  ||  SIM::mode == sOP  ||  y0.f1 == 0.){
    m0.c1 = 1./OPT::shortckt;
    m0.c0 = 0.;
  }else if (SIM::phase == pINIT_DC){
    {if (time0 == 0.){
      {if (!SIM::uic){
	m0.c1 = 1./OPT::shortckt;
	m0.c0 = 0.;
      }else if (initial_condition != NOT_INPUT){
	untested();
	m0.c1 = 0.;
	m0.c0 = -initial_condition;
      }else{
	untested();
	m0.c1 = 1./OPT::shortckt;
	m0.c0 = 0.;
      }}
    }else{
      untested();
      /* leave it alone to restore */
    }}
  }else{
    double dt = time0 - time1;
    switch (method_a){
    case mGEAR:
    case mTRAPGEAR:
    case mTRAPEULER:
    case mEULER:
      untested();
      m0.c1 = dt / y0.f1;
      m0.c0 = mt1.c0 + mt1.c1 * mt1.x; /* oldi */
      break;
    case mTRAP:
      /* oldi = mt1.c0 + mt1.c1 * mt1.x; */
      m0.c1 = dt/(2*y0.f1);
      m0.c0 = mt1.c0 + (mt1.c1 + m0.c1) * mt1.x;
      /* oldi + f1*oldv, with combined terms */
      break;
    }
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
