/*$Id: d_subckt.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * subcircuit stuff
 * base class for other elements using internal subckts
 * netlist syntax:
 * device: Xxxxx <nodelist> <subckt-name>
 * model:  .subckt <subckt-name> <nodelist>
 *	   (device cards)
 *	   .ends <subckt-name>
 * storage note ...
 * the .subckt always has a comment at the hook point, so a for loop works
 * the expansion (attact to the X) has all comments removed
 *	- need to process the entire ring - for doesn't work
 */
#include "l_stlextra.h"
#include "c_comand.h"
#include "ap.h"
#include "d_subckt.h"
/*--------------------------------------------------------------------------*/
//		MODEL_SUBCKT::MODEL_SUBCKT(const char*);
//	void	MODEL_SUBCKT::parse(CS& cmd);
// 	void	MODEL_SUBCKT::print(int,int)const;

//	void	CMD::ends(CS&);

//		DEV_SUBCKT::DEV_SUBCKT();
//		DEV_SUBCKT::DEV_SUBCKT(const DEV_SUBCKT& p);
//	void	DEV_SUBCKT::parse(CS& cmd);
// 	void	DEV_SUBCKT::print(int,int)const;
//	void	DEV_SUBCKT::expand();
//	void    COMPONENT::expandsubckt(const std::string&);
//	double	DEV_SUBCKT::probe_tr_num(const std::string&)const;
/*--------------------------------------------------------------------------*/
int DEV_SUBCKT::Count = 0;
int SUBCKT_COMMON::Count = -1;
int MODEL_SUBCKT::Count = 0;
static SUBCKT_COMMON Default_SUBCKT(CC_STATIC);

struct SSNODE {
  std::string _name;
  CARD_LIST::fat_iterator pb;
  explicit SSNODE() :_name(), pb(&CARD_LIST::card_list) {}
  explicit SSNODE(const std::string Name, CARD_LIST::fat_iterator c)
    :_name(Name), pb(c) {}
};
static std::list<SSNODE> substack;
/*--------------------------------------------------------------------------*/
MODEL_SUBCKT::MODEL_SUBCKT()
  :COMPONENT()
{
  for (int ii = 0;  ii <= PORTSPERSUBCKT;  ii++){
    nodes[ii].e = nodes[ii].t = nodes[ii].m = INVALIDNODE;
  }
  n = nodes;
  //set_label(name);
  root_model_list.push_back(this);
  ++Count;
}
/*--------------------------------------------------------------------------*/
MODEL_SUBCKT::~MODEL_SUBCKT()
{
  --Count;
  root_model_list.erase(
	std::remove(root_model_list.begin(), root_model_list.end(), this),
	root_model_list.end());
}
/*--------------------------------------------------------------------------*/
void MODEL_SUBCKT::parse(CS& cmd)
{ 
  cmd.skiparg();	/* skip known ".subckt" */
  parse_label(cmd);
  parse_nodes(cmd, PORTSPERSUBCKT, 1);
  substack.push_back(SSNODE(short_label(), CARD_LIST::putbefore));
  CARD_LIST::putbefore = CARD_LIST::fat_iterator(&(subckt()), subckt().end());
}
/*--------------------------------------------------------------------------*/
void MODEL_SUBCKT::print(OMSTREAM where, int)const
{
  where << ".subckt " << short_label() << ' ';
  printnodes(where, PORTSPERSUBCKT);
  where << '\n';

  {if (subckt().exists()){
    for (CARD_LIST::const_iterator 
	   ci = subckt().begin(); ci != subckt().end(); ++ci){
      (**ci).print(where, false);
    }
  }else{
    untested(); 
  }}
  where << "*+ends " << short_label() << '\n';
}
/*--------------------------------------------------------------------------*/
void CMD::ends(CS& cmd)
{
  SSNODE t;
  {if (substack.empty()){
    untested(); 
    error(bWARNING, "ends not in subckt\n");
  }else{
    t = substack.back();
    substack.pop_back();
  }}
  if (cmd.more()){
    if (!cmd.pmatch(t._name)){
      untested(); 
      error(bERROR, std::string("ends tag [") + cmd.tail()
	    + "] does not match subckt [" + t._name + "]\n");
    }
  }
  CARD_LIST::putbefore = t.pb;
}
/*--------------------------------------------------------------------------*/
DEV_SUBCKT::DEV_SUBCKT()
{
  attach_common(&Default_SUBCKT);
  for (int ii = 0;  ii <= PORTSPERSUBCKT;  ii++){
    nodes[ii].e = nodes[ii].t = nodes[ii].m = INVALIDNODE;
  }
  n = nodes;
  ++Count;
}
/*--------------------------------------------------------------------------*/
DEV_SUBCKT::DEV_SUBCKT(const DEV_SUBCKT& p):BASE_SUBCKT(p)
{
  //strcpy(modelname, p.modelname); in common
  for (int ii = 0;  ii <= PORTSPERSUBCKT;  ii++){
    nodes[ii] = p.nodes[ii];
  }
  n = nodes;
  ++Count;
}
/*--------------------------------------------------------------------------*/
void DEV_SUBCKT::parse(CS& cmd)
{
  assert(has_common());
  const SUBCKT_COMMON* cc = prechecked_cast<const SUBCKT_COMMON*>(common());
  assert(cc);
  SUBCKT_COMMON* c = new SUBCKT_COMMON(*cc);
  assert(c);
  assert(!c->has_model());

  parse_Label(cmd);
  parse_nodes(cmd, PORTSPERSUBCKT, 1);
  c->parse_modelname(cmd);
  attach_common(c);
}
/*--------------------------------------------------------------------------*/
void DEV_SUBCKT::print(OMSTREAM where, int)const
{
  const SUBCKT_COMMON* c = prechecked_cast<const SUBCKT_COMMON*>(common());
  assert(c);
  where << short_label();
  printnodes(where, PORTSPERSUBCKT);
  where << "  " << c->modelname() << '\n';
}
/*--------------------------------------------------------------------------*/
void DEV_SUBCKT::expand()
{
  const SUBCKT_COMMON* c = prechecked_cast<const SUBCKT_COMMON*>(common());
  assert(c);
  expandsubckt(c->modelname());
  if (subckt().empty()){
    untested(); 
    error(bERROR, "no subckt\n");
  }
  subckt().expand();
  assert(!constant()); /* because I have more work to do */
}
/*--------------------------------------------------------------------------*/
void COMPONENT::expandsubckt(const std::string& modelname)
{
  enum {UNUSED=0, USED=-3};

  if (!subckt().empty()){
    untested();
    subckt().destroy();
  }

  std::list<CARD*>::const_iterator mi =
    find_ptr(root_model_list.begin(), root_model_list.end(), modelname);
  {if (mi == root_model_list.end()){
    error(bDANGER, "can't find subckt: " + modelname + '\n');
    assert(subckt().empty());
    return;
  }else if(!dynamic_cast<MODEL_SUBCKT*>(*mi)){
    untested();
    error(bDANGER, modelname + " is not a subckt\n");
    assert(subckt().empty());
    return;
  }}
  const CARD* model = *mi;
  assert(model);
  
  int map[NODESPERSUBCKT];
  for (int i = 0; i < NODESPERSUBCKT; i++){ /* initialize: all nodes unused */
    map[i] = UNUSED;
  }
  for (CARD_LIST::const_iterator
	 ci = model->subckt().begin(); ci != model->subckt().end(); ++ci){
    CARD* scan = *ci;
    if (scan->is_device()){				/* mark nodes used */
      for (int ii = 0;  scan->n[ii].e != INVALIDNODE;  ii++){
	if (scan->n[ii].e > NODESPERSUBCKT){
	  untested(); 
	  error(bERROR, model->long_label() + ": too many internal nodes\n");
	}
	map[scan->n[ii].e] = USED;
      }
    }
  }
  /* map is flags showing USED or UNUSED */
  map[0] = 0;
  for (int port = 0; model->n[port].e != INVALIDNODE; port++){ /* map ports */
    if (model->n[port].e > NODESPERSUBCKT){
      untested(); 
      error(bERROR, "internal error: subckt node out of range: "
	    + model->long_label() + '\n');
    }
    map[model->n[port].e] = n[port].t;
  }
  /* map now has node numbers for ports only -- others still USED or UNUSED */
  for (int ii = 0;  ii < NODESPERSUBCKT;  ii++){
    if (map[ii] == USED){
      map[ii] = STATUS::newnode_subckt(); /* assign number to internal nodes */
    }
  }
  /* map now full of internal node numbers, with all UNUSED == 0 */
  
  {if (subckt().empty()){
    error(bTRACE, long_label() + ": expanding\n");
    for (CARD_LIST::const_iterator
	   ci = model->subckt().begin(); ci != model->subckt().end(); ++ci){
      CARD* scan = *ci;
      if (scan->is_device()){			/* copy subckt */
	CARD* scratch = scan->clone();
	scratch->set_owner(this);
	subckt().push_front(scratch);
      }
    }
  }else{
    error(bTRACE, long_label() + ": re-expanding\n");
  }}
  assert(!subckt().empty());
  {
  for (CARD_LIST::iterator
	 ci = subckt().begin(); ci != subckt().end(); ++ci){
    CARD* scan = *ci;
      {if (scan->is_device()){
	int ii;
	for (ii = 0;  scan->n[ii].e != INVALIDNODE;  ii++){
	  assert(scan->n[ii].e >= 0);	 /* bad node? */
	  assert(map[scan->n[ii].e] >= 0); /* node map, all mapped and valid */
	  scan->n[ii].t = map[scan->n[ii].e];
	}
	scan->n[ii].t = INVALIDNODE;
      }else{
	untested(); 
      }}
    }
  }
}
/*--------------------------------------------------------------------------*/
double DEV_SUBCKT::probe_tr_num(const std::string& what)const
{
  CS cmd(what);
  untested();
  assert(subckt().exists());
  
  {if (cmd.pmatch("V")){
    untested(); 
    int nn = cmd.ctoi();			/* BUG: no bounds check */
    printf("subckt probe\n");
    return n[nn+1].v0();
  }else if (cmd.pmatch("P")){
    untested(); 
    double power = 0.;
    untested();
    for (CARD_LIST::const_iterator
	   ci = subckt().begin(); ci != subckt().end(); ++ci){
      power += CARD::probe(*ci,"P");
    }      
    return power;
  }else if (cmd.pmatch("PD")){
    untested(); 
    double power = 0.;
    untested();
    for (CARD_LIST::const_iterator
	   ci = subckt().begin(); ci != subckt().end(); ++ci){
      power += CARD::probe(*ci,"P");
    }      
    return power;
  }else if (cmd.pmatch("PS")){
    untested(); 
    double power = 0.;
    untested();
    for (CARD_LIST::const_iterator
	   ci = subckt().begin(); ci != subckt().end(); ++ci){
      power += CARD::probe(*ci,"P");
    }      
    return power;
  }else{ /* bad parameter */
    untested(); 
    return NOT_VALID;
  }}
  /*NOTREACHED*/
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
