/*$Id: d_subckt.h,v 15.13 1999/10/18 05:40:26 al Exp $ -*- C++ -*-
 * data structures for subcircuits
 */
#ifndef D_SUBCKT_H
#define D_SUBCKT_H
#include "e_subckt.h"
/*--------------------------------------------------------------------------*/
#define NODESPERSUBCKT 1000
#define PORTSPERSUBCKT 100
/*--------------------------------------------------------------------------*/
class DEV_SUBCKT : public BASE_SUBCKT {
private:
  explicit	DEV_SUBCKT(const DEV_SUBCKT&);
public:
  explicit	DEV_SUBCKT();
		~DEV_SUBCKT()	{--Count;}
private: // override virtual
  CARD*		clone()const		{return new DEV_SUBCKT(*this);}
  void		parse(CS&);
  void		print(OMSTREAM,int)const;
  void		expand();
  double	probe_tr_num(const std::string&)const;
public:
  static int	count()			{return Count;}
private:
  static int	Count;
  node_t	nodes[PORTSPERSUBCKT+1];
};
/*--------------------------------------------------------------------------*/
class SUBCKT_COMMON : public COMPONENT_COMMON {
public:
  explicit SUBCKT_COMMON(int c=0)		:COMPONENT_COMMON(c) {++Count;}
  explicit SUBCKT_COMMON(const SUBCKT_COMMON& p):COMPONENT_COMMON(p) {++Count;}
	   ~SUBCKT_COMMON()			{--Count;}
  const char*	name()const			{untested(); return "subckt";}
  static int	count()				{return Count;}
private:
  static int	Count;
};
/*--------------------------------------------------------------------------*/
class MODEL_SUBCKT : public COMPONENT {
private:
  explicit	MODEL_SUBCKT(const MODEL_SUBCKT&p):COMPONENT(p){unreachable();}
public:
  explicit	MODEL_SUBCKT();
		~MODEL_SUBCKT();
private: // override virtual
  CARD*		clone()const	{untested(); return new MODEL_SUBCKT(*this);}
  void		parse(CS&);
  void		print(OMSTREAM,int)const;
  bool		do_tr()			{return true;}
  void		tr_load()		{/*nothing*/}
  void		tr_unload()		{untested();}
  void		do_ac()			{/*nothing*/}
  bool		is_device()const	{return false;}
public:
  static int	count()			{return Count;}
private:
  node_t	nodes[PORTSPERSUBCKT+1];
  static int	Count;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
