/*$Id: e_storag.h,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * "base" class for energy storage elements (L & C)
 */
#ifndef E_STORAGE_H
#define E_STORAGE_H
#include "e_oneport.h"
/*--------------------------------------------------------------------------*/
enum METHOD {mTRAPGEAR, mEULER, mTRAP, mGEAR, mTRAPEULER};
/*--------------------------------------------------------------------------*/
class STORAGE : public ONEPORT {
protected:
  explicit STORAGE()			:ONEPORT(),  method_a(mTRAPGEAR)  {}
  explicit STORAGE(const STORAGE& p)	:ONEPORT(p), method_a(p.method_a) {}
private: // override virtual
  void	   precalc();
  void     dc_advance();
  void     tr_advance();
  bool	   tr_needs_eval()	{return true;}
  void	   tr_queue_eval()	{q_eval();}
protected:
  void	   begin_core();
  double   review(double, double)const;
protected:
  METHOD   method_a;	/* actual integration method (auto)	*/
  double   time0;	/* time now (y[012], m[01])		*/
  double   time1;	/* one tick ago	 (mt1, yt1)		*/
  double   time2;	/* two tick ago	 (mt2, yt2)		*/
  double   time3;	/* three tick ago(mt3. yt3)		*/
//FPOLY1   y0;		/* iteration parameters, new		*/
  FPOLY1   yt1;		/* iteration parameters, 1 time ago	*/
  FPOLY1   yt2;		/* iteration parameters, 2 times ago	*/
  FPOLY1   yt3;		/* iteration parameters, 3 times ago	*/
//FPOLY1   y1;		/* iteration parameters, 1 iter ago	*/
//FPOLY1   y2;		/* iteration parameters, 2 iter ago	*/
//CPOLY1   m0;		/* matrix parameters, new		*/
//CPOLY1   m1;		/* matrix parameters, 1 fill ago	*/
  CPOLY1   mt1;		/* matrix parameters, 1 time ago	*/

//COMPLEX  ev;		/* ac effective value (usually real)	*/
//COMPLEX  acg;		/* ac admittance matrix values		*/   
protected:
  static METHOD method_select[meNUM_METHODS][meNUM_METHODS];
};
// commented out declarations mean inherited
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
