/*$Id: io_findf.cc,v 15.9 1999/10/11 05:05:15 al Exp $ -*- C++ -*-
 * Modified by AD.  Sent to me by C-WARE
 * This file contains the routine to locate a file,
 *	using a path string for the directories to search.
 * Interface:
 *	findfile(filename, paths, mode)
 *	    filename is the name of the file to be searched for,
 *	    paths is the path to follow to find it.
 *	    mode is how you want to open the file
 *	returns full path name, if successful, else "".
 *
 * PATHSEP, ENDDIR are system dependent, defined in md.h
*/
#include "io_.h"
// testing=nonstrict
/*--------------------------------------------------------------------------*/
std::string findfile(const std::string& filename, 
		     const std::string& path,
		     int mode)
{
#ifdef CHECK_LOCAL_FIRST
  if (OS::access_ok(filename, mode)){
    untested(); 
    return filename;
  }else{
    untested(); 
  }
#endif
					// for each item in the path
  for (const char* p_ptr = path.begin(); p_ptr!=path.end(); ++p_ptr){
    // p_ptr changed internally                               ^^^^^ skip sep
    std::string target = "";
    while (*p_ptr != PATHSEP  &&  p_ptr != path.end()){ // copy 1 path item
      target += *p_ptr++;
    }
    if (!target.empty() &&  !strchr(ENDDIR,p_ptr[-1])){
      target += *ENDDIR;		// append '/' if needed
    }
    
    target += filename;
    {if (OS::access_ok(target, mode)){	// found it
      return target;
    }else if (p_ptr==path.end()){	// ran out of path, didn't find it
      return "";
    }}					// else try again
  }
  return ""; // path doesn't exist - didn't go thru loop at all
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
