
#ifndef IIRBASE_INTEGER_LITERAL32_HH
#define IIRBASE_INTEGER_LITERAL32_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_IntegerLiteral32.hh,v 1.2 1999/03/09 20:50:32 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Literal.hh"

class IIR_IntegerLiteral32;

class IIRBase_IntegerLiteral32 : public IIR_Literal {

public:

  IIR_Kind get_kind() { return IIR_INTEGER_LITERAL32; }
  IIR_Char *get_kind_text() { return "IIR_IntegerLiteral32"; }

  static IIR_IntegerLiteral32* get(IIR_Int32);
  void release();

  IIR_Int32 value();
  void _set_value(IIR_Int32);

protected:
  IIRBase_IntegerLiteral32();
  virtual ~IIRBase_IntegerLiteral32() = 0;

private:
  IIR_Int32 val;
};
#endif
