// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AssociationElementByExpression.cc,v 1.3 1999/08/26 13:47:04 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_CaseStatementAlternativeByChoices.hh"
#include "IIR_Choice.hh"
#include "IIR_ConcurrentStatement.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_Label.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "symbol_table.hh"

IIRScram_AssociationElementByExpression::~IIRScram_AssociationElementByExpression() {}


void 
IIRScram_AssociationElementByExpression::_publish_vhdl(ostream &_vhdl_out) {
  if (get_formal() != NULL) {
    if (get_formal()->get_kind() == IIR_INTEGER_SUBTYPE_DEFINITION)
      get_formal()->_publish_vhdl_range(_vhdl_out);
    else 
      get_formal()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " => ";
  }

  if( get_actual() != NULL ){
    get_actual()->_publish_vhdl(_vhdl_out);
  }
  else{
    _vhdl_out << "open";
  }
}

void 
IIRScram_AssociationElementByExpression::_publish_vhdl_without_formals(ostream &_vhdl_out) {
  
  if ( get_formal() != NULL ){
    if ( get_formal()->get_kind() == IIR_FUNCTION_CALL ){
      get_formal()->_publish_vhdl(_vhdl_out);
      _vhdl_out << " => ";
    }
  }

  if( get_actual() != NULL ){
    get_actual()->_publish_vhdl(_vhdl_out);
  }
  else{
    _vhdl_out << "open";
  }
}

IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_resolved(){
  IIR_Boolean retval = TRUE;

  if( get_formal() != NULL && get_formal()->_is_resolved() == FALSE ){
    retval = FALSE;
    goto finish;
  }
  
  if( get_actual() != NULL && get_actual()->_is_resolved() == FALSE ){
    retval = FALSE;
  }

 finish:
  return retval;
}

IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_signal(){
  IIR_Boolean retval = TRUE;

  if( get_actual()->_is_signal() == FALSE ){
    retval = FALSE;
  }

  return retval;
}

IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_variable(){
  IIR_Boolean retval = TRUE;

  if( get_actual()->_is_variable() == FALSE ){
    retval = FALSE;
  }

  return retval;
}


IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_readable(){
  ASSERT( _is_resolved() == TRUE );

  return get_actual()->_is_readable();
}


IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_writable(){
  ASSERT( _is_resolved() == TRUE );

  return get_actual()->_is_writable();
}


void 
IIRScram_AssociationElementByExpression::_publish_cc() {
  ASSERT(_is_resolved() == TRUE);
  IIR_TypeDefinition *common_base_type = NULL;
  
  if(get_formal() != NULL) {
    common_base_type = get_actual()->_get_subtype()->_is_explicit_type_conversion_needed(get_formal()->_get_subtype());
    if (common_base_type != NULL) {
      // Okay. An explicit type conversion is needed.
      get_formal()->_get_subtype()->_publish_cc_type_name();
      _cc_out << "(ObjectBase::";
      get_formal()->_publish_cc_object_type();
      get_formal()->_get_subtype()->_publish_cc_constructor_args();
      _cc_out << ", ";
      _cc_out << "(const ";
      common_base_type->_publish_cc_type_name();
      _cc_out << " &) ";
    }
  }
  
  get_actual()->_publish_cc();
  
  if (common_base_type != NULL) {
    _cc_out << ")";
  }
}

void 
IIRScram_AssociationElementByExpression::_publish_cc_generic_map_aspect() {
  IIR_Label* label = NULL;
  IIR_Char* prefix_string = NULL;
  ASSERT(_is_resolved() == TRUE);
  ostrstream prefix;

  ASSERT((_current_publish_node->_is_concurrent_statement() == TRUE) ||
	 (_current_publish_node->get_kind() == IIR_LABEL));
  
  if(_current_publish_node->_is_concurrent_statement() == TRUE) {
    prefix << "enclosingArch->";
    prefix << *(((IIR_ConcurrentStatement*)_current_publish_node)->_get_label()->_get_declarator());
    prefix << "_elab_obj->";
  }
  else {
    prefix << "enclosingArch->";
    label = (IIR_Label*)_current_publish_node;
    if(label->get_statement() == NULL) {
      //The label that we have is already a mangled one
      prefix << *(label->_get_declarator());
    }
    else {
      //get the mangled label from unmangled one
      prefix << *(label->get_statement()->_get_label()->_get_declarator());
    }
    prefix << "_elab_obj->";
  }
  prefix << ends;
  prefix_string = prefix.str();

  if(get_formal() != NULL) {
    ASSERT ( (get_formal()->_get_subtype()) != NULL);
    _cc_out << "(";
    get_formal()->_get_subtype()->_publish_cc_type_name();
    _cc_out << "&)";
  }
  _set_publish_prefix_string(prefix_string);
  get_actual()->_publish_cc();

  delete [] prefix_string;
  _set_publish_prefix_string(NULL);
}

void
IIRScram_AssociationElementByExpression::_publish_cc_generic_map_aspect_for_conc_stmts()
{
  ASSERT(_is_resolved() == TRUE);
  if(get_formal() != NULL) {
    ASSERT( (get_formal()->_get_subtype()) != NULL);
    _cc_out << "(";
    get_formal()->_get_subtype()->_publish_cc_type_name();
    _cc_out << "&)";
  }
  
  get_actual()->_publish_cc();
}

void 
IIRScram_AssociationElementByExpression::_publish_cc_elaborate() {
  get_actual()->_publish_cc_elaborate();
}

IIR_Int32
IIRScram_AssociationElementByExpression::_get_number_of_element_associations() {

  if(get_actual()->get_kind() == IIR_OTHERS_INITIALIZATION) {
    return 1;
  }

  if (get_formal() == NULL) {
    return 1;
  }
  
  if(get_formal()->get_kind() == IIR_CASE_STATEMENT_ALTERNATIVE_BY_CHOICES) {
    IIR_CaseStatementAlternativeByChoices* case_choices = (IIR_CaseStatementAlternativeByChoices*)get_formal();
    return case_choices->choices.num_elements();
  }
  else {
    return 1;
  }
  return 1;
}

void
IIRScram_AssociationElementByExpression::_publish_cc_aggregate_iterator()
{
  _cc_out << "(";
  if (_get_aggregate_iterator_subtype() != NULL) {
    ASSERT(_get_aggregate_iterator_subtype()->_get_base_type_left() != NULL);
    _get_aggregate_iterator_subtype()->_get_base_type_left()->_publish_cc_value();

    if (_get_aggregate_iterator_subtype()->_get_base_type_direction()->_is_ascending_range() == FALSE) {
      _cc_out << " - ";
    }
    else {
      _cc_out << " + ";
    }
  }
  else {
    _cc_out << "1 + ";
  }
  
  _cc_out << _get_aggregate_iterator();
  _cc_out << ")";
}

void 
IIRScram_AssociationElementByExpression::_publish_cc_non_aggregate_object_init() {
  IIR* decl = NULL;
  switch(get_actual()->get_kind()) {
  case IIR_CONSTANT_DECLARATION:
  case IIR_CONSTANT_INTERFACE_DECLARATION:
  case IIR_VARIABLE_DECLARATION:
  case IIR_VARIABLE_INTERFACE_DECLARATION:
  case IIR_SIGNAL_DECLARATION:
  case IIR_SIGNAL_INTERFACE_DECLARATION:
  case IIR_SELECTED_NAME:
  case IIR_INDEXED_NAME:
    decl = get_actual();
    _cc_out << " new ";
    decl->_get_subtype()->_publish_cc_type_name();
    _cc_out << "(true, ";
    if (decl->_get_subtype()->_is_scalar_type() == TRUE) {
      decl->_publish_cc();
    } 
    else {
      if(decl->_get_subtype()->_is_array_type() == TRUE) {
	_cc_out << "ObjectBase::VARIABLE, ";
	if (decl->_get_subtype()->_get_num_indexes() < 2) {
	  decl->_get_subtype()->_publish_cc_range();
	  _cc_out << ", ";
	}
	
	decl->_publish_cc();

	if (decl->_get_subtype()->_get_num_indexes() < 2) {
	  _cc_out << ", ";
	  decl->_get_subtype()->_publish_cc_bounds();
	}
      }
      else {
	if(decl->_get_subtype()->_is_record_type() == TRUE){
	  _cc_out << "ObjectBase::VARIABLE, ";
	  decl->_publish_cc();
	}
      }
    }
    _cc_out << ")";
    break;
  default:
    //Currently for all other nodes, the same old stuff is done.
    //For any node, anything special has to be done, lets bother that time.
    //Presume IIR_*Attribute nodes needs work like object and interface 
    //declarations 
    get_actual()->_publish_cc_state_object_init();
    break;
  }
}

void 
IIRScram_AssociationElementByExpression::_publish_cc_state_object_init() {

  if (get_formal() == NULL) {
    if(get_actual()->get_kind() == IIR_OTHERS_INITIALIZATION) {
      _cc_out << " new ElementAssociation(Others, ";
      //      get_actual()->_publish_cc_state_object_init();
      _publish_cc_non_aggregate_object_init();
      _cc_out << ")";
    } else {
      _cc_out << "new ElementAssociation(";
      _publish_cc_aggregate_iterator();
      _cc_out << ", ";
      //    get_actual()->_publish_cc_state_object_init();
      _publish_cc_non_aggregate_object_init();
      _cc_out << ")";
    }
  }
  else {
    if(get_actual()->get_kind() == IIR_OTHERS_INITIALIZATION) {
      _cc_out << " new ElementAssociation(Others, ";
      //      get_actual()->_publish_cc_state_object_init();
      _publish_cc_non_aggregate_object_init();
      _cc_out << ")";
    }
    else if(get_formal()->get_kind() == IIR_CASE_STATEMENT_ALTERNATIVE_BY_CHOICES) {
      IIR_CaseStatementAlternativeByChoices* case_choices = (IIR_CaseStatementAlternativeByChoices*)get_formal();
      IIR_Choice* current_choice = case_choices->choices.first();
      while(current_choice != NULL) {
	_cc_out << " new ElementAssociation(";
	current_choice->get_value()->_publish_cc_universal_value();
	_cc_out << ", ";
	//	get_actual()->_publish_cc_state_object_init();
	_publish_cc_non_aggregate_object_init();
	_cc_out << ")";
	current_choice = case_choices->choices.successor(current_choice);
	if(current_choice != NULL) {
	  _cc_out << ", ";
	}
      }
    }
    else {
      _cc_out << " new ElementAssociation(";
      get_formal()->_publish_cc_universal_value();
      _cc_out << ", ";
      //      get_actual()->_publish_cc_state_object_init();
      _publish_cc_non_aggregate_object_init();
      _cc_out << ")";
    }
  }
}

// This method publishes the element as an argument to a subprogram
// (function/procudure).  This is different from _publish_cc because this
// publishes just the declarators.
// For example, 
//   "var" will be published by _publish_cc() as 
//     "state.current->var" and as
//     "var" by _publish_cc_subprogram_arguments().
// Assumption: get_actual() returns one of IIR_Declaration (any), IIR_Literal
// or IIR_IndexedName 
void
IIRScram_AssociationElementByExpression::_publish_cc_subprogram_arguments() {
  ASSERT(get_actual()->_is_resolved());

  if(get_actual()->_is_iir_declaration()) {
    ((IIR_Declaration *)get_actual())->_get_declarator()->_publish_cc();
  } else if(get_actual()->get_kind() == IIR_INDEXED_NAME) {
    get_actual()->_publish_cc_subprogram_arg();
  } else {    
    get_actual()->_publish_cc();
  }
}

void
IIRScram_AssociationElementByExpression::_get_signal_source_info(set<IIR_Declaration>* siginfo) {
  if(get_formal() != NULL) {
    ASSERT(_is_resolved() == TRUE);
    ASSERT(get_formal() != NULL);
    ASSERT(get_formal()->_is_resolved() == TRUE);
    if(get_formal()->_is_signal()) {
      ASSERT(get_formal()->_is_interface() == TRUE);
      IIR_Mode signal_mode = ((IIR_InterfaceDeclaration *) get_formal())->get_mode();
      if(signal_mode == IIR_OUT_MODE || signal_mode == IIR_INOUT_MODE) {
	siginfo->add((IIR_Declaration *) get_actual());
      }
    }
  }
  else {
    ASSERT(get_actual()->_is_resolved() == TRUE);
    get_actual()->_get_signal_source_info(siginfo);
  }
}

IIR*
IIRScram_AssociationElementByExpression::_get_actual() {
  return get_actual();
}

void 
IIRScram_AssociationElementByExpression::_set_actual( IIR *new_actual ) {
  set_actual( new_actual );
}

void
IIRScram_AssociationElementByExpression::_publish_cc_first_objectParameter() {

  get_actual()->_publish_cc_first_objectParameter();
}
  
set<IIR_TypeDefinition> *
IIRScram_AssociationElementByExpression::_get_rval_set( IIR_Boolean (IIR::*constraint_function)()){
  set<IIR_TypeDefinition> *retval = NULL;

  // the actual will be NULL if the VHDL says "open".
  set<IIR_TypeDefinition> *actual_rvals = NULL;
  if( get_actual() != NULL ){
    actual_rvals = get_actual()->_get_rval_set( constraint_function );
    if( actual_rvals == NULL ){
      report_undefined_symbol( get_actual() );
      return NULL;
    }
  }

  if( get_formal() == NULL ){
    retval = actual_rvals;
  }
  else{
    switch( get_formal()->get_kind() ){
    case IIR_INTEGER_LITERAL:
    case IIR_OTHERS_INITIALIZATION:{
      // Then we need to return an list of the array types with elements that match
      // the actuals.
      
      // Get the set of array types...
      set<IIR_ArrayTypeDefinition> *array_types = _get_symbol_table()->get_in_scope_array_types();

      IIR_TypeDefinition *current_array_type; 
      current_array_type = array_types->get_element();

      while( current_array_type != NULL ){
	IIR_TypeDefinition *actual_type = actual_rvals->get_element();
	
	bool one_matched = false;
	while( actual_type != NULL ){
	  if( actual_type->_is_compatible( current_array_type->_get_element_subtype() ) != NULL ){
	    one_matched = true;
	  }
	  actual_type = actual_rvals->get_next_element();
	}

	if( one_matched == true ){
	  if( retval == NULL ){
	    retval = new set<IIR_TypeDefinition>;
	  }
	  retval->add( current_array_type );
	}
	
	current_array_type = array_types->get_next_element();
      }

      delete actual_rvals;

      break;
    }
    default:{
//       set<IIR_TypeDefinition> *formal_rvals = get_formal()->_get_rval_set();
      if( actual_rvals == NULL ){
	return NULL;
      }
      else{
	return actual_rvals;
      }
    }
    }
  }

  return retval;
}

void 
IIRScram_AssociationElementByExpression::_type_check( set<IIR_TypeDefinition> *context_set ){
  IIR *expr = get_actual();

  ASSERT( expr != NULL );

  expr->_type_check( context_set );
}

IIR *
IIRScram_AssociationElementByExpression::_semantic_transform( set<IIR_TypeDefinition> *context_set ){
  IIR *expr = get_actual();

  ASSERT( expr != NULL );

  set_actual( expr->_semantic_transform( context_set ) );

  return this;
}

IIR *
IIRScram_AssociationElementByExpression::_rval_to_decl( IIR_TypeDefinition *my_rval ){

  if( _is_by_others() == TRUE &&
      my_rval->_is_array_type() == TRUE ){
    // Actual is an element of the array.
    IIR_TypeDefinition *element_subtype = my_rval->_get_element_subtype();
    set_actual( get_actual()->_rval_to_decl( element_subtype ) );
  }
  else{    
    set_actual( get_actual()->_semantic_transform( my_rval ) );
    get_actual()->_type_check( my_rval );
    set_actual( get_actual()->_rval_to_decl( my_rval ) );
  }


  return (IIR *)this;
}

ostream &
IIRScram_AssociationElementByExpression::_print( ostream &os ){
  if( get_formal() != NULL ){
    os << *get_formal();
    os << " => ";
  }

  if( get_actual() != NULL ){
    os << *get_actual();
  }

  return os;
}

void
IIRScram_AssociationElementByExpression::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list){
  get_actual()->_build_sensitivity_list(sensitivity_list);
}

void 
IIRScram_AssociationElementByExpression::_add_decl_into_cgen_symbol_table() {
  if(get_actual() != NULL) {
    get_actual()->_add_decl_into_cgen_symbol_table();
  }
}


IIR*
IIRScram_AssociationElementByExpression::_clone() {
  IIR *elem;
  IIR_AssociationElementByExpression *assoc;

  assoc = new IIR_AssociationElementByExpression();
  IIRScram::_clone( assoc );

  if (get_formal() != NULL) {
    elem = get_formal()->_clone();
    assoc->set_formal(elem);
  }
  elem = get_actual()->_clone();
  assoc->set_actual(elem);

  return assoc;
}

IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_globally_static_for_array(){
  IIR_Boolean retval = TRUE;

  if( get_formal() != NULL &&
      get_formal()->_is_iir_scalar_type_definition() == TRUE &&
      get_formal()->_is_globally_static() == FALSE ){
    retval = FALSE;
  }    

  // Can't have an OPEN array element association.
  ASSERT( get_actual() != NULL );
  
  if( get_actual()->_is_globally_static() == FALSE ){
    retval = FALSE;
  }
  
  return retval;
}

IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_globally_static_for_record(){
  // Can't have an OPEN record element association.
  ASSERT( get_actual() != NULL );

  return get_actual()->_is_globally_static();
}

IIR_Boolean 
IIRScram_AssociationElementByExpression::_is_globally_static_for_function(){
  if( get_actual() == NULL || get_actual()->_is_globally_static() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}
