// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Sunbramani skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EnumerationTypeDefinition.cc,v 1.3 1999/08/02 12:50:02 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_EnumerationTypeDefinition.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "IIR_StringLiteral.hh"
#include "symbol_table.hh"

IIRScram_EnumerationTypeDefinition::~IIRScram_EnumerationTypeDefinition() {}

void 
IIRScram_EnumerationTypeDefinition::_publish_vhdl_type_decl(ostream &_vhdl_out) {
  enumeration_literals._publish_vhdl(_vhdl_out);
}

ostream&
IIRScram_EnumerationTypeDefinition::_print(ostream& os) {
  if( enumeration_literals.num_elements() > 0 ){
    enumeration_literals._print(os);
  }
  else{
    IIR_ScalarTypeDefinition::_print( os );
  }
  return os;
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_list() {
  IIR_EnumerationLiteral *literal;

  literal = enumeration_literals.first();
  _cc_out << "enum";
  this->_publish_cc_type_name();
  ((IIR_StringLiteral *) literal->_get_declarator())->_publish_cc_variable_name();
  literal = enumeration_literals.successor(literal);
  for(register int i = 1; i < enumeration_literals.num_elements(); i++) {
    _cc_out << ", ";
    _cc_out << "enum";
    ((IIR_StringLiteral *) literal->_get_declarator())->_publish_cc_variable_name();
    literal = enumeration_literals.successor(literal);
  }
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_type_info(){
  IIR_EnumerationLiteral *literal;

  if (_is_anonymous() == FALSE) {
    //The imageMap strings are being published here
    _cc_out << "static char* ";
    _publish_cc();
    _cc_out << "_info_imageMap[] = {";
    
    literal = enumeration_literals.first();
    for(register int i = 0; i < (enumeration_literals.num_elements()-1); i++) {
      _cc_out << "\"" << literal->_get_declarator()->_convert_to_c_string()
	      << "\", ";
      literal = enumeration_literals.successor(literal);
    }
    if(enumeration_literals.num_elements() > 0) {
      _cc_out << "\"" << literal->_get_declarator()->_convert_to_c_string()
	      << "\"";
    }
    _cc_out << "};" << endl;
    
    _cc_out << "enumInfo ";
    _publish_cc();
    _cc_out << "_info(";
    if (_is_subtype() == TRUE)  {
      ASSERT (_get_base_type()->_is_iir_enumeration_type_definition() == TRUE);
      _cc_out << ((IIR_EnumerationTypeDefinition *) _get_base_type())->enumeration_literals.num_elements();
    }
    else  {
      _cc_out << enumeration_literals.num_elements();
    }
    _cc_out << ", ";
    _publish_cc();
    _cc_out << "_info_imageMap, ";
    
    if (_is_subtype() == FALSE) {
      _cc_out << "0";
    }
    else {
      get_left()->_publish_cc_universal_value();
    }
    
    _cc_out << ", ";
    _get_direction()->_publish_cc_direction();
    _cc_out << ")";
  }
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_extern_type_info(){
  _cc_out << "extern ";
  _cc_out << "enumInfo ";
  if (_is_anonymous() == FALSE) {
    _publish_cc();
  }
  else {
    ASSERT (_get_base_type() != NULL);
    _get_base_type()->_publish_cc();
  }
  
  _cc_out << "_info;" << endl;
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_type_string(){
  _cc_out << "EnumerationType";
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_data_members() {
// Publish the imageMap array
  _cc_out << "  static char *imageMap[" << enumeration_literals.num_elements() 
	  << "];" << endl;

// Publish the enumeration list
  _cc_out << "  enum ";
  _publish_cc_type_name();
  _cc_out << "Enum {";
  _publish_cc_list();
  _cc_out << "};" << endl;
  _cc_out << endl;
}

void
IIRScram_EnumerationTypeDefinition::_publish_cc_decl_constructors() {
  if(_is_subtype_decl() == TRUE) {
    _publish_cc_subtype_constructors();
  }
  else {
    _publish_cc_type_constructors();
  }
}

void
IIRScram_EnumerationTypeDefinition::_publish_cc_type_constructors() {
   IIRScram_ScalarTypeDefinition::_publish_cc_type_constructors();

// Constructor taking ObjectBase::ObjectType and enum as parameters
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  _publish_cc_type_name();
  _cc_out << "Enum val):";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, UniversalInteger(int(val)), "; 
  _publish_cc_type_name();
  _cc_out << "_info) {}" << endl;
}

void
IIRScram_EnumerationTypeDefinition::_publish_cc_subtype_constructors() {

  //Call the parents function first

  IIRScram_ScalarTypeDefinition::_publish_cc_subtype_constructors();

  // Constructor taking ObjectBase::ObjectType and enum as parameters
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  // Only the base type has the enumeration list.  All the subtypes of
  // that type inherit this list.
  _get_base_type()->_publish_cc_type_name();
  _cc_out << "Enum val) :";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, UniversalInteger(int(val)),";
  _publish_cc_type_name();
  _cc_out << "_info) {}" << endl;
}
  
void 
IIRScram_EnumerationTypeDefinition::_publish_cc_decl_cc() {
  char *className;
  IIR_EnumerationLiteral *literal;
  strstream classStream;

  classStream << "Savant" << *_get_declaration()->_get_declarator() <<"Type" << ends;

  className = classStream.str();

  _cc_out << "#include \"" << className << ".hh\"" << endl;
  _cc_out << endl;

  // Only the base type has the image map list.  All the subtypes inherit
  // this image map list from the bottom base type.
  if(_is_subtype_decl() == FALSE) {
    _cc_out << "char *" << className << "::imageMap[" 
	    << enumeration_literals.num_elements() << "] = {";
    literal = enumeration_literals.first();
    for(register int i = 0; i < (enumeration_literals.num_elements()-1); i++) {
      _cc_out << "\"" << literal->_get_declarator()->_convert_to_c_string()
	      << "\", ";
      literal = enumeration_literals.successor(literal);
    }
    if(enumeration_literals.num_elements() > 0) {
      _cc_out << "\"" << literal->_get_declarator()->_convert_to_c_string()
	      << "\"";
    }
    _cc_out << "};" << endl;
  }

  //This has been commented out because the attributes have been pushed
  //to the kernel
  //   _publish_cc_define_type_attributes();

//   _publish_cc_decl_relational_operators();
//   _publish_cc_decl_operators();
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_universal_type() {
  _cc_out << "UniversalInteger";
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_kernel_type() {
  _cc_out << "EnumerationType";
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_range() {
  ASSERT(get_left() != NULL);
  ASSERT(get_direction() != NULL);
  ASSERT(get_right() != NULL);

  get_left()->_publish_cc_universal_value();
//   enumeration_literals.first()->_publish_cc_universal_value();
  _cc_out << ", ";
  get_direction()->_publish_cc_direction();
  _cc_out << ", ";
  get_right()->_publish_cc_universal_value();
//   enumeration_literals.last()->_publish_cc_universal_value();
}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_attribute_image() {

  _cc_out << "const SavantstringType ";
  _cc_out << "\n";
  _publish_cc_type_name();
  _cc_out << "::IMAGE(const ";
  _publish_cc_base_type_name();
  _cc_out << "& x";
  _cc_out << ") {\n";

  _publish_cc_universal_type();
  _cc_out << " value;\n";
  _cc_out << " value = x.getObject()->readVal();\n";
  _cc_out << "if(value < ";
  _cc_out << enumeration_literals.num_elements() << " && value >= 0) {\n";
  _cc_out << " char *ptr = ";
  _publish_cc_type_name();
  _cc_out << "::imageMap[value];\n";
  _cc_out << "SavantstringType image(ObjectBase::VARIABLE,0,to,strlen(ptr) - 1, ptr);\n";
  _cc_out << "return image;\n";
  _cc_out << "}\n";
  _cc_out << "else {\n";
  _cc_out << "cerr << \"The parameter of `IMAGE attribute not withing range\";\n";
  _cc_out << "abort();\n";
  _cc_out << "return SavantstringType(ObjectBase::VARIABLE, 0, to, 0);\n";
  _cc_out << "}\n";
  _cc_out << "}\n";

}

void 
IIRScram_EnumerationTypeDefinition::_publish_cc_attribute_value() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << "\n";
  _publish_cc_type_name();
  _cc_out << "::VALUE(const SavantstringType& x) {\n";
  _cc_out << "int length = x.get_number_of_elements();\n";
  _cc_out << "strstream value;\n";
  _cc_out << "char* ptr;\n";
  _cc_out << "for(int i=0; i < length; i++) {\n";
  _cc_out << "x.get_element(i).print(value);\n";
  _cc_out << "}\n";
  _cc_out << "value << ends;\n";
  _cc_out << "ptr = value.str();\n";
  _cc_out << "UniversalInteger val = getIndex((const char *) ptr, imageMap, ";
  _cc_out << enumeration_literals.num_elements();
  _cc_out << ");\n";
  _cc_out << "if(";
  _publish_cc_range_check();
  _cc_out << ") {\n";
  _publish_cc_base_type_name();
  _cc_out << " retval(ObjectBase::VARIABLE, val);\n";
  _cc_out << "return retval;\n";
  _cc_out << "}\n";
  _cc_out << "else {\n";
  _cc_out << "cerr << \"The Result of `IMAGE attribute not withing range\";\n";
  _cc_out << "abort();\n";
  _cc_out << "return ";
  _publish_cc_base_type_name();
  _cc_out << "(ObjectBase::VARIABLE, 0);\n";
  _cc_out << "}\n";
  _cc_out << "}\n";
}

// LRM defnies an enumeration type as a character type thus (Section 3.1.1):
//   An enumeration type is said to be a character type if at least one of
//   its enumeration literals is a character literal.
IIR_Boolean
IIRScram_EnumerationTypeDefinition::_is_character_type() {
  IIR_EnumerationLiteral *literal = enumeration_literals.first();

  while(literal != NULL) {
    if(literal->_is_character_literal() == TRUE) {
      return TRUE;
    }
    literal = enumeration_literals.successor(literal);
  }

  return FALSE;
}

IIR_TypeDefinition *
IIRScram_EnumerationTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_EnumerationSubtypeDefinition();
  
  return retval;
}

IIR *
IIRScram_EnumerationTypeDefinition::_clone(){
  IIR_EnumerationTypeDefinition *retval = new IIR_EnumerationTypeDefinition();
  _clone( retval );

  return retval;
}

void 
IIRScram_EnumerationTypeDefinition::_clone( IIR_EnumerationTypeDefinition *copy_into ){
  copy_into->enumeration_literals = enumeration_literals;
  IIR_ScalarTypeDefinition::_clone( copy_into );
}

set<IIR_Declaration> *
IIRScram_EnumerationTypeDefinition::_find_declarations( IIR_TextLiteral *to_find ){
  return enumeration_literals._find_declarations( to_find );
}

set<IIR_Declaration> *
IIRScram_EnumerationTypeDefinition::_find_declarations( IIR_Name *to_find ){
  return enumeration_literals._find_declarations( to_find );
}

void 
IIRScram_EnumerationTypeDefinition::_come_into_scope( symbol_table *sym_tab,
						      IIR_TypeDeclaration *type_decl ){
  IIR_ScalarTypeDefinition::_come_into_scope( sym_tab, type_decl );

  IIR_EnumerationLiteral *literal = enumeration_literals.first();
  while( literal != NULL ){
    sym_tab->add_declaration( literal );
    literal = enumeration_literals.successor( literal );
  }
}

void 
IIRScram_EnumerationTypeDefinition::_come_out_of_scope( symbol_table *sym_tab ){
  IIR_ScalarTypeDefinition::_come_out_of_scope( sym_tab );

  IIR_EnumerationLiteral *literal = enumeration_literals.first();
  while( literal != NULL ){
    sym_tab->remove_from_scope( literal );
    literal = enumeration_literals.successor( literal );
  }
}
